/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.gatk.samples.SampleDB;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotator;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.RodRequiringAnnotation;
import org.broadinstitute.sting.utils.MendelianViolation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class MVLikelihoodRatio
extends InfoFieldAnnotation
implements ExperimentalAnnotation,
RodRequiringAnnotation {
    private MendelianViolation mendelianViolation = null;
    private String motherId;
    private String fatherId;
    private String childId;

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        boolean hasAppropriateGenotypes;
        if (this.mendelianViolation == null) {
            if (this.checkAndSetSamples(((Walker)((Object)walker)).getSampleDB())) {
                this.mendelianViolation = new MendelianViolation(((VariantAnnotator)walker).minGenotypeQualityP);
            } else {
                throw new UserException("Mendelian violation annotation can only be used from the Variant Annotator, and must be provided a valid PED file (-ped) from the command line containing only 1 trio.");
            }
        }
        HashMap<String, Object> toRet = new HashMap<String, Object>(1);
        boolean bl = hasAppropriateGenotypes = vc.hasGenotype(this.motherId) && vc.getGenotype(this.motherId).hasLikelihoods() && vc.hasGenotype(this.fatherId) && vc.getGenotype(this.fatherId).hasLikelihoods() && vc.hasGenotype(this.childId) && vc.getGenotype(this.childId).hasLikelihoods();
        if (hasAppropriateGenotypes) {
            toRet.put("MVLR", this.mendelianViolation.violationLikelihoodRatio(vc, this.motherId, this.fatherId, this.childId));
        }
        return toRet;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("MVLR");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("MVLR", 1, VCFHeaderLineType.Float, "Mendelian violation likelihood ratio: L[MV] - L[No MV]"));
    }

    private boolean checkAndSetSamples(SampleDB db) {
        Set<String> families = db.getFamilyIDs();
        if (families.size() != 1) {
            return false;
        }
        Set<Sample> family = db.getFamily(families.iterator().next());
        if (family.size() != 3) {
            return false;
        }
        Iterator<Sample> sampleIter = family.iterator();
        Sample sample = sampleIter.next();
        while (sampleIter.hasNext()) {
            if (sample.getParents().size() == 2) {
                this.motherId = sample.getMaternalID();
                this.fatherId = sample.getPaternalID();
                this.childId = sample.getID();
                return true;
            }
            sample = sampleIter.next();
        }
        return false;
    }
}

