/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class TandemRepeatAnnotator
extends InfoFieldAnnotation
implements StandardAnnotation {
    private static final String STR_PRESENT = "STR";
    private static final String REPEAT_UNIT_KEY = "RU";
    private static final String REPEATS_PER_ALLELE_KEY = "RPA";
    protected static final String[] keyNames = new String[]{"STR", "RU", "RPA"};
    protected static final VCFInfoHeaderLine[] descriptions = new VCFInfoHeaderLine[]{new VCFInfoHeaderLine("STR", 0, VCFHeaderLineType.Flag, "Variant is a short tandem repeat"), new VCFInfoHeaderLine("RU", 1, VCFHeaderLineType.String, "Tandem repeat unit (bases)"), new VCFInfoHeaderLine("RPA", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Number of times tandem repeat unit is repeated, for each allele (including reference)")};

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatible walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (!vc.isIndel()) {
            return null;
        }
        Pair<List<Integer>, byte[]> result = VariantContextUtils.getNumTandemRepeatUnits(vc, ref.getForwardBases());
        if (result == null) {
            return null;
        }
        byte[] repeatUnit = (byte[])result.second;
        List numUnits = (List)result.first;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(STR_PRESENT, true);
        map.put(REPEAT_UNIT_KEY, new String(repeatUnit));
        map.put(REPEATS_PER_ALLELE_KEY, numUnits);
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(keyNames);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(descriptions);
    }
}

