/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import net.sf.samtools.SAMFileHeader;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.MappingQualityUnavailableFilter;
import org.broadinstitute.sting.gatk.filters.MappingQualityZeroFilter;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationEngine;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.classloader.GATKLiteUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.recalibration.QuantizationInfo;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.RecalibrationReport;
import org.broadinstitute.sting.utils.recalibration.RecalibrationTables;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

@DocumentedGATKFeature(groupName="BAM Processing and Analysis Tools", extraDocs={CommandLineGATK.class})
@BAQMode(ApplicationTime=BAQ.ApplicationTime.FORBIDDEN)
@By(value=DataSource.READS)
@ReadFilters(value={MappingQualityZeroFilter.class, MappingQualityUnavailableFilter.class})
@Requires(value={DataSource.READS, DataSource.REFERENCE})
@PartitionBy(value=PartitionType.LOCUS)
public class BaseRecalibrator
extends LocusWalker<Long, Long>
implements TreeReducible<Long> {
    @ArgumentCollection
    private final RecalibrationArgumentCollection RAC = new RecalibrationArgumentCollection();
    private QuantizationInfo quantizationInfo;
    private RecalibrationTables recalibrationTables;
    private Covariate[] requestedCovariates;
    private RecalibrationEngine recalibrationEngine;
    private int minimumQToUse;
    protected static final String SKIP_RECORD_ATTRIBUTE = "SKIP";
    protected static final String SEEN_ATTRIBUTE = "SEEN";
    protected static final String COVARS_ATTRIBUTE = "COVARS";
    private static final String NO_DBSNP_EXCEPTION = "This calculation is critically dependent on being able to skip over known variant sites. Please provide a VCF file containing known sites of genetic variation.";

    @Override
    public void initialize() {
        if (this.getToolkit().getArguments().numberOfThreads > 1) {
            throw new UserException("We have temporarily disabled the ability to run BaseRecalibrator multi-threaded for performance reasons.  We hope to have this fixed for the next GATK release (2.2) and apologize for the inconvenience.");
        }
        if (this.getToolkit().isGATKLite() && !this.getToolkit().getArguments().disableIndelQuals) {
            throw new UserException.NotSupportedInGATKLite("base insertion/deletion recalibration is not supported, please use the --disable_indel_quals argument");
        }
        if (this.RAC.FORCE_PLATFORM != null) {
            this.RAC.DEFAULT_PLATFORM = this.RAC.FORCE_PLATFORM;
        }
        if (this.RAC.knownSites.isEmpty() && !this.RAC.RUN_WITHOUT_DBSNP) {
            throw new UserException.CommandLineException(NO_DBSNP_EXCEPTION);
        }
        if (this.RAC.LIST_ONLY) {
            RecalUtils.listAvailableCovariates(logger);
            System.exit(0);
        }
        this.RAC.recalibrationReport = this.getToolkit().getArguments().BQSR_RECAL_FILE;
        Pair<ArrayList<Covariate>, ArrayList<Covariate>> covariates = RecalUtils.initializeCovariates(this.RAC);
        ArrayList<Covariate> requiredCovariates = covariates.getFirst();
        ArrayList<Covariate> optionalCovariates = covariates.getSecond();
        this.requestedCovariates = new Covariate[requiredCovariates.size() + optionalCovariates.size()];
        int covariateIndex = 0;
        for (Covariate covariate : requiredCovariates) {
            this.requestedCovariates[covariateIndex++] = covariate;
        }
        for (Covariate covariate : optionalCovariates) {
            this.requestedCovariates[covariateIndex++] = covariate;
        }
        logger.info("The covariates being used here: ");
        for (Covariate cov : this.requestedCovariates) {
            logger.info("\t" + cov.getClass().getSimpleName());
            cov.initialize(this.RAC);
        }
        int numReadGroups = 0;
        for (SAMFileHeader header : this.getToolkit().getSAMFileHeaders()) {
            numReadGroups += header.getReadGroups().size();
        }
        this.recalibrationTables = new RecalibrationTables(this.requestedCovariates, numReadGroups);
        this.recalibrationEngine = this.initializeRecalibrationEngine();
        this.recalibrationEngine.initialize(this.requestedCovariates, this.recalibrationTables);
        this.minimumQToUse = this.getToolkit().getArguments().PRESERVE_QSCORES_LESS_THAN;
    }

    private RecalibrationEngine initializeRecalibrationEngine() {
        Class recalibrationEngineClass = GATKLiteUtils.getProtectedClassIfAvailable(RecalibrationEngine.class);
        try {
            Constructor constructor = recalibrationEngineClass.getDeclaredConstructor(null);
            constructor.setAccessible(true);
            return (RecalibrationEngine)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Unable to create RecalibrationEngine class instance " + recalibrationEngineClass.getSimpleName());
        }
    }

    private boolean readHasBeenSkipped(GATKSAMRecord read) {
        return read.containsTemporaryAttribute(SKIP_RECORD_ATTRIBUTE);
    }

    private boolean isLowQualityBase(GATKSAMRecord read, int offset) {
        return read.getBaseQualities()[offset] < this.minimumQToUse;
    }

    private boolean readNotSeen(GATKSAMRecord read) {
        return !read.containsTemporaryAttribute(SEEN_ATTRIBUTE);
    }

    @Override
    public Long map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        long countedSites = 0L;
        if (tracker.getValues(this.RAC.knownSites).size() == 0) {
            for (PileupElement p : context.getBasePileup()) {
                GATKSAMRecord read = p.getRead();
                int offset = p.getOffset();
                if (this.readHasBeenSkipped(read) || this.isLowQualityBase(read, offset)) continue;
                if (this.readNotSeen(read)) {
                    read.setTemporaryAttribute(SEEN_ATTRIBUTE, true);
                    RecalUtils.parsePlatformForRead(read, this.RAC);
                    if (!RecalUtils.isColorSpaceConsistent(this.RAC.SOLID_NOCALL_STRATEGY, read)) {
                        read.setTemporaryAttribute(SKIP_RECORD_ATTRIBUTE, true);
                        continue;
                    }
                    read.setTemporaryAttribute(COVARS_ATTRIBUTE, RecalUtils.computeCovariates(read, this.requestedCovariates));
                }
                if (ReadUtils.isSOLiDRead(read) && this.RAC.SOLID_RECAL_MODE != RecalUtils.SOLID_RECAL_MODE.DO_NOTHING && !RecalUtils.isColorSpaceConsistent(read, offset)) continue;
                this.recalibrationEngine.updateDataForPileupElement(p, ref.getBase());
            }
            ++countedSites;
        }
        return countedSites;
    }

    @Override
    public Long reduceInit() {
        return 0L;
    }

    @Override
    public Long reduce(Long mapped, Long sum) {
        sum = sum + mapped;
        return sum;
    }

    @Override
    public Long treeReduce(Long sum1, Long sum2) {
        sum1 = sum1 + sum2;
        return sum1;
    }

    @Override
    public void onTraversalDone(Long result) {
        logger.info("Calculating quantized quality scores...");
        this.quantizeQualityScores();
        logger.info("Writing recalibration report...");
        this.generateReport();
        logger.info("...done!");
        if (!this.RAC.NO_PLOTS) {
            logger.info("Generating recalibration plots...");
            this.generatePlots();
        }
        logger.info("Processed: " + result + " sites");
    }

    private void generatePlots() {
        File recalFile = this.getToolkit().getArguments().BQSR_RECAL_FILE;
        if (recalFile != null) {
            RecalibrationReport report = new RecalibrationReport(recalFile);
            RecalUtils.generateRecalibrationPlot(this.RAC.RECAL_FILE, report.getRecalibrationTables(), this.recalibrationTables, this.requestedCovariates, this.RAC.KEEP_INTERMEDIATE_FILES);
        } else {
            RecalUtils.generateRecalibrationPlot(this.RAC.RECAL_FILE, this.recalibrationTables, this.requestedCovariates, this.RAC.KEEP_INTERMEDIATE_FILES);
        }
    }

    private void quantizeQualityScores() {
        this.quantizationInfo = new QuantizationInfo(this.recalibrationTables, this.RAC.QUANTIZING_LEVELS);
    }

    private void generateReport() {
        PrintStream output;
        try {
            output = new PrintStream(this.RAC.RECAL_FILE);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(this.RAC.RECAL_FILE, "could not be created");
        }
        RecalUtils.outputRecalibrationReport(this.RAC, this.quantizationInfo, this.recalibrationTables, this.requestedCovariates, output);
    }
}

