/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.classloader.PublicPackageSource;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.recalibration.RecalibrationTables;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class StandardRecalibrationEngine
implements RecalibrationEngine,
PublicPackageSource {
    protected Covariate[] covariates;
    protected RecalibrationTables recalibrationTables;

    @Override
    public void initialize(Covariate[] covariates, RecalibrationTables recalibrationTables) {
        this.covariates = covariates;
        this.recalibrationTables = recalibrationTables;
    }

    @Override
    public synchronized void updateDataForPileupElement(PileupElement pileupElement, byte refBase) {
        int offset = pileupElement.getOffset();
        ReadCovariates readCovariates = this.covariateKeySetFrom(pileupElement.getRead());
        byte qual = pileupElement.getQual();
        boolean isError = !BaseUtils.basesAreEqual(pileupElement.getBase(), refBase);
        int[] keys = readCovariates.getKeySet(offset, EventType.BASE_SUBSTITUTION);
        int eventIndex = EventType.BASE_SUBSTITUTION.index;
        NestedIntegerArray<RecalDatum> rgRecalTable = this.recalibrationTables.getTable(RecalibrationTables.TableType.READ_GROUP_TABLE);
        RecalDatum rgPreviousDatum = rgRecalTable.get(keys[0], eventIndex);
        RecalDatum rgThisDatum = this.createDatumObject(qual, isError);
        if (rgPreviousDatum == null) {
            rgRecalTable.put(rgThisDatum, keys[0], eventIndex);
        } else {
            rgPreviousDatum.combine(rgThisDatum);
        }
        NestedIntegerArray<RecalDatum> qualRecalTable = this.recalibrationTables.getTable(RecalibrationTables.TableType.QUALITY_SCORE_TABLE);
        RecalDatum qualPreviousDatum = qualRecalTable.get(keys[0], keys[1], eventIndex);
        if (qualPreviousDatum == null) {
            qualRecalTable.put(this.createDatumObject(qual, isError), keys[0], keys[1], eventIndex);
        } else {
            qualPreviousDatum.increment(isError);
        }
        for (int i = 2; i < this.covariates.length; ++i) {
            if (keys[i] < 0) continue;
            NestedIntegerArray<RecalDatum> covRecalTable = this.recalibrationTables.getTable(i);
            RecalDatum covPreviousDatum = covRecalTable.get(keys[0], keys[1], keys[i], eventIndex);
            if (covPreviousDatum == null) {
                covRecalTable.put(this.createDatumObject(qual, isError), keys[0], keys[1], keys[i], eventIndex);
                continue;
            }
            covPreviousDatum.increment(isError);
        }
    }

    protected RecalDatum createDatumObject(byte reportedQual, boolean isError) {
        return new RecalDatum(1L, isError ? 1L : 0L, reportedQual);
    }

    protected ReadCovariates covariateKeySetFrom(GATKSAMRecord read) {
        return (ReadCovariates)read.getTemporaryAttribute("COVARS");
    }
}

