/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class DepthOfCoverageStats {
    private Map<String, long[]> granularHistogramBySample;
    private Map<String, Long> totalCoverages;
    private int[] binLeftEndpoints;
    private long[][] locusCoverageCounts;
    private boolean tabulateLocusCounts = false;
    private long nLoci;
    private long totalDepthOfCoverage;
    private boolean includeDeletions = false;
    private int[] locusHistogram;
    private int totalLocusDepth;

    public static int[] calculateBinEndpoints(int lower, int upper, int bins) {
        if (bins > upper - lower || lower < 1) {
            throw new UserException.BadInput("the start must be at least 1 and the number of bins may not exceed stop - start");
        }
        int[] binLeftEndpoints = new int[bins + 1];
        binLeftEndpoints[0] = lower;
        int length = upper - lower;
        double scale = Math.log10(length) / (double)bins;
        for (int b = 1; b < bins; ++b) {
            int leftEnd;
            for (leftEnd = lower + (int)Math.floor(Math.pow(10.0, ((double)b - 1.0) * scale)); leftEnd <= binLeftEndpoints[b - 1]; ++leftEnd) {
            }
            binLeftEndpoints[b] = leftEnd;
        }
        binLeftEndpoints[binLeftEndpoints.length - 1] = upper;
        return binLeftEndpoints;
    }

    public DepthOfCoverageStats(int[] leftEndpoints) {
        this.binLeftEndpoints = leftEndpoints;
        this.granularHistogramBySample = new HashMap<String, long[]>();
        this.totalCoverages = new HashMap<String, Long>();
        this.nLoci = 0L;
        this.totalLocusDepth = 0;
        this.totalDepthOfCoverage = 0L;
    }

    public DepthOfCoverageStats(DepthOfCoverageStats cloneMe) {
        this.binLeftEndpoints = cloneMe.binLeftEndpoints;
        this.granularHistogramBySample = new HashMap<String, long[]>();
        this.totalCoverages = new HashMap<String, Long>();
        for (String s : cloneMe.getAllSamples()) {
            this.granularHistogramBySample.put(s, new long[cloneMe.getHistograms().get(s).length]);
            for (int i = 0; i < this.granularHistogramBySample.get(s).length; ++i) {
                this.granularHistogramBySample.get((Object)s)[i] = cloneMe.getHistograms().get(s)[i];
            }
            this.totalCoverages.put(s, cloneMe.totalCoverages.get(s));
        }
        this.includeDeletions = cloneMe.includeDeletions;
        if (cloneMe.tabulateLocusCounts) {
            this.locusCoverageCounts = new long[cloneMe.locusCoverageCounts.length][cloneMe.locusCoverageCounts[0].length];
        }
        this.nLoci = cloneMe.nLoci;
        this.totalDepthOfCoverage = cloneMe.totalDepthOfCoverage;
        this.tabulateLocusCounts = cloneMe.tabulateLocusCounts;
    }

    public void addSample(String sample) {
        if (this.granularHistogramBySample.containsKey(sample)) {
            return;
        }
        long[] binCounts = new long[this.binLeftEndpoints.length + 1];
        for (int b = 0; b < binCounts.length; ++b) {
            binCounts[b] = 0L;
        }
        this.granularHistogramBySample.put(sample, binCounts);
        this.totalCoverages.put(sample, 0L);
    }

    public void initializeLocusCounts() {
        this.locusCoverageCounts = new long[this.granularHistogramBySample.size()][this.binLeftEndpoints.length + 1];
        this.locusHistogram = new int[this.binLeftEndpoints.length + 1];
        for (int b = 0; b < this.binLeftEndpoints.length + 1; ++b) {
            for (int a = 0; a < this.granularHistogramBySample.size(); ++a) {
                this.locusCoverageCounts[a][b] = 0L;
            }
            this.locusHistogram[b] = 0;
        }
        this.tabulateLocusCounts = true;
    }

    public void initializeDeletions() {
        this.includeDeletions = true;
    }

    public void updateDepths(Map<String, Integer> depthBySample) {
        for (String sample : this.granularHistogramBySample.keySet()) {
            int b;
            if (depthBySample.containsKey(sample)) {
                b = this.updateSample(sample, depthBySample.get(sample));
                this.totalLocusDepth += depthBySample.get(sample).intValue();
            } else {
                b = this.updateSample(sample, 0);
            }
            if (!this.tabulateLocusCounts) continue;
            int i = 0;
            while (i <= b) {
                int n = i++;
                this.locusHistogram[n] = this.locusHistogram[n] + 1;
            }
        }
        this.updateLocusCounts(this.locusHistogram);
        ++this.nLoci;
        this.totalDepthOfCoverage += (long)this.totalLocusDepth;
        this.totalLocusDepth = 0;
    }

    public void update(Map<String, int[]> countsBySample) {
        if (countsBySample == null) {
            this.updateDepths(new HashMap<String, Integer>(1));
            return;
        }
        HashMap<String, Integer> depthBySample = new HashMap<String, Integer>();
        for (String s : countsBySample.keySet()) {
            int total = 0;
            int[] counts = countsBySample.get(s);
            for (byte base : BaseUtils.EXTENDED_BASES) {
                if (!this.includeDeletions && base == 68) continue;
                total += counts[BaseUtils.extendedBaseToBaseIndex(base)];
            }
            depthBySample.put(s, total);
        }
        this.updateDepths(depthBySample);
    }

    private int updateSample(String sample, int depth) {
        this.totalCoverages.put(sample, this.totalCoverages.get(sample) + (long)depth);
        long[] granularBins = this.granularHistogramBySample.get(sample);
        for (int b = 0; b < this.binLeftEndpoints.length; ++b) {
            if (depth >= this.binLeftEndpoints[b]) continue;
            int n = b;
            granularBins[n] = granularBins[n] + 1L;
            return b;
        }
        int n = this.binLeftEndpoints.length;
        granularBins[n] = granularBins[n] + 1L;
        return this.binLeftEndpoints.length;
    }

    public void merge(DepthOfCoverageStats newStats) {
        this.mergeSamples(newStats);
        if (this.tabulateLocusCounts && newStats.tabulateLocusCounts) {
            this.mergeLocusCounts(newStats.getLocusCounts());
        }
        this.nLoci += newStats.getTotalLoci();
        this.totalDepthOfCoverage += newStats.getTotalCoverage();
    }

    private void mergeSamples(DepthOfCoverageStats otherStats) {
        Map<String, long[]> otherHistogram = otherStats.getHistograms();
        Map<String, Double> otherMeans = otherStats.getMeans();
        for (String s : this.getAllSamples()) {
            long[] internalCounts = this.granularHistogramBySample.get(s);
            long[] externalCounts = otherHistogram.get(s);
            for (int b = 0; b < internalCounts.length; ++b) {
                int n = b;
                internalCounts[n] = internalCounts[n] + externalCounts[b];
            }
            this.totalCoverages.put(s, this.totalCoverages.get(s) + otherStats.totalCoverages.get(s));
        }
    }

    private void mergeLocusCounts(long[][] otherCounts) {
        for (int a = 0; a < this.locusCoverageCounts.length; ++a) {
            for (int b = 0; b < this.locusCoverageCounts[0].length; ++b) {
                long[] lArray = this.locusCoverageCounts[a];
                int n = b;
                lArray[n] = lArray[n] + otherCounts[a][b];
            }
        }
    }

    private void updateLocusCounts(int[] cumulativeSamplesByDepthBin) {
        if (this.tabulateLocusCounts) {
            for (int bin = 0; bin < cumulativeSamplesByDepthBin.length; ++bin) {
                int numSamples = cumulativeSamplesByDepthBin[bin];
                for (int i = 0; i < numSamples; ++i) {
                    long[] lArray = this.locusCoverageCounts[i];
                    int n = bin;
                    lArray[n] = lArray[n] + 1L;
                }
                cumulativeSamplesByDepthBin[bin] = 0;
            }
        }
    }

    public Map<String, long[]> getHistograms() {
        return this.granularHistogramBySample;
    }

    public long[][] getLocusCounts() {
        return this.locusCoverageCounts;
    }

    public int[] getEndpoints() {
        return this.binLeftEndpoints;
    }

    public Map<String, Double> getMeans() {
        HashMap<String, Double> means = new HashMap<String, Double>();
        for (String s : this.getAllSamples()) {
            means.put(s, (double)this.totalCoverages.get(s).longValue() / (double)this.nLoci);
        }
        return means;
    }

    public Map<String, Long> getTotals() {
        return this.totalCoverages;
    }

    public long getTotalLoci() {
        return this.nLoci;
    }

    public Set<String> getAllSamples() {
        return this.granularHistogramBySample.keySet();
    }

    public double getTotalMeanCoverage() {
        return (double)this.totalDepthOfCoverage / (double)this.nLoci;
    }

    public long getTotalCoverage() {
        return this.totalDepthOfCoverage;
    }

    public double[] getCoverageProportions(String sample) {
        long[] hist = this.granularHistogramBySample.get(sample);
        double[] distribution = new double[hist.length];
        long count = 0L;
        for (int i = hist.length - 1; i >= 0; --i) {
            distribution[i] = (double)(count += hist[i]) / (double)this.nLoci;
        }
        return distribution;
    }

    public int value2bin(int value) {
        for (int index = 0; index < this.binLeftEndpoints.length; ++index) {
            if (this.binLeftEndpoints[index] <= value) continue;
            return index;
        }
        return this.binLeftEndpoints.length - 1;
    }
}

