/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.LocusStatistics;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.ThresHolder;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

class SampleStatistics {
    private final GenomeLoc interval;
    private final ArrayList<LocusStatistics> loci;
    private int[] preSortedDepths = null;
    private int preComputedTotalCoverage = -1;
    private int nReads = -1;
    private int nBadMates = -1;

    private SampleStatistics(GenomeLoc interval, ArrayList<LocusStatistics> loci) {
        this.interval = interval;
        this.loci = loci;
        this.nReads = 0;
        this.nBadMates = 0;
    }

    public SampleStatistics(GenomeLoc interval) {
        this(interval, new ArrayList<LocusStatistics>(interval.size()));
        for (int i = 0; i < interval.size(); ++i) {
            this.loci.add(new LocusStatistics());
        }
    }

    public long totalCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return this.preComputedTotalCoverage;
    }

    public double averageCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return (double)this.preComputedTotalCoverage / (double)this.loci.size();
    }

    public Set<CallableStatus> getCallableStatuses(ThresHolder thresholds) {
        if (this.nReads == 0) {
            return Collections.singleton(CallableStatus.NO_READS);
        }
        HashSet<CallableStatus> output = new HashSet<CallableStatus>();
        HashMap<CallableStatus, Double> totals = new HashMap<CallableStatus, Double>(CallableStatus.values().length);
        for (CallableStatus status : CallableStatus.values()) {
            totals.put(status, 0.0);
        }
        for (int i = 0; i < this.interval.size(); ++i) {
            for (CallableStatus status : this.callableStatus(i, thresholds)) {
                double count = (Double)totals.get((Object)status);
                totals.put(status, count + 1.0);
            }
        }
        double intervalSize = this.interval.size();
        if ((double)this.nBadMates / (double)this.nReads >= thresholds.getBadMateStatusThreshold()) {
            output.add(CallableStatus.BAD_MATE);
        }
        if ((Double)totals.get((Object)CallableStatus.COVERAGE_GAPS) / intervalSize >= thresholds.getCoverageStatusThreshold()) {
            output.add(CallableStatus.COVERAGE_GAPS);
        }
        if ((Double)totals.get((Object)CallableStatus.LOW_COVERAGE) / intervalSize >= thresholds.getCoverageStatusThreshold()) {
            output.add(CallableStatus.LOW_COVERAGE);
        }
        if ((Double)totals.get((Object)CallableStatus.EXCESSIVE_COVERAGE) / intervalSize >= thresholds.getExcessiveCoverageThreshold()) {
            output.add(CallableStatus.EXCESSIVE_COVERAGE);
        }
        if ((Double)totals.get((Object)CallableStatus.POOR_QUALITY) / intervalSize >= thresholds.getQualityStatusThreshold()) {
            output.add(CallableStatus.POOR_QUALITY);
        }
        if ((Double)totals.get((Object)CallableStatus.REF_N) > 0.0) {
            output.add(CallableStatus.REF_N);
        }
        if (output.isEmpty()) {
            output.add(CallableStatus.PASS);
        }
        return output;
    }

    public void addLocus(GenomeLoc locus, ReadBackedPileup pileup, ThresHolder thresholds) {
        if (!this.interval.containsP(locus)) {
            throw new ReviewedStingException(String.format("Locus %s is not part of the Interval %s", locus, this.interval));
        }
        if (pileup != null) {
            int locusIndex = locus.getStart() - this.interval.getStart();
            int rawCoverage = pileup.depthOfCoverage();
            int coverage = thresholds.getFilteredCoverage(pileup);
            LocusStatistics locusData = new LocusStatistics(coverage, rawCoverage);
            this.loci.set(locusIndex, locusData);
            for (GATKSAMRecord read : pileup.getReads()) {
                this.processRead(read, thresholds);
            }
        }
    }

    private void processRead(GATKSAMRecord read, ThresHolder thresholds) {
        if (read.getTemporaryAttribute("checkedBadMate") == null) {
            ++this.nReads;
            if (!this.hasValidMate(read, thresholds)) {
                ++this.nBadMates;
            }
            read.setTemporaryAttribute("checkedBadMate", true);
        }
    }

    private Set<CallableStatus> callableStatus(int locusIndex, ThresHolder thresholds) {
        LocusStatistics locus = this.loci.get(locusIndex);
        return locus.callableStatuses(thresholds);
    }

    private void calculateTotalCoverage() {
        this.preComputedTotalCoverage = 0;
        for (LocusStatistics locus : this.loci) {
            this.preComputedTotalCoverage += locus.getCoverage();
        }
    }

    public double getQuantileDepth(double percentage) {
        if (this.preSortedDepths == null) {
            this.getDepthsAsSortedArray();
        }
        return SampleStatistics.getQuartile(this.preSortedDepths, percentage);
    }

    static double getQuartile(int[] data, double percentage) {
        int size = data.length;
        if (size == 1) {
            return data[0];
        }
        if (percentage == 0.5) {
            return SampleStatistics.getMedian(data);
        }
        double position = ((double)size - 1.0) / 2.0;
        if (percentage == 0.25) {
            return SampleStatistics.getMedian(Arrays.copyOfRange(data, 0, (int)position + 1));
        }
        if (percentage == 0.75) {
            if (position % 1.0 == 0.0) {
                return SampleStatistics.getMedian(Arrays.copyOfRange(data, (int)position, size));
            }
            return SampleStatistics.getMedian(Arrays.copyOfRange(data, (int)position + 1, size));
        }
        return -1.0;
    }

    private static double getMedian(int[] data) {
        double size = data.length;
        if (size == 1.0) {
            return data[0];
        }
        double position = (size - 1.0) / 2.0;
        if (position % 1.0 == 0.0) {
            return data[(int)position];
        }
        double high = data[(int)Math.ceil(position)];
        double low = data[(int)Math.floor(position)];
        return (high + low) / 2.0;
    }

    private void getDepthsAsSortedArray() {
        this.preSortedDepths = new int[this.loci.size()];
        for (int i = 0; i < this.loci.size(); ++i) {
            this.preSortedDepths[i] = this.loci.get(i).getCoverage();
        }
        Arrays.sort(this.preSortedDepths);
    }

    boolean hasValidMate(GATKSAMRecord read, ThresHolder thresholds) {
        if (!read.getReadPairedFlag()) {
            return false;
        }
        if (!read.getMateReferenceIndex().equals(read.getReferenceIndex())) {
            return false;
        }
        if (read.getMateUnmappedFlag() || read.getReadUnmappedFlag()) {
            return false;
        }
        if (read.getReadNegativeStrandFlag() == read.getMateNegativeStrandFlag()) {
            return false;
        }
        if (read.getReadNegativeStrandFlag() == read.getAlignmentStart() < read.getMateAlignmentStart()) {
            return false;
        }
        return Math.abs(read.getAlignmentStart() - read.getMateAlignmentStart()) <= thresholds.getMaximumInsertSize();
    }

    public int getnReads() {
        return this.nReads;
    }

    public int getnBadMates() {
        return this.nBadMates;
    }
}

