/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.FeatureCodec;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffNode;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffableReader;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.AbstractVCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFIDHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFDiffableReader
implements DiffableReader {
    private static Logger logger = Logger.getLogger(VCFDiffableReader.class);

    @Override
    public String getName() {
        return "VCF";
    }

    @Override
    public DiffElement readFromFile(File file, int maxElementsToRead) {
        DiffNode root = DiffNode.rooted(file.getName());
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String version = br.readLine();
            root.add("VERSION", version);
            br.close();
            VCFCodec vcfCodec = new VCFCodec();
            vcfCodec.disableOnTheFlyModifications();
            AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), (FeatureCodec)vcfCodec, false);
            VCFHeader header = (VCFHeader)reader.getHeader();
            for (VCFHeaderLine headerLine : header.getMetaDataInInputOrder()) {
                String key = headerLine.getKey();
                if (headerLine instanceof VCFIDHeaderLine) {
                    key = key + "_" + ((VCFIDHeaderLine)((Object)headerLine)).getID();
                }
                if (root.hasElement(key)) {
                    logger.warn("Skipping duplicate header line: file=" + file + " line=" + headerLine.toString());
                    continue;
                }
                root.add(key, headerLine.toString());
            }
            int count = 0;
            int nRecordsAtPos = 1;
            String prevName = "";
            CloseableTribbleIterator it = reader.iterator();
            while (it.hasNext()) {
                VariantContext vc = (VariantContext)it.next();
                String name = vc.getChr() + ":" + vc.getStart();
                if (name.equals(prevName)) {
                    name = name + "_" + ++nRecordsAtPos;
                } else {
                    prevName = name;
                }
                DiffNode vcRoot = DiffNode.empty(name, root);
                vcRoot.add("CHROM", vc.getChr());
                vcRoot.add("POS", vc.getStart());
                vcRoot.add("ID", vc.getID());
                vcRoot.add("REF", vc.getReference());
                vcRoot.add("ALT", vc.getAlternateAlleles());
                vcRoot.add("QUAL", vc.hasLog10PError() ? Double.valueOf(vc.getLog10PError() * -10.0) : ".");
                vcRoot.add("FILTER", !vc.filtersWereApplied() ? "." : (vc.getFilters().isEmpty() ? "PASS" : vc.getFilters()));
                for (Map.Entry<String, Object> attribute : vc.getAttributes().entrySet()) {
                    if (attribute.getKey().startsWith("_")) continue;
                    vcRoot.add(attribute.getKey(), attribute.getValue());
                }
                for (Genotype g : vc.getGenotypes()) {
                    DiffNode gRoot = DiffNode.empty(g.getSampleName(), vcRoot);
                    gRoot.add("GT", g.getGenotypeString());
                    if (g.hasGQ()) {
                        gRoot.add("GQ", g.getGQ());
                    }
                    if (g.hasDP()) {
                        gRoot.add("DP", g.getDP());
                    }
                    if (g.hasAD()) {
                        gRoot.add("AD", Utils.join(",", g.getAD()));
                    }
                    if (g.hasPL()) {
                        gRoot.add("PL", Utils.join(",", g.getPL()));
                    }
                    if (g.getFilters() != null) {
                        gRoot.add("FT", g.getFilters());
                    }
                    for (Map.Entry<String, Object> attribute : g.getExtendedAttributes().entrySet()) {
                        if (attribute.getKey().startsWith("_")) continue;
                        gRoot.add(attribute.getKey(), attribute.getValue());
                    }
                    vcRoot.add(gRoot);
                }
                root.add(vcRoot);
                if ((count += vcRoot.size()) <= maxElementsToRead || maxElementsToRead == -1) continue;
                break;
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        return root.getBinding();
    }

    @Override
    public boolean canRead(File file) {
        return AbstractVCFCodec.canDecodeFile(file.getPath(), "##fileformat=VCFv4");
    }
}

