/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;

class VCFIndelAttributes {
    public static String ALLELIC_DEPTH_KEY = "AD";
    public static String DEPTH_TOTAL_KEY = "DP";
    public static String MAPQ_KEY = "MQS";
    public static String MM_KEY = "MM";
    public static String NQS_MMRATE_KEY = "NQSMM";
    public static String NQS_AVQ_KEY = "NQSBQ";
    public static String STRAND_COUNT_KEY = "SC";
    public static String RSTART_OFFSET_KEY = "RStart";
    public static String REND_OFFSET_KEY = "REnd";

    VCFIndelAttributes() {
    }

    public static Set<? extends VCFHeaderLine> getAttributeHeaderLines() {
        HashSet<VCFFormatHeaderLine> lines = new HashSet<VCFFormatHeaderLine>();
        lines.add(new VCFFormatHeaderLine(ALLELIC_DEPTH_KEY, 2, VCFHeaderLineType.Integer, "# of reads supporting consensus indel/reference at the site"));
        lines.add(new VCFFormatHeaderLine(DEPTH_TOTAL_KEY, 1, VCFHeaderLineType.Integer, "Total coverage at the site"));
        lines.add(new VCFFormatHeaderLine(MAPQ_KEY, 2, VCFHeaderLineType.Float, "Average mapping qualities of consensus indel-supporting reads/reference-supporting reads"));
        lines.add(new VCFFormatHeaderLine(MM_KEY, 2, VCFHeaderLineType.Float, "Average # of mismatches per consensus indel-supporting read/per reference-supporting read"));
        lines.add(new VCFFormatHeaderLine(NQS_MMRATE_KEY, 2, VCFHeaderLineType.Float, "Within NQS window: fraction of mismatching bases in consensus indel-supporting reads/in reference-supporting reads"));
        lines.add(new VCFFormatHeaderLine(NQS_AVQ_KEY, 2, VCFHeaderLineType.Float, "Within NQS window: average quality of bases from consensus indel-supporting reads/from reference-supporting reads"));
        lines.add(new VCFFormatHeaderLine(STRAND_COUNT_KEY, 4, VCFHeaderLineType.Integer, "Strandness: counts of forward-/reverse-aligned indel-supporting reads / forward-/reverse-aligned reference supporting reads"));
        lines.add(new VCFFormatHeaderLine(RSTART_OFFSET_KEY, 2, VCFHeaderLineType.Integer, "Median/mad of indel offsets from the starts of the reads"));
        lines.add(new VCFFormatHeaderLine(REND_OFFSET_KEY, 2, VCFHeaderLineType.Integer, "Median/mad of indel offsets from the ends of the reads"));
        return lines;
    }

    public static Map<String, Object> recordStrandCounts(int cnt_cons_fwd, int cnt_cons_rev, int cnt_ref_fwd, int cnt_ref_rev, Map<String, Object> attrs) {
        attrs.put(STRAND_COUNT_KEY, new Integer[]{cnt_cons_fwd, cnt_cons_rev, cnt_ref_fwd, cnt_ref_rev});
        return attrs;
    }

    public static Map<String, Object> recordDepth(int cnt_cons, int cnt_indel, int cnt_total, Map<String, Object> attrs) {
        attrs.put(ALLELIC_DEPTH_KEY, new Integer[]{cnt_cons, cnt_indel});
        attrs.put(DEPTH_TOTAL_KEY, cnt_total);
        return attrs;
    }

    public static Map<String, Object> recordAvMapQ(double cons, double ref, Map<String, Object> attrs) {
        attrs.put(MAPQ_KEY, new Float[]{Float.valueOf((float)cons), Float.valueOf((float)ref)});
        return attrs;
    }

    public static Map<String, Object> recordAvMM(double cons, double ref, Map<String, Object> attrs) {
        attrs.put(MM_KEY, new Float[]{Float.valueOf((float)cons), Float.valueOf((float)ref)});
        return attrs;
    }

    public static Map<String, Object> recordNQSMMRate(double cons, double ref, Map<String, Object> attrs) {
        attrs.put(NQS_MMRATE_KEY, new Float[]{Float.valueOf((float)cons), Float.valueOf((float)ref)});
        return attrs;
    }

    public static Map<String, Object> recordNQSAvQ(double cons, double ref, Map<String, Object> attrs) {
        attrs.put(NQS_AVQ_KEY, new Float[]{Float.valueOf((float)cons), Float.valueOf((float)ref)});
        return attrs;
    }

    public static Map<String, Object> recordOffsetFromStart(int median, int mad, Map<String, Object> attrs) {
        attrs.put(RSTART_OFFSET_KEY, new Integer[]{median, mad});
        return attrs;
    }

    public static Map<String, Object> recordOffsetFromEnd(int median, int mad, Map<String, Object> attrs) {
        attrs.put(REND_OFFSET_KEY, new Integer[]{median, mad});
        return attrs;
    }
}

