/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;

class DisjointSet {
    private ItemNode[] nodes;

    public DisjointSet(int numItems) {
        this.nodes = new ItemNode[numItems];
        for (int i = 0; i < numItems; ++i) {
            this.nodes[i] = new ItemNode(i);
        }
    }

    public int findSet(int itemIndex) {
        ItemNode curNode = this.nodes[itemIndex];
        while (curNode.parent != null) {
            curNode = curNode.parent;
        }
        ItemNode root = curNode;
        curNode = this.nodes[itemIndex];
        while (curNode != root) {
            ItemNode next = curNode.parent;
            curNode.parent = root;
            curNode = next;
        }
        return root.itemIndex;
    }

    public boolean inSameSet(int x, int y) {
        return x == y || this.nodes[x].parent == this.nodes[y].parent || this.findSet(x) == this.findSet(y);
    }

    public Set<Integer> inSameSetAs(int x, Collection<Integer> testSet) {
        TreeSet<Integer> sameSetInds = new TreeSet<Integer>();
        int xSet = this.findSet(x);
        for (int t : testSet) {
            if (this.findSet(t) != xSet) continue;
            sameSetInds.add(t);
        }
        return sameSetInds;
    }

    public void setUnion(int x, int y) {
        this.link(this.findSet(x), this.findSet(y));
    }

    private void link(int x, int y) {
        if (x == y) {
            return;
        }
        if (this.nodes[x].rank > this.nodes[y].rank) {
            this.nodes[y].parent = this.nodes[x];
        } else {
            this.nodes[x].parent = this.nodes[y];
            if (this.nodes[x].rank == this.nodes[y].rank) {
                this.nodes[y].rank++;
            }
        }
    }

    private class ItemNode {
        private int itemIndex;
        private ItemNode parent;
        private int rank;

        public ItemNode(int itemIndex) {
            this.itemIndex = itemIndex;
            this.parent = null;
            this.rank = 0;
        }
    }
}

