/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector;

import java.util.TreeSet;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.ExactAFCalculationModel;
import org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector.SampleSelector;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class GLBasedSampleSelector
extends SampleSelector {
    double[] flatPriors = null;
    double referenceLikelihood;

    public GLBasedSampleSelector(TreeSet<String> sm, double refLik) {
        super(sm);
        this.referenceLikelihood = refLik;
    }

    @Override
    public boolean selectSiteInSamples(VariantContext vc) {
        if (this.samples == null || this.samples.isEmpty()) {
            return true;
        }
        VariantContext subContext = vc.subContextFromSamples(this.samples);
        if (this.flatPriors == null) {
            this.flatPriors = new double[1 + 2 * this.samples.size()];
        }
        AlleleFrequencyCalculationResult result = new AlleleFrequencyCalculationResult(vc.getAlternateAlleles().size());
        ExactAFCalculationModel.linearExactMultiAllelic(subContext.getGenotypes(), vc.getAlternateAlleles().size(), this.flatPriors, result);
        return result.getLog10PosteriorOfAFzero() < this.referenceLikelihood;
    }
}

