/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Molten;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeType;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="Genotype Concordance Detailed", description="Determine the genotype concordance between the genotypes in difference tracks, and  concordance statistics")
public class GenotypeConcordance
extends VariantEvaluator {
    protected static final Logger logger = Logger.getLogger(GenotypeConcordance.class);
    @Molten(variableFormat="%s", valueFormat="%s")
    public final Map<Object, Object> map = new TreeMap<Object, Object>();
    private final long[][] truthByCalledGenotypeCounts;

    public GenotypeConcordance() {
        int nGenotypeTypes = GenotypeType.values().length;
        this.truthByCalledGenotypeCounts = new long[nGenotypeTypes][nGenotypeTypes];
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void update2(VariantContext eval, VariantContext validation, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (validation != null && !validation.hasGenotypes() || eval == null && !GenotypeConcordance.isValidVC(validation)) {
            return;
        }
        boolean validationIsValidVC = GenotypeConcordance.isValidVC(validation);
        if (eval != null) {
            for (Genotype g : eval.getGenotypes()) {
                String sample = g.getSampleName();
                GenotypeType called = g.getType();
                GenotypeType truth = !validationIsValidVC || !validation.hasGenotype(sample) ? GenotypeType.NO_CALL : validation.getGenotype(sample).getType();
                this.incrValue(truth, called);
            }
        } else {
            GenotypeType called = GenotypeType.NO_CALL;
            for (Genotype g : validation.getGenotypes()) {
                GenotypeType truth = g.getType();
                this.incrValue(truth, called);
            }
        }
    }

    private static boolean isValidVC(VariantContext vc) {
        return vc != null && !vc.isFiltered();
    }

    private void incrValue(GenotypeType truth, GenotypeType called) {
        long[] lArray = this.truthByCalledGenotypeCounts[truth.ordinal()];
        int n = called.ordinal();
        lArray[n] = lArray[n] + 1L;
    }

    private long count(GenotypeType truth, GenotypeType called) {
        return this.truthByCalledGenotypeCounts[truth.ordinal()][called.ordinal()];
    }

    private long count(EnumSet<GenotypeType> truth, GenotypeType called) {
        return this.count(truth, EnumSet.of(called));
    }

    private long count(GenotypeType truth, EnumSet<GenotypeType> called) {
        return this.count(EnumSet.of(truth), called);
    }

    private long count(EnumSet<GenotypeType> truth, EnumSet<GenotypeType> called) {
        long sum = 0L;
        for (GenotypeType truth1 : truth) {
            for (GenotypeType called1 : called) {
                sum += this.count(truth1, called1);
            }
        }
        return sum;
    }

    private long countDiag(EnumSet<GenotypeType> d1) {
        long sum = 0L;
        for (GenotypeType e1 : d1) {
            sum += this.truthByCalledGenotypeCounts[e1.ordinal()][e1.ordinal()];
        }
        return sum;
    }

    @Override
    public void finalizeEvaluation() {
        String field;
        EnumSet<GenotypeType> allVariantGenotypes = EnumSet.of(GenotypeType.HOM_VAR, GenotypeType.HET);
        EnumSet<GenotypeType> allCalledGenotypes = EnumSet.of(GenotypeType.HOM_VAR, GenotypeType.HET, GenotypeType.HOM_REF);
        EnumSet<GenotypeType> allGenotypes = EnumSet.allOf(GenotypeType.class);
        for (GenotypeType truth : GenotypeType.values()) {
            for (GenotypeType called : GenotypeType.values()) {
                String field2 = String.format("n_true_%s_called_%s", new Object[]{truth, called});
                Long value = this.count(truth, called);
                this.map.put(field2, value.toString());
            }
        }
        for (GenotypeType called : GenotypeType.values()) {
            field = String.format("total_called_%s", new Object[]{called});
            Long value = this.count(allGenotypes, called);
            this.map.put(field, value.toString());
        }
        for (GenotypeType truth : GenotypeType.values()) {
            field = String.format("total_true_%s", new Object[]{truth});
            Long value = this.count(truth, allGenotypes);
            this.map.put(field, value.toString());
        }
        for (GenotypeType genotype : GenotypeType.values()) {
            field = String.format("percent_%s_called_%s", new Object[]{genotype, genotype});
            long numer = this.count(genotype, genotype);
            long denom = this.count(EnumSet.of(genotype), allGenotypes);
            this.map.put(field, Utils.formattedPercent(numer, denom));
        }
        String field3 = "percent_non_reference_sensitivity";
        long numer = this.count(allVariantGenotypes, allVariantGenotypes);
        long denom = this.count(allVariantGenotypes, allGenotypes);
        this.map.put("percent_non_reference_sensitivity", Utils.formattedPercent(numer, denom));
        field3 = "percent_overall_genotype_concordance";
        numer = this.countDiag(allCalledGenotypes);
        denom = this.count(allCalledGenotypes, allCalledGenotypes);
        this.map.put("percent_overall_genotype_concordance", Utils.formattedPercent(numer, denom));
        field3 = "percent_non_reference_discrepancy_rate";
        long homrefConcords = this.count(GenotypeType.HOM_REF, GenotypeType.HOM_REF);
        long allNoHomRef = this.count(allCalledGenotypes, allCalledGenotypes) - homrefConcords;
        long numer2 = allNoHomRef - this.countDiag(allVariantGenotypes);
        long denom2 = this.count(allCalledGenotypes, allCalledGenotypes) - homrefConcords;
        this.map.put("percent_non_reference_discrepancy_rate", Utils.formattedPercent(numer2, denom2));
    }
}

