/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class CpG
extends VariantStratifier {
    @Override
    public void initialize() {
        this.states.add("all");
        this.states.add("CpG");
        this.states.add("non_CpG");
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        String fwRefBases;
        String rightFlank;
        boolean isCpG = false;
        if (ref != null && ref.getBases() != null && (rightFlank = (fwRefBases = new String(ref.getBases())).substring(fwRefBases.length() / 2, fwRefBases.length() / 2 + 2)).equalsIgnoreCase("CG")) {
            isCpG = true;
        }
        ArrayList<Object> relevantStates = new ArrayList<Object>(2);
        relevantStates.add("all");
        relevantStates.add(isCpG ? "CpG" : "non_CpG");
        return relevantStates;
    }
}

