/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.writer.VariantContextWriter;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
@Reference(window=@Window(start=0, stop=100))
public class FilterLiftedVariants
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    private static final int MAX_VARIANT_SIZE = 100;
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter writer = null;
    private long failedLocs = 0L;
    private long totalLocs = 0L;

    @Override
    public void initialize() {
        String trackName = this.variantCollection.variants.getName();
        Set<String> samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), Arrays.asList(trackName));
        Map<String, VCFHeader> vcfHeaders = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(trackName));
        VCFHeader vcfHeader = new VCFHeader(vcfHeaders.containsKey(trackName) ? vcfHeaders.get(trackName).getMetaDataInSortedOrder() : Collections.emptySet(), samples);
        this.writer.writeHeader(vcfHeader);
    }

    private void filterAndWrite(byte[] ref, VariantContext vc) {
        ++this.totalLocs;
        boolean failed = false;
        byte[] recordRef = vc.getReference().getBases();
        for (int i = 0; i < recordRef.length && i < 100; ++i) {
            if (recordRef[i] == ref[i + (vc.isPointEvent() ? 0 : 1)]) continue;
            failed = true;
            break;
        }
        if (failed) {
            ++this.failedLocs;
        } else {
            this.writer.add(vc);
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        for (VariantContext vc : VCs) {
            this.filterAndWrite(ref.getBases(), vc);
        }
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return 0;
    }

    @Override
    public void onTraversalDone(Integer result) {
        System.out.println("Filtered " + this.failedLocs + " records out of " + this.totalLocs + " total records.");
    }
}

