/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.classloader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.reflections.util.ClasspathHelper;

public class JVMUtils {
    private JVMUtils() {
    }

    public static File getLocationFor(Class clazz) throws IOException {
        try {
            URI locationURI = clazz.getProtectionDomain().getCodeSource().getLocation().toURI();
            return new File(locationURI);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        catch (NullPointerException ne) {
            throw new IOException("Can not extract code source location for " + clazz.getName());
        }
    }

    public static boolean isConcrete(Class clazz) {
        return !Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers());
    }

    public static boolean isAnonymous(Class clazz) {
        return clazz.isAnonymousClass();
    }

    public static List<Field> getAllFields(Class type) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        while (type != null) {
            allFields.addAll(Arrays.asList(type.getDeclaredFields()));
            type = type.getSuperclass();
        }
        return allFields;
    }

    public static Field findField(Class type, String fieldName) {
        while (type != null) {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            type = type.getSuperclass();
        }
        return null;
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException ex) {
            throw new ReviewedStingException(String.format("Could not set %s in instance %s to %s", field.getName(), instance.getClass().getName(), value.toString()));
        }
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException ex) {
            throw new ReviewedStingException(String.format("Could not retrieve %s in instance %s", field.getName(), instance.getClass().getName()));
        }
    }

    public static <T> T getObjectOfType(Collection<Object> objectsToFilter, Class<T> type) {
        Collection<T> selectedObjects = JVMUtils.getObjectsOfType(objectsToFilter, type);
        if (selectedObjects.size() > 1) {
            throw new ReviewedStingException("User asked for a single instance of the type, multiple were present");
        }
        if (selectedObjects.size() == 0) {
            throw new ReviewedStingException("User asked for a single instance of the type, but none were present");
        }
        return selectedObjects.iterator().next();
    }

    public static <T> Collection<T> getObjectsOfType(Collection<Object> objectsToFilter, Class<T> type) {
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (Object object : objectsToFilter) {
            if (!type.isAssignableFrom(object.getClass())) continue;
            selectedObjects.add(object);
        }
        return selectedObjects;
    }

    public static Set<URL> getClasspathURLs() {
        return ClasspathHelper.getUrlsForManifestsCurrentClasspath();
    }

    public static void addGenericTypes(Set<Class<?>> classes, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type actualType : parameterizedType.getActualTypeArguments()) {
                JVMUtils.addGenericTypes(classes, actualType);
            }
        } else if (type instanceof GenericArrayType) {
            JVMUtils.addGenericTypes(classes, ((GenericArrayType)type).getGenericComponentType());
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type upperType : wildcardType.getUpperBounds()) {
                JVMUtils.addGenericTypes(classes, upperType);
            }
            for (Type lowerType : wildcardType.getLowerBounds()) {
                JVMUtils.addGenericTypes(classes, lowerType);
            }
        } else if (type instanceof Class) {
            classes.add((Class)type);
        } else {
            throw new StingException("Unknown type: " + type + " (" + type.getClass().getName() + ")");
        }
    }

    public static Class getParameterizedTypeClass(Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)t;
            if (parameterizedType.getActualTypeArguments().length != 1) {
                throw new ReviewedStingException("BUG: more than 1 generic type found on class" + t);
            }
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        throw new ReviewedStingException("BUG: could not find generic type on class " + t);
    }

    public static String classInterfaces(Class covClass) {
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Class<?> interfaceClass : covClass.getInterfaces()) {
            interfaces.add(interfaceClass.getSimpleName());
        }
        return Utils.join(", ", interfaces);
    }
}

