/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.classloader;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.LoggerFactory;

public class PluginManager<PluginType> {
    private static final Reflections defaultReflections;
    protected final String pluginCategory;
    protected final String pluginSuffix;
    private final SortedMap<String, Class<? extends PluginType>> pluginsByName;
    private final List<Class<? extends PluginType>> plugins;
    private final List<Class<? extends PluginType>> interfaces;

    public PluginManager(Class<PluginType> pluginType) {
        this(pluginType, pluginType.getSimpleName().toLowerCase(), pluginType.getSimpleName(), null);
    }

    public PluginManager(Class<PluginType> pluginType, List<URL> classpath) {
        this(pluginType, pluginType.getSimpleName().toLowerCase(), pluginType.getSimpleName(), classpath);
    }

    public PluginManager(Class<PluginType> pluginType, String pluginCategory, String pluginSuffix) {
        this(pluginType, pluginCategory, pluginSuffix, null);
    }

    public PluginManager(Class<PluginType> pluginType, String pluginCategory, String pluginSuffix, List<URL> classpath) {
        Reflections reflections;
        this.pluginCategory = pluginCategory;
        this.pluginSuffix = pluginSuffix;
        this.plugins = new ArrayList<Class<? extends PluginType>>();
        this.interfaces = new ArrayList<Class<? extends PluginType>>();
        if (classpath == null) {
            reflections = defaultReflections;
        } else {
            PluginManager.addClasspath(classpath);
            reflections = new Reflections(new ConfigurationBuilder().setUrls(classpath).setScanners(new SubTypesScanner()));
        }
        Set<Class<PluginType>> allTypes = reflections.getSubTypesOf(pluginType);
        for (Class<PluginType> clazz : allTypes) {
            if (JVMUtils.isAnonymous(clazz)) continue;
            if (JVMUtils.isConcrete(clazz)) {
                this.plugins.add(clazz);
                continue;
            }
            this.interfaces.add(clazz);
        }
        this.pluginsByName = new TreeMap<String, Class<? extends PluginType>>();
        for (Class<Object> clazz : this.plugins) {
            String pluginName = this.getName(clazz);
            this.pluginsByName.put(pluginName, clazz);
        }
        this.sortPlugins(this.plugins);
        this.sortPlugins(this.interfaces);
    }

    private final void sortPlugins(List<Class<? extends PluginType>> unsortedPlugins) {
        Collections.sort(unsortedPlugins, new ComparePluginsByName());
    }

    private static void addClasspath(List<URL> urls) {
        Set<URL> existing = JVMUtils.getClasspathURLs();
        for (URL url : urls) {
            if (existing.contains(url)) continue;
            try {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)ClassLoader.getSystemClassLoader(), url);
            }
            catch (Exception e) {
                throw new ReviewedStingException("Error adding url to the current classloader.", e);
            }
        }
    }

    public Map<String, Class<? extends PluginType>> getPluginsByName() {
        return Collections.unmodifiableMap(this.pluginsByName);
    }

    public boolean exists(String pluginName) {
        return this.pluginsByName.containsKey(pluginName);
    }

    public boolean exists(Class<?> plugin) {
        return this.pluginsByName.containsValue(plugin);
    }

    public List<Class<? extends PluginType>> getPlugins() {
        return this.plugins;
    }

    public List<Class<? extends PluginType>> getInterfaces() {
        return this.interfaces;
    }

    public List<Class<? extends PluginType>> getPluginsImplementing(Class<?> type) {
        ArrayList<Class<PluginType>> implementing = new ArrayList<Class<PluginType>>();
        for (Class<PluginType> plugin : this.getPlugins()) {
            if (!type.isAssignableFrom(plugin)) continue;
            implementing.add(plugin);
        }
        return implementing;
    }

    public PluginType createByName(String pluginName) {
        Class plugin = (Class)this.pluginsByName.get(pluginName);
        if (plugin == null) {
            throw new UserException(String.format("Could not find %s with name: %s", this.pluginCategory, pluginName));
        }
        try {
            return (PluginType)plugin.newInstance();
        }
        catch (Exception e) {
            throw new DynamicClassResolutionException(plugin, e);
        }
    }

    public PluginType createByType(Class<? extends PluginType> pluginType) {
        try {
            Constructor<PluginType> noArgsConstructor = pluginType.getDeclaredConstructor(null);
            noArgsConstructor.setAccessible(true);
            return noArgsConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new DynamicClassResolutionException(pluginType, e);
        }
    }

    public List<PluginType> createAllTypes() {
        ArrayList<PluginType> instances = new ArrayList<PluginType>();
        for (Class<PluginType> c : this.getPlugins()) {
            instances.add(this.createByType(c));
        }
        return instances;
    }

    public String getName(Class<? extends PluginType> pluginType) {
        String pluginName = "";
        if (pluginName.length() == 0) {
            pluginName = pluginType.getSimpleName();
            if (this.pluginSuffix != null && pluginName.endsWith(this.pluginSuffix)) {
                pluginName = pluginName.substring(0, pluginName.lastIndexOf(this.pluginSuffix));
            }
        }
        return pluginName;
    }

    static {
        URL cwd;
        Logger logger = (Logger)LoggerFactory.getLogger(Reflections.class);
        logger.setLevel(Level.OFF);
        LinkedHashSet<URL> classPathUrls = new LinkedHashSet<URL>();
        try {
            cwd = new File(".").getAbsoluteFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        for (URL url : JVMUtils.getClasspathURLs()) {
            if (url.equals(cwd)) continue;
            classPathUrls.add(url);
        }
        defaultReflections = new Reflections(new ConfigurationBuilder().setUrls(classPathUrls).setScanners(new SubTypesScanner()));
    }

    private final class ComparePluginsByName
    implements Comparator<Class<? extends PluginType>> {
        private ComparePluginsByName() {
        }

        @Override
        public int compare(Class<? extends PluginType> aClass, Class<? extends PluginType> aClass1) {
            String pluginName1 = PluginManager.this.getName(aClass);
            String pluginName2 = PluginManager.this.getName(aClass1);
            return pluginName1.compareTo(pluginName2);
        }
    }
}

