/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.samread;

import net.sf.samtools.Cigar;
import net.sf.samtools.TextCigarCodec;
import net.sf.samtools.util.StringUtil;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.samread.SAMReadFeature;

public class SAMReadCodec
extends AsciiFeatureCodec<SAMReadFeature> {
    private static final int expectedTokenCount = 11;

    public SAMReadCodec() {
        super(SAMReadFeature.class);
    }

    @Override
    public SAMReadFeature decode(String line) {
        if (line.startsWith("@")) {
            return null;
        }
        String[] tokens = new String[11];
        int count = ParsingUtils.splitWhitespace(line, tokens);
        if (count != 11) {
            throw new CodecLineParsingException("the SAM read line didn't have the expected number of tokens (expected = 11, saw = " + count + " on " + "line = " + line + ")");
        }
        String readName = tokens[0];
        int flags = Integer.parseInt(tokens[1]);
        String contigName = tokens[2];
        int alignmentStart = Integer.parseInt(tokens[3]);
        int mapQ = Integer.parseInt(tokens[4]);
        String cigarString = tokens[5];
        String mateContigName = tokens[6];
        int mateAlignmentStart = Integer.parseInt(tokens[7]);
        int inferredInsertSize = Integer.parseInt(tokens[8]);
        byte[] bases = StringUtil.stringToBytes(tokens[9]);
        byte[] qualities = StringUtil.stringToBytes(tokens[10]);
        Cigar cigar = TextCigarCodec.getSingleton().decode(cigarString);
        int alignmentEnd = alignmentStart + cigar.getReferenceLength() - 1;
        for (byte quality : qualities) {
            quality = (byte)(quality - 33);
        }
        return new SAMReadFeature(readName, flags, contigName, alignmentStart, alignmentEnd, mapQ, cigarString, mateContigName, mateAlignmentStart, inferredInsertSize, bases, qualities);
    }
}

