/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ArtificialSAMFileReader
extends SAMFileReader {
    private final GenomeLocParser genomeLocParser;
    private final List<SAMRecord> reads;

    public ArtificialSAMFileReader(SAMSequenceDictionary sequenceDictionary, SAMRecord ... reads) {
        super(ArtificialSAMFileReader.createEmptyInputStream(), true);
        this.genomeLocParser = new GenomeLocParser(sequenceDictionary);
        this.reads = Arrays.asList(reads);
    }

    @Override
    public SAMRecordIterator query(String sequence, int start, int end, boolean contained) {
        GenomeLoc region = this.genomeLocParser.createGenomeLoc(sequence, start, end);
        ArrayList<SAMRecord> coveredSubset = new ArrayList<SAMRecord>();
        for (SAMRecord read : this.reads) {
            GenomeLoc readPosition = this.genomeLocParser.createGenomeLoc(read);
            if (contained && region.containsP(readPosition)) {
                coveredSubset.add(read);
                continue;
            }
            if (contained || !readPosition.overlapsP(region)) continue;
            coveredSubset.add(read);
        }
        final Iterator iterator = coveredSubset.iterator();
        return new SAMRecordIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return (SAMRecord)iterator.next();
            }

            @Override
            public void close() {
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
                return this;
            }
        };
    }

    @Override
    public SAMRecordIterator iterator() {
        return new SAMRecordIterator(){
            private final Iterator<SAMRecord> iterator;
            {
                this.iterator = ArtificialSAMFileReader.this.reads.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SAMRecord next() {
                return this.iterator.next();
            }

            @Override
            public void close() {
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }

            @Override
            public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
                return this;
            }
        };
    }

    private static InputStream createEmptyInputStream() {
        try {
            byte[] byteArray = "".getBytes("ISO-8859-1");
            return new ByteArrayInputStream(byteArray);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ReviewedStingException("Unable to build empty input stream", ex);
        }
    }
}

