\name{pvalstest}
\alias{pvalstest}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Permutation p-values for copy number data}
\description{
  This function provides raw permuation p-values for a few test statistics on discretized copy number data. It also provides a permutation matrix of p-values which may be used for estimating False Discovery Rate.
}
\usage{
pvalstest(datacgh, data.info, teststat = "Chi-square", sepfile = "no", dataclinvar, whclinvar = 1, group, groupnames, mc = "no", comparison = "all", lgonly = 0, af = 0, niter = 1000)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{datacgh}{A data frame containing discretized aCGH data}
 \item{data.info}{A data frame containing genomic information on the aCGH data (chromosome, base pair position, etc)}
  \item{teststat}{"Chi-square", "Wilxocon" or "KW" (Kruskal-Wallis)}

  \item{sepfile}{Do you use a separate file containing clinical data? "yes" or "no"}
  \item{dataclinvar}{A .txt file containing clinical grouping information. Order of rows (in terms of samples) should be the same as the order of the columns in Xmat. Only needed when sepfile = "yes"}
  \item{whclinvar}{The number of the column with clinical data you wish to use}
  \item{group}{If sep= "no": a vector containing the sizes of your groups}
  \item{groupnames}{If sep= "no": a character vector containing the names of your groups}
  \item{mc}{Do you want to make multiple comparisons, "yes" or "no"}
  \item{comparison}{Vector containing comparisons you wish to make. 1 with 3 and 2 with 3 is entered as c(1,3,2,3). Use "all" for all pair-wise comparisons.}
  \item{lgonly}{What states do you wish to compare? Options: -1 for losses vs non-loss, 1 for gain vs non-gain, 0 for all 3}
  \item{af}{Filter out regions with less than af*100 perc. aberrations}
  \item{niter}{number of permutations. At least 10.000 recommended for final calculations}
}
\details{On the test statistics: 
Wilcoxon: this is Wilcoxon rank-sum test for two groups, and its generalization (Steel) for multiple comparisons,
Chi-square: chisquare test for association between aberration pattern and group label; can also do multiple comparisons
KW: Kruskal-Wallis test, generalization of Wilcoxon for more than 2 groups.
On lgonly: 0 is most powerful, while -1 (or 1) can be better interpretable. Computation time is mostly determined by the number of permutations. Note that this function provides besides the raw p-values, an estimation of the null p-value distributions (which may be highly non-uniform for these data!) which is useful for estimating fdr. 
}
\value{
  \item{pvals}{A vector of raw p-values}
  \item{pvperm}{A matrix containing niter columns of permutation p-values}
  \item{info}{Data frame containing information on the regions tested}
}

\author{Mark A. van de Wiel}


\examples{
data(cghreg)
datainfo <- data.frame(chromosomes(cghreg), bpstart(cghreg), bpend(cghreg), nclone(cghreg), avedist(cghreg))
datacgh <- regions(cghreg)
\dontrun{pvs <- pvalstest(datacgh,datainfo,group=c(7,30),groupnames=c("MSI+", "CIN+"),af=0.1,niter=10000)}
}

