\name{buildExonCountSet}
\alias{buildExonCountSet}
\title{
   Makes an ExonCountSet object from R objects.
}
\description{
   This function inputs an GRanges object and a summarizedExperiment object and builds an ExonCountSet object.
}
\usage{
buildExonCountSet( summarizedExperiment, design, exonicParts )
}
\arguments{
  \item{summarizedExperiment}{
     A summarizedExperiments object, output of the function countReadsForDEXSeq.
  }
  \item{design}{
     A factor or data frame with the design annotation (e.g. treatments, or tissue 
     types, or phenotypes, or the like).  The length of the factor (or rows in the data frame) 
     has to be equal to the number of columns of the assay data, assigning a 
     condition to each sample. If it is a data frame, all the columns of the design need to be factors.
  }
  \item{exonicParts}{
     A GRanges object generated by the function prepareAnnotationForDEXSeq.
  }
}
\author{
     From code kindly provided by Mike Love.
}
\value{
     An ExonCountSet object.
}
\examples{
\dontrun{
   library(GenomicFeatures)
   library(Rsamtools)
   hse <- makeTranscriptDbFromBiomart(biomart="ensembl", dataset="hsapiens_gene_ensembl")
   exonicParts <- disjointExons( hse )
   
   bamDir <- system.file("extdata",package="parathyroidSE",mustWork=TRUE)

   fls <- list.files(bamDir, pattern="bam$",full=TRUE)
   bamlst <- BamFileList( fls, index=character(), yieldSize=100000, obeyQname=TRUE )
   SE <- summarizeOverlaps( exonicParts, bamlst, mode="Union", singleEnd=FALSE, 
  	  ignore.strand=TRUE, inter.feature=FALSE, fragments=TRUE )

   ecs <- buildExonCountSet( SE, c("A", "A", "B"), exonicParts )
}
}
