\name{countReadsForDEXSeq}
\alias{countReadsForDEXSeq}
\alias{countReadsForDEXSeq-deprecated}
\title{
   Prepare annotation transcriptDb object for DEXSeq.
}
\description{
   WARNING: This function is deprecated, use summarizedOverlaps from the package GenomicRanges instead.
}
\usage{
countReadsForDEXSeq( exonicParts, bamFileList, scanBamParam =
                 ScanBamParam(), singleEnd = TRUE, ignoreStrand = TRUE,
                 mode = function(features, reads, ignore.strand,
                 inter.feature = FALSE) { countOverlaps(features,
                 reads, ignore.strand = ignoreStrand)})
}
\arguments{
  \item{exonicParts}{
     An GRanges object.
  }
  \item{bamFileList}{
     A BamFileList object.
  }
  \item{scanBamParam}{
     Function ScanBamParam to create a parameter object influencing what
     fields and which records are imported from a BAM file.
  }
  \item{singleEnd}{
     Logical. Indicating whether the reads are single-end or paired-end.
  }
  \item{ignoreStrand}{
     Logical. Indicating whether the strand of the reads should be ignored. Useful
     for data generated by strand-specific protocols.
  }
  \item{mode}{
     A function with the method used to count the overlaps to exons. The default allows 
     a read fragment to be counted in two exons, if it overlaps with both of them.
  }
}
\author{
     From code kindly provided by Mike Love.
}
\value{
     A GRanges object.
}
\examples{
\dontrun{
   library(GenomicFeatures)
   hse <- makeTranscriptDbFromBiomart(biomart="ensembl", dataset="hsapiens_gene_ensembl")
   exonicParts <- prepareAnnotationForDEXSeq( hse )
   
   bamDir <- system.file("extdata",package="parathyroidSE",mustWork=TRUE)
   fls <- list.files(bamDir, pattern="bam$",full=TRUE)
   bamlst <- BamFileList(fls)

   SE <- countReadsForDEXSeq( exonicParts, bamlst )
}
}
