/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.klib;

import gov.nih.nlm.ncbi.vdb.klib.KRef;
import gov.nih.nlm.ncbi.vdb.klib.VDBDuplicateException;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.klib.VDBReleaseException;

public abstract class VDBObject
implements KRef {
    private long self;

    protected VDBObject(long obj) {
        this.self = obj;
    }

    @Override
    public void release() throws VDBException {
        if (this.self == 0L) {
            return;
        }
        if (!this.Release(this.self)) {
            throw new VDBReleaseException();
        }
        this.self = 0L;
    }

    @Override
    public KRef duplicate() throws VDBException {
        long dup = this.Duplicate(this.self);
        if (dup == 0L) {
            throw new VDBDuplicateException();
        }
        VDBObject result = this.create(dup);
        if (result == null) {
            throw new NullPointerException();
        }
        return result;
    }

    public long getSelf() {
        return this.self;
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    protected abstract VDBObject create(long var1);

    protected abstract long Duplicate(long var1);

    protected abstract boolean Release(long var1);
}

