/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Args;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.CommandExecutor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.CommandListener;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.DownloadCommandFirer;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.ResolveReferencesCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.ResolveSraCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.ResolveSraFirer;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.ResolveUrlCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.ResolveUrlFirer;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqMgr;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.SraListener;
import java.io.File;
import java.io.FileNotFoundException;

class CommandFactory {
    CommandFactory() {
    }

    static Command makeResolveReferencesCommand(CommandListener listener, RefseqMgr mgr, String[] paths) throws FileNotFoundException {
        DownloadCommandFirer l = new DownloadCommandFirer(listener, mgr);
        return new ResolveReferencesCommand(paths, mgr, (SraListener)l);
    }

    static Command makeResolveReferencesCommand(CommandListener listener, RefseqMgr mgr, String path) throws FileNotFoundException {
        DownloadCommandFirer l = new DownloadCommandFirer(listener, mgr);
        return new ResolveReferencesCommand(path, mgr, (SraListener)l);
    }

    static Command makeResolveSraCommand(CommandListener listener, RefseqMgr mgr, String name) {
        DownloadCommandFirer d = new DownloadCommandFirer(listener, mgr);
        ResolveSraFirer r = new ResolveSraFirer(listener, mgr);
        return new ResolveSraCommand(name, mgr, r, d);
    }

    static Command makeResolveUrlCommand(CommandListener listener, RefseqMgr mgr, String url) {
        DownloadCommandFirer d = new DownloadCommandFirer(listener, mgr);
        ResolveUrlFirer r = new ResolveUrlFirer(listener, mgr);
        return new ResolveUrlCommand(url, mgr, r, d);
    }

    public static void main(String[] args) {
        System.loadLibrary("vdb_jni");
        CommandExecutor q = new CommandExecutor();
        try {
            RefseqMgr mgr = new RefseqMgr();
            for (int i = 0; i < args.length; ++i) {
                String a = args[i];
                if (Args.processArg(a)) continue;
                Command c = null;
                c = new File(a).exists() ? CommandFactory.makeResolveReferencesCommand((CommandListener)q, mgr, a) : (a.length() > 0 && a.charAt(0) == 'h' ? CommandFactory.makeResolveUrlCommand(q, mgr, a) : CommandFactory.makeResolveSraCommand(q, mgr, a));
                q.addToEventQueue(c);
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }
}

