/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Writer;

class KConfigNodeHelper {
    private KConfigNode node;
    private String name;

    KConfigNodeHelper(KConfigNode node, String name) {
        this.node = node;
        this.name = name;
    }

    void out(Writer w, int indent) {
        String[] children = this.node.listChildren();
        if (children.length > 0) {
            w.println(indent, "<" + this.name + ">");
            String v = this.node.read();
            if (v.length() > 0) {
                w.println(indent + 1, v);
            }
            for (int i = 0; i < children.length; ++i) {
                try {
                    KConfigNode n = this.node.openNodeRead(children[i]);
                    new KConfigNodeHelper(n, children[i]).out(w, indent + 1);
                    continue;
                }
                catch (VDBException e) {
                    SRAToolkit.stackTracePrint(e);
                }
            }
            w.println(indent, "</" + this.name + ">");
        } else {
            String v = this.node.read();
            if (v.length() > 0) {
                w.println(indent, "<" + this.name + ">" + v + "</" + this.name + ">");
            } else {
                w.println(indent, "<" + this.name + "/>");
            }
        }
    }
}

