/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqMgr;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.SraListener;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.Refseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import java.util.Iterator;

class ResolveReferencesCommand
extends Command {
    private String[] paths;
    private RefseqMgr mgr;
    private SraListener listener;

    ResolveReferencesCommand(String path, RefseqMgr mgr, SraListener listener) {
        this(new String[]{path}, mgr, listener);
    }

    ResolveReferencesCommand(String[] paths, RefseqMgr mgr, SraListener listener) {
        if (paths == null || mgr == null) {
            throw new NullPointerException();
        }
        this.paths = paths;
        this.mgr = mgr;
        this.listener = listener;
    }

    @Override
    protected boolean execute() throws Exception {
        if (this.paths.length == 0) {
            Handler.reportStatusTop(this.myNumber() + "Nothing to check");
            return true;
        }
        String s = "" + this.paths.length + " files:";
        for (int i = 0; i < this.paths.length; ++i) {
            s = s + " " + this.paths[i];
        }
        Handler.reportStatusTop(this.myNumber() + "Checking references of " + s + "...");
        boolean ok = true;
        RefseqList l = this.mgr.listReferences(this.paths);
        Iterator<Refseq> it = l.externalIterator();
        while (it.hasNext()) {
            Refseq r = it.next();
            if (r.isResolved() || this.listener == null) continue;
            ok &= this.listener.event(r);
        }
        if (this.paths.length == 1) {
            Handler.reportStatusTop(this.myNumber() + "References check of " + this.paths[0] + (ok ? " succeed" : " failed"));
        } else {
            Handler.reportStatusTop(this.myNumber() + "References check of " + this.paths.length + " files" + (ok ? " succeed" : " failed"));
        }
        return ok;
    }
}

