/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.kfs.KFSPath;
import gov.nih.nlm.ncbi.vdb.klib.VDBException;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.Command;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.CommandFactory;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.CommandListener;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.CreateNewDirectoriesCommand;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitCategory;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitShell;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqMgr;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class SRAToolkit
implements CommandListener,
Runnable {
    public static final int HAS_DEFINED_ROOT = 1;
    public static final int REP_DISABLED = 2;
    public static final int HAS_ACCESSIBLE_SRA = 4;
    public static final int HAS_ACCESSIBLE_REFSEQ = 8;
    public static final int HAS_REMOTE_PUBLIC = 16;
    public static final int HAS_REMOTE_PROTECTED = 32;
    public static final int MIN_CONFIG_BITS = 61;
    public SRAToolkitShell shell;
    private String currentRepositoryPath = "";
    private SRAToolkitNode selectedRoot;
    private SRAToolkitCategory selectedCategory;
    private boolean quit = false;
    private static boolean debug = false;
    private static final int capacity = 4096;
    private static final int num_threads = 8;
    private int write = 0;
    private int read = 0;
    private int count = 0;
    private int uWrite = 0;
    private int uRead = 0;
    private int uCount = 0;
    private int rWrite = 0;
    private int rRead = 0;
    private int rCount = 0;
    private int windowCount = 0;
    private Command[] cmdQueue = new Command[4096];
    private Command[] undoQueue = new Command[4096];
    private Command[] redoQueue = new Command[4096];
    private SRAToolkitCategory[] categories;
    private Thread[] threads;
    private RefseqMgr rMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.quit) {
            Command cmd = null;
            SRAToolkit sRAToolkit = this;
            synchronized (sRAToolkit) {
                if (this.count == 0) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.count != 0) {
                    cmd = this.cmdQueue[this.read];
                    this.cmdQueue[this.read] = null;
                    --this.count;
                    if (++this.read == 4096) {
                        this.read = 0;
                    }
                }
            }
            if (cmd == null) continue;
            cmd.run();
        }
    }

    public static SRAToolkit make(String[] args, boolean createDirs) throws Exception {
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("--debug")) continue;
            debug = true;
        }
        SRAToolkit app = new SRAToolkit();
        try {
            if (debug) {
                SRAToolkit.setDebug(true);
            }
            app.populateCategories(createDirs);
            app.setDefaultSelection();
            if (app.getSelectedRoot() != null) {
                SRAToolkit.debugPrintln(app.getSelectedRoot().getName());
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        return app;
    }

    public void quit() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(KConfig kfg, String name, String root, String vols) throws Exception {
        KConfigNode rep = kfg.openNodeUpdate("/repository/user/aux/" + name);
        try {
            KConfigNode node = rep.openNodeUpdate("root");
            try {
                node.write(root);
            }
            finally {
                node.release();
            }
            node = rep.openNodeUpdate("apps/refseq/volumes/refseq");
            try {
                node.write(vols);
            }
            finally {
                node.release();
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        finally {
            rep.release();
        }
    }

    public void addRepository(KConfig kfg, String name, String root) throws Exception {
        String vols = null;
        String tmp = root;
        int ch = tmp.lastIndexOf(47);
        if (root.startsWith("/")) {
            root = "/";
            vols = tmp.substring(1);
        } else if (ch != -1) {
            root = tmp.substring(0, ch);
            vols = tmp.substring(ch + 1);
        }
        this.addRepository(kfg, name, root, vols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDBGapRepository(KConfig kfg, String name, String encryptKey, String dlTicket, String description) throws Exception {
        boolean success = true;
        KConfigNode rep = kfg.openNodeUpdate("/repository/user/protected/" + name);
        try {
            String ncbiHome = null;
            KConfigNode node = kfg.openNodeRead("NCBI_HOME");
            try {
                ncbiHome = node.readString();
            }
            finally {
                node.release();
            }
            String encryptionKeyPath = ncbiHome + "/" + name + ".enc_key";
            KFSPath keyPath = KFSPath.makeFromPosixString(encryptionKeyPath);
            File encryptionKeyFile = new File(keyPath.getSystemPathString());
            FileOutputStream encryptionKeyOut = new FileOutputStream(encryptionKeyFile);
            OutputStreamWriter encryptionKeyWriter = new OutputStreamWriter(encryptionKeyOut);
            encryptionKeyWriter.write(encryptKey, 0, encryptKey.length());
            encryptionKeyWriter.write("\n");
            encryptionKeyWriter.flush();
            node = rep.openNodeUpdate("encryption-key-path");
            try {
                node.write(encryptionKeyPath);
            }
            finally {
                node.release();
            }
            node = rep.openNodeUpdate("download-ticket");
            try {
                node.write(dlTicket);
            }
            finally {
                node.release();
            }
            node = rep.openNodeUpdate("description");
            try {
                node.write(description);
            }
            finally {
                node.release();
            }
            node = rep.openNodeUpdate("apps/sra/volumes/sraFlat");
            try {
                node.write("sra");
            }
            finally {
                node.release();
            }
            node = rep.openNodeUpdate("cache-enabled");
            try {
                node.write("true");
            }
            finally {
                node.release();
            }
            node = rep.openNodeUpdate("root");
            try {
                String rootPath = kfg.readString("HOME") + "/ncbi/" + name;
                node.write(rootPath);
            }
            finally {
                node.release();
            }
        }
        catch (Exception e) {
            success = false;
            SRAToolkit.stackTracePrint(e);
        }
        finally {
            rep.release();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAccessibleAppVolume(KConfigNode rep, String root, String appVolPath) {
        SRAToolkit.debugPrintln(" Root is: " + root);
        try {
            KConfigNode vols = rep.openNodeRead(appVolPath);
            try {
                String[] typeNames = vols.listChildren();
                int i = 0;
                while (i < typeNames.length) {
                    String typeName = typeNames[i];
                    KConfigNode alg = vols.openNodeRead(typeName);
                    try {
                        String vol_list = alg.read();
                        String[] vol_array = vol_list.split(":");
                        for (int j = 0; j < vol_array.length; ++j) {
                            String vol = vol_array[j];
                            KFSPath volPath = KFSPath.makeFromPosixString(root + "/" + vol);
                            File f = new File(volPath.getSystemPathString());
                            if (!f.isDirectory()) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    finally {
                        alg.release();
                    }
                    ++i;
                }
                return false;
            }
            finally {
                vols.release();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private int checkMinimumRemoteConfig(KConfigNode remoteRepo) throws Exception {
        int bit_field = 0;
        try {
            String disabled = remoteRepo.readString("disabled");
            if (disabled.equals("true")) {
                bit_field |= 2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String url = remoteRepo.readString("resolver-cgi");
            if (url.length() != 0) {
                return bit_field |= 0xD;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String root = remoteRepo.readString("root");
        if (root.length() >= 2 && root.charAt(1) == ':' && Character.isLetter(root.charAt(0)) || root.indexOf(92) >= 0) {
            throw new VDBException("Windows root path needs to be rewritten");
        }
        bit_field |= 1;
        if (this.hasAccessibleAppVolume(remoteRepo, root, "apps/sra/volumes")) {
            bit_field |= 4;
        }
        if (this.hasAccessibleAppVolume(remoteRepo, root, "apps/refseq/volumes")) {
            bit_field |= 8;
        }
        return bit_field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkRemoteConfig(KConfigNode sub) throws Exception {
        int bit_field = 0;
        String[] remoteNames = sub.listChildren();
        boolean allDisabled = remoteNames.length > 0;
        for (int i = 0; i < remoteNames.length; ++i) {
            String remoteName = remoteNames[i];
            KConfigNode remoteRepo = sub.openNodeRead(remoteName);
            try {
                int rep_bit_field = this.checkMinimumRemoteConfig(remoteRepo);
                if ((rep_bit_field & 3) != 1) continue;
                allDisabled = false;
                bit_field |= rep_bit_field;
                continue;
            }
            finally {
                remoteRepo.release();
            }
        }
        return bit_field;
    }

    private int checkMinimumUserConfig(KConfigNode userPublic) throws Exception {
        int bit_field = 0;
        try {
            String disabled = userPublic.readString("disabled");
            if (disabled.equals("true")) {
                bit_field |= 2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String root = userPublic.readString("root");
        if (root.length() >= 2 && root.charAt(1) == ':' && Character.isLetter(root.charAt(0)) || root.indexOf(92) >= 0) {
            throw new VDBException("Windows root path needs to be rewritten");
        }
        bit_field |= 1;
        if (this.hasAccessibleAppVolume(userPublic, root, "apps/sra/volumes")) {
            bit_field |= 4;
        }
        if (this.hasAccessibleAppVolume(userPublic, root, "apps/refseq/volumes")) {
            bit_field |= 8;
        }
        return bit_field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkUserConfig(KConfigNode sub) throws Exception {
        int bit_field = 0;
        String[] userPubNames = sub.listChildren();
        boolean allDisabled = userPubNames.length > 0;
        for (int i = 0; i < userPubNames.length; ++i) {
            String userPubName = userPubNames[i];
            KConfigNode userPublic = sub.openNodeRead(userPubName);
            try {
                int rep_bit_field = this.checkMinimumUserConfig(userPublic);
                if ((rep_bit_field & 3) != 1) continue;
                allDisabled = false;
                bit_field |= rep_bit_field & 0xD;
                continue;
            }
            finally {
                userPublic.release();
            }
        }
        return bit_field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkMinimumConfig() throws Exception {
        int bit_field = 0;
        KConfig kfg = KConfig.make();
        try {
            int rep_bit_field;
            KConfigNode remote;
            try {
                remote = kfg.openNodeRead("/repository/remote/main");
                try {
                    rep_bit_field = this.checkRemoteConfig(remote);
                    if (rep_bit_field != 0) {
                        bit_field |= 0x10;
                    }
                }
                finally {
                    remote.release();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (bit_field == 0) {
                try {
                    remote = kfg.openNodeRead("/repository/remote/sub");
                    try {
                        rep_bit_field = this.checkRemoteConfig(remote);
                        if (rep_bit_field != 0) {
                            bit_field |= 0x10;
                        }
                    }
                    finally {
                        remote.release();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                remote = kfg.openNodeRead("/repository/remote/protected");
                try {
                    rep_bit_field = this.checkRemoteConfig(remote);
                    if (rep_bit_field != 0) {
                        bit_field |= 0x20;
                    }
                }
                finally {
                    remote.release();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                KConfigNode dflt;
                block39: {
                    int n;
                    dflt = kfg.openNodeRead("/config/default");
                    try {
                        String dflt_value = dflt.read();
                        if (!dflt_value.equals("true")) break block39;
                        n = bit_field;
                    }
                    catch (Throwable throwable) {
                        dflt.release();
                        throw throwable;
                    }
                    dflt.release();
                    return n;
                }
                dflt.release();
            }
            catch (Exception e) {
                // empty catch block
            }
            KConfigNode sub = kfg.openNodeRead("/repository/user/main");
            try {
                int rep_bit_field2 = this.checkUserConfig(sub);
                bit_field |= rep_bit_field2;
            }
            finally {
                sub.release();
            }
        }
        catch (Exception exception) {
        }
        finally {
            kfg.release();
        }
        if (bit_field & true) {
            SRAToolkit.debugPrintln("user-public repository has root");
        }
        if ((bit_field & 2) != 0) {
            SRAToolkit.debugPrintln("user-public repository is disabled");
        }
        if ((bit_field & 4) != 0) {
            SRAToolkit.debugPrintln("user-public repository has an accessible sra volume");
        }
        if ((bit_field & 8) == 0) return bit_field;
        SRAToolkit.debugPrintln("user-public repository has an accessible refseq volume");
        return bit_field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMinimumConfig(int minConfig, KConfig kfg) throws Exception {
        KConfigNode node;
        String rootPath;
        SRAToolkit.debugPrintln("updating user configuration");
        KConfigNode rep = kfg.openNodeUpdate("/repository/user/main/public");
        try {
            if ((minConfig & 1) == 0) {
                rootPath = kfg.readString("HOME") + "/ncbi/public";
                node = rep.openNodeUpdate("root");
                try {
                    node.write(rootPath);
                }
                finally {
                    node.release();
                }
            }
            if ((minConfig & 4) == 0) {
                node = rep.openNodeUpdate("apps/sra/volumes/sraFlat");
                try {
                    node.write("sra");
                }
                finally {
                    node.release();
                }
            }
            if ((minConfig & 8) == 0) {
                node = rep.openNodeUpdate("apps/refseq/volumes/refseq");
                try {
                    node.write("refseq");
                }
                finally {
                    node.release();
                }
            }
            node = rep.openNodeUpdate("apps/wgs/volumes/wgsFlat");
            try {
                node.write("wgs");
            }
            finally {
                node.release();
            }
            node = rep.openNodeUpdate("cache-enabled");
            try {
                node.write("true");
            }
            finally {
                node.release();
            }
        }
        finally {
            rep.release();
        }
        try {
            KConfigNode legacy_refseq = kfg.openNodeUpdate("/refseq/paths");
            try {
                String root;
                String path = legacy_refseq.read();
                Vector<String> paths = new Vector<String>();
                int colon = path.indexOf(58);
                if (colon != -1) {
                    do {
                        String parsed = path.substring(0, colon);
                        paths.add(parsed);
                    } while ((colon = (path = path.substring(colon + 1)).indexOf(58)) != -1);
                    paths.add(path);
                } else {
                    paths = null;
                }
                int size = paths.size();
                if (paths == null) {
                    root = path;
                    String legacy_name = "legacy-refseq";
                    this.addRepository(kfg, legacy_name, root);
                } else {
                    for (int i = 0; i < paths.size(); ++i) {
                        root = (String)paths.elementAt(i);
                        String legacy_name = "legacy-refseq-" + (i + 1);
                        this.addRepository(kfg, legacy_name, root);
                    }
                }
            }
            finally {
                legacy_refseq.release();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((minConfig & 0x10) == 0) {
            rep = kfg.openNodeUpdate("/repository/remote/main/CGI/");
            try {
                node = rep.openNodeUpdate("resolver-cgi");
                try {
                    node.write("http://www.ncbi.nlm.nih.gov/Traces/names/names.cgi");
                }
                finally {
                    node.release();
                }
            }
            finally {
                rep.release();
            }
            SRAToolkit.debugPrintln("updating remote configuration");
            rep = kfg.openNodeUpdate("/repository/remote/aux/NCBI");
            try {
                rootPath = "http://ftp-trace.ncbi.nlm.nih.gov/sra";
                node = rep.openNodeUpdate("root");
                try {
                    node.write(rootPath);
                }
                finally {
                    node.release();
                }
                node = rep.openNodeUpdate("apps/sra/volumes/fuse1000");
                try {
                    node.write("sra-instant/reads/ByRun/sra");
                }
                finally {
                    node.release();
                }
                node = rep.openNodeUpdate("apps/refseq/volumes/refseq");
                try {
                    node.write("refseq");
                }
                finally {
                    node.release();
                }
                node = rep.openNodeUpdate("apps/wgs/volumes/fuseWGS");
                try {
                    node.write("wgs");
                }
                finally {
                    node.release();
                }
            }
            finally {
                rep.release();
            }
        }
        if ((minConfig & 0x20) == 0) {
            rep = kfg.openNodeUpdate("/repository/remote/protected/CGI/");
            try {
                node = rep.openNodeUpdate("resolver-cgi");
                try {
                    node.write("http://www.ncbi.nlm.nih.gov/Traces/names/names.cgi");
                }
                finally {
                    node.release();
                }
            }
            finally {
                rep.release();
            }
        }
    }

    @Override
    public synchronized void addToEventQueue(Command cmd) throws Exception {
        if (this.count == 4096) {
            throw new Exception("Command queue is full");
        }
        this.cmdQueue[this.write] = cmd;
        ++this.count;
        if (++this.write == 4096) {
            this.write = 0;
        }
        this.notifyAll();
    }

    public synchronized void addToUndoQueue(Command cmd) throws Exception {
        if (this.uCount == 4096) {
            throw new Exception("Undo queue is full");
        }
        this.undoQueue[this.uWrite] = cmd;
        ++this.uCount;
        if (++this.uWrite == 4096) {
            this.uWrite = 0;
        }
        SRAToolkit.debugPrintln("there are: " + this.uCount + " in undo");
    }

    public synchronized void addToRedoQueue(Command cmd) throws Exception {
    }

    public String[] getCategoryNames() {
        String[] names = new String[this.categories.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.categories[i].getName();
        }
        return names;
    }

    public SRAToolkitCategory[] getCategories() {
        return this.categories;
    }

    public SRAToolkitNode[] getCategoryNodes(int which) {
        return this.categories[which].getNodes();
    }

    public int getWindowCount() {
        return this.windowCount;
    }

    public void incrementWindowCount() {
        ++this.windowCount;
    }

    public void decrementWindowCount() {
        --this.windowCount;
    }

    public String getCurrentRepositoryPath() {
        return this.currentRepositoryPath;
    }

    public SRAToolkitCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public SRAToolkitNode getSelectedRoot() {
        return this.selectedRoot;
    }

    public void setSelectedCategory(int category) {
        if (category >= 0 && category < this.categories.length) {
            this.selectedCategory = this.categories[category];
        }
    }

    public void setSelectedRoot(int root) throws Exception {
        SRAToolkitNode rep = this.selectedCategory.getRepository(root);
        if (rep != null) {
            this.selectedRoot = (SRAToolkitNode)rep.getChildAt(root);
        } else {
            SRAToolkit.debugPrintln("Node does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRAToolkitNode populateApp(String root, String name, KConfigNode app, boolean remote, boolean createDirs, int cat, String repository) throws Exception {
        KConfigNode vols = app.openNodeRead("volumes");
        try {
            Object volName;
            int i;
            Object leaf;
            String volString = "";
            String[] volTypes = vols.listChildren();
            for (int i2 = 0; i2 < volTypes.length; ++i2) {
                String volType = volTypes[i2];
                KConfigNode alg = vols.openNodeRead(volType);
                try {
                    volString = volString + ":" + alg.readString();
                    continue;
                }
                finally {
                    alg.release();
                }
            }
            String[] tmpList = volString.split(":");
            ArrayList<String> volList = new ArrayList<String>(tmpList.length);
            for (int i3 = 0; i3 < tmpList.length; ++i3) {
                String volName2 = tmpList[i3];
                if (volName2 == null || (volName2 = volName2.trim()).length() == 0) continue;
                int index = volName2.lastIndexOf("/");
                if (index != -1) {
                    String tmp = volName2;
                    leaf = tmp.substring(index + 1);
                    tmp = tmp.substring(0, index);
                    volName2 = tmp = (String)leaf + "/" + tmp;
                }
                volList.add(volName2);
            }
            Object[] volArray = new String[volList.size()];
            volArray = volList.toArray(volArray);
            Arrays.sort(volArray);
            Vector<SRAToolkitNode> subNodes = new Vector<SRAToolkitNode>(volArray.length);
            if (remote) {
                for (i = 0; i < volArray.length; ++i) {
                    try {
                        leaf = volName = volArray[i];
                        int index = ((String)volName).indexOf("/");
                        if (index != -1) {
                            leaf = ((String)volName).substring(0, index);
                            volName = ((String)volName).substring(index + 1) + "/" + (String)leaf;
                        }
                        String path = root + "/" + (String)volName;
                        SRAToolkitNode node = SRAToolkitNode.makeRemoteNode((String)leaf, path, cat, repository);
                        subNodes.add(i, node);
                        continue;
                    }
                    catch (Exception e) {
                        SRAToolkit.stackTracePrint(e);
                    }
                }
            } else {
                for (i = 0; i < volArray.length; ++i) {
                    leaf = volName = volArray[i];
                    int index = ((String)volName).indexOf("/");
                    if (index != -1) {
                        leaf = ((String)volName).substring(0, index);
                        volName = ((String)volName).substring(index + 1) + "/" + (String)leaf;
                    }
                    String path = root + "/" + (String)volName;
                    if (createDirs) {
                        KFSPath volPath = KFSPath.makeFromPosixString(path);
                        File volDir = new File(volPath.getSystemPathString());
                        if (!volDir.exists()) {
                            volDir.mkdirs();
                        } else if (!volDir.isDirectory()) {
                            // empty if block
                        }
                    }
                    SRAToolkitNode node = SRAToolkitNode.makeLocalNode((String)leaf, path, cat, repository);
                    subNodes.add(i, node);
                }
            }
            SRAToolkitNode sRAToolkitNode = SRAToolkitNode.makePrebuiltNode(name, ".", cat, repository, subNodes);
            return sRAToolkitNode;
        }
        finally {
            vols.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SRAToolkitNode populateRepository(String repName, KConfigNode rep, boolean remote, boolean createDirs, int cat) throws Exception {
        String root = rep.readString("root");
        if (createDirs) {
            KFSPath rootPath = KFSPath.makeFromPosixString(root);
            File rootFile = new File(rootPath.getSystemPathString());
            if (!rootFile.exists()) {
                rootFile.mkdirs();
            } else if (!rootFile.isDirectory()) {
                // empty if block
            }
        }
        KConfigNode apps = rep.openNodeRead("apps");
        try {
            String[] appNames = apps.listChildren();
            Vector<SRAToolkitNode> subnodes = new Vector<SRAToolkitNode>(appNames.length);
            for (int i = 0; i < appNames.length; ++i) {
                String appName = appNames[i];
                KConfigNode app = apps.openNodeRead(appName);
                try {
                    SRAToolkitNode appNode = this.populateApp(root, appName, app, remote, createDirs, cat, repName);
                    subnodes.add(i, appNode);
                    continue;
                }
                finally {
                    app.release();
                }
            }
            SRAToolkitNode sRAToolkitNode = SRAToolkitNode.makePrebuiltNode(repName, "", cat, repName, subnodes);
            return sRAToolkitNode;
        }
        finally {
            apps.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSharedSubcategory(KConfigNode sub, int catIdx, boolean remote, boolean createDirs, int cat) throws Exception {
        String[] repNames = sub.listChildren();
        for (int j = 0; j < repNames.length; ++j) {
            String repName = repNames[j];
            KConfigNode rep = sub.openNodeRead(repName);
            try {
                try {
                    SRAToolkitNode repNode = this.populateRepository(repName, rep, remote, createDirs, cat);
                    this.categories[catIdx].add(repNode);
                }
                catch (Exception e) {
                    if (repName.equals("CGI")) continue;
                    SRAToolkit.stackTracePrint("An Exception was caught during '" + repName + "' repository populating", e);
                }
                continue;
            }
            finally {
                rep.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSharedSubcategory(KConfigNode category, int catIdx, String subName, boolean remote, boolean createDirs, int cat) throws Exception {
        KConfigNode sub = category.openNodeRead(subName);
        try {
            this.populateSharedSubcategory(sub, catIdx, remote, createDirs, cat);
        }
        finally {
            sub.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSharedCategory(KConfigNode category, int catIdx, boolean remote, int cat) throws Exception {
        KConfigNode main = null;
        try {
            main = category.openNodeRead("main");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (main != null) {
            try {
                this.populateSharedSubcategory(main, catIdx, remote, false, cat);
            }
            finally {
                main.release();
            }
        }
        String[] subCategories = category.listChildren();
        for (int i = 0; i < subCategories.length; ++i) {
            String subName = subCategories[i];
            if (subName.equals("main") || subName.equals("protected") || !subName.equals("aux")) continue;
            this.populateSharedSubcategory(category, catIdx, subName, remote, false, cat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateUserCategory(KConfigNode category, boolean createDirs, int cat) throws Exception {
        KConfigNode pub = null;
        try {
            pub = category.openNodeRead("main");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pub != null) {
            try {
                this.populateSharedSubcategory(pub, 2, false, createDirs, cat);
            }
            finally {
                pub.release();
            }
        }
        String[] subCategories = category.listChildren();
        for (int i = 0; i < subCategories.length; ++i) {
            String subName = subCategories[i];
            if (subName.equals("main") || !subName.equals("protected") && !subName.equals("aux")) continue;
            this.populateSharedSubcategory(category, 2, subName, false, createDirs, cat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCategories(boolean createDirs) throws Exception {
        KConfig kfg = KConfig.make();
        try {
            KConfigNode repository = kfg.openNodeRead("/repository");
            try {
                String[] categoryNames = repository.listChildren();
                for (int i = 0; i < categoryNames.length; ++i) {
                    String categoryName = categoryNames[i];
                    KConfigNode category = repository.openNodeRead(categoryName);
                    try {
                        if (categoryName.equals("remote")) {
                            this.populateSharedCategory(category, 0, true, 1);
                            continue;
                        }
                        if (categoryName.equals("site")) {
                            this.populateSharedCategory(category, 1, false, 2);
                            continue;
                        }
                        if (categoryName.equals("user")) {
                            this.populateUserCategory(category, createDirs, 3);
                            continue;
                        }
                        SRAToolkit.debugPrintln("Warning: unknown repository category: " + categoryName);
                        continue;
                    }
                    finally {
                        category.release();
                    }
                }
            }
            finally {
                repository.release();
            }
        }
        finally {
            kfg.release();
        }
    }

    public void setDefaultSelection() {
        try {
            this.setSelectedCategory(2);
            this.setSelectedRoot(0);
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    public void updateSRAToolkitApp() {
        try {
            this.buildSRAToolkitCategories();
            this.populateCategories(true);
            this.setDefaultSelection();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    public void scanForMissingRefseq(String[] paths) {
        if (paths != null) {
            try {
                this.rMgr = new RefseqMgr();
                this.addToEventQueue(CommandFactory.makeResolveReferencesCommand((CommandListener)this, this.rMgr, paths));
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        }
    }

    public void httpDownload(String[] paths) {
        if (paths != null) {
            try {
                this.rMgr = new RefseqMgr();
                for (int i = 0; i < paths.length; ++i) {
                    this.addToEventQueue(CommandFactory.makeResolveUrlCommand(this, this.rMgr, paths[i]));
                }
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        }
    }

    public static Command makeCreateDirectoriesCommand(SRAToolkit app) {
        return new CreateNewDirectoriesCommand(app);
    }

    public static boolean setRemoteDisabled(KConfig kfg, String which) {
        boolean b = SRAToolkit.setRemoteDisabled(kfg, which, "main");
        return b |= SRAToolkit.setRemoteDisabled(kfg, which, "aux");
    }

    private static boolean setRemoteDisabled(KConfig kfg, String which, String type) {
        return SRAToolkit.setRemoteDisabled(kfg, which, type, null);
    }

    private static boolean setRemoteDisabled(KConfig kfg, String which, String type, String selectedRep) {
        return SRAToolkit.setRepoDisabled(kfg, which, type, selectedRep, "remote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setRepoDisabled(KConfig kfg, String which, String type, String selectedRep, String cat) {
        String found;
        KConfigNode rep;
        boolean hasBeenSet = false;
        String path = "/repository/" + cat + "/" + type + "/" + (selectedRep != null ? selectedRep : "NCBI");
        try {
            rep = kfg.openNodeRead(path);
            rep.release();
            found = path;
        }
        catch (VDBException e) {
            if (selectedRep != null) {
                return false;
            }
            try {
                path = "/repository/" + cat + "/" + type + "/CGI";
                KConfigNode rep2 = kfg.openNodeRead(path);
                rep2.release();
                found = path;
            }
            catch (VDBException e0) {
                return false;
            }
        }
        try {
            rep = kfg.openNodeUpdate(found);
            try {
                KConfigNode disabledNode = rep.openNodeUpdate("disabled");
                try {
                    disabledNode.write(which);
                    hasBeenSet = true;
                }
                finally {
                    disabledNode.release();
                }
            }
            finally {
                rep.release();
            }
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        return hasBeenSet;
    }

    public static void debugFormat(String format, Object args) {
        if (debug) {
            System.out.format(format, args);
        }
    }

    public static void debugPrint(char c) {
        if (debug) {
            System.out.print(c);
        }
    }

    public static void debugPrint(String x) {
        if (debug) {
            System.out.print(x);
        }
    }

    public static void debugPrintln() {
        if (debug) {
            System.out.println();
        }
    }

    public static void debugPrintln(boolean x) {
        if (debug) {
            System.out.println(x);
        }
    }

    public static void debugPrintln(int x) {
        if (debug) {
            System.out.println(x);
        }
    }

    public static void debugPrintln(Object x) {
        if (debug) {
            System.out.println(x);
        }
    }

    public static void debugPrintln(String x) {
        if (debug) {
            System.out.println(x);
        }
    }

    public static void errPrintln(Object x) {
        System.err.println(x);
    }

    public static void errPrintln(String x) {
        System.err.println(x);
    }

    public static void print(String x) {
        System.out.print(x);
    }

    public static void println(String x) {
        System.out.println(x);
    }

    public static void stackTracePrint(Throwable t) {
        SRAToolkit.stackTracePrint(null, t);
    }

    public static void stackTracePrint(String message, Throwable t) {
        if (debug) {
            if (message != null) {
                System.out.print(message + ": ");
            }
            t.printStackTrace();
        } else if (message != null) {
            SRAToolkit.errPrintln(message);
        } else {
            SRAToolkit.errPrintln(t);
        }
    }

    public boolean getDebug() {
        return debug;
    }

    public SRAToolkitShell getShell() {
        return this.shell;
    }

    public static void setDebug() {
        SRAToolkit.setDebug(true);
    }

    public static void setDebug(boolean _debug) {
        debug = _debug;
    }

    private void buildSRAToolkitCategories() {
        this.categories = new SRAToolkitCategory[3];
        this.categories[0] = new SRAToolkitCategory("REMOTE");
        this.categories[1] = new SRAToolkitCategory("SITE");
        this.categories[2] = new SRAToolkitCategory("USER");
    }

    private SRAToolkit() {
        int i;
        this.shell = new SRAToolkitShell(this);
        this.buildSRAToolkitCategories();
        this.threads = new Thread[8];
        for (i = 0; i < 8; ++i) {
            this.threads[i] = new Thread(this);
        }
        for (i = 0; i < 8; ++i) {
            this.threads[i].start();
        }
    }
}

