/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.app;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitFTPNode;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

class SRAToolkitFTPRootNode
extends SRAToolkitFTPNode {
    private String scheme;
    private String server;
    private String fPath;

    public SRAToolkitFTPRootNode(String _name, String _path, int cat, String repository) {
        super(_name, _path, cat, repository);
        this.parsePath(_path);
    }

    private void parsePath(String _path) {
        String tmp = _path;
        int index = tmp.indexOf(":");
        if (index >= 0) {
            this.scheme = tmp.substring(0, index);
            tmp = tmp.substring(index + 1);
            tmp = tmp.substring(2);
            index = tmp.indexOf("/", 1);
            this.server = tmp.substring(0, index);
            this.fPath = (index = (tmp = tmp.substring(index)).indexOf("?")) == -1 ? tmp : tmp.substring(0, index);
        }
    }

    @Override
    protected FTPClient connectToServer() throws Exception {
        FTPClient ftp = new FTPClient();
        ftp.enterLocalPassiveMode();
        SRAToolkit.debugPrintln("connecting to server '" + this.server + "'");
        ftp.connect(this.server);
        try {
            ftp.enterLocalPassiveMode();
            if (!FTPReply.isPositiveCompletion(ftp.getReplyCode())) {
                throw new Exception("failed to connect to server");
            }
            ftp.login("anonymous", "sra-tools@ncbi.nlm.nih.gov");
        }
        catch (Exception e) {
            ftp.disconnect();
            throw e;
        }
        return ftp;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    protected FTPFile[] listChildren(FTPClient ftp, String pathToDir) throws Exception {
        SRAToolkit.debugPrintln("listing children on server");
        String pathOnServer = this.fPath + "/" + pathToDir;
        return ftp.listFiles(pathOnServer);
    }

    @Override
    protected FTPFile[] listChildren(FTPClient ftp) throws Exception {
        SRAToolkit.debugPrintln("listing children of root volume");
        return ftp.listFiles(this.fPath);
    }
}

