/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.RightPanelColumnView;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsole;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitPopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class ColumnViewList
extends JPanel {
    private static final long serialVersionUID = 1L;
    private RightPanelColumnView columnView;
    private Object[] selectedNodes;
    private JList treeList;
    private SRAToolkitNode root;
    private String[] listNames;
    private int columnId;
    private int childCount;
    private Vector<SRAToolkitNode> nodeList;

    public ColumnViewList(RightPanelColumnView c, SRAToolkitNode r, int index) {
        this.setLayout(new BorderLayout());
        this.root = r;
        this.columnView = c;
        this.columnId = index;
        if (this.root != null) {
            this.childCount = this.root.getChildCount();
            this.nodeList = new Vector(this.childCount);
            Enumeration<SRAToolkitNode> e = this.root.children();
            while (e.hasMoreElements()) {
                SRAToolkitNode child = e.nextElement();
                String name = child.getName();
                if (name.startsWith(".")) continue;
                this.nodeList.add(child);
            }
            this.treeList = new JList(this.nodeList){

                @Override
                public int locationToIndex(Point location) {
                    int index = super.locationToIndex(location);
                    if (index != -1 && !this.getCellBounds(index, index).contains(location)) {
                        return -1;
                    }
                    return index;
                }
            };
            this.treeList.setCellRenderer(new NodeCellRenderer());
            this.treeList.setVisibleRowCount(this.childCount);
            this.treeList.setSelectionMode(2);
            this.treeList.addMouseListener(new MouseAdapter(){
                private String[] nodePaths;
                private SRAToolkitPopupMenu menu;
                private int category = 0;
                private SRAToolkitNode node = null;

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    JList list = (JList)e.getSource();
                    ColumnViewList parent = (ColumnViewList)list.getParent();
                    Point p = e.getPoint();
                    int index = list.locationToIndex(p);
                    if (SwingUtilities.isRightMouseButton(e)) {
                        int[] indices = list.getSelectedIndices();
                        if (list.isSelectedIndex(index)) {
                            if (this.category == 1) {
                                if (this.node.isLeaf()) {
                                    this.showPopup(e, parent, this.category);
                                }
                            } else {
                                this.showPopup(e, parent, this.category);
                            }
                        }
                    } else if (index == -1) {
                        list.clearSelection();
                        parent.setSelectedObjects(null);
                        ColumnViewList.this.columnView.addEmptyColumns(ColumnViewList.this.columnId);
                    } else {
                        Object[] selections = list.getSelectedValues();
                        if (selections.length > 0) {
                            this.node = (SRAToolkitNode)selections[0];
                            this.category = this.node.getCategory();
                            String repository = this.node.getRepository();
                            SRAToolkit.debugPrintln(repository);
                            parent.setSelectedObjects(selections);
                            if (selections.length == 1) {
                                if (this.node.getChildCount() != 0) {
                                    ColumnViewList.this.columnView.addNewColumns(this.node, ColumnViewList.this.columnId);
                                } else {
                                    ColumnViewList.this.columnView.addEmptyColumns(ColumnViewList.this.columnId);
                                }
                            } else {
                                ColumnViewList.this.columnView.addEmptyColumns(ColumnViewList.this.columnId);
                            }
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                private void showPopup(MouseEvent e, ColumnViewList parent, int category) {
                    Component mc = e.getComponent();
                    switch (category) {
                        case 1: {
                            this.menu = SRAToolkitPopupMenu.makeColumnViewListRemotePopupMenu(parent);
                            break;
                        }
                        case 2: {
                            this.menu = SRAToolkitPopupMenu.makeColumnViewListSitePopupMenu(parent);
                            break;
                        }
                        case 3: {
                            this.menu = SRAToolkitPopupMenu.makeColumnViewListLocalPopupMenu(parent);
                        }
                    }
                    if (this.menu == null) {
                        SRAToolkit.debugPrintln(" menu is null ");
                    }
                    this.menu.show(mc, e.getX(), e.getY());
                    if (this.menu.getParent().getX() == 0) {
                        this.menu.show(mc, e.getX(), e.getY() - this.menu.getHeight());
                    }
                }
            });
            this.add((Component)this.treeList, "Center");
        }
    }

    public void setSelectedObjects(Object[] nodes) {
        if (nodes != null) {
            this.selectedNodes = nodes;
            for (int i = 0; i < nodes.length; ++i) {
                SRAToolkitNode node = (SRAToolkitNode)this.selectedNodes[i];
                SRAToolkit.debugPrintln(node.getPath());
            }
        }
    }

    public void relayEventToConsole(String which) {
        if (which.equals("scan")) {
            int length = this.selectedNodes.length;
            String[] paths = new String[length];
            for (int i = 0; i < length; ++i) {
                SRAToolkitNode node = (SRAToolkitNode)this.selectedNodes[i];
                if (node == null) {
                    SRAToolkit.debugPrintln("node is null");
                }
                paths[i] = node.getPath();
            }
            this.columnView.relayEventToConsole(which, paths);
        } else if (which.equals("download")) {
            int length = this.selectedNodes.length;
            String[] paths = new String[length];
            for (int i = 0; i < length; ++i) {
                SRAToolkitNode node = (SRAToolkitNode)this.selectedNodes[i];
                if (node == null) {
                    SRAToolkit.debugPrintln("node is null");
                }
                paths[i] = node.getPath();
            }
            this.columnView.relayEventToConsole(which, paths);
        }
    }

    class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Color HIGHLIGHT_COLOR = new Color(0, 0, 128);
        private String name;
        private Image selectedImage;

        public NodeCellRenderer() {
            this.setOpaque(true);
            this.setIconTextGap(12);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SRAToolkitNode node = (SRAToolkitNode)value;
            String entry = node.getName();
            if (entry != null) {
                String rsrc = !node.isDirectory() ? "/rsrc/icon/document-2.png" : (node.isEmpty() ? "/rsrc/icon/system_folder_white.png" : "/rsrc/icon/folder-2.png");
                URL url = SRAToolkitConsole.class.getResource(rsrc);
                ImageIcon icon = new ImageIcon(url);
                this.setText(entry);
                this.setIcon(icon);
                if (isSelected) {
                    this.setBackground(this.HIGHLIGHT_COLOR);
                    this.setForeground(Color.white);
                } else {
                    this.setBackground(Color.white);
                    this.setForeground(Color.black);
                }
            }
            return this;
        }
    }
}

