/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleLeftPanel;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitPopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

class LeftPanelLocalPopupMenu
extends SRAToolkitPopupMenu {
    private SRAToolkitConsoleLeftPanel lPanel;
    private int level;
    private String repository;
    private JMenuItem enableCache;
    private JMenuItem disableCache;
    private KConfig config;

    public LeftPanelLocalPopupMenu(SRAToolkitConsoleLeftPanel _location, int _level, String _repository) {
        this.lPanel = _location;
        this.level = _level;
        this.repository = _repository;
        this.populateMenu(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateMenu(SRAToolkitPopupMenu _menu) {
        JMenuItem removeRepository;
        JMenuItem importRepository;
        block21: {
            importRepository = new JMenuItem("Import Repository");
            importRepository.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LeftPanelLocalPopupMenu.this.lPanel.relayEventToConsole("import");
                }
            });
            removeRepository = new JMenuItem("Remove Repository");
            importRepository.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LeftPanelLocalPopupMenu.this.lPanel.relayEventToConsole("remove");
                }
            });
            this.enableCache = new JRadioButtonMenuItem("Enable Repository for caching");
            this.enableCache.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent ae) {
                    block7: {
                        try {
                            LeftPanelLocalPopupMenu.this.config = KConfig.make();
                            if (LeftPanelLocalPopupMenu.this.config == null) break block7;
                            try {
                                KConfigNode cache = LeftPanelLocalPopupMenu.this.config.openNodeUpdate("/repository/user/main/" + LeftPanelLocalPopupMenu.this.repository + "/cache-enabled");
                                try {
                                    cache.write("true");
                                    LeftPanelLocalPopupMenu.this.enableCache.setSelected(true);
                                }
                                catch (Exception ex) {
                                    cache.release();
                                }
                            }
                            finally {
                                LeftPanelLocalPopupMenu.this.config.commit();
                                LeftPanelLocalPopupMenu.this.config.release();
                            }
                        }
                        catch (Exception e) {
                            SRAToolkit.stackTracePrint(e);
                        }
                    }
                }
            });
            this.disableCache = new JRadioButtonMenuItem("Disable Repository for caching");
            this.disableCache.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent ae) {
                    block7: {
                        try {
                            LeftPanelLocalPopupMenu.this.config = KConfig.make();
                            if (LeftPanelLocalPopupMenu.this.config == null) break block7;
                            try {
                                KConfigNode cache = LeftPanelLocalPopupMenu.this.config.openNodeUpdate("/repository/user/main/" + LeftPanelLocalPopupMenu.this.repository + "/cache-enabled");
                                try {
                                    cache.write("false");
                                    LeftPanelLocalPopupMenu.this.disableCache.setSelected(true);
                                }
                                catch (Exception ex) {
                                    cache.release();
                                }
                            }
                            finally {
                                LeftPanelLocalPopupMenu.this.config.commit();
                                LeftPanelLocalPopupMenu.this.config.release();
                            }
                        }
                        catch (Exception e) {
                            SRAToolkit.stackTracePrint(e);
                        }
                    }
                }
            });
            try {
                this.config = KConfig.make();
                if (this.config == null) break block21;
                try {
                    KConfigNode cache = this.config.openNodeRead("/repository/user/main/" + this.repository + "/cache-enabled");
                    try {
                        if (cache.read().equals("true")) {
                            this.enableCache.setSelected(true);
                            this.disableCache.setSelected(false);
                        } else {
                            this.enableCache.setSelected(true);
                        }
                    }
                    finally {
                        cache.release();
                    }
                }
                catch (Exception ex) {
                    this.enableCache.setSelected(true);
                }
                finally {
                    this.config.release();
                }
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        }
        _menu.add(importRepository);
        _menu.add(removeRepository);
        _menu.addSeparator();
        _menu.add(this.enableCache);
        _menu.add(this.disableCache);
        switch (this.level) {
            case 1: {
                removeRepository.setEnabled(false);
                this.enableCache.setEnabled(false);
                this.enableCache.setSelected(false);
                this.disableCache.setEnabled(false);
                break;
            }
            case 2: {
                if (this.repository.startsWith("legacy")) {
                    this.enableCache.setSelected(false);
                    this.enableCache.setEnabled(false);
                    this.disableCache.setEnabled(false);
                } else if (this.enableCache.isSelected()) {
                    this.enableCache.setEnabled(false);
                    this.disableCache.setEnabled(true);
                } else {
                    this.enableCache.setEnabled(true);
                    this.disableCache.setEnabled(false);
                }
                removeRepository.setEnabled(false);
                importRepository.setEnabled(false);
                break;
            }
            case 3: {
                this.enableCache.setEnabled(false);
                this.disableCache.setEnabled(false);
                removeRepository.setEnabled(false);
                importRepository.setEnabled(false);
            }
        }
    }
}

