/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConfigMgr;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

class RemoteConfigDialog
extends JDialog
implements PropertyChangeListener {
    private JCheckBox remoteDisabled;
    private String btnString1 = "OK";
    private JOptionPane optionPane;
    private KConfig kfg;
    private SRAToolkitConfigMgr mgr;
    private boolean hasBeenSet = false;

    public RemoteConfigDialog(SRAToolkitConfigMgr _mgr, KConfig _kfg) {
        super((Frame)_mgr, true);
        this.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        this.setTitle("Configuration Manager");
        this.mgr = _mgr;
        try {
            this.kfg = (KConfig)_kfg.duplicate();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        this.remoteDisabled = new JCheckBox("Disable Repository");
        this.remoteDisabled.setSelected(false);
        this.remoteDisabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String which = RemoteConfigDialog.this.remoteDisabled.isSelected() ? "true" : "false";
                RemoteConfigDialog.this.hasBeenSet = RemoteConfigDialog.this.setRemoteDisabled(which);
            }
        });
        String remote = "\nRemote Internet access to NCBI is enabled by default.\nYou can disable it here (not recommended), and you can also\nenable it or disable it later from the browser window.";
        Object[] array = new Object[]{remote, this.remoteDisabled};
        Object[] options = new Object[]{this.btnString1};
        this.optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                RemoteConfigDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.optionPane.addPropertyChangeListener(this);
        this.setContentPane(this.optionPane);
    }

    public boolean setRemoteDisabled(String which) {
        return SRAToolkit.setRemoteDisabled(this.kfg, which);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (!this.btnString1.equals(value)) {
                JOptionPane.showMessageDialog(this, "Remote Internet access to NCBI is enabled\n You may edit this under \"Preferences\"", null, 2);
            }
            if (!this.hasBeenSet) {
                this.setRemoteDisabled("false");
            }
            this.setVisible(false);
            this.openConfirmationDialog();
        }
    }

    public void openConfirmationDialog() {
        Object[] options = new Object[]{"OK", "EXIT"};
        int response = JOptionPane.showOptionDialog(this, "Configuration is now complete\n\nPress 'OK' to continue browsing or 'EXIT' to quit", "Exiting...", 0, 2, null, options, options[0]);
        if (response == 0) {
            this.clearAndHide(true, false);
        } else {
            this.clearAndHide(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAndHide(boolean ok, boolean exited) {
        this.setVisible(false);
        try {
            SRAToolkitConfigMgr.clearDefaultConfigNode(this.kfg);
            this.kfg.commit();
            this.kfg.release();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        finally {
            this.mgr.closeConfigMgr(ok, exited);
        }
    }
}

