/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.ColumnViewList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleRightPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class RightPanelColumnView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SRAToolkitConsoleRightPanel rightPanel;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JPanel[] panels = new JPanel[100];
    private SRAToolkitNode root = null;
    private int columnCount = 0;
    private Border raisedbevel = BorderFactory.createRaisedBevelBorder();
    private Border loweredbevel = BorderFactory.createLoweredBevelBorder();
    private Border border = BorderFactory.createCompoundBorder(this.raisedbevel, this.loweredbevel);

    RightPanelColumnView(SRAToolkitConsoleRightPanel _rightPanel, SRAToolkitNode _root) {
        this.setLayout(new BorderLayout());
        this.rightPanel = _rightPanel;
        this.root = _root;
        this.initMainPanel();
        this.add((Component)this.mainScrollPane, "Center");
    }

    RightPanelColumnView(SRAToolkitConsoleRightPanel _rightPanel, SRAToolkitNode _root, SRAToolkitNode _node) {
        this.setLayout(new BorderLayout());
        this.rightPanel = _rightPanel;
        this.root = _root;
        SRAToolkit.debugPrintln("Not initializing");
        this.updateColumns(_node, 0);
        this.add((Component)this.mainScrollPane, "Center");
    }

    private void initMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout());
        for (int i = 0; i < 100; ++i) {
            JPanel panel;
            if (i == 0) {
                panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.setBorder(this.border);
                this.panels[i] = panel;
                JScrollPane pane = new JScrollPane(new ColumnViewList(this, this.root, i));
                pane.setPreferredSize(new Dimension(210, this.root.getChildCount()));
                pane.setHorizontalScrollBarPolicy(30);
                this.panels[i].add((Component)pane, "Center");
                this.mainPanel.add(this.panels[i]);
                this.columnCount = 1;
                continue;
            }
            panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(this.border);
            panel.setBackground(Color.white);
            panel.setEnabled(false);
            this.panels[i] = panel;
            this.mainPanel.add(this.panels[i]);
        }
        this.mainScrollPane = new JScrollPane(this.mainPanel);
        this.mainScrollPane.setVerticalScrollBarPolicy(21);
    }

    public void relayEventToConsole(String which, Object obj) {
        this.rightPanel.relayEventToConsole(which, obj);
    }

    public void addNewColumns(SRAToolkitNode target, int selectedColumnId) {
        if (selectedColumnId == 0) {
            this.columnCount = 1;
        }
        this.removeColumn(selectedColumnId + 1);
        this.addColumn(target, selectedColumnId + 1);
    }

    public void addEmptyColumns(int selectedColumnId) {
        if (selectedColumnId == 0) {
            this.columnCount = 1;
        }
        this.removeColumn(selectedColumnId + 1);
        this.addColumn(null, selectedColumnId + 1);
    }

    public void updateColumns(SRAToolkitNode target, int selectedColumnId) {
        this.updateMainPanel();
        this.stackToAddColumns(target, selectedColumnId);
    }

    private void updateMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout());
        for (int i = 0; i < 100; ++i) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBorder(this.border);
            panel.setBackground(Color.white);
            panel.setEnabled(false);
            this.panels[i] = panel;
            this.mainPanel.add(this.panels[i]);
        }
        this.mainScrollPane = new JScrollPane(this.mainPanel);
        this.mainScrollPane.setVerticalScrollBarPolicy(21);
    }

    private void stackToAddColumns(SRAToolkitNode target, int selectedColumnId) {
        if (target != null) {
            SRAToolkitNode child;
            Stack<SRAToolkitNode> stack = new Stack<SRAToolkitNode>();
            for (child = target; child != null; child = (SRAToolkitNode)child.getParent()) {
                SRAToolkit.debugPrintln("Pushing: " + child);
                stack.push(child);
            }
            while (!stack.empty()) {
                child = (SRAToolkitNode)stack.pop();
                SRAToolkit.debugPrintln("Popped: " + child);
                this.removeColumn(selectedColumnId);
                this.addColumn(child, selectedColumnId++);
            }
        }
    }

    private void removeColumn(int removeColumnId) {
        if (this.panels[removeColumnId] != null) {
            if (removeColumnId != 0) {
                this.panels[removeColumnId].removeAll();
            }
            for (int i = removeColumnId; i < this.panels.length; ++i) {
                this.mainPanel.remove(this.panels[i]);
            }
            --this.columnCount;
        }
    }

    private void addColumn(SRAToolkitNode parent, int addColumnId) {
        SRAToolkitNode node = parent;
        if (node != null) {
            if (node.getChildCount() != 0) {
                JScrollPane pane = new JScrollPane(new ColumnViewList(this, node, addColumnId));
                pane.setPreferredSize(new Dimension(210, parent.getChildCount()));
                pane.setHorizontalScrollBarPolicy(30);
                this.panels[addColumnId].add((Component)pane, "Center");
                this.mainPanel.add(this.panels[addColumnId]);
                this.rightPanel.repaint();
                for (int i = addColumnId + 1; i < this.panels.length; ++i) {
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.setBorder(this.border);
                    panel.setBackground(Color.white);
                    this.panels[i] = panel;
                    this.mainPanel.add(this.panels[i]);
                }
                ++this.columnCount;
            }
        } else {
            for (int i = addColumnId; i < this.panels.length; ++i) {
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.setBorder(this.border);
                panel.setBackground(Color.white);
                this.panels[i] = panel;
                this.mainPanel.add(this.panels[i]);
            }
            this.rightPanel.repaint();
        }
    }
}

