/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.kfs.KFSPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.InitialConfigurationSemaphore;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.RemoteConfigDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SRAToolkitConfigMgr
extends JFrame {
    private InitialConfigurationSemaphore stop;
    private KConfig kfg;

    public SRAToolkitConfigMgr(KConfig _kfg, InitialConfigurationSemaphore _stop) throws Exception {
        this.stop = _stop;
        System.loadLibrary("vdb_jni");
        this.kfg = (KConfig)_kfg.duplicate();
        UserConfigDialog dialog = new UserConfigDialog(this, this.kfg);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConfigMgr(boolean ok, boolean exited) {
        try {
            this.kfg.release();
            this.dispose();
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        finally {
            if (this.stop != null) {
                this.stop.done(ok, exited);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearDefaultConfigNode(KConfig kfg) {
        try {
            String path = "/config/default";
            KConfigNode dflt = kfg.openNodeRead(path);
            try {
                String dflt_value = dflt.read();
                dflt.release();
                dflt = null;
                if (dflt_value.equals("true")) {
                    dflt = kfg.openNodeUpdate(path);
                    dflt.write("false");
                }
            }
            finally {
                if (dflt != null) {
                    dflt.release();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class UserConfigDialog
    extends JDialog
    implements ActionListener,
    PropertyChangeListener {
        private String typedText;
        private JTextField textField;
        private JFrame frame;
        private JOptionPane optionPane;
        private String btnString1;
        private String btnString2;
        private String defaultPath;
        private KConfig kfg;
        private SRAToolkitConfigMgr mgr;

        public String getValidatedText() {
            return this.typedText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UserConfigDialog(SRAToolkitConfigMgr _mgr, KConfig _kfg) throws Exception {
            super((Frame)_mgr, true);
            this.typedText = null;
            this.btnString1 = "Next";
            this.btnString2 = "Cancel";
            this.defaultPath = null;
            this.setModalityType(Dialog.ModalityType.MODELESS);
            this.mgr = _mgr;
            this.kfg = (KConfig)_kfg.duplicate();
            this.setTitle("Configuration Manager");
            KConfigNode rep = this.kfg.openNodeUpdate("/repository/user/main/public");
            try {
                KConfigNode node = rep.openNodeRead("root");
                try {
                    this.defaultPath = node.readString();
                }
                finally {
                    node.release();
                }
            }
            finally {
                rep.release();
            }
            KFSPath dPath = KFSPath.makeFromPosixString(this.defaultPath);
            this.textField = new JTextField();
            this.textField.setText(dPath.getSystemPathString());
            JButton browseButton = new JButton("Browse");
            browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setFileSelectionMode(1);
                    chooser.setApproveButtonText("OK");
                    int opt = chooser.showOpenDialog(SRAToolkitConfigMgr.this);
                    if (opt == 0) {
                        File file = chooser.getSelectedFile();
                        if (!file.exists()) {
                            file.mkdirs();
                        } else if (!file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        String path = file.toString();
                        UserConfigDialog.this.textField.setText(path);
                    }
                }
            });
            String config = "Welcome to the SRAToolkit Configuration Manager.\n\nThe SRAToolkit has the ability to download and cache data.\nPlease indicate where data should be stored.\nYou should choose a volume with enough free space.\n\nPath to your Repository: ";
            Object[] array = new Object[]{config, this.textField, browseButton};
            Object[] options = new Object[]{this.btnString1, this.btnString2};
            this.optionPane = new JOptionPane(array, 3, 0, null, options, options[0]);
            this.setContentPane(this.optionPane);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    UserConfigDialog.this.optionPane.setValue(new Integer(-1));
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ce) {
                    UserConfigDialog.this.textField.requestFocusInWindow();
                }
            });
            this.textField.addActionListener(this);
            this.optionPane.addPropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.optionPane.setValue(this.btnString1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRepRootPosixPath(String path) {
            try {
                KConfigNode rep = this.kfg.openNodeUpdate("/repository/user/main/public");
                try {
                    KConfigNode rootNode = rep.openNodeUpdate("root");
                    try {
                        rootNode.write(path);
                    }
                    finally {
                        rootNode.release();
                    }
                }
                finally {
                    rep.release();
                }
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
                Object value = this.optionPane.getValue();
                if (value == JOptionPane.UNINITIALIZED_VALUE) {
                    return;
                }
                this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                if (this.btnString1.equals(value)) {
                    this.typedText = this.textField.getText();
                    if (!this.typedText.equals("")) {
                        KFSPath typedPath = null;
                        try {
                            typedPath = KFSPath.makeFromSystemString(this.typedText);
                        }
                        catch (Exception ex) {
                            SRAToolkit.stackTracePrint(ex);
                        }
                        File file = new File(typedPath.getSystemPathString());
                        if (!file.exists()) {
                            int response = JOptionPane.showOptionDialog(this, "Directory:\n\n " + this.typedText + " \n\nDoes not exist.\n" + "\nWould you like us to create it? ", "Warning", 0, 2, null, null, null);
                            if (response == 0) {
                                this.setRepRootPosixPath(typedPath.getPosixPathString());
                                RemoteConfigDialog rDialog = new RemoteConfigDialog(this.mgr, this.kfg);
                                this.clearAndHide();
                                rDialog.pack();
                                rDialog.setLocationRelativeTo(this.mgr);
                                rDialog.setVisible(true);
                            } else {
                                this.textField.selectAll();
                                this.textField.setText(this.defaultPath);
                                JOptionPane.showMessageDialog(this, "Please enter a valid directory to store data", "Error", 0);
                                this.typedText = null;
                                this.textField.requestFocusInWindow();
                            }
                        } else {
                            this.setRepRootPosixPath(typedPath.getPosixPathString());
                            RemoteConfigDialog rDialog = new RemoteConfigDialog(this.mgr, this.kfg);
                            this.clearAndHide();
                            rDialog.pack();
                            rDialog.setLocationRelativeTo(this.mgr);
                            rDialog.setVisible(true);
                        }
                    } else {
                        this.textField.selectAll();
                        JOptionPane.showMessageDialog(this, "Please enter a valid directory to store data", "Error", 0);
                        this.typedText = null;
                        this.textField.requestFocusInWindow();
                    }
                } else {
                    this.typedText = null;
                    int response = JOptionPane.showOptionDialog(this, "Are you sure you want to cancel configuration?\nConfiguration is required to run the SRAToolkit\nUpon restarting the SRAToolkit, you will need\nto complete the configuration again", "Warning", 0, 2, null, null, null);
                    if (response == 0) {
                        this.clearAndHide(false, true);
                    }
                }
            }
        }

        public void clearAndHide() {
            this.textField.setText(null);
            this.setVisible(false);
            try {
                this.kfg.release();
                this.dispose();
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearAndHide(boolean ok, boolean exited) {
            this.textField.setText(null);
            this.setVisible(false);
            try {
                this.kfg.release();
                this.dispose();
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
            finally {
                this.mgr.closeConfigMgr(ok, exited);
            }
        }
    }
}

