/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.kfg.KConfig;
import gov.nih.nlm.ncbi.vdb.kfg.KConfigNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitNode;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsole;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitPopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SRAToolkitConsoleLeftPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MouseListener mListener = new MouseAdapter(){
        private SRAToolkitPopupMenu menu;

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)SRAToolkitConsoleLeftPanel.this.tree.getLastSelectedPathComponent();
                Point p = e.getPoint();
                int level = tNode.getLevel();
                SRAToolkit.debugPrintln(level);
                if (level == 1) {
                    if (tNode.toString().equals("REMOTE")) {
                        this.showPopup(e, p, 1, level, null);
                    }
                    if (tNode.toString().equals("SITE")) {
                        this.showPopup(e, p, 2, level, null);
                    }
                    if (tNode.toString().equals("USER")) {
                        this.showPopup(e, p, 3, level, null);
                    }
                } else {
                    SRAToolkitNode node = (SRAToolkitNode)tNode.getUserObject();
                    if (node != null) {
                        int category = node.getCategory();
                        String repository = node.getRepository();
                        this.showPopup(e, p, category, level, repository);
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void showPopup(MouseEvent e, Point p, int category, int level, String repository) {
            if (category != 0) {
                TreePath tPath = SRAToolkitConsoleLeftPanel.this.tree.getSelectionPath();
                Rectangle rect = SRAToolkitConsoleLeftPanel.this.tree.getPathBounds(tPath);
                SRAToolkitConsoleLeftPanel parent = (SRAToolkitConsoleLeftPanel)SRAToolkitConsoleLeftPanel.this.tree.getParent();
                if (rect.contains(p)) {
                    // empty if block
                }
                Component mc = e.getComponent();
                switch (category) {
                    case 1: {
                        this.menu = SRAToolkitPopupMenu.makeLeftPanelRemotePopupMenu(parent, level, repository);
                        break;
                    }
                    case 2: {
                        this.menu = SRAToolkitPopupMenu.makeLeftPanelSitePopupMenu(parent, level, repository);
                        break;
                    }
                    case 3: {
                        this.menu = SRAToolkitPopupMenu.makeLeftPanelLocalPopupMenu(parent, level, repository);
                    }
                }
                if (this.menu != null) {
                    this.menu.show(mc, e.getX(), e.getY());
                    if (this.menu.getParent().getX() == 0) {
                        this.menu.show(mc, e.getX(), e.getY() - this.menu.getHeight());
                    }
                }
            }
        }
    };
    private JTree tree;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private SRAToolkitNode selectedNode;
    private SRAToolkitConsole console;
    private SRAToolkit app;

    public static SRAToolkitConsoleLeftPanel make(SRAToolkit _app, SRAToolkitConsole _console) {
        SRAToolkitConsoleLeftPanel panel = null;
        try {
            panel = new SRAToolkitConsoleLeftPanel(_app, _console);
        }
        catch (Exception e) {
            SRAToolkit.stackTracePrint(e);
        }
        return panel;
    }

    public void relayEventToConsole(String which) {
        this.console.interpretEvent(which, null);
    }

    public void setSelectedNode(SRAToolkitNode node) {
        this.selectedNode = node;
    }

    public void expandAll(JTree t) {
        for (int i = 0; i < t.getRowCount(); ++i) {
            t.expandRow(i);
        }
    }

    public void updateTree() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.expandAll(this.tree);
    }

    private void populateRepository(SRAToolkitNode rep, DefaultMutableTreeNode repository) {
        Enumeration<SRAToolkitNode> e = rep.children();
        while (e.hasMoreElements()) {
            SRAToolkitNode app = e.nextElement();
            DefaultMutableTreeNode appNode = new DefaultMutableTreeNode(app);
            repository.add(appNode);
        }
    }

    private void populateRoot() {
        String[] catNames = this.app.getCategoryNames();
        for (int i = 0; i < catNames.length; ++i) {
            if (catNames[i].equals("SITE")) {
                boolean noSite = true;
                try {
                    KConfig config = KConfig.make();
                    KConfigNode node = config.openNodeRead("/repository/site");
                    noSite = false;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (noSite) continue;
            }
            DefaultMutableTreeNode category = new DefaultMutableTreeNode(catNames[i]);
            this.root.add(category);
            SRAToolkitNode[] repositories = this.app.getCategoryNodes(i);
            for (int j = 0; j < repositories.length; ++j) {
                SRAToolkitNode repository = repositories[j];
                DefaultMutableTreeNode repositoryNode = new DefaultMutableTreeNode(repository);
                this.populateRepository(repository, repositoryNode);
                category.add(repositoryNode);
            }
        }
    }

    private SRAToolkitConsoleLeftPanel(SRAToolkit _app, SRAToolkitConsole _console) {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.app = _app;
        this.console = _console;
        this.root = new DefaultMutableTreeNode("");
        this.populateRoot();
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.addMouseListener(this.mListener);
        this.tree.addTreeSelectionListener(new SelectionListener());
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.expandAll(this.tree);
        this.add(this.tree);
        this.setPreferredSize(new Dimension(200, 900));
    }

    class SelectionListener
    implements TreeSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent se) {
            JTree tree = (JTree)se.getSource();
            SRAToolkitConsoleLeftPanel lPanel = (SRAToolkitConsoleLeftPanel)tree.getParent();
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
            if (selectedNode == null) {
                SRAToolkit.debugPrintln("null");
            } else if (selectedNode.isLeaf()) {
                SRAToolkitNode node = (SRAToolkitNode)selectedNode.getUserObject();
                lPanel.setSelectedNode(node);
                try {
                    SRAToolkit sRAToolkit = SRAToolkitConsoleLeftPanel.this.app;
                    SRAToolkitConsoleLeftPanel.this.console;
                    sRAToolkit.addToEventQueue(SRAToolkitConsole.makeUpdateRightPanelCommand(SRAToolkitConsoleLeftPanel.this.app, SRAToolkitConsoleLeftPanel.this.console, node));
                }
                catch (Exception e) {
                    SRAToolkit.stackTracePrint(e);
                }
            }
        }
    }
}

