/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkitShell;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitStdStreamMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DefaultCaret;

public class SRAToolkitConsoleShell
extends JPanel
implements Runnable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel inputBar;
    private JButton clear;
    private JTextArea textArea;
    private JTextField textInput;
    private JScrollPane scrollPane;
    private Thread stdoutThread;
    private Thread stderrThread;
    private SRAToolkitStdStreamMonitor outMonitor;
    private SRAToolkitStdStreamMonitor errMonitor;
    private SRAToolkitShell shell;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        String args = null;
        JTextField jTextField = this.textInput;
        synchronized (jTextField) {
            args = this.textInput.getText();
            this.textInput.setText("");
        }
        if (args != null) {
            try {
                this.shell.parseArgs(args);
            }
            catch (Exception e) {
                SRAToolkit.stackTracePrint(e);
            }
        }
    }

    public void threadShutDown() {
        try {
            this.stdoutThread.join(1000L);
            this.stderrThread.join(1000L);
            this.outMonitor.close();
            this.errMonitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void appendTextArea(int which, String string) {
        if (which == 2) {
            if (string.equals("\n")) {
                this.textArea.append(string);
            } else {
                this.textArea.append("+++++++++++++++++\n");
                this.textArea.append("Error: " + string + "\n");
            }
        } else {
            this.textArea.append(string);
        }
    }

    public void setTextFieldFocus() {
        this.textInput.requestFocus();
    }

    public SRAToolkitConsoleShell(SRAToolkitShell _shell) throws IOException {
        this.setLayout(new BorderLayout());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = new Dimension(screenSize.width / 2, screenSize.height / 2);
        this.setPreferredSize(frameSize);
        this.shell = _shell;
        Font font = new Font("Courier", 0, 14);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(font);
        this.textArea.setLineWrap(true);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.textInput = new JTextField();
        this.clear = new JButton("Clear");
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SRAToolkitConsoleShell.this.textArea.setText("");
            }
        });
        this.scrollPane = new JScrollPane(this.textArea);
        this.inputBar = new JPanel();
        this.inputBar.setLayout(new BorderLayout());
        this.inputBar.add((Component)this.textInput, "North");
        this.inputBar.add((Component)this.clear, "South");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.inputBar, "South");
        this.textInput.addActionListener(this);
        this.outMonitor = new SRAToolkitStdStreamMonitor(1, this);
        this.stdoutThread = new Thread(this.outMonitor);
        this.stdoutThread.start();
        this.errMonitor = new SRAToolkitStdStreamMonitor(2, this);
        this.stderrThread = new Thread(this.errMonitor);
        this.stderrThread.start();
    }

    @Override
    public void run() {
    }
}

