/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.gui;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.gui.SRAToolkitConsoleShell;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;

public class SRAToolkitStdStreamMonitor
extends OutputStream
implements Runnable {
    int which;
    boolean quit = false;
    SRAToolkitConsoleShell guiShell;
    PipedInputStream piped_input;
    PipedOutputStream piped_output;

    public SRAToolkitStdStreamMonitor(int which, SRAToolkitConsoleShell gShell) throws IOException {
        this.which = which;
        this.guiShell = gShell;
        this.piped_input = new PipedInputStream();
        this.piped_output = new PipedOutputStream(this.piped_input);
    }

    @Override
    public synchronized void close() {
        try {
            this.piped_output.close();
            this.notify();
        }
        catch (IOException e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    @Override
    public synchronized void flush() {
        try {
            this.piped_output.flush();
            this.notify();
        }
        catch (IOException e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    @Override
    public synchronized void write(byte[] b) {
        try {
            this.piped_output.write(b);
            this.notify();
        }
        catch (IOException e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        try {
            this.piped_output.write(b, off, len);
            this.notify();
        }
        catch (IOException e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    @Override
    public synchronized void write(int b) {
        try {
            this.piped_output.write(b);
            this.notify();
        }
        catch (IOException e) {
            SRAToolkit.stackTracePrint(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void run() {
        PrintStream old = null;
        try {
            PrintStream print_stream = new PrintStream(this, true);
            switch (this.which) {
                case 1: {
                    old = System.out;
                    System.setOut(print_stream);
                    break;
                }
                case 2: {
                    old = System.err;
                    System.setErr(print_stream);
                    break;
                }
                default: {
                    throw new Exception("aaaaah !");
                }
            }
            while (!this.quit) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    // empty catch block
                }
                int available = this.piped_input.available();
                if (this.quit || available <= 0) continue;
                byte[] b = new byte[available];
                this.piped_input.read(b);
                String s = new String(b, 0, available);
                available = this.piped_input.available();
                while (available > 0 && !this.quit) {
                    byte[] b2 = new byte[available];
                    this.piped_input.read(b2);
                    s = s + new String(b2, 0, available);
                    available = this.piped_input.available();
                }
                this.guiShell.appendTextArea(this.which, s);
            }
            if (old == null) return;
        }
        catch (Exception exception) {
            if (old == null) return;
            switch (this.which) {
                case 1: {
                    System.setOut(old);
                    return;
                }
                case 2: {
                    System.setErr(old);
                }
            }
            return;
            catch (Throwable throwable) {
                if (old == null) throw throwable;
                switch (this.which) {
                    case 1: {
                        System.setOut(old);
                        throw throwable;
                    }
                    case 2: {
                        System.setErr(old);
                    }
                }
                throw throwable;
            }
        }
        switch (this.which) {
            case 1: {
                System.setOut(old);
                return;
            }
            case 2: {
                System.setErr(old);
            }
        }
        return;
    }
}

