/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.net.WebAccessor;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqWebRepository;
import gov.nih.nlm.ncbi.vdb.sratoolkit.util.logging.Handler;
import java.io.File;

class NonFlatRefseqWebRepository
extends RefseqWebRepository {
    private String root;

    NonFlatRefseqWebRepository(String local, String remote, boolean mkLocal) throws Exception {
        super(local, remote, mkLocal);
    }

    @Override
    int getSize(ResolvedPath obj) throws Exception {
        String remote = obj.remote();
        if (remote.length() <= 0) {
            throw new Exception("remote path is unknown for refseq " + obj.accession());
        }
        return WebAccessor.getSize(remote);
    }

    @Override
    String download(ResolvedPath obj) throws Exception {
        String local = obj.cache();
        if (local.length() <= 0) {
            Handler.reportError("local path to download is unknown for refseq " + obj.accession());
            return null;
        }
        String remote = obj.remote();
        if (remote.length() <= 0) {
            throw new Exception("remote path is unknown for refseq " + obj.accession());
        }
        return this.download(remote, local);
    }

    @Override
    String getPathCache(ResolvedPath obj) {
        return obj.cache();
    }

    @Override
    String getPathRemote(ResolvedPath obj) {
        return obj.remote();
    }

    @Override
    String getPackedPath(String name) {
        return this.root + File.separator + name;
    }
}

