/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqItf;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.Refseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqList;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqPackedHelper;

class PackedRefseqList
extends RefseqList {
    protected RefseqPackedHelper packed;

    static PackedRefseqList make(RefseqItf papa, RefseqPackedHelper packed) {
        return new PackedRefseqList(papa, packed);
    }

    protected PackedRefseqList(RefseqPackedHelper packed) {
        this.packed = packed;
    }

    private PackedRefseqList(RefseqItf papa, RefseqPackedHelper packed) {
        this(packed);
        this.addAll(papa);
    }

    @Override
    protected boolean pack(Refseq refseq) {
        String packedName = this.packed.packedFileName(refseq.getSeqId());
        if (packedName != null) {
            try {
                refseq.setPackedSeqFile(packedName);
                return true;
            }
            catch (Exception e) {
                SRAToolkit.errPrintln(e);
                return false;
            }
        }
        return false;
    }
}

