/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPath;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.ResolvedPathVisitor;
import java.io.File;

public class Refseq
extends ResolvedPath {
    private boolean local;
    private String seqId;
    private String resolvedPath;
    private String repository;
    private String cachePath;
    private String remotePath;
    private String seqIdFile;
    private int packedCount;

    Refseq(boolean local, String seqId, String path) {
        if (seqId == null) {
            throw new NullPointerException();
        }
        this.packedCount = 0;
        this.cachePath = "";
        this.remotePath = "";
        this.local = local;
        this.seqId = this.seqIdFile = seqId;
        String string = this.resolvedPath = path == null ? "" : path;
        if (this.resolvedPath != "") {
            File f = new File(this.resolvedPath);
            this.repository = f.getParent();
        }
    }

    @Override
    public String accession() {
        return this.getSeqId();
    }

    @Override
    public String local() {
        return this.getResolvedPath();
    }

    @Override
    public String remote() {
        return this.getPathRemote();
    }

    @Override
    public String cache() {
        return this.getPathCache();
    }

    @Override
    public boolean accept(ResolvedPathVisitor v) {
        return v.visit(this);
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getSeqId() {
        return this.seqId;
    }

    public String getPathLocal() {
        return this.getResolvedPath();
    }

    public boolean isResolved() {
        return this.resolvedPath.length() > 0;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPathCache() {
        return this.cachePath;
    }

    public void setPathCache(String path) throws Exception {
        this.cachePath = path;
    }

    public String getPathRemote() {
        return this.remotePath;
    }

    public void setPathRemote(String path) throws Exception {
        this.remotePath = path;
    }

    public boolean isPacked() {
        return this.packedCount > 0;
    }

    public int getPackedCount() {
        return this.packedCount;
    }

    public String getSeqIdFile() {
        return this.seqIdFile;
    }

    public void setPackedSeqFile(String name) throws Exception {
        if (this.packedCount == 0) {
            this.cachePath = this.seqIdFile = name;
        } else {
            if (!name.equals(this.seqIdFile)) {
                throw new Exception("Bad packed SeqId name: " + this.seqIdFile + " vs. " + name);
            }
            if (this.packedCount == 1) {
                this.seqId = this.seqIdFile;
            }
        }
        ++this.packedCount;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean detailed) {
        String result = this.seqId;
        result = this.local ? result + ",local" : result + ",remote";
        if (this.isResolved()) {
            result = result + ":" + this.resolvedPath;
        }
        if (!detailed) {
            return result;
        }
        result = result + ". cache=" + this.getPathCache() + ". remote=" + this.getPathRemote();
        return result;
    }
}

