/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseq.RefseqItf;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.Refseq;
import gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl.RefseqFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RefseqList {
    protected int localCount = 0;
    private Map<String, Refseq> impl = new HashMap<String, Refseq>();

    protected boolean pack(Refseq refseq) {
        return false;
    }

    protected boolean setPaths(Refseq refseq) {
        return false;
    }

    public static RefseqList make(RefseqItf papa) {
        return new RefseqList(papa);
    }

    protected RefseqList() {
    }

    private RefseqList(RefseqItf papa) {
        this();
        this.addAll(papa);
    }

    public void addAll(RefseqList c) {
        Iterator<Refseq> it = c.externalIterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        this.localCount += c.localCount;
    }

    public Iterator<Refseq> externalIterator() {
        return new ListIterator(this);
    }

    public int count() {
        return this.count(true);
    }

    public int localCount() {
        return this.localCount;
    }

    public int externalCount() {
        return this.externalCount(true);
    }

    public int unresolvedCount() {
        return this.resolvedCount(true, false);
    }

    public int resolvedCount() {
        return this.resolvedCount(true, true);
    }

    public int countAll() {
        return this.count(false);
    }

    public int externalCountAll() {
        return this.externalCount(false);
    }

    public int unresolvedCountAll() {
        return this.resolvedCount(false, false);
    }

    public int resolvedCountAll() {
        return this.resolvedCount(false, true);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean detailed) {
        String result = this.getClass().getName();
        int last = result.lastIndexOf(".");
        if (last >= 0 && last + 1 < result.length()) {
            result = result.substring(last + 1);
        }
        result = result + "[";
        int size = this.count();
        if (size == 0) {
            return result + size + "]";
        }
        if (this.externalCount() == 0) {
            return result + size + " local]";
        }
        result = this.localCount() == 0 ? result + size + " external]" : result + this.externalCount() + " external; " + this.localCount() + " local]";
        if (!detailed) {
            return result;
        }
        result = result + " = {\n";
        Iterator<Refseq> it = this.externalIterator();
        int i = 0;
        while (it.hasNext()) {
            result = result + "\t" + i + ":\t" + it.next() + "\n";
            ++i;
        }
        return result + "}";
    }

    protected void addAll(RefseqItf papa) {
        if (papa == null) {
            return;
        }
        int count = papa.getCount();
        for (int i = 0; i < count; ++i) {
            try {
                boolean local = papa.isLocal(i);
                if (!local) {
                    String seqId = papa.getSeqId(i);
                    String path = papa.getPathLocal(i);
                    Refseq refseq = RefseqFactory.makeRefseq(local, seqId, path);
                    this.add(refseq);
                    continue;
                }
                ++this.localCount;
                continue;
            }
            catch (Exception e) {
                SRAToolkit.errPrintln(e);
            }
        }
    }

    protected void add(Refseq refseq) {
        this.pack(refseq);
        this.setPaths(refseq);
        this.impl.put(refseq.getPathCache(), refseq);
    }

    private int count(boolean packedAs1) {
        return this.localCount() + this.externalCount(packedAs1);
    }

    private int externalCount(boolean packedAs1) {
        if (packedAs1) {
            return this.impl.size();
        }
        int i = 0;
        Iterator<Refseq> it = this.externalIterator();
        while (it.hasNext()) {
            int packedCount = it.next().getPackedCount();
            if (packedCount > 0) {
                i += packedCount;
                continue;
            }
            ++i;
        }
        return i;
    }

    private int resolvedCount(boolean packedAs1, boolean countResolved) {
        int result = 0;
        Iterator<Refseq> it = this.externalIterator();
        while (it.hasNext()) {
            boolean resolved;
            int packed;
            Refseq r = it.next();
            int cnt = 1;
            if (!packedAs1 && (packed = it.next().getPackedCount()) > 0) {
                cnt = packed;
            }
            if ((!(resolved = r.isResolved()) || !countResolved) && (resolved || countResolved)) continue;
            result += cnt;
        }
        return result;
    }

    private class ListIterator
    implements Iterator<Refseq> {
        private Iterator it;

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Refseq next() {
            Map.Entry pairs = (Map.Entry)this.it.next();
            return (Refseq)pairs.getValue();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        private ListIterator(RefseqList obj) {
            this.it = obj.impl.entrySet().iterator();
        }
    }
}

