/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.sratoolkit.refseqImpl;

import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RefseqPackedHelper {
    private ArrayList<String> packed = new ArrayList();

    public RefseqPackedHelper(String name) throws IOException {
        String line;
        if (name == null) {
            return;
        }
        BufferedReader r = new BufferedReader(new FileReader(name));
        while ((line = r.readLine()) != null) {
            if (line.length() <= 0 || line.charAt(0) == '#') continue;
            this.packed.add(line);
        }
        r.close();
    }

    String packedFileName(String refseq) {
        for (String prefix : this.packed) {
            if (!refseq.startsWith(prefix)) continue;
            SRAToolkit.debugPrintln("packedFileName: prefix found");
            return prefix;
        }
        SRAToolkit.debugPrintln("packedFileName: prefix not found");
        return null;
    }

    public String toString() {
        String result = "";
        Iterator<String> it = this.packed.iterator();
        while (it.hasNext()) {
            if (result.length() > 0) {
                result = result + "\n";
            }
            result = result + it.next();
        }
        return result;
    }

    public static String getName() {
        return "packed.txt";
    }
}

