/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.vdb.vfs;

import gov.nih.nlm.ncbi.vdb.kfs.KFSPath;
import gov.nih.nlm.ncbi.vdb.klib.KDbg;
import gov.nih.nlm.ncbi.vdb.klib.VDBMakeException;
import gov.nih.nlm.ncbi.vdb.klib.VDBObject;
import gov.nih.nlm.ncbi.vdb.sratoolkit.app.SRAToolkit;

public class VResolver
extends VDBObject {
    static VResolver make(long mgr, long cfg) throws VDBMakeException {
        long obj = VResolver.Make(mgr, cfg);
        if (obj == 0L) {
            throw new VDBMakeException();
        }
        return new VResolver(obj);
    }

    public String local(String accession) throws Exception {
        String s;
        if (KDbg.jni()) {
            SRAToolkit.errPrintln("VResolver::local(" + accession + ")");
        }
        if ((s = VResolver.Local(this.getSelf(), accession)) == null) {
            return null;
        }
        KFSPath path = KFSPath.makeFromPosixString(s);
        return path.getSystemPathString();
    }

    public String remote(String accession) {
        if (KDbg.jni()) {
            SRAToolkit.errPrintln("VResolver::remote(" + accession + ")");
        }
        StringBuffer s = new StringBuffer();
        long sz = VResolver.Remote(this.getSelf(), accession, s, 0);
        return s.toString();
    }

    public long remote(String accession, StringBuffer remote) {
        return this.remote(accession, remote, 0);
    }

    public long remoteFasp(String accession, StringBuffer remote) {
        return this.remote(accession, remote, 1);
    }

    private long remote(String accession, StringBuffer remote, int scheme) {
        if (remote == null) {
            throw new NullPointerException();
        }
        if (KDbg.jni()) {
            SRAToolkit.errPrintln("VResolver::remote(" + accession + ", size)");
        }
        remote.setLength(0);
        return VResolver.Remote(this.getSelf(), accession, remote, scheme);
    }

    public String cache(String accession) throws Exception {
        String s;
        if (KDbg.jni()) {
            SRAToolkit.errPrintln("VResolver::cache(" + accession + ")");
        }
        if ((s = VResolver.Cache(this.getSelf(), accession)) == null) {
            return null;
        }
        KFSPath path = KFSPath.makeFromPosixString(s);
        return path.getSystemPathString();
    }

    @Override
    protected VDBObject create(long obj) {
        return new VResolver(obj);
    }

    private VResolver(long obj) {
        super(obj);
    }

    @Override
    protected native long Duplicate(long var1);

    @Override
    protected native boolean Release(long var1);

    private static native long Make(long var0, long var2);

    private static native String Local(long var0, String var2);

    private static native String Cache(long var0, String var2);

    private static native long Remote(long var0, String var2, StringBuffer var3, int var4);
}

