/* File: main.c for The boomerang simulator
** Authors: John C. Orthoefer <jco@reef.cis.ufl.edu>
**	    Brian Bartholomew <bb@math.ufl.edu>
** Date: 10 Nov 1990
** History:  Converted from PC BASIC (10 Nov 1990)
** 
*/

#include <stdio.h>
#include "rang.h"

double atof();    /* Note that the man page didn't mention to do this */


main(argc, argv)
int argc;
char *argv[];
{
   extern char *optarg;
   int errflag = 0;
   char c;
   int mode = Dmode;

/* Initial values for vars */
   Vel = DVel;
   aim = Daim;
   tilt = Dtilt;
   LayDown = DLayDown;
   Elevation = DElevation;

   while ((c = getopt(argc, argv, "v:a:t:l:e:m:")) != -1) {

      switch (c) {
	 case '?':
	    ++errflag;
	    break;
         case 'v':
	    Vel = atof(optarg);
	    break;
         case 'm':
	    mode = atoi(optarg);
	    break;
         case 'a':
	    aim = atof(optarg);
	    break;
         case 't':
	    tilt = atof(optarg);
	    break;
         case 'l':
	    LayDown = atof(optarg);
	    break;
         case 'e':
	    Elevation = atof(optarg);
	    break;
      }
   }

   if (errflag) {
      (void)fprintf(stderr, "Usage:\t%s [-v velocity] [-a aim] [-t tilt] [-l lay_down] [-e elevation]\n\t[-m mode]\n", argv[0]);
      (void)fprintf(stderr, "Defaults: velocity  =%8.3f\n", DVel);
      (void)fprintf(stderr, "          aim       =%8.3f\n", Daim);
      (void)fprintf(stderr, "          tilt      =%8.3f\n", Dtilt);
      (void)fprintf(stderr, "          lay_down  =%8.3f\n", DLayDown);
      (void)fprintf(stderr, "          elevation =%8.3f\n", DElevation);
      (void)fprintf(stderr, "          mode      =%4d\n", Dmode);
      exit (1);
   }

   initrang(mode);
   initio(mode);

   plotrang(mode);
   while (Z > 0.0) {
      AdvRang();
      plotrang(mode);
   }
}   
