/* File: rangio.c for The boomerang simulator
** Authors: John C. Orthoefer <jco@reef.cis.ufl.edu>
**	    Brian Bartholomew <bb@math.ufl.edu>
** Date: 10 Nov 1990
** History:  Converted from PC BASIC (10 Nov 1990)
** 
*/

#include <stdio.h>
#include <math.h>
#include "rang.h"

double XG, YG;
double XR, YR;


initio(mode)
int mode;
{
   switch(mode) {
   default:
      break;
   case 1:
      printf("%c Cross-hairs and base-lines -\n", CommentChar);
      printf("%f %f\n%f %f\n\n",0.0, 100.0, 319.0, 100.0);
      printf("%f %f\n%f %f\n\n",160.0, 0.0, 160.0, 199.0);
      printf("%f %f\n%f %f\n\n",10.0, 185.0, 150.0, 185.0);
      printf("%f %f\n%f %f\n\n",295.0, 10.0, 295.0, 90.0);
      break;
   }

   printf("%c Initial Conditions -\n", CommentChar);
   printf("%c   Velocity   :%8.3f\n", CommentChar, Vel);
   printf("%c   Aim        :%8.3f\n", CommentChar, aim);
   printf("%c   Tilt       :%8.3f\n", CommentChar, tilt);
   printf("%c   Lay Down   :%8.3f\n", CommentChar, LayDown);
   printf("%c   View Angle :%8.3f\n", CommentChar, Elevation);
   printf("\n%c Data follows -\n", CommentChar);
}
      

plotrang(mode)
int mode;	/* Mode = 0 : rang in 3D */
		/* Mode = 1 : 3 rang pics (w/ compress axis) */
		/*		plus the 3D pic */
{
   switch(mode) {
   default:
      simple3d();
      break;
   case 1:
      fourpics();
      break;
   }
}

simple3d()
{
   XG=160.0+M*X;
   YG=175.0-sin(E)*M*Y;
   XR=XG;
   YR=YG-cos(E)*M*Z;
   printf("%f %f\n%f %f\n\n", XG,YG,XR,YR);
   printf("%f %f\n%f %f\n\n", XRL,YRL,XR,YR);
   XRL=XR; YRL=YR;
}

fourpics()
{
   printf("%f %f\n\n", M*X-20.0, 95.0-M*Y);
   printf("%f %f\n\n", -20.0+M*X, 185.0-M*Z);
   printf("%f %f\n\n", 295.0-M*Z,  95.0-M*Y);
   XG=140.0+M*X; YG=185.0-sin(E)*M*Y;
   XR=XG; YR=YG-cos(E)*M*Z;
   printf("%f %f\n%f %f\n\n", XG, YG, XR, YR);
   printf("%f %f\n%f %f\n\n", XRL, YRL, XR, YR);
   XRL=XR; YRL=YR;
}
