/****************************************\
*                                        *
*	       dataread.c                *
*				         *
*        read data from a socket         *
*                                        *
*  	for use with CA simulator        *
*                                        *
*                                        *
\****************************************/

/* Aug 30 1988 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#define TRUE 1
#define MAXLEN 32

/*
 * Format of socket messages from CA simulator is as follows:  The first message
 * is a single integer, giving the number of states per cell currently in use.
 * Subsequent messages are sent once every CA time step; each message is a list
 * of integers, one per state, giving a count of the number of cells in the current
 * array with that state.
 */

/*
 * This program creates a socket and then begins an infinite loop.  Each time
 * through the loop it accepts a connection and prints out messages from it.
 * The first message is assumed to be a single integer, giving the length (in
 * integers) of all subsequent messages.  When the connection breaks, or a
 * termination message comes through, the program accepts a new connection.
 */

int     sock, msgsock;

main()
{
    int     buf[MAXLEN], rval, msglen;
    int     i;

    setup_receiver();

    do {
	connect_receiver();
	rval = get_message(&msglen, 1);
	while (rval != 0) {
	    bzero(buf, sizeof(buf));
	    rval = get_message(buf, msglen);	/* get list of integers */
	    if (rval == 0)
		break;
	    printf("[");		/* print out the list */
	    for (i = 0; i < msglen; i++)
		printf(" %d", buf[i]);
	    printf("]\n");
	    fflush(stdout);
	}
	disconnect_receiver();
    } while (TRUE);

    /*
     * Since this program has an infinite loop, the socket "sock" is never
     * explicitly closed.  However, all sockets will be closed automatically
     * when a process is killed or terminates normally.
     */

    close_receiver();
}

setup_receiver()
{
    struct sockaddr_in server;
    int     length;

    /* Create socket */
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
	perror("opening stream socket");
	exit(1);
    }
    /* Name socket using wildcards */
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = 0;
    if (bind(sock, &server, sizeof(server))) {
	perror("binding stream socket");
	exit(1);
    }
    /* Find out assigned port number and print it out */
    length = sizeof(server);
    if (getsockname(sock, &server, &length)) {
	perror("getting socket name");
	exit(1);
    }
    fprintf(stderr, "Socket has port #%d\n", ntohs(server.sin_port));

    /* Start accepting connections */
    listen(sock, 5);
}

connect_receiver()
{
    msgsock = accept(sock, 0, 0);
    if (msgsock == -1) {
	perror("accept");
	exit(1);
    }
}

disconnect_receiver()
{
    close(msgsock);
}

get_message(data, len)			/* Receives len integers into array
					 * data. Returns 0 if connection
					 * closed.	  */
    int    *data, len;
{
    int     r;
    if ((r = read(msgsock, (char *) data, len * sizeof(int))) < 0)
	perror("reading stream message");
    if (r == 0)
	fprintf(stderr, "Ending connection\n");
    return (r);
}

close_receiver()
{
    close(sock);
}


/***** END OF FILE *****/
