/* $Id: tickwin.c,v 1.9 90/04/13 20:33:42 pturner Exp Locker: pturner $
 *
 * Ticks and labels popup
 *
 * TODO: separate the box around plot items from tick mark parameters
 *
 */

#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "globals.h"
#include "defines.h"
#include "objdefs.h"

extern Frame main_frame;
extern void update_proc();
extern Pixfont *winfont;

Frame define_tics_frame;	/* for tickmarks */
static Panel define_tics_panel;
static Panel_item define_tics_xmajor;
static Panel_item define_tics_xminor;
static Panel_item define_tics_ymajor;
static Panel_item define_tics_yminor;
static Panel_item define_tics_xform;
static Panel_item define_tics_yform;
static Panel_item define_xtics_skip;
static Panel_item define_ytics_skip;
static Panel_item define_xtics_angle;
static Panel_item define_ytics_angle;
static Panel_item xgridcol_item;
static Panel_item xgridline_item;
static Panel_item ygridcol_item;
static Panel_item ygridline_item;
static Panel_item xticlen_item;
static Panel_item yticlen_item;
static Panel_item toggle_xtics_item;
static Panel_item toggle_ytics_item;
static Panel_item toggle_autoticks_item;

static Panel_item axes_scaletype_item;
static Panel_item toggle_xticnum_item;
static Panel_item toggle_yticnum_item;

static Panel_item toggle_box_item;	/* for the box around the plot */
static Panel_item boxcol_item;
static Panel_item boxline_item;

static Panel_item title_item;	/* plot labels */
static Panel_item subtitle_item;
static Panel_item xaxis_item;
static Panel_item yaxis_item;

static Panel_item defaults_font_item;	/* for default settings in ticks
					 * popup */
static Panel_item defcolor_item;
static Panel_item defchar_item;
static Panel_item defsymsize_item;

/*
 * freshen up tickmarks
 */
void updatetics()
{
    int itmp;

    if (xt1 > 0)
	sprintf(buf, "%.5g", xt1);
    else
	strcpy(buf, "UNDEFINED");
    panel_set_value(define_tics_xmajor, buf);
    if (xt2 > 0 || xticslog)
	sprintf(buf, "%.5g", xt2);
    else
	strcpy(buf, "UNDEFINED");
    panel_set_value(define_tics_xminor, buf);
    if (yt1 > 0)
	sprintf(buf, "%.5g", yt1);
    else
	strcpy(buf, "UNDEFINED");
    panel_set_value(define_tics_ymajor, buf);
    if (yt2 > 0 || yticslog)
	sprintf(buf, "%.5g", yt2);
    else
	strcpy(buf, "UNDEFINED");
    panel_set_value(define_tics_yminor, buf);

    sprintf(buf, "%d", xform);
    panel_set_value(define_tics_xform, buf);
    sprintf(buf, "%d", yform);
    panel_set_value(define_tics_yform, buf);
    sprintf(buf, "%d", xticangle);
    panel_set_value(define_xtics_angle, buf);
    sprintf(buf, "%d", yticangle);
    panel_set_value(define_ytics_angle, buf);
    sprintf(buf, "%d", xticlskip);
    panel_set_value(define_xtics_skip, buf);
    sprintf(buf, "%d", yticlskip);
    panel_set_value(define_ytics_skip, buf);

    panel_set_value(title_item, title);
    panel_set_value(subtitle_item, stitle);
    panel_set_value(xaxis_item, xlabel);
    panel_set_value(yaxis_item, ylabel);

    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 0, xticflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 1, xticlflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 2, fformx, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 3, xgridflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 4, xticslog, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 5, xzflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 6, xztflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 7, xticinoutflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 8, xticopflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 9, xabsflag, 0);
    panel_set(toggle_xtics_item, PANEL_TOGGLE_VALUE, 10, xtopflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 0, yticflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 1, yticlflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 2, fformy, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 3, ygridflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 4, yticslog, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 5, yzflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 6, yztflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 7, yticinoutflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 8, yticopflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 9, yabsflag, 0);
    panel_set(toggle_ytics_item, PANEL_TOGGLE_VALUE, 10, ytopflag, 0);
    if (boxon) {
	if (boxflag) {
	    itmp = 0;
	} else {
	    itmp = 1;
	}
    } else {
	itmp = 2;
    }
    panel_set_value(toggle_box_item, itmp);
    panel_set_value(boxcol_item, boxcol);
    panel_set_value(boxline_item, boxlin);
    panel_set_value(xgridcol_item, xgcol);
    panel_set_value(xgridline_item, xglin);
    panel_set_value(ygridcol_item, ygcol);
    panel_set_value(ygridline_item, yglin);
    panel_set_value(xticlen_item, (int) (xticsize * 50));
    panel_set_value(yticlen_item, (int) (yticsize * 50));
    if (yticslog && xticslog) {
	itmp = 3;
    } else if (yticslog && !xticslog) {
	itmp = 2;
    } else if (!yticslog && xticslog) {
	itmp = 1;
    } else {
	itmp = 0;
    }
    panel_set_value(axes_scaletype_item, itmp);
    if (!(xticnum >= 3 && xticnum <= 10)) {
	xticnum = 6;
    }
    if (!(yticnum >= 3 && yticnum <= 10)) {
	yticnum = 6;
    }
    panel_set_value(toggle_xticnum_item, xticnum - 3);
    panel_set_value(toggle_yticnum_item, yticnum - 3);
}

/*
 * define tick marks
 */
static void define_tics_proc(item, event)
    Panel_item item;
    Event *event;
{
    char val[80];
    int ier, itmp;
    extern double result;
    double x = (xg2 - xg1), y = (yg2 - yg1), a = xg1, b = yg1, c = xg2, d = yg2;
    int errpos;

    strcpy(val, panel_get_value(define_tics_xmajor));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    xt1 = result;
    strcpy(val, panel_get_value(define_tics_xminor));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    xt2 = result;
    strcpy(val, panel_get_value(define_tics_ymajor));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    yt1 = result;
    strcpy(val, panel_get_value(define_tics_yminor));
    fixupstr(val);
    scanner(val, &x, &y, &a, &b, &c, &d, 0, 0, &errpos);
    if (errpos) {
	return;
    }
    yt2 = result;
    strcpy(val, panel_get_value(define_tics_xform));
    xform = atoi(val);
    strcpy(val, panel_get_value(define_tics_yform));
    yform = atoi(val);
    strcpy(val, panel_get_value(define_xtics_angle));
    xticangle = atoi(val);
    strcpy(val, panel_get_value(define_ytics_angle));
    yticangle = atoi(val);
    strcpy(val, panel_get_value(define_xtics_skip));
    xticlskip = atoi(val);
    strcpy(val, panel_get_value(define_ytics_skip));
    yticlskip = atoi(val);
    xticflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 0);
    yticflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 0);
    xticlflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 1);
    yticlflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 1);
    fformx = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 2);
    fformy = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 2);
    xgridflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 3);
    ygridflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 3);
    xticslog = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 4);
    yticslog = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 4);
    if (xticslog) {
	if (xt2 > 9.0 || xt2 < 0.0) {
	    xt2 = 9.0;
	    sprintf(buf, "%.5g", xt2);
	    panel_set_value(define_tics_xminor, buf);
	}
    }
    if (yticslog) {
	if (yt2 > 9.0 || yt2 < 0.0) {
	    yt2 = 9.0;
	    sprintf(buf, "%.5g", yt2);
	    panel_set_value(define_tics_yminor, buf);
	}
    }
    xzflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 5);
    yzflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 5);
    xztflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 6);
    yztflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 6);
    xticinoutflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 7);
    yticinoutflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 7);
    xticopflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 8);
    yticopflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 8);
    xabsflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 9);
    yabsflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 9);
    xtopflag = (int) panel_get(toggle_xtics_item, PANEL_TOGGLE_VALUE, 10);
    ytopflag = (int) panel_get(toggle_ytics_item, PANEL_TOGGLE_VALUE, 10);
    itmp = (int) panel_get_value(toggle_box_item);
    if (itmp == 2) {
	boxon = 0;
    } else if (itmp == 1) {
	boxon = 1;
	boxflag = 0;
    } else {
	boxon = 1;
	boxflag = 1;
    }
    boxcol = (int) panel_get_value(boxcol_item);
    boxlin = (int) panel_get_value(boxline_item);
    xgcol = (int) panel_get_value(xgridcol_item);
    xglin = (int) panel_get_value(xgridline_item);
    ygcol = (int) panel_get_value(ygridcol_item);
    yglin = (int) panel_get_value(ygridline_item);
    xticsize = (int) panel_get_value(xticlen_item) / 50.0;
    yticsize = (int) panel_get_value(yticlen_item) / 50.0;
    drawgraph();
}

/*
 * set the plot labels, title, x/y-axis labels
 */
static void define_labels_proc(item, event)
    Panel_item item;
    Event *event;
{
    strcpy(title, panel_get_value(title_item));
    strcpy(stitle, panel_get_value(subtitle_item));
    strcpy(xlabel, panel_get_value(xaxis_item));
    strcpy(ylabel, panel_get_value(yaxis_item));
    drawgraph();
}

/*
 * set the style of the box around the plot
 */
static void define_box_proc(item, event)
    Panel_item item;
    Event *event;
{
    int itmp;

    itmp = (int) panel_get_value(toggle_box_item);
    if (itmp == 2) {
	boxon = 0;
    } else if (itmp == 1) {
	boxon = 1;
	boxflag = 0;
    } else {
	boxon = 1;
	boxflag = 1;
    }
    boxcol = (int) panel_get_value(boxcol_item);
    boxlin = (int) panel_get_value(boxline_item);
    drawgraph();
}

/*
 * establish some default settings, font, color, linestyle
 * TODO: this should be someplace other than tickmarks
 */
static void do_defaults_proc(item, event)
    Panel_item item;
    Event *event;
{
    extern int curfont;

    curfont = (int) panel_get_value(defaults_font_item);
    defcolor = (int) panel_get_value(defcolor_item) + 1;
    defchar = (int) panel_get_value(defchar_item) / 50.0;
    defsymsize = (int) panel_get_value(defsymsize_item) / 50.0;
    drawgraph();
}

static void defchar_proc(item, value, event)
    Panel_item item;
    Event *event;
    int value;
{
    defchar = value / 50.0;
}

/*
 * close the ticks popup
 */
static void define_tics_done_proc()
{
    window_set(define_tics_frame, WIN_SHOW, FALSE, 0);
}

/*
 * another method of setting the axes scaling
 */
static void setaxis_scale_proc(item, event)
    Panel_item item;
    Event *event;
{
    extern int go_locateflag;
    int i, cx = xticslog, cy = yticslog;
    int scale_type = (int) panel_get_value(axes_scaletype_item);

    go_locateflag = 0;		/* shut down the locator */
    if ((xticslog || yticslog) && logtransflag) {
	invlogtrans(0);
	if (cx) {
	    defaultx();
	    defaultxtics(0);
	}
	if (cy) {
	    defaulty();
	    defaultytics(0);
	}
	for (i = 0; i < maxplot; i++) {
	    if (isactive(i)) {
		update_status(i);
	    }
	}
    }
    switch (scale_type) {
    case 0:
	xticslog = 0;
	yticslog = 0;
	break;
    case 1:
	xticslog = 1;
	yticslog = 0;
	break;
    case 2:
	xticslog = 0;
	yticslog = 1;
	break;
    case 3:
	xticslog = 1;
	yticslog = 1;
	break;
    }
    if (xticslog || yticslog) {
	logtrans();
	for (i = 0; i < maxplot; i++) {
	    if (isactive(i)) {
		update_status(i);
	    }
	}
	if (xticslog && yticslog) {
	    defaultgraph();
	    defaulttics(0);
	} else {
	    if (xticslog) {
		defaultx();
		defaultxtics(0);
	    } else {
		if (yticslog) {
		    defaulty();
		    defaultytics(0);
		}
	    }
	}
    } else {
	defaultgraph();
	defaulttics(0);
    }
    updatetics();
    updateparms();
    drawgraph();
    go_locateflag = 1;
}

/*
 * set spacing of ticks to the default value
 */
void autotick_proc()
{
    int auto_type = (int) panel_get_value(toggle_autoticks_item);

    xticnum = 3 + (int) panel_get_value(toggle_xticnum_item);
    yticnum = 3 + (int) panel_get_value(toggle_yticnum_item);

    switch (auto_type) {
    case 0:
	defaulttics(0);
	break;
    case 1:
	defaultxtics(0);
	break;
    case 2:
	defaultytics(0);
	break;
    }
    updatetics();
    drawgraph();
}

/*
 * create the ticks popup
 */
void define_tics_popup()
{
    define_tics_frame = window_create(main_frame, FRAME,
				      FRAME_LABEL, "Tics and labels",
				      FRAME_SHOW_LABEL, TRUE,
				      WIN_FONT, winfont,
				      WIN_Y, 50,
			 WIN_ERROR_MSG, "Couldn't create define_tics_frame",
				      0);
    define_tics_panel = window_create(define_tics_frame, PANEL,
				      WIN_FONT, winfont,
				WIN_VERTICAL_SCROLLBAR, scrollbar_create(0),
				      0);
    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(10),
		      PANEL_LABEL_IMAGE,
	   panel_button_image(define_tics_panel, "Define tics", 0, winfont),
		      PANEL_NOTIFY_PROC, define_tics_proc,
		      0);
    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	   panel_button_image(define_tics_panel, "Update tics", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(20),
		      PANEL_ITEM_Y, ATTR_ROW(10),
		      PANEL_NOTIFY_PROC, updatetics,
		      0);

    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
      panel_button_image(define_tics_panel, "Set axes scaling", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(24),
		      PANEL_NOTIFY_PROC, setaxis_scale_proc,
		      0);
    axes_scaletype_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
					    PANEL_ITEM_X, ATTR_COL(25),
					    PANEL_ITEM_Y, ATTR_ROW(24),
					    PANEL_LABEL_STRING, "Axes:",
					    PANEL_CHOICE_STRINGS,
					    "Linear-Linear",
					    "Log-linear",
					    "Linear-log",
					    "Log-log",
					    0,
					    0);

    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	    panel_button_image(define_tics_panel, "Auto ticks", 0, winfont),
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(26),
		      PANEL_NOTIFY_PROC, autotick_proc,
		      0);
    toggle_autoticks_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
					      PANEL_ITEM_X, ATTR_COL(13),
					      PANEL_ITEM_Y, ATTR_ROW(26),
					      PANEL_LABEL_STRING, "For:",
					      PANEL_CHOICE_STRINGS,
					      "Both axes",
					      "X-axis",
					      "Y-axis",
					      0,
					      0);
    toggle_xticnum_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
					    PANEL_ITEM_X, ATTR_COL(31),
					    PANEL_ITEM_Y, ATTR_ROW(26),
					    PANEL_LABEL_STRING, "# X ticks:",
					    PANEL_CHOICE_STRINGS,
				    "3", "4", "5", "6", "7", "8", "9", "10",
					    0,
					    0);
    toggle_yticnum_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
					    PANEL_ITEM_X, ATTR_COL(48),
					    PANEL_ITEM_Y, ATTR_ROW(26),
					    PANEL_LABEL_STRING, "# Y ticks:",
					    PANEL_CHOICE_STRINGS,
				    "3", "4", "5", "6", "7", "8", "9", "10",
					    0,
					    0);

    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(28),
		      PANEL_LABEL_IMAGE,
		  panel_button_image(define_tics_panel, "Done", 0, winfont),
		      PANEL_NOTIFY_PROC, define_tics_done_proc,
		      0);
    define_tics_xmajor = panel_create_item(define_tics_panel, PANEL_TEXT,
					   PANEL_ITEM_X, ATTR_COL(1),
					   PANEL_ITEM_Y, ATTR_ROW(11),
				  PANEL_LABEL_STRING, "X-axis major tics: ",
					 PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_tics_xminor = panel_create_item(define_tics_panel, PANEL_TEXT,
					   PANEL_ITEM_X, ATTR_COL(1),
					   PANEL_ITEM_Y, ATTR_ROW(12),
				  PANEL_LABEL_STRING, "X-axis minor tics: ",
					 PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_tics_ymajor = panel_create_item(define_tics_panel, PANEL_TEXT,
					   PANEL_ITEM_X, ATTR_COL(40),
					   PANEL_ITEM_Y, ATTR_ROW(11),
				  PANEL_LABEL_STRING, "Y-axis major tics: ",
					 PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_tics_yminor = panel_create_item(define_tics_panel, PANEL_TEXT,
					   PANEL_ITEM_X, ATTR_COL(40),
					   PANEL_ITEM_Y, ATTR_ROW(12),
				  PANEL_LABEL_STRING, "Y-axis minor tics: ",
					 PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_tics_xform = panel_create_item(define_tics_panel, PANEL_TEXT,
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(13),
			    PANEL_LABEL_STRING, "X-axis labels precision: ",
					  PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_tics_yform = panel_create_item(define_tics_panel, PANEL_TEXT,
					  PANEL_ITEM_X, ATTR_COL(40),
					  PANEL_ITEM_Y, ATTR_ROW(13),
			    PANEL_LABEL_STRING, "Y-axis labels precision: ",
					  PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_xtics_skip = panel_create_item(define_tics_panel, PANEL_TEXT,
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(14),
				 PANEL_LABEL_STRING, "X-axis labels skip: ",
					  PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_ytics_skip = panel_create_item(define_tics_panel, PANEL_TEXT,
					  PANEL_ITEM_X, ATTR_COL(40),
					  PANEL_ITEM_Y, ATTR_ROW(14),
				 PANEL_LABEL_STRING, "Y-axis labels skip: ",
					  PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_xtics_angle = panel_create_item(define_tics_panel, PANEL_TEXT,
					   PANEL_ITEM_X, ATTR_COL(1),
					   PANEL_ITEM_Y, ATTR_ROW(15),
				PANEL_LABEL_STRING, "X-axis labels angle: ",
					 PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    define_ytics_angle = panel_create_item(define_tics_panel, PANEL_TEXT,
					   PANEL_ITEM_X, ATTR_COL(40),
					   PANEL_ITEM_Y, ATTR_ROW(15),
				PANEL_LABEL_STRING, "Y-axis labels angle: ",
					 PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    toggle_xtics_item = panel_create_item(define_tics_panel, PANEL_TOGGLE,
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(16),
					  PANEL_DISPLAY_LEVEL, PANEL_NONE,
				PANEL_LABEL_STRING, "X-axis Toggles (menu)",
					  PANEL_LAYOUT, PANEL_VERTICAL,
					  PANEL_CHOICE_STRINGS,
					  "Show X-axis tics",
					  "Show X-axis tic labels",
					  "X-axis labels decimal",
					  "X-axis grid",
					  "X-axis logarithmic",
					  "Draw the line Y=0",
					  "Tics for the line Y=0",
					  "X-axis tics out",
					  "X-axis tics top",
					  "X-axis labels absolute",
					  "X-axis labels on top",
					  0,
					  0);
    toggle_ytics_item = panel_create_item(define_tics_panel, PANEL_TOGGLE,
					  PANEL_ITEM_X, ATTR_COL(40),
					  PANEL_ITEM_Y, ATTR_ROW(16),
					  PANEL_DISPLAY_LEVEL, PANEL_NONE,
				PANEL_LABEL_STRING, "Y-axis Toggles (menu)",
					  PANEL_LAYOUT, PANEL_VERTICAL,
					  PANEL_CHOICE_STRINGS,
					  "Show Y-axis tics",
					  "Show Y-axis tic labels",
					  "Y-axis labels decimal",
					  "Y-axis grid",
					  "Y-axis logarithmic",
					  "Draw the line X=0",
					  "Tics for the line X=0",
					  "Y-axis tics out",
					  "Y-axis tics right",
					  "Y-axis labels absolute",
					  "Y-axis labels on right",
					  0,
					  0);

    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(22),
		      PANEL_LABEL_IMAGE,
	    panel_button_image(define_tics_panel, "Define Box", 0, winfont),
		      PANEL_NOTIFY_PROC, define_box_proc,
		      0);
    toggle_box_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
					PANEL_ITEM_X, ATTR_COL(15),
					PANEL_ITEM_Y, ATTR_ROW(22),
					PANEL_CHOICE_STRINGS,
					"Closed box",
					"Half open box",
					"No box",
					0,
					0);

    boxcol_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
				    PANEL_CHOICE_STRINGS,
				    "No pen",
				    "Pen 1",
				    "Pen 2",
				    "Pen 3",
				    "Pen 4",
				    "Pen 5",
				    "Pen 6",
				    "Pen 7",
				    "Pen 8", 0,
				    PANEL_ITEM_X, ATTR_COL(35),
				    PANEL_ITEM_Y, ATTR_ROW(22),
				    0);
    boxline_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
				     PANEL_CHOICE_STRINGS,
				     "No line",
				     "Solid line",
				     "Dotted line",
				     "Dashed line",
				     "Long Dashed",
				     "Dot-dashed", 0,
				     PANEL_ITEM_X, ATTR_COL(45),
				     PANEL_ITEM_Y, ATTR_ROW(22),
				     0);

    xgridcol_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
				      PANEL_LABEL_STRING, "X-grid pen:",
				      PANEL_CHOICE_STRINGS,
				      "No pen",
				      "Pen 1",
				      "Pen 2",
				      "Pen 3",
				      "Pen 4",
				      "Pen 5",
				      "Pen 6",
				      "Pen 7",
				      "Pen 8", 0,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(17),
				      0);
    xgridline_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
				       PANEL_LABEL_STRING, "X-grid line:",
				       PANEL_CHOICE_STRINGS,
				       "No line",
				       "Solid",
				       "Dotted",
				       "Dashed",
				       "Long Dashed",
				       "Dot-dashed", 0,
				       PANEL_ITEM_X, ATTR_COL(1),
				       PANEL_ITEM_Y, ATTR_ROW(18),
				       0);
    ygridcol_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
				      PANEL_LABEL_STRING, "Y-grid pen:",
				      PANEL_CHOICE_STRINGS,
				      "No pen",
				      "Pen 1",
				      "Pen 2",
				      "Pen 3",
				      "Pen 4",
				      "Pen 5",
				      "Pen 6",
				      "Pen 7",
				      "Pen 8", 0,
				      PANEL_ITEM_X, ATTR_COL(40),
				      PANEL_ITEM_Y, ATTR_ROW(17),
				      0);
    ygridline_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
				       PANEL_LABEL_STRING, "Y-grid line:",
				       PANEL_CHOICE_STRINGS,
				       "No line",
				       "Solid",
				       "Dotted",
				       "Dashed",
				       "Long Dashed",
				       "Dot-dashed", 0,
				       PANEL_ITEM_X, ATTR_COL(40),
				       PANEL_ITEM_Y, ATTR_ROW(18),
				       0);
    xticlen_item = panel_create_item(define_tics_panel, PANEL_SLIDER,
				     PANEL_ITEM_X, ATTR_COL(1),
				     PANEL_ITEM_Y, ATTR_ROW(19),
				     PANEL_LABEL_STRING, "X-tick length",
				     PANEL_VALUE, 50,
				     PANEL_MIN_VALUE, 10,
				     PANEL_MAX_VALUE, 200,
				     0);
    yticlen_item = panel_create_item(define_tics_panel, PANEL_SLIDER,
				     PANEL_ITEM_X, ATTR_COL(1),
				     PANEL_ITEM_Y, ATTR_ROW(20),
				     PANEL_LABEL_STRING, "Y-tick length",
				     PANEL_VALUE, 50,
				     PANEL_MIN_VALUE, 10,
				     PANEL_MAX_VALUE, 200,
				     0);
    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      PANEL_LABEL_IMAGE,
	 panel_button_image(define_tics_panel, "Define labels", 0, winfont),
		      PANEL_NOTIFY_PROC, define_labels_proc,
		      0);
    title_item = panel_create_item(define_tics_panel, PANEL_TEXT,
				   PANEL_LABEL_STRING, "Title: ",
				   PANEL_ITEM_X, ATTR_COL(1),
				   PANEL_ITEM_Y, ATTR_ROW(1),
				   PANEL_VALUE_DISPLAY_LENGTH, 40, 0);
    subtitle_item = panel_create_item(define_tics_panel, PANEL_TEXT,
				      PANEL_LABEL_STRING, "Subtitle: ",
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(2),
				      PANEL_VALUE_DISPLAY_LENGTH, 40, 0);
    xaxis_item = panel_create_item(define_tics_panel, PANEL_TEXT,
				   PANEL_LABEL_STRING, "X-axis label: ",
				   PANEL_ITEM_X, ATTR_COL(1),
				   PANEL_ITEM_Y, ATTR_ROW(3),
				   PANEL_VALUE_DISPLAY_LENGTH, 40, 0);
    yaxis_item = panel_create_item(define_tics_panel, PANEL_TEXT,
				   PANEL_LABEL_STRING, "Y-axis label: ",
				   PANEL_ITEM_X, ATTR_COL(1),
				   PANEL_ITEM_Y, ATTR_ROW(4),
				   PANEL_VALUE_DISPLAY_LENGTH, 40, 0);

    panel_create_item(define_tics_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(6),
		      PANEL_LABEL_IMAGE,
	  panel_button_image(define_tics_panel, "Set defaults", 0, winfont),
		      PANEL_NOTIFY_PROC, do_defaults_proc,
		      0);
    defaults_font_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
					   PANEL_ITEM_X, ATTR_COL(1),
					   PANEL_ITEM_Y, ATTR_ROW(7),
					PANEL_LABEL_STRING, "Default font:",
					   PANEL_CHOICE_STRINGS,
					   "Romanc",
					   "Romand",
					   "Romans",
					   "Romant",
					   "Italicc",
					   "Italict",
					   "Scriptc",
					   "Scripts",
					   "Greekc",
					   "Greeks",
					   0,
					   0);
    defchar_item = panel_create_item(define_tics_panel, PANEL_SLIDER,
				     PANEL_ITEM_X, ATTR_COL(25),
				     PANEL_ITEM_Y, ATTR_ROW(7),
				     PANEL_LABEL_STRING, "Default char size",
				     PANEL_VALUE, 50,
				     PANEL_MIN_VALUE, 10,
				     PANEL_MAX_VALUE, 200,
				     0);
    defsymsize_item = panel_create_item(define_tics_panel, PANEL_SLIDER,
					PANEL_ITEM_X, ATTR_COL(25),
					PANEL_ITEM_Y, ATTR_ROW(8),
				     PANEL_LABEL_STRING, "Default sym size",
					PANEL_VALUE, 50,
					PANEL_MIN_VALUE, 10,
					PANEL_MAX_VALUE, 200,
					0);
    defcolor_item = panel_create_item(define_tics_panel, PANEL_CYCLE,
				      PANEL_LABEL_STRING, "Default pen:",
				      PANEL_CHOICE_STRINGS,
				      "Pen 1",
				      "Pen 2",
				      "Pen 3",
				      "Pen 4",
				      "Pen 5",
				      "Pen 6",
				      "Pen 7",
				      "Pen 8", 0,
				      PANEL_ITEM_X, ATTR_COL(1),
				      PANEL_ITEM_Y, ATTR_ROW(8),
				      0);
    window_fit(define_tics_panel);
    window_fit(define_tics_frame);
    updatetics();
    panel_set_value(defaults_font_item, curfont);
}
