/**********************************************************************/
/*                                                                    */
/*           File bws3.c:  Multiprocessor Simulation Model 3          */
/*                                                                    */
/*  This is the asynchronous model of a multiprocessor memory-bus     */
/*  subsystem with first-in, first out request queueing shown in      */
/*  Figure 5.8.                                                       */
/*                                                                    */
/**********************************************************************/

#include <smpl.h>
#define queued 1

real p=0.250;      /* local memory miss rate            */
int  N=8,M=4,nB=2, /* no. processors, memories, & buses */
     module[17],   /* facility descriptors for modules  */
     bus,          /* facility descriptor for buses     */
     req[17];      /* processor's current memory module */

/*-------------------  MEMORY-BUS BANDWIDTH MODEL  -------------------*/
main()
  {
    int event,i,n; real x=1.0/p-1.0;
    smpl(0,"Bandwidth Model");
    bus=facility("bus",nB);
    for (i=1; i<=M; i++) module[i]=facility("module",1);
    for (n=1; n<=N; n++)
      {req[n]=random(1,M); schedule(1,expntl(x),n);}
    while (time()<10000.0)
      {
        cause(&event,&n);
        switch(event)
          {
            case 1: /* reserve memory module */
              if (request(module[req[n]],n,0)!=queued)
                then schedule(2,0.0,n);
              break;
            case 2: /* reserve bus & initiate transfer  */
              if (request(bus,n,0)!=queued) then
                schedule(3,1.0,n);
              break;
            case 3: /* complete:  schedule next request */
              release(bus,n); release(module[req[n]],n);
              req[n]=random(1,M); schedule(1,expntl(x),n);
              break;
          }
      }
    report();
  }
