
/* Copyright (c) 2015-2026 Valve Corporation
 * Copyright (c) 2015-2026 LunarG, Inc.
 * Copyright (c) 2015-2017, 2019, 2021 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*
 * This file is generated from the Khronos Vulkan XML API Registry.
 */

#pragma once

#include "api_dump.h"

//========================== Handle Implementations =========================//

template <ApiDumpFormat Format>
void dump_VkBuffer(const VkBuffer& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkImage(const VkImage& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkInstance(const VkInstance& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(static_cast<void*>(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkPhysicalDevice(const VkPhysicalDevice& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(static_cast<void*>(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDevice(const VkDevice& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(static_cast<void*>(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkQueue(const VkQueue& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(static_cast<void*>(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkSemaphore(const VkSemaphore& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkCommandBuffer(const VkCommandBuffer& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(static_cast<void*>(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkFence(const VkFence& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDeviceMemory(const VkDeviceMemory& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkQueryPool(const VkQueryPool& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkImageView(const VkImageView& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkCommandPool(const VkCommandPool& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkRenderPass(const VkRenderPass& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkFramebuffer(const VkFramebuffer& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkEvent(const VkEvent& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkBufferView(const VkBufferView& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkShaderModule(const VkShaderModule& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkPipelineCache(const VkPipelineCache& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkPipelineLayout(const VkPipelineLayout& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkPipeline(const VkPipeline& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDescriptorSetLayout(const VkDescriptorSetLayout& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkSampler(const VkSampler& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDescriptorSet(const VkDescriptorSet& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDescriptorPool(const VkDescriptorPool& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDescriptorUpdateTemplate(const VkDescriptorUpdateTemplate& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkSamplerYcbcrConversion(const VkSamplerYcbcrConversion& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkPrivateDataSlot(const VkPrivateDataSlot& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkSurfaceKHR(const VkSurfaceKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkSwapchainKHR(const VkSwapchainKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDisplayKHR(const VkDisplayKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDisplayModeKHR(const VkDisplayModeKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkVideoSessionKHR(const VkVideoSessionKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkVideoSessionParametersKHR(const VkVideoSessionParametersKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDeferredOperationKHR(const VkDeferredOperationKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkPipelineBinaryKHR(const VkPipelineBinaryKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDebugReportCallbackEXT(const VkDebugReportCallbackEXT& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkCuModuleNVX(const VkCuModuleNVX& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkCuFunctionNVX(const VkCuFunctionNVX& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDebugUtilsMessengerEXT(const VkDebugUtilsMessengerEXT& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkTensorARM(const VkTensorARM& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkValidationCacheEXT(const VkValidationCacheEXT& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkAccelerationStructureNV(const VkAccelerationStructureNV& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkPerformanceConfigurationINTEL(const VkPerformanceConfigurationINTEL& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkIndirectCommandsLayoutNV(const VkIndirectCommandsLayoutNV& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)

template <ApiDumpFormat Format>
void dump_VkCudaModuleNV(const VkCudaModuleNV& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkCudaFunctionNV(const VkCudaFunctionNV& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

template <ApiDumpFormat Format>
void dump_VkAccelerationStructureKHR(const VkAccelerationStructureKHR& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}
#if defined(VK_USE_PLATFORM_FUCHSIA)

template <ApiDumpFormat Format>
void dump_VkBufferCollectionFUCHSIA(const VkBufferCollectionFUCHSIA& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}
#endif  // VK_USE_PLATFORM_FUCHSIA

template <ApiDumpFormat Format>
void dump_VkMicromapEXT(const VkMicromapEXT& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkTensorViewARM(const VkTensorViewARM& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkOpticalFlowSessionNV(const VkOpticalFlowSessionNV& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkShaderEXT(const VkShaderEXT& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkDataGraphPipelineSessionARM(const VkDataGraphPipelineSessionARM& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkExternalComputeQueueNV(const VkExternalComputeQueueNV& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(static_cast<void*>(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkIndirectExecutionSetEXT(const VkIndirectExecutionSetEXT& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

template <ApiDumpFormat Format>
void dump_VkIndirectCommandsLayoutEXT(const VkIndirectCommandsLayoutEXT& object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_handle<Format>(TYPE_ERASE_HANDLE(object), settings, type_name, var_name, indents, address);
}

//======================== Video Enum Implementations =======================//

template <ApiDumpFormat Format>
void dump_StdVideoH264ChromaFormatIdc(const StdVideoH264ChromaFormatIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_CHROMA_FORMAT_IDC_MONOCHROME:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CHROMA_FORMAT_IDC_MONOCHROME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_CHROMA_FORMAT_IDC_420:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CHROMA_FORMAT_IDC_420", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_CHROMA_FORMAT_IDC_422:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CHROMA_FORMAT_IDC_422", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_CHROMA_FORMAT_IDC_444:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CHROMA_FORMAT_IDC_444", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_CHROMA_FORMAT_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CHROMA_FORMAT_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264ProfileIdc(const StdVideoH264ProfileIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_PROFILE_IDC_BASELINE:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PROFILE_IDC_BASELINE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PROFILE_IDC_MAIN:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PROFILE_IDC_MAIN", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PROFILE_IDC_HIGH:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PROFILE_IDC_HIGH", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PROFILE_IDC_HIGH_444_PREDICTIVE:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PROFILE_IDC_HIGH_444_PREDICTIVE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PROFILE_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PROFILE_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264LevelIdc(const StdVideoH264LevelIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_LEVEL_IDC_1_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_1_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_1_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_1_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_1_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_1_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_1_3:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_1_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_2_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_2_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_2_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_2_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_2_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_2_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_3_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_3_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_3_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_3_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_3_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_3_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_4_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_4_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_4_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_4_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_4_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_4_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_5_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_5_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_5_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_5_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_5_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_5_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_6_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_6_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_6_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_6_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_6_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_6_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_LEVEL_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_LEVEL_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264PocType(const StdVideoH264PocType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_POC_TYPE_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_POC_TYPE_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_POC_TYPE_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_POC_TYPE_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_POC_TYPE_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_POC_TYPE_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_POC_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_POC_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264AspectRatioIdc(const StdVideoH264AspectRatioIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_UNSPECIFIED:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_UNSPECIFIED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_SQUARE:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_SQUARE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_12_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_12_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_10_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_10_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_16_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_16_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_40_33:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_40_33", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_24_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_24_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_20_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_20_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_32_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_32_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_80_33:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_80_33", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_18_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_18_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_15_11:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_15_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_64_33:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_64_33", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_160_99:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_160_99", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_4_3:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_4_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_3_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_3_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_2_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_2_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_EXTENDED_SAR:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_EXTENDED_SAR", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_ASPECT_RATIO_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_ASPECT_RATIO_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264WeightedBipredIdc(const StdVideoH264WeightedBipredIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_DEFAULT:
            dump_enum<Format>(settings, "STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_DEFAULT", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_EXPLICIT:
            dump_enum<Format>(settings, "STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_EXPLICIT", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_IMPLICIT:
            dump_enum<Format>(settings, "STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_IMPLICIT", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264ModificationOfPicNumsIdc(const StdVideoH264ModificationOfPicNumsIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_SUBTRACT:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_SUBTRACT", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_ADD:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_ADD", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_LONG_TERM:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_LONG_TERM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_END:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_END", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264MemMgmtControlOp(const StdVideoH264MemMgmtControlOp object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_END:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_END", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_SHORT_TERM:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_SHORT_TERM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_LONG_TERM:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_LONG_TERM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_LONG_TERM:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_LONG_TERM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_SET_MAX_LONG_TERM_INDEX:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_SET_MAX_LONG_TERM_INDEX", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_ALL:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_ALL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_CURRENT_AS_LONG_TERM:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_CURRENT_AS_LONG_TERM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264CabacInitIdc(const StdVideoH264CabacInitIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_CABAC_INIT_IDC_0:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CABAC_INIT_IDC_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_CABAC_INIT_IDC_1:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CABAC_INIT_IDC_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_CABAC_INIT_IDC_2:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CABAC_INIT_IDC_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_CABAC_INIT_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_CABAC_INIT_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264DisableDeblockingFilterIdc(const StdVideoH264DisableDeblockingFilterIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_DISABLED:
            dump_enum<Format>(settings, "STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_DISABLED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_ENABLED:
            dump_enum<Format>(settings, "STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_ENABLED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_PARTIAL:
            dump_enum<Format>(settings, "STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_PARTIAL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264SliceType(const StdVideoH264SliceType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_SLICE_TYPE_P:
            dump_enum<Format>(settings, "STD_VIDEO_H264_SLICE_TYPE_P", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_SLICE_TYPE_B:
            dump_enum<Format>(settings, "STD_VIDEO_H264_SLICE_TYPE_B", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_SLICE_TYPE_I:
            dump_enum<Format>(settings, "STD_VIDEO_H264_SLICE_TYPE_I", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_SLICE_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_SLICE_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264PictureType(const StdVideoH264PictureType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_PICTURE_TYPE_P:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PICTURE_TYPE_P", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PICTURE_TYPE_B:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PICTURE_TYPE_B", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PICTURE_TYPE_I:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PICTURE_TYPE_I", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PICTURE_TYPE_IDR:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PICTURE_TYPE_IDR", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_PICTURE_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_PICTURE_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH264NonVclNaluType(const StdVideoH264NonVclNaluType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_SPS:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_SPS", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_PPS:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_PPS", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_AUD:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_AUD", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_PREFIX:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_PREFIX", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_SEQUENCE:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_SEQUENCE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_STREAM:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_STREAM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_PRECODED:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_PRECODED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H264_NON_VCL_NALU_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H264_NON_VCL_NALU_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoDecodeH264FieldOrderCount(const StdVideoDecodeH264FieldOrderCount object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_TOP:
            dump_enum<Format>(settings, "STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_TOP", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_BOTTOM:
            dump_enum<Format>(settings, "STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_BOTTOM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH265ChromaFormatIdc(const StdVideoH265ChromaFormatIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H265_CHROMA_FORMAT_IDC_MONOCHROME:
            dump_enum<Format>(settings, "STD_VIDEO_H265_CHROMA_FORMAT_IDC_MONOCHROME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_CHROMA_FORMAT_IDC_420:
            dump_enum<Format>(settings, "STD_VIDEO_H265_CHROMA_FORMAT_IDC_420", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_CHROMA_FORMAT_IDC_422:
            dump_enum<Format>(settings, "STD_VIDEO_H265_CHROMA_FORMAT_IDC_422", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_CHROMA_FORMAT_IDC_444:
            dump_enum<Format>(settings, "STD_VIDEO_H265_CHROMA_FORMAT_IDC_444", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_CHROMA_FORMAT_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H265_CHROMA_FORMAT_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH265ProfileIdc(const StdVideoH265ProfileIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H265_PROFILE_IDC_MAIN:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PROFILE_IDC_MAIN", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PROFILE_IDC_MAIN_10:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PROFILE_IDC_MAIN_10", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PROFILE_IDC_MAIN_STILL_PICTURE:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PROFILE_IDC_MAIN_STILL_PICTURE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PROFILE_IDC_FORMAT_RANGE_EXTENSIONS:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PROFILE_IDC_FORMAT_RANGE_EXTENSIONS", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PROFILE_IDC_SCC_EXTENSIONS:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PROFILE_IDC_SCC_EXTENSIONS", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PROFILE_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PROFILE_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH265LevelIdc(const StdVideoH265LevelIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H265_LEVEL_IDC_1_0:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_1_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_2_0:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_2_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_2_1:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_2_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_3_0:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_3_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_3_1:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_3_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_4_0:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_4_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_4_1:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_4_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_5_0:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_5_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_5_1:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_5_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_5_2:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_5_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_6_0:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_6_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_6_1:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_6_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_6_2:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_6_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_LEVEL_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H265_LEVEL_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH265SliceType(const StdVideoH265SliceType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H265_SLICE_TYPE_B:
            dump_enum<Format>(settings, "STD_VIDEO_H265_SLICE_TYPE_B", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_SLICE_TYPE_P:
            dump_enum<Format>(settings, "STD_VIDEO_H265_SLICE_TYPE_P", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_SLICE_TYPE_I:
            dump_enum<Format>(settings, "STD_VIDEO_H265_SLICE_TYPE_I", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_SLICE_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H265_SLICE_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH265PictureType(const StdVideoH265PictureType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H265_PICTURE_TYPE_P:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PICTURE_TYPE_P", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PICTURE_TYPE_B:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PICTURE_TYPE_B", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PICTURE_TYPE_I:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PICTURE_TYPE_I", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PICTURE_TYPE_IDR:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PICTURE_TYPE_IDR", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_PICTURE_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H265_PICTURE_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoH265AspectRatioIdc(const StdVideoH265AspectRatioIdc object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_UNSPECIFIED:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_UNSPECIFIED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_SQUARE:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_SQUARE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_12_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_12_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_10_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_10_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_16_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_16_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_40_33:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_40_33", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_24_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_24_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_20_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_20_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_32_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_32_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_80_33:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_80_33", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_18_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_18_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_15_11:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_15_11", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_64_33:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_64_33", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_160_99:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_160_99", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_4_3:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_4_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_3_2:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_3_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_2_1:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_2_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_EXTENDED_SAR:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_EXTENDED_SAR", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_H265_ASPECT_RATIO_IDC_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_H265_ASPECT_RATIO_IDC_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1Profile(const StdVideoAV1Profile object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_PROFILE_MAIN:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_PROFILE_MAIN", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_PROFILE_HIGH:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_PROFILE_HIGH", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_PROFILE_PROFESSIONAL:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_PROFILE_PROFESSIONAL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_PROFILE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_PROFILE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1Level(const StdVideoAV1Level object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_LEVEL_2_0:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_2_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_2_1:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_2_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_2_2:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_2_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_2_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_2_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_3_0:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_3_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_3_1:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_3_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_3_2:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_3_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_3_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_3_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_4_0:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_4_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_4_1:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_4_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_4_2:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_4_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_4_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_4_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_5_0:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_5_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_5_1:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_5_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_5_2:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_5_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_5_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_5_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_6_0:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_6_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_6_1:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_6_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_6_2:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_6_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_6_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_6_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_7_0:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_7_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_7_1:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_7_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_7_2:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_7_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_7_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_7_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_LEVEL_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_LEVEL_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1FrameType(const StdVideoAV1FrameType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_FRAME_TYPE_KEY:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_TYPE_KEY", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_TYPE_INTER:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_TYPE_INTER", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_TYPE_INTRA_ONLY:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_TYPE_INTRA_ONLY", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_TYPE_SWITCH:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_TYPE_SWITCH", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1ReferenceName(const StdVideoAV1ReferenceName object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_REFERENCE_NAME_INTRA_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_INTRA_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_LAST_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_LAST_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_LAST2_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_LAST2_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_LAST3_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_LAST3_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_GOLDEN_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_GOLDEN_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_BWDREF_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_BWDREF_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_ALTREF2_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_ALTREF2_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_ALTREF_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_ALTREF_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_REFERENCE_NAME_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_REFERENCE_NAME_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1InterpolationFilter(const StdVideoAV1InterpolationFilter object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_INTERPOLATION_FILTER_BILINEAR:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_INTERPOLATION_FILTER_BILINEAR", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_INTERPOLATION_FILTER_SWITCHABLE:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_INTERPOLATION_FILTER_SWITCHABLE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_INTERPOLATION_FILTER_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_INTERPOLATION_FILTER_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1TxMode(const StdVideoAV1TxMode object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_TX_MODE_ONLY_4X4:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TX_MODE_ONLY_4X4", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TX_MODE_LARGEST:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TX_MODE_LARGEST", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TX_MODE_SELECT:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TX_MODE_SELECT", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TX_MODE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TX_MODE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1FrameRestorationType(const StdVideoAV1FrameRestorationType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_NONE:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_NONE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_WIENER:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_WIENER", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SGRPROJ:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SGRPROJ", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SWITCHABLE:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_SWITCHABLE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_FRAME_RESTORATION_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1ColorPrimaries(const StdVideoAV1ColorPrimaries object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_COLOR_PRIMARIES_BT_709:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_BT_709", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_UNSPECIFIED:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_UNSPECIFIED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_M:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_M", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_B_G:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_BT_470_B_G", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_BT_601:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_BT_601", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_240:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_240", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_GENERIC_FILM:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_GENERIC_FILM", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_BT_2020:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_BT_2020", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_XYZ:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_XYZ", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_431:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_431", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_432:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_SMPTE_432", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_EBU_3213:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_EBU_3213", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_COLOR_PRIMARIES_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_COLOR_PRIMARIES_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1TransferCharacteristics(const StdVideoAV1TransferCharacteristics object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_0:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_709:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_709", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_UNSPECIFIED:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_UNSPECIFIED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_RESERVED_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_M:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_M", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_B_G:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_470_B_G", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_601:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_601", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_240:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_240", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LINEAR:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LINEAR", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100_SQRT10:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_LOG_100_SQRT10", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_IEC_61966:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_IEC_61966", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_1361:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_1361", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SRGB:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SRGB", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_10_BIT:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_10_BIT", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_12_BIT:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_BT_2020_12_BIT", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_2084:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_2084", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_428:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_SMPTE_428", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_HLG:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_HLG", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_TRANSFER_CHARACTERISTICS_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1MatrixCoefficients(const StdVideoAV1MatrixCoefficients object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_IDENTITY:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_IDENTITY", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_709:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_709", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_UNSPECIFIED:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_UNSPECIFIED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_RESERVED_3:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_RESERVED_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_FCC:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_FCC", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_470_B_G:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_470_B_G", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_601:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_601", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_240:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_240", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_YCGCO:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_YCGCO", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_NCL:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_NCL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_CL:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_BT_2020_CL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_2085:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_SMPTE_2085", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_NCL:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_NCL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_CL:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_CHROMAT_CL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_ICTCP:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_ICTCP", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_MATRIX_COEFFICIENTS_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_MATRIX_COEFFICIENTS_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoAV1ChromaSamplePosition(const StdVideoAV1ChromaSamplePosition object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_UNKNOWN:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_UNKNOWN", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_VERTICAL:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_VERTICAL", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_COLOCATED:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_COLOCATED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_RESERVED:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_RESERVED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_AV1_CHROMA_SAMPLE_POSITION_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoVP9Profile(const StdVideoVP9Profile object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_VP9_PROFILE_0:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_PROFILE_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_PROFILE_1:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_PROFILE_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_PROFILE_2:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_PROFILE_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_PROFILE_3:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_PROFILE_3", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_PROFILE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_PROFILE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoVP9Level(const StdVideoVP9Level object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_VP9_LEVEL_1_0:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_1_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_1_1:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_1_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_2_0:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_2_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_2_1:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_2_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_3_0:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_3_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_3_1:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_3_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_4_0:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_4_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_4_1:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_4_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_5_0:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_5_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_5_1:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_5_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_5_2:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_5_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_6_0:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_6_0", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_6_1:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_6_1", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_6_2:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_6_2", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_LEVEL_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_LEVEL_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoVP9FrameType(const StdVideoVP9FrameType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_VP9_FRAME_TYPE_KEY:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_FRAME_TYPE_KEY", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_FRAME_TYPE_NON_KEY:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_FRAME_TYPE_NON_KEY", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_FRAME_TYPE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_FRAME_TYPE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoVP9ReferenceName(const StdVideoVP9ReferenceName object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_VP9_REFERENCE_NAME_INTRA_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_REFERENCE_NAME_INTRA_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_REFERENCE_NAME_LAST_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_REFERENCE_NAME_LAST_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_REFERENCE_NAME_GOLDEN_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_REFERENCE_NAME_GOLDEN_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_REFERENCE_NAME_ALTREF_FRAME:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_REFERENCE_NAME_ALTREF_FRAME", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_REFERENCE_NAME_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_REFERENCE_NAME_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoVP9InterpolationFilter(const StdVideoVP9InterpolationFilter object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_VP9_INTERPOLATION_FILTER_EIGHTTAP:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_INTERPOLATION_FILTER_EIGHTTAP", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_INTERPOLATION_FILTER_EIGHTTAP_SHARP:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_INTERPOLATION_FILTER_EIGHTTAP_SHARP", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_INTERPOLATION_FILTER_BILINEAR:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_INTERPOLATION_FILTER_BILINEAR", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_INTERPOLATION_FILTER_SWITCHABLE:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_INTERPOLATION_FILTER_SWITCHABLE", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_INTERPOLATION_FILTER_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_INTERPOLATION_FILTER_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_StdVideoVP9ColorSpace(const StdVideoVP9ColorSpace object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case STD_VIDEO_VP9_COLOR_SPACE_UNKNOWN:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_UNKNOWN", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_BT_601:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_BT_601", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_BT_709:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_BT_709", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_SMPTE_170:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_SMPTE_170", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_SMPTE_240:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_SMPTE_240", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_BT_2020:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_BT_2020", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_RESERVED:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_RESERVED", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_RGB:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_RGB", static_cast<uint32_t>(object));
            break;
        case STD_VIDEO_VP9_COLOR_SPACE_INVALID:
            dump_enum<Format>(settings, "STD_VIDEO_VP9_COLOR_SPACE_INVALID", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

//=========================== Enum Implementations ==========================//

template <ApiDumpFormat Format>
void dump_return_value_VkResult(const VkResult& object, const ApiDumpSettings& settings) {
    switch ((int64_t)object) {
        case VK_SUCCESS:
            dump_enum<Format>(settings, "VK_SUCCESS", static_cast<int32_t>(object));
            break;
        case VK_NOT_READY:
            dump_enum<Format>(settings, "VK_NOT_READY", static_cast<int32_t>(object));
            break;
        case VK_TIMEOUT:
            dump_enum<Format>(settings, "VK_TIMEOUT", static_cast<int32_t>(object));
            break;
        case VK_EVENT_SET:
            dump_enum<Format>(settings, "VK_EVENT_SET", static_cast<int32_t>(object));
            break;
        case VK_EVENT_RESET:
            dump_enum<Format>(settings, "VK_EVENT_RESET", static_cast<int32_t>(object));
            break;
        case VK_INCOMPLETE:
            dump_enum<Format>(settings, "VK_INCOMPLETE", static_cast<int32_t>(object));
            break;
        case VK_ERROR_OUT_OF_HOST_MEMORY:
            dump_enum<Format>(settings, "VK_ERROR_OUT_OF_HOST_MEMORY", static_cast<int32_t>(object));
            break;
        case VK_ERROR_OUT_OF_DEVICE_MEMORY:
            dump_enum<Format>(settings, "VK_ERROR_OUT_OF_DEVICE_MEMORY", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INITIALIZATION_FAILED:
            dump_enum<Format>(settings, "VK_ERROR_INITIALIZATION_FAILED", static_cast<int32_t>(object));
            break;
        case VK_ERROR_DEVICE_LOST:
            dump_enum<Format>(settings, "VK_ERROR_DEVICE_LOST", static_cast<int32_t>(object));
            break;
        case VK_ERROR_MEMORY_MAP_FAILED:
            dump_enum<Format>(settings, "VK_ERROR_MEMORY_MAP_FAILED", static_cast<int32_t>(object));
            break;
        case VK_ERROR_LAYER_NOT_PRESENT:
            dump_enum<Format>(settings, "VK_ERROR_LAYER_NOT_PRESENT", static_cast<int32_t>(object));
            break;
        case VK_ERROR_EXTENSION_NOT_PRESENT:
            dump_enum<Format>(settings, "VK_ERROR_EXTENSION_NOT_PRESENT", static_cast<int32_t>(object));
            break;
        case VK_ERROR_FEATURE_NOT_PRESENT:
            dump_enum<Format>(settings, "VK_ERROR_FEATURE_NOT_PRESENT", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INCOMPATIBLE_DRIVER:
            dump_enum<Format>(settings, "VK_ERROR_INCOMPATIBLE_DRIVER", static_cast<int32_t>(object));
            break;
        case VK_ERROR_TOO_MANY_OBJECTS:
            dump_enum<Format>(settings, "VK_ERROR_TOO_MANY_OBJECTS", static_cast<int32_t>(object));
            break;
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            dump_enum<Format>(settings, "VK_ERROR_FORMAT_NOT_SUPPORTED", static_cast<int32_t>(object));
            break;
        case VK_ERROR_FRAGMENTED_POOL:
            dump_enum<Format>(settings, "VK_ERROR_FRAGMENTED_POOL", static_cast<int32_t>(object));
            break;
        case VK_ERROR_UNKNOWN:
            dump_enum<Format>(settings, "VK_ERROR_UNKNOWN", static_cast<int32_t>(object));
            break;
        case VK_ERROR_VALIDATION_FAILED:
            dump_enum<Format>(settings, "VK_ERROR_VALIDATION_FAILED", static_cast<int32_t>(object));
            break;
        case VK_ERROR_OUT_OF_POOL_MEMORY:
            dump_enum<Format>(settings, "VK_ERROR_OUT_OF_POOL_MEMORY", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INVALID_EXTERNAL_HANDLE:
            dump_enum<Format>(settings, "VK_ERROR_INVALID_EXTERNAL_HANDLE", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS:
            dump_enum<Format>(settings, "VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS", static_cast<int32_t>(object));
            break;
        case VK_ERROR_FRAGMENTATION:
            dump_enum<Format>(settings, "VK_ERROR_FRAGMENTATION", static_cast<int32_t>(object));
            break;
        case VK_PIPELINE_COMPILE_REQUIRED:
            dump_enum<Format>(settings, "VK_PIPELINE_COMPILE_REQUIRED", static_cast<int32_t>(object));
            break;
        case VK_ERROR_NOT_PERMITTED:
            dump_enum<Format>(settings, "VK_ERROR_NOT_PERMITTED", static_cast<int32_t>(object));
            break;
        case VK_ERROR_SURFACE_LOST_KHR:
            dump_enum<Format>(settings, "VK_ERROR_SURFACE_LOST_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_NATIVE_WINDOW_IN_USE_KHR:
            dump_enum<Format>(settings, "VK_ERROR_NATIVE_WINDOW_IN_USE_KHR", static_cast<int32_t>(object));
            break;
        case VK_SUBOPTIMAL_KHR:
            dump_enum<Format>(settings, "VK_SUBOPTIMAL_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_OUT_OF_DATE_KHR:
            dump_enum<Format>(settings, "VK_ERROR_OUT_OF_DATE_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INCOMPATIBLE_DISPLAY_KHR:
            dump_enum<Format>(settings, "VK_ERROR_INCOMPATIBLE_DISPLAY_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INVALID_SHADER_NV:
            dump_enum<Format>(settings, "VK_ERROR_INVALID_SHADER_NV", static_cast<int32_t>(object));
            break;
        case VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR:
            dump_enum<Format>(settings, "VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR:
            dump_enum<Format>(settings, "VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR:
            dump_enum<Format>(settings, "VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR:
            dump_enum<Format>(settings, "VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR:
            dump_enum<Format>(settings, "VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR:
            dump_enum<Format>(settings, "VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT:
            dump_enum<Format>(settings, "VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT", static_cast<int32_t>(object));
            break;
        case VK_ERROR_PRESENT_TIMING_QUEUE_FULL_EXT:
            dump_enum<Format>(settings, "VK_ERROR_PRESENT_TIMING_QUEUE_FULL_EXT", static_cast<int32_t>(object));
            break;
        case VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT:
            dump_enum<Format>(settings, "VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT", static_cast<int32_t>(object));
            break;
        case VK_THREAD_IDLE_KHR:
            dump_enum<Format>(settings, "VK_THREAD_IDLE_KHR", static_cast<int32_t>(object));
            break;
        case VK_THREAD_DONE_KHR:
            dump_enum<Format>(settings, "VK_THREAD_DONE_KHR", static_cast<int32_t>(object));
            break;
        case VK_OPERATION_DEFERRED_KHR:
            dump_enum<Format>(settings, "VK_OPERATION_DEFERRED_KHR", static_cast<int32_t>(object));
            break;
        case VK_OPERATION_NOT_DEFERRED_KHR:
            dump_enum<Format>(settings, "VK_OPERATION_NOT_DEFERRED_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR:
            dump_enum<Format>(settings, "VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_COMPRESSION_EXHAUSTED_EXT:
            dump_enum<Format>(settings, "VK_ERROR_COMPRESSION_EXHAUSTED_EXT", static_cast<int32_t>(object));
            break;
        case VK_INCOMPATIBLE_SHADER_BINARY_EXT:
            dump_enum<Format>(settings, "VK_INCOMPATIBLE_SHADER_BINARY_EXT", static_cast<int32_t>(object));
            break;
        case VK_PIPELINE_BINARY_MISSING_KHR:
            dump_enum<Format>(settings, "VK_PIPELINE_BINARY_MISSING_KHR", static_cast<int32_t>(object));
            break;
        case VK_ERROR_NOT_ENOUGH_SPACE_KHR:
            dump_enum<Format>(settings, "VK_ERROR_NOT_ENOUGH_SPACE_KHR", static_cast<int32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<int32_t>(object));
    }
}
template <ApiDumpFormat Format>
void dump_VkResult(const VkResult object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_return_value_VkResult<Format>(object, settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkStructureType(const VkStructureType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_STRUCTURE_TYPE_APPLICATION_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_APPLICATION_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBMIT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBMIT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_SPARSE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_SPARSE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FENCE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FENCE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EVENT_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EVENT_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_BARRIER", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_END_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBPASS_END_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_BARRIER_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEPENDENCY_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEPENDENCY_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBMIT_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBMIT_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_COPY_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_COPY_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_COPY_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_COPY_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_BLIT_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_BLIT_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_MAP_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_MAP_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_AREA_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_AREA_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_HDR_METADATA_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_HDR_METADATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_STRUCTURE_TYPE_TEXEL_BUFFER_DESCRIPTOR_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TEXEL_BUFFER_DESCRIPTOR_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_DESCRIPTOR_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_DESCRIPTOR_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RESOURCE_DESCRIPTOR_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RESOURCE_DESCRIPTOR_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_HEAP_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_HEAP_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PUSH_DATA_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PUSH_DATA_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_AND_BINDING_MAPPING_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_AND_BINDING_MAPPING_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SHADER_DESCRIPTOR_SET_AND_BINDING_MAPPING_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SHADER_DESCRIPTOR_SET_AND_BINDING_MAPPING_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DATA_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DATA_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_HEAP_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_HEAP_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_HEAP_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_HEAP_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_DESCRIPTOR_HEAP_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_DESCRIPTOR_HEAP_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_INDEX_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_INDEX_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_PUSH_DATA_TOKEN_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_PUSH_DATA_TOKEN_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBSAMPLED_IMAGE_FORMAT_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBSAMPLED_IMAGE_FORMAT_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_HEAP_TENSOR_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_HEAP_TENSOR_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_BFLOAT16_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_BFLOAT16_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GEOMETRY_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GEOMETRY_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_TIMING_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_TIMING_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_TIMING_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_TIMING_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_TIME_DOMAIN_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_TIME_DOMAIN_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_TIMINGS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_TIMINGS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_TIMING_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_TIMING_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PAST_PRESENTATION_TIMING_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PAST_PRESENTATION_TIMING_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PAST_PRESENTATION_TIMING_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PAST_PRESENTATION_TIMING_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PAST_PRESENTATION_TIMING_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PAST_PRESENTATION_TIMING_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_TIMING_SURFACE_CAPABILITIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_TIMING_SURFACE_CAPABILITIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_CALIBRATED_TIMESTAMP_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_CALIBRATED_TIMESTAMP_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_MAP_PLACED_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_MAP_PLACED_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_3D_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_3D_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_ID_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_ID_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_GET_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_GET_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_FEEDBACK_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_FEEDBACK_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_STRUCTURE_TYPE_CUDA_MODULE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CUDA_MODULE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CUDA_FUNCTION_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CUDA_FUNCTION_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CUDA_LAUNCH_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CUDA_LAUNCH_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUDA_KERNEL_LAUNCH_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_PROPERTIES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_SHADING_PROPERTIES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_TILE_SHADING_CREATE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_TILE_SHADING_CREATE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PER_TILE_BEGIN_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PER_TILE_BEGIN_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PER_TILE_END_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PER_TILE_END_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPATCH_TILE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPATCH_TILE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_METAL_BUFFER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_METAL_TEXTURE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_METAL_IO_SURFACE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_METAL_SHARED_EVENT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_PROPERTIES_IDENTIFIER_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_PROPERTIES_IDENTIFIER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_UNTYPED_POINTERS_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_UNTYPED_POINTERS_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_RGB_CONVERSION_FEATURES_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_RGB_CONVERSION_FEATURES_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_RGB_CONVERSION_CAPABILITIES_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_RGB_CONVERSION_CAPABILITIES_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_PROFILE_RGB_CONVERSION_INFO_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_PROFILE_RGB_CONVERSION_INFO_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_RGB_CONVERSION_CREATE_INFO_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_RGB_CONVERSION_CREATE_INFO_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISPLACEMENT_MICROMAP_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_USAGE_OHOS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_NATIVE_BUFFER_USAGE_OHOS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_PROPERTIES_OHOS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_NATIVE_BUFFER_PROPERTIES_OHOS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_FORMAT_PROPERTIES_OHOS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_NATIVE_BUFFER_FORMAT_PROPERTIES_OHOS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_NATIVE_BUFFER_INFO_OHOS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_NATIVE_BUFFER_INFO_OHOS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_GET_NATIVE_BUFFER_INFO_OHOS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_GET_NATIVE_BUFFER_INFO_OHOS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_OHOS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_OHOS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_VIEW_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_VIEW_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_TENSOR_MEMORY_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_TENSOR_MEMORY_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_TENSOR_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_TENSOR_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TENSOR_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TENSOR_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_FORMAT_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_FORMAT_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_DESCRIPTION_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_DESCRIPTION_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_MEMORY_REQUIREMENTS_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_MEMORY_REQUIREMENTS_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_MEMORY_BARRIER_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_MEMORY_BARRIER_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TENSOR_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TENSOR_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_TENSOR_MEMORY_REQUIREMENTS_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_TENSOR_MEMORY_REQUIREMENTS_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_TENSOR_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_TENSOR_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_COPY_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_COPY_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_DEPENDENCY_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_DEPENDENCY_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_TENSOR_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_TENSOR_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_TENSOR_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_TENSOR_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_TENSOR_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_TENSOR_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_TENSOR_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_TENSOR_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_TENSOR_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_TENSOR_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_TENSOR_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_TENSOR_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DESCRIPTOR_GET_TENSOR_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DESCRIPTOR_GET_TENSOR_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_CAPTURE_DESCRIPTOR_DATA_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_CAPTURE_DESCRIPTOR_DATA_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TENSOR_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TENSOR_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_FRAME_BOUNDARY_TENSORS_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_FRAME_BOUNDARY_TENSORS_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_FEATURES_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FORMAT_RESOLVE_PROPERTIES_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DENSE_GEOMETRY_FORMAT_FEATURES_AMDX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DENSE_GEOMETRY_FORMAT_FEATURES_AMDX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DENSE_GEOMETRY_FORMAT_TRIANGLES_DATA_AMDX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DENSE_GEOMETRY_FORMAT_TRIANGLES_DATA_AMDX", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_ID_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_ID_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_ID_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_ID_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_2_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_2_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_WAIT_2_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_WAIT_2_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_2_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_2_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PRESENT_WAIT_2_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PRESENT_WAIT_2_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_BINARY_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_BINARY_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_BINARY_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_BINARY_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_BINARY_KEY_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_BINARY_KEY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RELEASE_CAPTURED_PIPELINE_DATA_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RELEASE_CAPTURED_PIPELINE_DATA_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_BINARY_DATA_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_BINARY_DATA_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_BINARY_HANDLES_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_BINARY_HANDLES_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INTERNALLY_SYNCHRONIZED_QUEUES_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INTERNALLY_SYNCHRONIZED_QUEUES_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SET_LATENCY_MARKER_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SET_LATENCY_MARKER_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_OUT_OF_BAND_QUEUE_TYPE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_OUT_OF_BAND_QUEUE_TYPE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_RESOURCE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_RESOURCE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_MEMORY_REQUIREMENTS_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_MEMORY_REQUIREMENTS_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_DATA_GRAPH_PIPELINE_SESSION_MEMORY_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_DATA_GRAPH_PIPELINE_SESSION_MEMORY_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DATA_GRAPH_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DATA_GRAPH_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SHADER_MODULE_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SHADER_MODULE_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_PROPERTY_QUERY_RESULT_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_PROPERTY_QUERY_RESULT_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_COMPILER_CONTROL_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_COMPILER_CONTROL_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENTS_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENTS_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENT_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENT_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_IDENTIFIER_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_IDENTIFIER_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_DISPATCH_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_DISPATCH_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PROCESSING_ENGINE_CREATE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PROCESSING_ENGINE_CREATE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_DATA_GRAPH_PROCESSING_ENGINE_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_DATA_GRAPH_PROCESSING_ENGINE_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_DATA_GRAPH_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_DATA_GRAPH_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_QUEUE_FAMILY_DATA_GRAPH_PROCESSING_ENGINE_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_QUEUE_FAMILY_DATA_GRAPH_PROCESSING_ENGINE_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_TENSOR_SEMI_STRUCTURED_SPARSITY_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_TENSOR_SEMI_STRUCTURED_SPARSITY_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PICTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PICTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_DPB_SLOT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_DPB_SLOT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PICTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PICTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_DPB_SLOT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_DPB_SLOT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_LAYER_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_LAYER_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUALITY_LEVEL_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUALITY_LEVEL_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_GOP_REMAINING_FRAME_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_GOP_REMAINING_FRAME_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_DECODE_VP9_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_DECODE_VP9_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_PICTURE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_PICTURE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_PROFILE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_VP9_PROFILE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_INLINE_QUERY_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_INLINE_QUERY_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFIED_IMAGE_LAYOUTS_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFIED_IMAGE_LAYOUTS_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_ATTACHMENT_FEEDBACK_LOOP_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_ATTACHMENT_FEEDBACK_LOOP_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SCREEN_BUFFER_PROPERTIES_QNX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SCREEN_BUFFER_PROPERTIES_QNX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SCREEN_BUFFER_FORMAT_PROPERTIES_QNX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SCREEN_BUFFER_FORMAT_PROPERTIES_QNX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_SCREEN_BUFFER_INFO_QNX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_SCREEN_BUFFER_INFO_QNX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCREEN_BUFFER_FEATURES_QNX:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_SCREEN_BUFFER_FEATURES_QNX", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SET_DESCRIPTOR_BUFFER_OFFSETS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SET_DESCRIPTOR_BUFFER_OFFSETS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_PROPERTIES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_MEMORY_HEAP_PROPERTIES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TILE_MEMORY_REQUIREMENTS_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TILE_MEMORY_REQUIREMENTS_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TILE_MEMORY_BIND_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TILE_MEMORY_BIND_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_TILE_MEMORY_SIZE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_TILE_MEMORY_SIZE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_MEMORY_INDIRECT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_MEMORY_INDIRECT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INDIRECT_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INDIRECT_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DECOMPRESS_MEMORY_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DECOMPRESS_MEMORY_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_INTRA_REFRESH_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_INTRA_REFRESH_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_INTRA_REFRESH_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_INTRA_REFRESH_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_INTRA_REFRESH_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_INTRA_REFRESH_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_REFERENCE_INTRA_REFRESH_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_REFERENCE_INTRA_REFRESH_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_INTRA_REFRESH_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_INTRA_REFRESH_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_FORMAT_QUANTIZATION_MAP_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_FORMAT_QUANTIZATION_MAP_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_SESSION_PARAMETERS_CREATE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_SESSION_PARAMETERS_CREATE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUANTIZATION_MAP_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUANTIZATION_MAP_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUANTIZATION_MAP_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUANTIZATION_MAP_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_FORMAT_H265_QUANTIZATION_MAP_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_FORMAT_H265_QUANTIZATION_MAP_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUANTIZATION_MAP_CAPABILITIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUANTIZATION_MAP_CAPABILITIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_FORMAT_AV1_QUANTIZATION_MAP_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_FORMAT_AV1_QUANTIZATION_MAP_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DEVICE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DEVICE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DATA_PARAMS_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DATA_PARAMS_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_COMPUTE_QUEUE_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_COMPUTE_QUEUE_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_LIST_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_LIST_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_VULKAN_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_VULKAN_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT8_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT8_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_CLUSTERS_BOTTOM_LEVEL_INPUT_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_CLUSTERS_BOTTOM_LEVEL_INPUT_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_TRIANGLE_CLUSTER_INPUT_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_TRIANGLE_CLUSTER_INPUT_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_MOVE_OBJECTS_INPUT_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_MOVE_OBJECTS_INPUT_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_INPUT_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_INPUT_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_COMMANDS_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_COMMANDS_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CLUSTER_ACCELERATION_STRUCTURE_CREATE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CLUSTER_ACCELERATION_STRUCTURE_CREATE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_PARTITIONED_ACCELERATION_STRUCTURE_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_PARTITIONED_ACCELERATION_STRUCTURE_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCES_INPUT_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCES_INPUT_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_FLAGS_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_FLAGS_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_PIPELINE_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_PIPELINE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_SHADER_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_SHADER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_PIPELINE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_PIPELINE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_LAYOUT_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_LAYOUT_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_PIPELINE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_PIPELINE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_SHADER_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_GENERATED_COMMANDS_SHADER_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_ACCESS_FLAGS_3_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_BARRIER_ACCESS_FLAGS_3_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_PROPERTIES_MESA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_PROPERTIES_MESA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FMA_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FMA_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PUSH_CONSTANT_BANK_INFO_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PUSH_CONSTANT_BANK_INFO_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_CONSTANT_BANK_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_CONSTANT_BANK_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_CONSTANT_BANK_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_CONSTANT_BANK_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLAMP_CONTROL_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLAMP_CONTROL_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_9_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_9_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_9_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_9_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_OWNERSHIP_TRANSFER_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_QUEUE_FAMILY_OWNERSHIP_TRANSFER_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_INLINE_SESSION_PARAMETERS_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_INLINE_SESSION_PARAMETERS_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_INLINE_SESSION_PARAMETERS_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_INLINE_SESSION_PARAMETERS_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_INLINE_SESSION_PARAMETERS_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_INLINE_SESSION_PARAMETERS_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_SURFACE_CREATE_INFO_OHOS:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SURFACE_CREATE_INFO_OHOS", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_HDR_VIVID_DYNAMIC_METADATA_HUAWEI:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_HDR_VIVID_DYNAMIC_METADATA_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_PROPERTIES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_PROPERTIES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_IMPORT_MEMORY_METAL_HANDLE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_IMPORT_MEMORY_METAL_HANDLE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_METAL_HANDLE_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_METAL_HANDLE_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_MEMORY_GET_METAL_HANDLE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_MEMORY_GET_METAL_HANDLE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_COUNTERS_BY_REGION_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_COUNTERS_BY_REGION_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_COUNTERS_BY_REGION_PROPERTIES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_COUNTERS_BY_REGION_PROPERTIES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_PERFORMANCE_COUNTERS_BY_REGION_BEGIN_INFO_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_PERFORMANCE_COUNTERS_BY_REGION_BEGIN_INFO_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FORMAT_PACK_FEATURES_ARM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FORMAT_PACK_FEATURES_ARM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_LAYERED_FEATURES_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_LAYERED_FEATURES_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_LAYERED_PROPERTIES_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_LAYERED_PROPERTIES_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_DENSITY_MAP_LAYERED_CREATE_INFO_VALVE:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_DENSITY_MAP_LAYERED_CREATE_INFO_VALVE", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_STRUCTURE_TYPE_SET_PRESENT_CONFIG_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_SET_PRESENT_CONFIG_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_METERING_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_METERING_FEATURES_NV", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_DEVICE_MEMORY_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_DEVICE_MEMORY_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_64_BIT_INDEXING_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_64_BIT_INDEXING_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_RESOLVE_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_RESOLVE_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_BEGIN_CUSTOM_RESOLVE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_BEGIN_CUSTOM_RESOLVE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_CUSTOM_RESOLVE_CREATE_INFO_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_CUSTOM_RESOLVE_CREATE_INFO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DATA_GRAPH_MODEL_FEATURES_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DATA_GRAPH_MODEL_FEATURES_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_BUILTIN_MODEL_CREATE_INFO_QCOM:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_BUILTIN_MODEL_CREATE_INFO_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_10_FEATURES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_10_FEATURES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_10_PROPERTIES_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_10_PROPERTIES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_FLAGS_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_FLAGS_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RENDERING_END_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RENDERING_END_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_RESOLVE_IMAGE_MODE_INFO_KHR:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_RESOLVE_IMAGE_MODE_INFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_LONG_VECTOR_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_LONG_VECTOR_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_LONG_VECTOR_PROPERTIES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_LONG_VECTOR_PROPERTIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CACHE_INCREMENTAL_MODE_FEATURES_SEC:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CACHE_INCREMENTAL_MODE_FEATURES_SEC", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_UNIFORM_BUFFER_UNSIZED_ARRAY_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_UNIFORM_BUFFER_UNSIZED_ARRAY_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_COMPUTE_OCCUPANCY_PRIORITY_PARAMETERS_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_COMPUTE_OCCUPANCY_PRIORITY_PARAMETERS_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_OCCUPANCY_PRIORITY_FEATURES_NV:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_OCCUPANCY_PRIORITY_FEATURES_NV", static_cast<uint32_t>(object));
            break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_PARTITIONED_FEATURES_EXT:
            dump_enum<Format>(settings, "VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_PARTITIONED_FEATURES_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkImageLayout(const VkImageLayout object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_IMAGE_LAYOUT_UNDEFINED:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_UNDEFINED", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_GENERAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_GENERAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_PREINITIALIZED:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_PREINITIALIZED", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_PRESENT_SRC_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_TENSOR_ALIASING_ARM:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_TENSOR_ALIASING_ARM", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_VIDEO_ENCODE_QUANTIZATION_MAP_KHR:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_VIDEO_ENCODE_QUANTIZATION_MAP_KHR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT:
            dump_enum<Format>(settings, "VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkObjectType(const VkObjectType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_OBJECT_TYPE_UNKNOWN:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_UNKNOWN", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_INSTANCE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_INSTANCE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_PHYSICAL_DEVICE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_PHYSICAL_DEVICE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DEVICE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DEVICE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_QUEUE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_QUEUE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_SEMAPHORE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_SEMAPHORE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_COMMAND_BUFFER:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_COMMAND_BUFFER", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_FENCE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_FENCE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DEVICE_MEMORY:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DEVICE_MEMORY", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_BUFFER:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_BUFFER", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_IMAGE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_IMAGE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_EVENT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_EVENT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_QUERY_POOL:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_QUERY_POOL", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_BUFFER_VIEW:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_BUFFER_VIEW", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_IMAGE_VIEW:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_IMAGE_VIEW", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_SHADER_MODULE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_SHADER_MODULE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_PIPELINE_CACHE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_PIPELINE_CACHE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_PIPELINE_LAYOUT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_PIPELINE_LAYOUT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_RENDER_PASS:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_RENDER_PASS", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_PIPELINE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_PIPELINE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_SAMPLER:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_SAMPLER", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DESCRIPTOR_POOL:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DESCRIPTOR_POOL", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DESCRIPTOR_SET:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DESCRIPTOR_SET", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_FRAMEBUFFER:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_FRAMEBUFFER", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_COMMAND_POOL:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_COMMAND_POOL", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_PRIVATE_DATA_SLOT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_PRIVATE_DATA_SLOT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_SURFACE_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_SURFACE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_SWAPCHAIN_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_SWAPCHAIN_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DISPLAY_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DISPLAY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DISPLAY_MODE_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DISPLAY_MODE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_VIDEO_SESSION_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_VIDEO_SESSION_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_CU_MODULE_NVX:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_CU_MODULE_NVX", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_CU_FUNCTION_NVX:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_CU_FUNCTION_NVX", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_VALIDATION_CACHE_EXT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_VALIDATION_CACHE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_OBJECT_TYPE_CUDA_MODULE_NV:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_CUDA_MODULE_NV", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_CUDA_FUNCTION_NV:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_CUDA_FUNCTION_NV", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_MICROMAP_EXT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_MICROMAP_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_TENSOR_ARM:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_TENSOR_ARM", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_TENSOR_VIEW_ARM:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_TENSOR_VIEW_ARM", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_SHADER_EXT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_SHADER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_PIPELINE_BINARY_KHR:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_PIPELINE_BINARY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_DATA_GRAPH_PIPELINE_SESSION_ARM:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_DATA_GRAPH_PIPELINE_SESSION_ARM", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_EXTERNAL_COMPUTE_QUEUE_NV:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_EXTERNAL_COMPUTE_QUEUE_NV", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_EXT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OBJECT_TYPE_INDIRECT_EXECUTION_SET_EXT:
            dump_enum<Format>(settings, "VK_OBJECT_TYPE_INDIRECT_EXECUTION_SET_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkVendorId(const VkVendorId object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VENDOR_ID_KHRONOS:
            dump_enum<Format>(settings, "VK_VENDOR_ID_KHRONOS", static_cast<uint32_t>(object));
            break;
        case VK_VENDOR_ID_VIV:
            dump_enum<Format>(settings, "VK_VENDOR_ID_VIV", static_cast<uint32_t>(object));
            break;
        case VK_VENDOR_ID_VSI:
            dump_enum<Format>(settings, "VK_VENDOR_ID_VSI", static_cast<uint32_t>(object));
            break;
        case VK_VENDOR_ID_KAZAN:
            dump_enum<Format>(settings, "VK_VENDOR_ID_KAZAN", static_cast<uint32_t>(object));
            break;
        case VK_VENDOR_ID_CODEPLAY:
            dump_enum<Format>(settings, "VK_VENDOR_ID_CODEPLAY", static_cast<uint32_t>(object));
            break;
        case VK_VENDOR_ID_MESA:
            dump_enum<Format>(settings, "VK_VENDOR_ID_MESA", static_cast<uint32_t>(object));
            break;
        case VK_VENDOR_ID_POCL:
            dump_enum<Format>(settings, "VK_VENDOR_ID_POCL", static_cast<uint32_t>(object));
            break;
        case VK_VENDOR_ID_MOBILEYE:
            dump_enum<Format>(settings, "VK_VENDOR_ID_MOBILEYE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSystemAllocationScope(const VkSystemAllocationScope object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SYSTEM_ALLOCATION_SCOPE_COMMAND:
            dump_enum<Format>(settings, "VK_SYSTEM_ALLOCATION_SCOPE_COMMAND", static_cast<uint32_t>(object));
            break;
        case VK_SYSTEM_ALLOCATION_SCOPE_OBJECT:
            dump_enum<Format>(settings, "VK_SYSTEM_ALLOCATION_SCOPE_OBJECT", static_cast<uint32_t>(object));
            break;
        case VK_SYSTEM_ALLOCATION_SCOPE_CACHE:
            dump_enum<Format>(settings, "VK_SYSTEM_ALLOCATION_SCOPE_CACHE", static_cast<uint32_t>(object));
            break;
        case VK_SYSTEM_ALLOCATION_SCOPE_DEVICE:
            dump_enum<Format>(settings, "VK_SYSTEM_ALLOCATION_SCOPE_DEVICE", static_cast<uint32_t>(object));
            break;
        case VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE:
            dump_enum<Format>(settings, "VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkInternalAllocationType(const VkInternalAllocationType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE:
            dump_enum<Format>(settings, "VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkFormat(const VkFormat object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_FORMAT_UNDEFINED:
            dump_enum<Format>(settings, "VK_FORMAT_UNDEFINED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R4G4_UNORM_PACK8:
            dump_enum<Format>(settings, "VK_FORMAT_R4G4_UNORM_PACK8", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R4G4B4A4_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R4G4B4A4_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B4G4R4A4_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_B4G4R4A4_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R5G6B5_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R5G6B5_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B5G6R5_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_B5G6R5_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R5G5B5A1_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R5G5B5A1_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B5G5R5A1_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_B5G5R5A1_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A1R5G5B5_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_A1R5G5B5_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_SRGB:
            dump_enum<Format>(settings, "VK_FORMAT_R8_SRGB", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8_SRGB:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8_SRGB", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8_SRGB:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8_SRGB", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8_SRGB:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8_SRGB", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8A8_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8A8_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8A8_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8A8_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8A8_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8A8_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8A8_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8A8_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8A8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8A8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8A8_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8A8_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8G8B8A8_SRGB:
            dump_enum<Format>(settings, "VK_FORMAT_R8G8B8A8_SRGB", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8A8_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8A8_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8A8_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8A8_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8A8_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8A8_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8A8_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8A8_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8A8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8A8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8A8_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8A8_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8A8_SRGB:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8A8_SRGB", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8B8G8R8_UNORM_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A8B8G8R8_UNORM_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8B8G8R8_SNORM_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A8B8G8R8_SNORM_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8B8G8R8_USCALED_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A8B8G8R8_USCALED_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8B8G8R8_SSCALED_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A8B8G8R8_SSCALED_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8B8G8R8_UINT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A8B8G8R8_UINT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8B8G8R8_SINT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A8B8G8R8_SINT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8B8G8R8_SRGB_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A8B8G8R8_SRGB_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2R10G10B10_UNORM_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2R10G10B10_UNORM_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2R10G10B10_SNORM_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2R10G10B10_SNORM_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2R10G10B10_USCALED_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2R10G10B10_USCALED_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2R10G10B10_SSCALED_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2R10G10B10_SSCALED_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2R10G10B10_UINT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2R10G10B10_UINT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2R10G10B10_SINT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2R10G10B10_SINT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2B10G10R10_UNORM_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2B10G10R10_UNORM_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2B10G10R10_SNORM_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2B10G10R10_SNORM_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2B10G10R10_USCALED_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2B10G10R10_USCALED_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2B10G10R10_SSCALED_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2B10G10R10_SSCALED_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2B10G10R10_UINT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2B10G10R10_UINT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A2B10G10R10_SINT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_A2B10G10R10_SINT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R16_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16A16_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16A16_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16A16_SNORM:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16A16_SNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16A16_USCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16A16_USCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16A16_SSCALED:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16A16_SSCALED", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16A16_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16A16_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16A16_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16A16_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16B16A16_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16B16A16_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R32_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32B32_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32B32_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32B32_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32B32_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32B32_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32B32_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32B32A32_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32B32A32_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32B32A32_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32B32A32_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R32G32B32A32_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R32G32B32A32_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R64_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64B64_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64B64_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64B64_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64B64_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64B64_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64B64_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64B64A64_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64B64A64_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64B64A64_SINT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64B64A64_SINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R64G64B64A64_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_R64G64B64A64_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B10G11R11_UFLOAT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_B10G11R11_UFLOAT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_E5B9G9R9_UFLOAT_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_E5B9G9R9_UFLOAT_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_D16_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_D16_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_X8_D24_UNORM_PACK32:
            dump_enum<Format>(settings, "VK_FORMAT_X8_D24_UNORM_PACK32", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_D32_SFLOAT:
            dump_enum<Format>(settings, "VK_FORMAT_D32_SFLOAT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_S8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_S8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_D16_UNORM_S8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_D16_UNORM_S8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_D24_UNORM_S8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_D24_UNORM_S8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_D32_SFLOAT_S8_UINT:
            dump_enum<Format>(settings, "VK_FORMAT_D32_SFLOAT_S8_UINT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC1_RGB_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC1_RGB_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC1_RGB_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC1_RGB_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC1_RGBA_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC1_RGBA_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC1_RGBA_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC1_RGBA_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC2_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC2_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC2_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC2_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC3_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC3_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC3_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC3_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC4_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC4_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC4_SNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC4_SNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC5_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC5_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC5_SNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC5_SNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC6H_UFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC6H_UFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC6H_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC6H_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC7_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC7_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_BC7_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_BC7_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_EAC_R11_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_EAC_R11_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_EAC_R11_SNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_EAC_R11_SNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_EAC_R11G11_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_EAC_R11G11_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_EAC_R11G11_SNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_EAC_R11G11_SNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x4_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x4_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x4_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x4_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x5_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x5_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x5_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x5_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x5_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x5_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x5_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x5_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x6_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x6_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x6_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x6_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x8_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x8_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x8_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x8_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x5_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x5_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x5_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x5_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x6_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x6_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x6_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x6_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x8_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x8_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x8_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x8_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x10_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x10_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x10_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x10_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_12x10_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_12x10_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_12x10_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_12x10_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_12x12_UNORM_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_12x12_UNORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_12x12_SRGB_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_12x12_SRGB_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G8B8G8R8_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G8B8G8R8_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B8G8R8G8_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_B8G8R8G8_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G8_B8R8_2PLANE_420_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G8_B8R8_2PLANE_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G8_B8R8_2PLANE_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R10X6_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R10X6_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R10X6G10X6_UNORM_2PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R10X6G10X6_UNORM_2PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R12X4_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R12X4_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R12X4G12X4_UNORM_2PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R12X4G12X4_UNORM_2PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G16B16G16R16_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G16B16G16R16_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_B16G16R16G16_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_B16G16R16G16_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G16_B16R16_2PLANE_420_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G16_B16R16_2PLANE_420_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G16_B16R16_2PLANE_422_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G16_B16R16_2PLANE_422_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G8_B8R8_2PLANE_444_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G8_B8R8_2PLANE_444_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G16_B16R16_2PLANE_444_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_G16_B16R16_2PLANE_444_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A4R4G4B4_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_A4R4G4B4_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A4B4G4R4_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_A4B4G4R4_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A1B5G5R5_UNORM_PACK16:
            dump_enum<Format>(settings, "VK_FORMAT_A1B5G5R5_UNORM_PACK16", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_A8_UNORM:
            dump_enum<Format>(settings, "VK_FORMAT_A8_UNORM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG:
            dump_enum<Format>(settings, "VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_3x3x3_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_3x3x3_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_3x3x3_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_3x3x3_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_3x3x3_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_3x3x3_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x3x3_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x3x3_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x3x3_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x3x3_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x3x3_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x3x3_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4x3_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4x3_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4x3_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4x3_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4x3_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4x3_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4x4_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4x4_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4x4_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4x4_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_4x4x4_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_4x4x4_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x4x4_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x4x4_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x4x4_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x4x4_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x4x4_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x4x4_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5x4_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5x4_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5x4_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5x4_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5x4_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5x4_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5x5_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5x5_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5x5_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5x5_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_5x5x5_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_5x5x5_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x5x5_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x5x5_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x5x5_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x5x5_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x5x5_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x5x5_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6x5_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6x5_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6x5_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6x5_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6x5_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6x5_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6x6_UNORM_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6x6_UNORM_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6x6_SRGB_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6x6_SRGB_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_ASTC_6x6x6_SFLOAT_BLOCK_EXT:
            dump_enum<Format>(settings, "VK_FORMAT_ASTC_6x6x6_SFLOAT_BLOCK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R8_BOOL_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R8_BOOL_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R16G16_SFIXED5_NV:
            dump_enum<Format>(settings, "VK_FORMAT_R16G16_SFIXED5_NV", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R10X6_UINT_PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R10X6_UINT_PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R10X6G10X6_UINT_2PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R10X6G10X6_UINT_2PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R10X6G10X6B10X6A10X6_UINT_4PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R10X6G10X6B10X6A10X6_UINT_4PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R12X4_UINT_PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R12X4_UINT_PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R12X4G12X4_UINT_2PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R12X4G12X4_UINT_2PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R12X4G12X4B12X4A12X4_UINT_4PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R12X4G12X4B12X4A12X4_UINT_4PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R14X2_UINT_PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R14X2_UINT_PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R14X2G14X2_UINT_2PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R14X2G14X2_UINT_2PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R14X2G14X2B14X2A14X2_UINT_4PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R14X2G14X2B14X2A14X2_UINT_4PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R14X2_UNORM_PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R14X2_UNORM_PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R14X2G14X2_UNORM_2PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R14X2G14X2_UNORM_2PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_R14X2G14X2B14X2A14X2_UNORM_4PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_R14X2G14X2B14X2A14X2_UNORM_4PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G14X2_B14X2R14X2_2PLANE_420_UNORM_3PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_G14X2_B14X2R14X2_2PLANE_420_UNORM_3PACK16_ARM", static_cast<uint32_t>(object));
            break;
        case VK_FORMAT_G14X2_B14X2R14X2_2PLANE_422_UNORM_3PACK16_ARM:
            dump_enum<Format>(settings, "VK_FORMAT_G14X2_B14X2R14X2_2PLANE_422_UNORM_3PACK16_ARM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkImageTiling(const VkImageTiling object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_IMAGE_TILING_OPTIMAL:
            dump_enum<Format>(settings, "VK_IMAGE_TILING_OPTIMAL", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_TILING_LINEAR:
            dump_enum<Format>(settings, "VK_IMAGE_TILING_LINEAR", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT:
            dump_enum<Format>(settings, "VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkImageType(const VkImageType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_IMAGE_TYPE_1D:
            dump_enum<Format>(settings, "VK_IMAGE_TYPE_1D", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_TYPE_2D:
            dump_enum<Format>(settings, "VK_IMAGE_TYPE_2D", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_TYPE_3D:
            dump_enum<Format>(settings, "VK_IMAGE_TYPE_3D", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPhysicalDeviceType(const VkPhysicalDeviceType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PHYSICAL_DEVICE_TYPE_OTHER:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_TYPE_OTHER", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_TYPE_CPU:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_TYPE_CPU", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkQueryType(const VkQueryType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_QUERY_TYPE_OCCLUSION:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_OCCLUSION", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_PIPELINE_STATISTICS:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_PIPELINE_STATISTICS", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_TIMESTAMP:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_TIMESTAMP", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_VIDEO_ENCODE_FEEDBACK_KHR", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_MESH_PRIMITIVES_GENERATED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_PRIMITIVES_GENERATED_EXT:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_PRIMITIVES_GENERATED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_BOTTOM_LEVEL_POINTERS_KHR:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_BOTTOM_LEVEL_POINTERS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SIZE_KHR:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SIZE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_QUERY_TYPE_MICROMAP_COMPACTED_SIZE_EXT:
            dump_enum<Format>(settings, "VK_QUERY_TYPE_MICROMAP_COMPACTED_SIZE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSharingMode(const VkSharingMode object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SHARING_MODE_EXCLUSIVE:
            dump_enum<Format>(settings, "VK_SHARING_MODE_EXCLUSIVE", static_cast<uint32_t>(object));
            break;
        case VK_SHARING_MODE_CONCURRENT:
            dump_enum<Format>(settings, "VK_SHARING_MODE_CONCURRENT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkComponentSwizzle(const VkComponentSwizzle object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COMPONENT_SWIZZLE_IDENTITY:
            dump_enum<Format>(settings, "VK_COMPONENT_SWIZZLE_IDENTITY", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_SWIZZLE_ZERO:
            dump_enum<Format>(settings, "VK_COMPONENT_SWIZZLE_ZERO", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_SWIZZLE_ONE:
            dump_enum<Format>(settings, "VK_COMPONENT_SWIZZLE_ONE", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_SWIZZLE_R:
            dump_enum<Format>(settings, "VK_COMPONENT_SWIZZLE_R", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_SWIZZLE_G:
            dump_enum<Format>(settings, "VK_COMPONENT_SWIZZLE_G", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_SWIZZLE_B:
            dump_enum<Format>(settings, "VK_COMPONENT_SWIZZLE_B", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_SWIZZLE_A:
            dump_enum<Format>(settings, "VK_COMPONENT_SWIZZLE_A", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkImageViewType(const VkImageViewType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_IMAGE_VIEW_TYPE_1D:
            dump_enum<Format>(settings, "VK_IMAGE_VIEW_TYPE_1D", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_VIEW_TYPE_2D:
            dump_enum<Format>(settings, "VK_IMAGE_VIEW_TYPE_2D", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_VIEW_TYPE_3D:
            dump_enum<Format>(settings, "VK_IMAGE_VIEW_TYPE_3D", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_VIEW_TYPE_CUBE:
            dump_enum<Format>(settings, "VK_IMAGE_VIEW_TYPE_CUBE", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_VIEW_TYPE_1D_ARRAY:
            dump_enum<Format>(settings, "VK_IMAGE_VIEW_TYPE_1D_ARRAY", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_VIEW_TYPE_2D_ARRAY:
            dump_enum<Format>(settings, "VK_IMAGE_VIEW_TYPE_2D_ARRAY", static_cast<uint32_t>(object));
            break;
        case VK_IMAGE_VIEW_TYPE_CUBE_ARRAY:
            dump_enum<Format>(settings, "VK_IMAGE_VIEW_TYPE_CUBE_ARRAY", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCommandBufferLevel(const VkCommandBufferLevel object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COMMAND_BUFFER_LEVEL_PRIMARY:
            dump_enum<Format>(settings, "VK_COMMAND_BUFFER_LEVEL_PRIMARY", static_cast<uint32_t>(object));
            break;
        case VK_COMMAND_BUFFER_LEVEL_SECONDARY:
            dump_enum<Format>(settings, "VK_COMMAND_BUFFER_LEVEL_SECONDARY", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkIndexType(const VkIndexType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_INDEX_TYPE_UINT16:
            dump_enum<Format>(settings, "VK_INDEX_TYPE_UINT16", static_cast<uint32_t>(object));
            break;
        case VK_INDEX_TYPE_UINT32:
            dump_enum<Format>(settings, "VK_INDEX_TYPE_UINT32", static_cast<uint32_t>(object));
            break;
        case VK_INDEX_TYPE_UINT8:
            dump_enum<Format>(settings, "VK_INDEX_TYPE_UINT8", static_cast<uint32_t>(object));
            break;
        case VK_INDEX_TYPE_NONE_KHR:
            dump_enum<Format>(settings, "VK_INDEX_TYPE_NONE_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPipelineCacheHeaderVersion(const VkPipelineCacheHeaderVersion object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PIPELINE_CACHE_HEADER_VERSION_ONE:
            dump_enum<Format>(settings, "VK_PIPELINE_CACHE_HEADER_VERSION_ONE", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_CACHE_HEADER_VERSION_DATA_GRAPH_QCOM:
            dump_enum<Format>(settings, "VK_PIPELINE_CACHE_HEADER_VERSION_DATA_GRAPH_QCOM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkBorderColor(const VkBorderColor object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK", static_cast<uint32_t>(object));
            break;
        case VK_BORDER_COLOR_INT_TRANSPARENT_BLACK:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_INT_TRANSPARENT_BLACK", static_cast<uint32_t>(object));
            break;
        case VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK", static_cast<uint32_t>(object));
            break;
        case VK_BORDER_COLOR_INT_OPAQUE_BLACK:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_INT_OPAQUE_BLACK", static_cast<uint32_t>(object));
            break;
        case VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE", static_cast<uint32_t>(object));
            break;
        case VK_BORDER_COLOR_INT_OPAQUE_WHITE:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_INT_OPAQUE_WHITE", static_cast<uint32_t>(object));
            break;
        case VK_BORDER_COLOR_FLOAT_CUSTOM_EXT:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_FLOAT_CUSTOM_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BORDER_COLOR_INT_CUSTOM_EXT:
            dump_enum<Format>(settings, "VK_BORDER_COLOR_INT_CUSTOM_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkFilter(const VkFilter object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_FILTER_NEAREST:
            dump_enum<Format>(settings, "VK_FILTER_NEAREST", static_cast<uint32_t>(object));
            break;
        case VK_FILTER_LINEAR:
            dump_enum<Format>(settings, "VK_FILTER_LINEAR", static_cast<uint32_t>(object));
            break;
        case VK_FILTER_CUBIC_EXT:
            dump_enum<Format>(settings, "VK_FILTER_CUBIC_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSamplerAddressMode(const VkSamplerAddressMode object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SAMPLER_ADDRESS_MODE_REPEAT:
            dump_enum<Format>(settings, "VK_SAMPLER_ADDRESS_MODE_REPEAT", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT:
            dump_enum<Format>(settings, "VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE:
            dump_enum<Format>(settings, "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER:
            dump_enum<Format>(settings, "VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE:
            dump_enum<Format>(settings, "VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSamplerMipmapMode(const VkSamplerMipmapMode object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SAMPLER_MIPMAP_MODE_NEAREST:
            dump_enum<Format>(settings, "VK_SAMPLER_MIPMAP_MODE_NEAREST", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_MIPMAP_MODE_LINEAR:
            dump_enum<Format>(settings, "VK_SAMPLER_MIPMAP_MODE_LINEAR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCompareOp(const VkCompareOp object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COMPARE_OP_NEVER:
            dump_enum<Format>(settings, "VK_COMPARE_OP_NEVER", static_cast<uint32_t>(object));
            break;
        case VK_COMPARE_OP_LESS:
            dump_enum<Format>(settings, "VK_COMPARE_OP_LESS", static_cast<uint32_t>(object));
            break;
        case VK_COMPARE_OP_EQUAL:
            dump_enum<Format>(settings, "VK_COMPARE_OP_EQUAL", static_cast<uint32_t>(object));
            break;
        case VK_COMPARE_OP_LESS_OR_EQUAL:
            dump_enum<Format>(settings, "VK_COMPARE_OP_LESS_OR_EQUAL", static_cast<uint32_t>(object));
            break;
        case VK_COMPARE_OP_GREATER:
            dump_enum<Format>(settings, "VK_COMPARE_OP_GREATER", static_cast<uint32_t>(object));
            break;
        case VK_COMPARE_OP_NOT_EQUAL:
            dump_enum<Format>(settings, "VK_COMPARE_OP_NOT_EQUAL", static_cast<uint32_t>(object));
            break;
        case VK_COMPARE_OP_GREATER_OR_EQUAL:
            dump_enum<Format>(settings, "VK_COMPARE_OP_GREATER_OR_EQUAL", static_cast<uint32_t>(object));
            break;
        case VK_COMPARE_OP_ALWAYS:
            dump_enum<Format>(settings, "VK_COMPARE_OP_ALWAYS", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDescriptorType(const VkDescriptorType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_SAMPLER", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_STORAGE_IMAGE", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_SAMPLE_WEIGHT_IMAGE_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_BLOCK_MATCH_IMAGE_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_TENSOR_ARM:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_TENSOR_ARM", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_MUTABLE_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_MUTABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_NV:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPipelineBindPoint(const VkPipelineBindPoint object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PIPELINE_BIND_POINT_GRAPHICS:
            dump_enum<Format>(settings, "VK_PIPELINE_BIND_POINT_GRAPHICS", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_BIND_POINT_COMPUTE:
            dump_enum<Format>(settings, "VK_PIPELINE_BIND_POINT_COMPUTE", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_PIPELINE_BIND_POINT_EXECUTION_GRAPH_AMDX:
            dump_enum<Format>(settings, "VK_PIPELINE_BIND_POINT_EXECUTION_GRAPH_AMDX", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        case VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR:
            dump_enum<Format>(settings, "VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI:
            dump_enum<Format>(settings, "VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_BIND_POINT_DATA_GRAPH_ARM:
            dump_enum<Format>(settings, "VK_PIPELINE_BIND_POINT_DATA_GRAPH_ARM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkBlendFactor(const VkBlendFactor object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_BLEND_FACTOR_ZERO:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ZERO", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_SRC_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_SRC_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_DST_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_DST_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_SRC_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_SRC_ALPHA", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_DST_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_DST_ALPHA", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_CONSTANT_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_CONSTANT_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_CONSTANT_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_CONSTANT_ALPHA", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_SRC_ALPHA_SATURATE:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_SRC_ALPHA_SATURATE", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_SRC1_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_SRC1_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_SRC1_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_SRC1_ALPHA", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA:
            dump_enum<Format>(settings, "VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkBlendOp(const VkBlendOp object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_BLEND_OP_ADD:
            dump_enum<Format>(settings, "VK_BLEND_OP_ADD", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SUBTRACT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SUBTRACT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_REVERSE_SUBTRACT:
            dump_enum<Format>(settings, "VK_BLEND_OP_REVERSE_SUBTRACT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_MIN:
            dump_enum<Format>(settings, "VK_BLEND_OP_MIN", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_MAX:
            dump_enum<Format>(settings, "VK_BLEND_OP_MAX", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_ZERO_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_ZERO_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SRC_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SRC_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_DST_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_DST_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SRC_OVER_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SRC_OVER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_DST_OVER_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_DST_OVER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SRC_IN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SRC_IN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_DST_IN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_DST_IN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SRC_OUT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SRC_OUT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_DST_OUT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_DST_OUT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SRC_ATOP_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SRC_ATOP_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_DST_ATOP_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_DST_ATOP_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_XOR_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_XOR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_MULTIPLY_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_MULTIPLY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SCREEN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SCREEN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_OVERLAY_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_OVERLAY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_DARKEN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_DARKEN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_LIGHTEN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_LIGHTEN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_COLORDODGE_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_COLORDODGE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_COLORBURN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_COLORBURN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_HARDLIGHT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_HARDLIGHT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_SOFTLIGHT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_SOFTLIGHT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_DIFFERENCE_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_DIFFERENCE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_EXCLUSION_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_EXCLUSION_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_INVERT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_INVERT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_INVERT_RGB_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_INVERT_RGB_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_LINEARDODGE_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_LINEARDODGE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_LINEARBURN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_LINEARBURN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_VIVIDLIGHT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_VIVIDLIGHT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_LINEARLIGHT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_LINEARLIGHT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_PINLIGHT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_PINLIGHT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_HARDMIX_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_HARDMIX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_HSL_HUE_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_HSL_HUE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_HSL_SATURATION_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_HSL_SATURATION_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_HSL_COLOR_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_HSL_COLOR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_HSL_LUMINOSITY_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_HSL_LUMINOSITY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_PLUS_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_PLUS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_PLUS_CLAMPED_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_PLUS_CLAMPED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_PLUS_DARKER_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_PLUS_DARKER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_MINUS_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_MINUS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_MINUS_CLAMPED_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_MINUS_CLAMPED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_CONTRAST_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_CONTRAST_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_INVERT_OVG_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_INVERT_OVG_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_RED_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_RED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_GREEN_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_GREEN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OP_BLUE_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OP_BLUE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDynamicState(const VkDynamicState object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DYNAMIC_STATE_VIEWPORT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VIEWPORT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_SCISSOR:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_SCISSOR", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_LINE_WIDTH:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_LINE_WIDTH", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_BIAS:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_BIAS", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_BLEND_CONSTANTS:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_BLEND_CONSTANTS", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_BOUNDS:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_BOUNDS", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_STENCIL_WRITE_MASK:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_STENCIL_WRITE_MASK", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_STENCIL_REFERENCE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_STENCIL_REFERENCE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_CULL_MODE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_CULL_MODE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_FRONT_FACE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_FRONT_FACE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_COMPARE_OP:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_COMPARE_OP", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_STENCIL_OP:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_STENCIL_OP", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_LINE_STIPPLE:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_LINE_STIPPLE", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VERTEX_INPUT_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VERTEX_INPUT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_LOGIC_OP_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_LOGIC_OP_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_POLYGON_MODE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_POLYGON_MODE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_SAMPLE_MASK_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_SAMPLE_MASK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_ATTACHMENT_FEEDBACK_LOOP_ENABLE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DYNAMIC_STATE_DEPTH_CLAMP_RANGE_EXT:
            dump_enum<Format>(settings, "VK_DYNAMIC_STATE_DEPTH_CLAMP_RANGE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkFrontFace(const VkFrontFace object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_FRONT_FACE_COUNTER_CLOCKWISE:
            dump_enum<Format>(settings, "VK_FRONT_FACE_COUNTER_CLOCKWISE", static_cast<uint32_t>(object));
            break;
        case VK_FRONT_FACE_CLOCKWISE:
            dump_enum<Format>(settings, "VK_FRONT_FACE_CLOCKWISE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkVertexInputRate(const VkVertexInputRate object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VERTEX_INPUT_RATE_VERTEX:
            dump_enum<Format>(settings, "VK_VERTEX_INPUT_RATE_VERTEX", static_cast<uint32_t>(object));
            break;
        case VK_VERTEX_INPUT_RATE_INSTANCE:
            dump_enum<Format>(settings, "VK_VERTEX_INPUT_RATE_INSTANCE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPrimitiveTopology(const VkPrimitiveTopology object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PRIMITIVE_TOPOLOGY_POINT_LIST:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_POINT_LIST", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_LINE_LIST:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_LINE_LIST", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_LINE_STRIP:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY", static_cast<uint32_t>(object));
            break;
        case VK_PRIMITIVE_TOPOLOGY_PATCH_LIST:
            dump_enum<Format>(settings, "VK_PRIMITIVE_TOPOLOGY_PATCH_LIST", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPolygonMode(const VkPolygonMode object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_POLYGON_MODE_FILL:
            dump_enum<Format>(settings, "VK_POLYGON_MODE_FILL", static_cast<uint32_t>(object));
            break;
        case VK_POLYGON_MODE_LINE:
            dump_enum<Format>(settings, "VK_POLYGON_MODE_LINE", static_cast<uint32_t>(object));
            break;
        case VK_POLYGON_MODE_POINT:
            dump_enum<Format>(settings, "VK_POLYGON_MODE_POINT", static_cast<uint32_t>(object));
            break;
        case VK_POLYGON_MODE_FILL_RECTANGLE_NV:
            dump_enum<Format>(settings, "VK_POLYGON_MODE_FILL_RECTANGLE_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkStencilOp(const VkStencilOp object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_STENCIL_OP_KEEP:
            dump_enum<Format>(settings, "VK_STENCIL_OP_KEEP", static_cast<uint32_t>(object));
            break;
        case VK_STENCIL_OP_ZERO:
            dump_enum<Format>(settings, "VK_STENCIL_OP_ZERO", static_cast<uint32_t>(object));
            break;
        case VK_STENCIL_OP_REPLACE:
            dump_enum<Format>(settings, "VK_STENCIL_OP_REPLACE", static_cast<uint32_t>(object));
            break;
        case VK_STENCIL_OP_INCREMENT_AND_CLAMP:
            dump_enum<Format>(settings, "VK_STENCIL_OP_INCREMENT_AND_CLAMP", static_cast<uint32_t>(object));
            break;
        case VK_STENCIL_OP_DECREMENT_AND_CLAMP:
            dump_enum<Format>(settings, "VK_STENCIL_OP_DECREMENT_AND_CLAMP", static_cast<uint32_t>(object));
            break;
        case VK_STENCIL_OP_INVERT:
            dump_enum<Format>(settings, "VK_STENCIL_OP_INVERT", static_cast<uint32_t>(object));
            break;
        case VK_STENCIL_OP_INCREMENT_AND_WRAP:
            dump_enum<Format>(settings, "VK_STENCIL_OP_INCREMENT_AND_WRAP", static_cast<uint32_t>(object));
            break;
        case VK_STENCIL_OP_DECREMENT_AND_WRAP:
            dump_enum<Format>(settings, "VK_STENCIL_OP_DECREMENT_AND_WRAP", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkLogicOp(const VkLogicOp object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_LOGIC_OP_CLEAR:
            dump_enum<Format>(settings, "VK_LOGIC_OP_CLEAR", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_AND:
            dump_enum<Format>(settings, "VK_LOGIC_OP_AND", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_AND_REVERSE:
            dump_enum<Format>(settings, "VK_LOGIC_OP_AND_REVERSE", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_COPY:
            dump_enum<Format>(settings, "VK_LOGIC_OP_COPY", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_AND_INVERTED:
            dump_enum<Format>(settings, "VK_LOGIC_OP_AND_INVERTED", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_NO_OP:
            dump_enum<Format>(settings, "VK_LOGIC_OP_NO_OP", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_XOR:
            dump_enum<Format>(settings, "VK_LOGIC_OP_XOR", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_OR:
            dump_enum<Format>(settings, "VK_LOGIC_OP_OR", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_NOR:
            dump_enum<Format>(settings, "VK_LOGIC_OP_NOR", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_EQUIVALENT:
            dump_enum<Format>(settings, "VK_LOGIC_OP_EQUIVALENT", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_INVERT:
            dump_enum<Format>(settings, "VK_LOGIC_OP_INVERT", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_OR_REVERSE:
            dump_enum<Format>(settings, "VK_LOGIC_OP_OR_REVERSE", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_COPY_INVERTED:
            dump_enum<Format>(settings, "VK_LOGIC_OP_COPY_INVERTED", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_OR_INVERTED:
            dump_enum<Format>(settings, "VK_LOGIC_OP_OR_INVERTED", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_NAND:
            dump_enum<Format>(settings, "VK_LOGIC_OP_NAND", static_cast<uint32_t>(object));
            break;
        case VK_LOGIC_OP_SET:
            dump_enum<Format>(settings, "VK_LOGIC_OP_SET", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAttachmentLoadOp(const VkAttachmentLoadOp object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ATTACHMENT_LOAD_OP_LOAD:
            dump_enum<Format>(settings, "VK_ATTACHMENT_LOAD_OP_LOAD", static_cast<uint32_t>(object));
            break;
        case VK_ATTACHMENT_LOAD_OP_CLEAR:
            dump_enum<Format>(settings, "VK_ATTACHMENT_LOAD_OP_CLEAR", static_cast<uint32_t>(object));
            break;
        case VK_ATTACHMENT_LOAD_OP_DONT_CARE:
            dump_enum<Format>(settings, "VK_ATTACHMENT_LOAD_OP_DONT_CARE", static_cast<uint32_t>(object));
            break;
        case VK_ATTACHMENT_LOAD_OP_NONE:
            dump_enum<Format>(settings, "VK_ATTACHMENT_LOAD_OP_NONE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAttachmentStoreOp(const VkAttachmentStoreOp object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ATTACHMENT_STORE_OP_STORE:
            dump_enum<Format>(settings, "VK_ATTACHMENT_STORE_OP_STORE", static_cast<uint32_t>(object));
            break;
        case VK_ATTACHMENT_STORE_OP_DONT_CARE:
            dump_enum<Format>(settings, "VK_ATTACHMENT_STORE_OP_DONT_CARE", static_cast<uint32_t>(object));
            break;
        case VK_ATTACHMENT_STORE_OP_NONE:
            dump_enum<Format>(settings, "VK_ATTACHMENT_STORE_OP_NONE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSubpassContents(const VkSubpassContents object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SUBPASS_CONTENTS_INLINE:
            dump_enum<Format>(settings, "VK_SUBPASS_CONTENTS_INLINE", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS:
            dump_enum<Format>(settings, "VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_CONTENTS_INLINE_AND_SECONDARY_COMMAND_BUFFERS_KHR:
            dump_enum<Format>(settings, "VK_SUBPASS_CONTENTS_INLINE_AND_SECONDARY_COMMAND_BUFFERS_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDescriptorUpdateTemplateType(const VkDescriptorUpdateTemplateType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSamplerYcbcrModelConversion(const VkSamplerYcbcrModelConversion object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY:
            dump_enum<Format>(settings, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY:
            dump_enum<Format>(settings, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709:
            dump_enum<Format>(settings, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601:
            dump_enum<Format>(settings, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020:
            dump_enum<Format>(settings, "VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSamplerYcbcrRange(const VkSamplerYcbcrRange object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SAMPLER_YCBCR_RANGE_ITU_FULL:
            dump_enum<Format>(settings, "VK_SAMPLER_YCBCR_RANGE_ITU_FULL", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_YCBCR_RANGE_ITU_NARROW:
            dump_enum<Format>(settings, "VK_SAMPLER_YCBCR_RANGE_ITU_NARROW", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkChromaLocation(const VkChromaLocation object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_CHROMA_LOCATION_COSITED_EVEN:
            dump_enum<Format>(settings, "VK_CHROMA_LOCATION_COSITED_EVEN", static_cast<uint32_t>(object));
            break;
        case VK_CHROMA_LOCATION_MIDPOINT:
            dump_enum<Format>(settings, "VK_CHROMA_LOCATION_MIDPOINT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPointClippingBehavior(const VkPointClippingBehavior object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES:
            dump_enum<Format>(settings, "VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES", static_cast<uint32_t>(object));
            break;
        case VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY:
            dump_enum<Format>(settings, "VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkTessellationDomainOrigin(const VkTessellationDomainOrigin object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT:
            dump_enum<Format>(settings, "VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT", static_cast<uint32_t>(object));
            break;
        case VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT:
            dump_enum<Format>(settings, "VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDriverId(const VkDriverId object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DRIVER_ID_AMD_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_AMD_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_AMD_OPEN_SOURCE:
            dump_enum<Format>(settings, "VK_DRIVER_ID_AMD_OPEN_SOURCE", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_RADV:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_RADV", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_NVIDIA_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_NVIDIA_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS:
            dump_enum<Format>(settings, "VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA:
            dump_enum<Format>(settings, "VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_IMAGINATION_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_IMAGINATION_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_QUALCOMM_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_QUALCOMM_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_ARM_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_ARM_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_GOOGLE_SWIFTSHADER:
            dump_enum<Format>(settings, "VK_DRIVER_ID_GOOGLE_SWIFTSHADER", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_GGP_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_GGP_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_BROADCOM_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_BROADCOM_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_LLVMPIPE:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_LLVMPIPE", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MOLTENVK:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MOLTENVK", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_COREAVI_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_COREAVI_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_JUICE_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_JUICE_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_VERISILICON_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_VERISILICON_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_TURNIP:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_TURNIP", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_V3DV:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_V3DV", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_PANVK:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_PANVK", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_SAMSUNG_PROPRIETARY:
            dump_enum<Format>(settings, "VK_DRIVER_ID_SAMSUNG_PROPRIETARY", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_VENUS:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_VENUS", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_DOZEN:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_DOZEN", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_NVK:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_NVK", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_IMAGINATION_OPEN_SOURCE_MESA:
            dump_enum<Format>(settings, "VK_DRIVER_ID_IMAGINATION_OPEN_SOURCE_MESA", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_HONEYKRISP:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_HONEYKRISP", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_VULKAN_SC_EMULATION_ON_VULKAN:
            dump_enum<Format>(settings, "VK_DRIVER_ID_VULKAN_SC_EMULATION_ON_VULKAN", static_cast<uint32_t>(object));
            break;
        case VK_DRIVER_ID_MESA_KOSMICKRISP:
            dump_enum<Format>(settings, "VK_DRIVER_ID_MESA_KOSMICKRISP", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkShaderFloatControlsIndependence(const VkShaderFloatControlsIndependence object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY:
            dump_enum<Format>(settings, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL:
            dump_enum<Format>(settings, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE:
            dump_enum<Format>(settings, "VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSemaphoreType(const VkSemaphoreType object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SEMAPHORE_TYPE_BINARY:
            dump_enum<Format>(settings, "VK_SEMAPHORE_TYPE_BINARY", static_cast<uint32_t>(object));
            break;
        case VK_SEMAPHORE_TYPE_TIMELINE:
            dump_enum<Format>(settings, "VK_SEMAPHORE_TYPE_TIMELINE", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSamplerReductionMode(const VkSamplerReductionMode object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE:
            dump_enum<Format>(settings, "VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_REDUCTION_MODE_MIN:
            dump_enum<Format>(settings, "VK_SAMPLER_REDUCTION_MODE_MIN", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_REDUCTION_MODE_MAX:
            dump_enum<Format>(settings, "VK_SAMPLER_REDUCTION_MODE_MAX", static_cast<uint32_t>(object));
            break;
        case VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_RANGECLAMP_QCOM:
            dump_enum<Format>(settings, "VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_RANGECLAMP_QCOM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPipelineRobustnessBufferBehavior(const VkPipelineRobustnessBufferBehavior object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DEVICE_DEFAULT:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DEVICE_DEFAULT", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DISABLED:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_DISABLED", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS_2:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_BUFFER_BEHAVIOR_ROBUST_BUFFER_ACCESS_2", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPipelineRobustnessImageBehavior(const VkPipelineRobustnessImageBehavior object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DEVICE_DEFAULT:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DEVICE_DEFAULT", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DISABLED:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_DISABLED", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS_2:
            dump_enum<Format>(settings, "VK_PIPELINE_ROBUSTNESS_IMAGE_BEHAVIOR_ROBUST_IMAGE_ACCESS_2", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkQueueGlobalPriority(const VkQueueGlobalPriority object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_QUEUE_GLOBAL_PRIORITY_LOW:
            dump_enum<Format>(settings, "VK_QUEUE_GLOBAL_PRIORITY_LOW", static_cast<uint32_t>(object));
            break;
        case VK_QUEUE_GLOBAL_PRIORITY_MEDIUM:
            dump_enum<Format>(settings, "VK_QUEUE_GLOBAL_PRIORITY_MEDIUM", static_cast<uint32_t>(object));
            break;
        case VK_QUEUE_GLOBAL_PRIORITY_HIGH:
            dump_enum<Format>(settings, "VK_QUEUE_GLOBAL_PRIORITY_HIGH", static_cast<uint32_t>(object));
            break;
        case VK_QUEUE_GLOBAL_PRIORITY_REALTIME:
            dump_enum<Format>(settings, "VK_QUEUE_GLOBAL_PRIORITY_REALTIME", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkLineRasterizationMode(const VkLineRasterizationMode object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_LINE_RASTERIZATION_MODE_DEFAULT:
            dump_enum<Format>(settings, "VK_LINE_RASTERIZATION_MODE_DEFAULT", static_cast<uint32_t>(object));
            break;
        case VK_LINE_RASTERIZATION_MODE_RECTANGULAR:
            dump_enum<Format>(settings, "VK_LINE_RASTERIZATION_MODE_RECTANGULAR", static_cast<uint32_t>(object));
            break;
        case VK_LINE_RASTERIZATION_MODE_BRESENHAM:
            dump_enum<Format>(settings, "VK_LINE_RASTERIZATION_MODE_BRESENHAM", static_cast<uint32_t>(object));
            break;
        case VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH:
            dump_enum<Format>(settings, "VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPresentModeKHR(const VkPresentModeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PRESENT_MODE_IMMEDIATE_KHR:
            dump_enum<Format>(settings, "VK_PRESENT_MODE_IMMEDIATE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PRESENT_MODE_MAILBOX_KHR:
            dump_enum<Format>(settings, "VK_PRESENT_MODE_MAILBOX_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PRESENT_MODE_FIFO_KHR:
            dump_enum<Format>(settings, "VK_PRESENT_MODE_FIFO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PRESENT_MODE_FIFO_RELAXED_KHR:
            dump_enum<Format>(settings, "VK_PRESENT_MODE_FIFO_RELAXED_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR:
            dump_enum<Format>(settings, "VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR:
            dump_enum<Format>(settings, "VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PRESENT_MODE_FIFO_LATEST_READY_KHR:
            dump_enum<Format>(settings, "VK_PRESENT_MODE_FIFO_LATEST_READY_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkColorSpaceKHR(const VkColorSpaceKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COLOR_SPACE_SRGB_NONLINEAR_KHR:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_SRGB_NONLINEAR_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_BT709_LINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_BT709_LINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_BT709_NONLINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_BT709_NONLINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_BT2020_LINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_BT2020_LINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_HDR10_ST2084_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_HDR10_ST2084_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_DOLBYVISION_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_DOLBYVISION_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_HDR10_HLG_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_HDR10_HLG_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_PASS_THROUGH_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_PASS_THROUGH_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COLOR_SPACE_DISPLAY_NATIVE_AMD:
            dump_enum<Format>(settings, "VK_COLOR_SPACE_DISPLAY_NATIVE_AMD", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkQueryResultStatusKHR(const VkQueryResultStatusKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_QUERY_RESULT_STATUS_ERROR_KHR:
            dump_enum<Format>(settings, "VK_QUERY_RESULT_STATUS_ERROR_KHR", static_cast<int32_t>(object));
            break;
        case VK_QUERY_RESULT_STATUS_NOT_READY_KHR:
            dump_enum<Format>(settings, "VK_QUERY_RESULT_STATUS_NOT_READY_KHR", static_cast<int32_t>(object));
            break;
        case VK_QUERY_RESULT_STATUS_COMPLETE_KHR:
            dump_enum<Format>(settings, "VK_QUERY_RESULT_STATUS_COMPLETE_KHR", static_cast<int32_t>(object));
            break;
        case VK_QUERY_RESULT_STATUS_INSUFFICIENT_BITSTREAM_BUFFER_RANGE_KHR:
            dump_enum<Format>(settings, "VK_QUERY_RESULT_STATUS_INSUFFICIENT_BITSTREAM_BUFFER_RANGE_KHR", static_cast<int32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<int32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPerformanceCounterUnitKHR(const VkPerformanceCounterUnitKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPerformanceCounterScopeKHR(const VkPerformanceCounterScopeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPerformanceCounterStorageKHR(const VkPerformanceCounterStorageKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR:
            dump_enum<Format>(settings, "VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkFragmentShadingRateCombinerOpKHR(const VkFragmentShadingRateCombinerOpKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPipelineExecutableStatisticFormatKHR(const VkPipelineExecutableStatisticFormatKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR:
            dump_enum<Format>(settings, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR:
            dump_enum<Format>(settings, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR:
            dump_enum<Format>(settings, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR:
            dump_enum<Format>(settings, "VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkVideoEncodeTuningModeKHR(const VkVideoEncodeTuningModeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VIDEO_ENCODE_TUNING_MODE_DEFAULT_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_TUNING_MODE_DEFAULT_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_TUNING_MODE_HIGH_QUALITY_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_TUNING_MODE_HIGH_QUALITY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_TUNING_MODE_LOW_LATENCY_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_TUNING_MODE_LOW_LATENCY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_TUNING_MODE_ULTRA_LOW_LATENCY_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_TUNING_MODE_ULTRA_LOW_LATENCY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_TUNING_MODE_LOSSLESS_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_TUNING_MODE_LOSSLESS_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkComponentTypeKHR(const VkComponentTypeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COMPONENT_TYPE_FLOAT16_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_FLOAT16_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_FLOAT32_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_FLOAT32_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_FLOAT64_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_FLOAT64_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_SINT8_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_SINT8_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_SINT16_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_SINT16_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_SINT32_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_SINT32_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_SINT64_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_SINT64_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_UINT8_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_UINT8_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_UINT16_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_UINT16_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_UINT32_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_UINT32_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_UINT64_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_UINT64_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_BFLOAT16_KHR:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_BFLOAT16_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_SINT8_PACKED_NV:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_SINT8_PACKED_NV", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_UINT8_PACKED_NV:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_UINT8_PACKED_NV", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_FLOAT8_E4M3_EXT:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_FLOAT8_E4M3_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COMPONENT_TYPE_FLOAT8_E5M2_EXT:
            dump_enum<Format>(settings, "VK_COMPONENT_TYPE_FLOAT8_E5M2_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkScopeKHR(const VkScopeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SCOPE_DEVICE_KHR:
            dump_enum<Format>(settings, "VK_SCOPE_DEVICE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_SCOPE_WORKGROUP_KHR:
            dump_enum<Format>(settings, "VK_SCOPE_WORKGROUP_KHR", static_cast<uint32_t>(object));
            break;
        case VK_SCOPE_SUBGROUP_KHR:
            dump_enum<Format>(settings, "VK_SCOPE_SUBGROUP_KHR", static_cast<uint32_t>(object));
            break;
        case VK_SCOPE_QUEUE_FAMILY_KHR:
            dump_enum<Format>(settings, "VK_SCOPE_QUEUE_FAMILY_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkVideoEncodeAV1PredictionModeKHR(const VkVideoEncodeAV1PredictionModeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_INTRA_ONLY_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_INTRA_ONLY_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_SINGLE_REFERENCE_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_SINGLE_REFERENCE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_UNIDIRECTIONAL_COMPOUND_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_UNIDIRECTIONAL_COMPOUND_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_BIDIRECTIONAL_COMPOUND_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_AV1_PREDICTION_MODE_BIDIRECTIONAL_COMPOUND_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkVideoEncodeAV1RateControlGroupKHR(const VkVideoEncodeAV1RateControlGroupKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_INTRA_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_INTRA_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_PREDICTIVE_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_PREDICTIVE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_BIPREDICTIVE_KHR:
            dump_enum<Format>(settings, "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_GROUP_BIPREDICTIVE_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkTimeDomainKHR(const VkTimeDomainKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_TIME_DOMAIN_DEVICE_KHR:
            dump_enum<Format>(settings, "VK_TIME_DOMAIN_DEVICE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_TIME_DOMAIN_CLOCK_MONOTONIC_KHR:
            dump_enum<Format>(settings, "VK_TIME_DOMAIN_CLOCK_MONOTONIC_KHR", static_cast<uint32_t>(object));
            break;
        case VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_KHR:
            dump_enum<Format>(settings, "VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_KHR", static_cast<uint32_t>(object));
            break;
        case VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_KHR:
            dump_enum<Format>(settings, "VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_KHR", static_cast<uint32_t>(object));
            break;
        case VK_TIME_DOMAIN_PRESENT_STAGE_LOCAL_EXT:
            dump_enum<Format>(settings, "VK_TIME_DOMAIN_PRESENT_STAGE_LOCAL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_TIME_DOMAIN_SWAPCHAIN_LOCAL_EXT:
            dump_enum<Format>(settings, "VK_TIME_DOMAIN_SWAPCHAIN_LOCAL_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPhysicalDeviceLayeredApiKHR(const VkPhysicalDeviceLayeredApiKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PHYSICAL_DEVICE_LAYERED_API_VULKAN_KHR:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_LAYERED_API_VULKAN_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_LAYERED_API_D3D12_KHR:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_LAYERED_API_D3D12_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_LAYERED_API_METAL_KHR:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_LAYERED_API_METAL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_LAYERED_API_OPENGL_KHR:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_LAYERED_API_OPENGL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_LAYERED_API_OPENGLES_KHR:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_LAYERED_API_OPENGLES_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDefaultVertexAttributeValueKHR(const VkDefaultVertexAttributeValueKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEFAULT_VERTEX_ATTRIBUTE_VALUE_ZERO_ZERO_ZERO_ZERO_KHR:
            dump_enum<Format>(settings, "VK_DEFAULT_VERTEX_ATTRIBUTE_VALUE_ZERO_ZERO_ZERO_ZERO_KHR", static_cast<uint32_t>(object));
            break;
        case VK_DEFAULT_VERTEX_ATTRIBUTE_VALUE_ZERO_ZERO_ZERO_ONE_KHR:
            dump_enum<Format>(settings, "VK_DEFAULT_VERTEX_ATTRIBUTE_VALUE_ZERO_ZERO_ZERO_ONE_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDebugReportObjectTypeEXT(const VkDebugReportObjectTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_CUDA_MODULE_NV_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_CUDA_MODULE_NV_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_CUDA_FUNCTION_NV_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_CUDA_FUNCTION_NV_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA_EXT:
            dump_enum<Format>(settings, "VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkRasterizationOrderAMD(const VkRasterizationOrderAMD object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_RASTERIZATION_ORDER_STRICT_AMD:
            dump_enum<Format>(settings, "VK_RASTERIZATION_ORDER_STRICT_AMD", static_cast<uint32_t>(object));
            break;
        case VK_RASTERIZATION_ORDER_RELAXED_AMD:
            dump_enum<Format>(settings, "VK_RASTERIZATION_ORDER_RELAXED_AMD", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkShaderInfoTypeAMD(const VkShaderInfoTypeAMD object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SHADER_INFO_TYPE_STATISTICS_AMD:
            dump_enum<Format>(settings, "VK_SHADER_INFO_TYPE_STATISTICS_AMD", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_INFO_TYPE_BINARY_AMD:
            dump_enum<Format>(settings, "VK_SHADER_INFO_TYPE_BINARY_AMD", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD:
            dump_enum<Format>(settings, "VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkValidationCheckEXT(const VkValidationCheckEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VALIDATION_CHECK_ALL_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_CHECK_ALL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_CHECK_SHADERS_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_CHECK_SHADERS_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDisplayPowerStateEXT(const VkDisplayPowerStateEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DISPLAY_POWER_STATE_OFF_EXT:
            dump_enum<Format>(settings, "VK_DISPLAY_POWER_STATE_OFF_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DISPLAY_POWER_STATE_SUSPEND_EXT:
            dump_enum<Format>(settings, "VK_DISPLAY_POWER_STATE_SUSPEND_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DISPLAY_POWER_STATE_ON_EXT:
            dump_enum<Format>(settings, "VK_DISPLAY_POWER_STATE_ON_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDeviceEventTypeEXT(const VkDeviceEventTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDisplayEventTypeEXT(const VkDisplayEventTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT:
            dump_enum<Format>(settings, "VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkViewportCoordinateSwizzleNV(const VkViewportCoordinateSwizzleNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV", static_cast<uint32_t>(object));
            break;
        case VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV", static_cast<uint32_t>(object));
            break;
        case VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV", static_cast<uint32_t>(object));
            break;
        case VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV", static_cast<uint32_t>(object));
            break;
        case VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV", static_cast<uint32_t>(object));
            break;
        case VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV", static_cast<uint32_t>(object));
            break;
        case VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV", static_cast<uint32_t>(object));
            break;
        case VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV:
            dump_enum<Format>(settings, "VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDiscardRectangleModeEXT(const VkDiscardRectangleModeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT:
            dump_enum<Format>(settings, "VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT:
            dump_enum<Format>(settings, "VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkConservativeRasterizationModeEXT(const VkConservativeRasterizationModeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT:
            dump_enum<Format>(settings, "VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT:
            dump_enum<Format>(settings, "VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT:
            dump_enum<Format>(settings, "VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDescriptorMappingSourceEXT(const VkDescriptorMappingSourceEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_CONSTANT_OFFSET_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_PUSH_INDEX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_INDIRECT_INDEX_ARRAY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_RESOURCE_HEAP_DATA_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_RESOURCE_HEAP_DATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_DATA_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_DATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_ADDRESS_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_PUSH_ADDRESS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_INDIRECT_ADDRESS_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_INDIRECT_ADDRESS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_HEAP_WITH_SHADER_RECORD_INDEX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_DATA_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_DATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_ADDRESS_EXT:
            dump_enum<Format>(settings, "VK_DESCRIPTOR_MAPPING_SOURCE_SHADER_RECORD_ADDRESS_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkBlendOverlapEXT(const VkBlendOverlapEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_BLEND_OVERLAP_UNCORRELATED_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OVERLAP_UNCORRELATED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OVERLAP_DISJOINT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OVERLAP_DISJOINT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_BLEND_OVERLAP_CONJOINT_EXT:
            dump_enum<Format>(settings, "VK_BLEND_OVERLAP_CONJOINT_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCoverageModulationModeNV(const VkCoverageModulationModeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COVERAGE_MODULATION_MODE_NONE_NV:
            dump_enum<Format>(settings, "VK_COVERAGE_MODULATION_MODE_NONE_NV", static_cast<uint32_t>(object));
            break;
        case VK_COVERAGE_MODULATION_MODE_RGB_NV:
            dump_enum<Format>(settings, "VK_COVERAGE_MODULATION_MODE_RGB_NV", static_cast<uint32_t>(object));
            break;
        case VK_COVERAGE_MODULATION_MODE_ALPHA_NV:
            dump_enum<Format>(settings, "VK_COVERAGE_MODULATION_MODE_ALPHA_NV", static_cast<uint32_t>(object));
            break;
        case VK_COVERAGE_MODULATION_MODE_RGBA_NV:
            dump_enum<Format>(settings, "VK_COVERAGE_MODULATION_MODE_RGBA_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkValidationCacheHeaderVersionEXT(const VkValidationCacheHeaderVersionEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkShadingRatePaletteEntryNV(const VkShadingRatePaletteEntryNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV:
            dump_enum<Format>(settings, "VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCoarseSampleOrderTypeNV(const VkCoarseSampleOrderTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV:
            dump_enum<Format>(settings, "VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV", static_cast<uint32_t>(object));
            break;
        case VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV:
            dump_enum<Format>(settings, "VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV", static_cast<uint32_t>(object));
            break;
        case VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV:
            dump_enum<Format>(settings, "VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV", static_cast<uint32_t>(object));
            break;
        case VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV:
            dump_enum<Format>(settings, "VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkRayTracingShaderGroupTypeKHR(const VkRayTracingShaderGroupTypeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR:
            dump_enum<Format>(settings, "VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR:
            dump_enum<Format>(settings, "VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR", static_cast<uint32_t>(object));
            break;
        case VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR:
            dump_enum<Format>(settings, "VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkGeometryTypeKHR(const VkGeometryTypeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_GEOMETRY_TYPE_TRIANGLES_KHR:
            dump_enum<Format>(settings, "VK_GEOMETRY_TYPE_TRIANGLES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_GEOMETRY_TYPE_AABBS_KHR:
            dump_enum<Format>(settings, "VK_GEOMETRY_TYPE_AABBS_KHR", static_cast<uint32_t>(object));
            break;
        case VK_GEOMETRY_TYPE_INSTANCES_KHR:
            dump_enum<Format>(settings, "VK_GEOMETRY_TYPE_INSTANCES_KHR", static_cast<uint32_t>(object));
            break;
        case VK_GEOMETRY_TYPE_SPHERES_NV:
            dump_enum<Format>(settings, "VK_GEOMETRY_TYPE_SPHERES_NV", static_cast<uint32_t>(object));
            break;
        case VK_GEOMETRY_TYPE_LINEAR_SWEPT_SPHERES_NV:
            dump_enum<Format>(settings, "VK_GEOMETRY_TYPE_LINEAR_SWEPT_SPHERES_NV", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_GEOMETRY_TYPE_DENSE_GEOMETRY_FORMAT_TRIANGLES_AMDX:
            dump_enum<Format>(settings, "VK_GEOMETRY_TYPE_DENSE_GEOMETRY_FORMAT_TRIANGLES_AMDX", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAccelerationStructureTypeKHR(const VkAccelerationStructureTypeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCopyAccelerationStructureModeKHR(const VkCopyAccelerationStructureModeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR:
            dump_enum<Format>(settings, "VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR:
            dump_enum<Format>(settings, "VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR:
            dump_enum<Format>(settings, "VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR:
            dump_enum<Format>(settings, "VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAccelerationStructureMemoryRequirementsTypeNV(const VkAccelerationStructureMemoryRequirementsTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkMemoryOverallocationBehaviorAMD(const VkMemoryOverallocationBehaviorAMD object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD:
            dump_enum<Format>(settings, "VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD", static_cast<uint32_t>(object));
            break;
        case VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD:
            dump_enum<Format>(settings, "VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD", static_cast<uint32_t>(object));
            break;
        case VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD:
            dump_enum<Format>(settings, "VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPerformanceConfigurationTypeINTEL(const VkPerformanceConfigurationTypeINTEL object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkQueryPoolSamplingModeINTEL(const VkQueryPoolSamplingModeINTEL object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL:
            dump_enum<Format>(settings, "VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPerformanceOverrideTypeINTEL(const VkPerformanceOverrideTypeINTEL object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPerformanceParameterTypeINTEL(const VkPerformanceParameterTypeINTEL object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPerformanceValueTypeINTEL(const VkPerformanceValueTypeINTEL object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL", static_cast<uint32_t>(object));
            break;
        case VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL:
            dump_enum<Format>(settings, "VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkValidationFeatureEnableEXT(const VkValidationFeatureEnableEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkValidationFeatureDisableEXT(const VkValidationFeatureDisableEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_VALIDATION_FEATURE_DISABLE_ALL_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_ALL_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT:
            dump_enum<Format>(settings, "VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCoverageReductionModeNV(const VkCoverageReductionModeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COVERAGE_REDUCTION_MODE_MERGE_NV:
            dump_enum<Format>(settings, "VK_COVERAGE_REDUCTION_MODE_MERGE_NV", static_cast<uint32_t>(object));
            break;
        case VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV:
            dump_enum<Format>(settings, "VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkProvokingVertexModeEXT(const VkProvokingVertexModeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT:
            dump_enum<Format>(settings, "VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT:
            dump_enum<Format>(settings, "VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
void dump_VkFullScreenExclusiveEXT(const VkFullScreenExclusiveEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_FULL_SCREEN_EXCLUSIVE_DEFAULT_EXT:
            dump_enum<Format>(settings, "VK_FULL_SCREEN_EXCLUSIVE_DEFAULT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT:
            dump_enum<Format>(settings, "VK_FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT:
            dump_enum<Format>(settings, "VK_FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT:
            dump_enum<Format>(settings, "VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
void dump_VkIndirectCommandsTokenTypeNV(const VkIndirectCommandsTokenTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_DATA_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_DATA_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_NV:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDepthBiasRepresentationEXT(const VkDepthBiasRepresentationEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORMAT_EXT:
            dump_enum<Format>(settings, "VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORMAT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORCE_UNORM_EXT:
            dump_enum<Format>(settings, "VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORCE_UNORM_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEPTH_BIAS_REPRESENTATION_FLOAT_EXT:
            dump_enum<Format>(settings, "VK_DEPTH_BIAS_REPRESENTATION_FLOAT_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDeviceMemoryReportEventTypeEXT(const VkDeviceMemoryReportEventTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkFragmentShadingRateTypeNV(const VkFragmentShadingRateTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkFragmentShadingRateNV(const VkFragmentShadingRateNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV:
            dump_enum<Format>(settings, "VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAccelerationStructureMotionInstanceTypeNV(const VkAccelerationStructureMotionInstanceTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDeviceFaultAddressTypeEXT(const VkDeviceFaultAddressTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEVICE_FAULT_ADDRESS_TYPE_NONE_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_ADDRESS_TYPE_NONE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_FAULT_ADDRESS_TYPE_READ_INVALID_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_ADDRESS_TYPE_READ_INVALID_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_FAULT_ADDRESS_TYPE_WRITE_INVALID_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_ADDRESS_TYPE_WRITE_INVALID_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_FAULT_ADDRESS_TYPE_EXECUTE_INVALID_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_ADDRESS_TYPE_EXECUTE_INVALID_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_UNKNOWN_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_UNKNOWN_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_INVALID_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_INVALID_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_FAULT_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_ADDRESS_TYPE_INSTRUCTION_POINTER_FAULT_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDeviceFaultVendorBinaryHeaderVersionEXT(const VkDeviceFaultVendorBinaryHeaderVersionEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEVICE_FAULT_VENDOR_BINARY_HEADER_VERSION_ONE_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_FAULT_VENDOR_BINARY_HEADER_VERSION_ONE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDeviceAddressBindingTypeEXT(const VkDeviceAddressBindingTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEVICE_ADDRESS_BINDING_TYPE_BIND_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_ADDRESS_BINDING_TYPE_BIND_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEVICE_ADDRESS_BINDING_TYPE_UNBIND_EXT:
            dump_enum<Format>(settings, "VK_DEVICE_ADDRESS_BINDING_TYPE_UNBIND_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkMicromapTypeEXT(const VkMicromapTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_MICROMAP_TYPE_OPACITY_MICROMAP_EXT:
            dump_enum<Format>(settings, "VK_MICROMAP_TYPE_OPACITY_MICROMAP_EXT", static_cast<uint32_t>(object));
            break;
#if defined(VK_ENABLE_BETA_EXTENSIONS)
        case VK_MICROMAP_TYPE_DISPLACEMENT_MICROMAP_NV:
            dump_enum<Format>(settings, "VK_MICROMAP_TYPE_DISPLACEMENT_MICROMAP_NV", static_cast<uint32_t>(object));
            break;
#endif  // VK_ENABLE_BETA_EXTENSIONS
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkBuildMicromapModeEXT(const VkBuildMicromapModeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_BUILD_MICROMAP_MODE_BUILD_EXT:
            dump_enum<Format>(settings, "VK_BUILD_MICROMAP_MODE_BUILD_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCopyMicromapModeEXT(const VkCopyMicromapModeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COPY_MICROMAP_MODE_CLONE_EXT:
            dump_enum<Format>(settings, "VK_COPY_MICROMAP_MODE_CLONE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COPY_MICROMAP_MODE_SERIALIZE_EXT:
            dump_enum<Format>(settings, "VK_COPY_MICROMAP_MODE_SERIALIZE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COPY_MICROMAP_MODE_DESERIALIZE_EXT:
            dump_enum<Format>(settings, "VK_COPY_MICROMAP_MODE_DESERIALIZE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_COPY_MICROMAP_MODE_COMPACT_EXT:
            dump_enum<Format>(settings, "VK_COPY_MICROMAP_MODE_COMPACT_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkOpacityMicromapFormatEXT(const VkOpacityMicromapFormatEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_OPACITY_MICROMAP_FORMAT_2_STATE_EXT:
            dump_enum<Format>(settings, "VK_OPACITY_MICROMAP_FORMAT_2_STATE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OPACITY_MICROMAP_FORMAT_4_STATE_EXT:
            dump_enum<Format>(settings, "VK_OPACITY_MICROMAP_FORMAT_4_STATE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkOpacityMicromapSpecialIndexEXT(const VkOpacityMicromapSpecialIndexEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_TRANSPARENT_EXT:
            dump_enum<Format>(settings, "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_TRANSPARENT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_OPAQUE_EXT:
            dump_enum<Format>(settings, "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_OPAQUE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_TRANSPARENT_EXT:
            dump_enum<Format>(settings, "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_TRANSPARENT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_OPAQUE_EXT:
            dump_enum<Format>(settings, "VK_OPACITY_MICROMAP_SPECIAL_INDEX_FULLY_UNKNOWN_OPAQUE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_OPACITY_MICROMAP_SPECIAL_INDEX_CLUSTER_GEOMETRY_DISABLE_OPACITY_MICROMAP_NV:
            dump_enum<Format>(settings, "VK_OPACITY_MICROMAP_SPECIAL_INDEX_CLUSTER_GEOMETRY_DISABLE_OPACITY_MICROMAP_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAccelerationStructureCompatibilityKHR(const VkAccelerationStructureCompatibilityKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAccelerationStructureBuildTypeKHR(const VkAccelerationStructureBuildTypeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR", static_cast<uint32_t>(object));
            break;
        case VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR:
            dump_enum<Format>(settings, "VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
template <ApiDumpFormat Format>
void dump_VkDisplacementMicromapFormatNV(const VkDisplacementMicromapFormatNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DISPLACEMENT_MICROMAP_FORMAT_64_TRIANGLES_64_BYTES_NV:
            dump_enum<Format>(settings, "VK_DISPLACEMENT_MICROMAP_FORMAT_64_TRIANGLES_64_BYTES_NV", static_cast<uint32_t>(object));
            break;
        case VK_DISPLACEMENT_MICROMAP_FORMAT_256_TRIANGLES_128_BYTES_NV:
            dump_enum<Format>(settings, "VK_DISPLACEMENT_MICROMAP_FORMAT_256_TRIANGLES_128_BYTES_NV", static_cast<uint32_t>(object));
            break;
        case VK_DISPLACEMENT_MICROMAP_FORMAT_1024_TRIANGLES_128_BYTES_NV:
            dump_enum<Format>(settings, "VK_DISPLACEMENT_MICROMAP_FORMAT_1024_TRIANGLES_128_BYTES_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#endif  // VK_ENABLE_BETA_EXTENSIONS
template <ApiDumpFormat Format>
void dump_VkRayTracingLssIndexingModeNV(const VkRayTracingLssIndexingModeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_RAY_TRACING_LSS_INDEXING_MODE_LIST_NV:
            dump_enum<Format>(settings, "VK_RAY_TRACING_LSS_INDEXING_MODE_LIST_NV", static_cast<uint32_t>(object));
            break;
        case VK_RAY_TRACING_LSS_INDEXING_MODE_SUCCESSIVE_NV:
            dump_enum<Format>(settings, "VK_RAY_TRACING_LSS_INDEXING_MODE_SUCCESSIVE_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkRayTracingLssPrimitiveEndCapsModeNV(const VkRayTracingLssPrimitiveEndCapsModeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_RAY_TRACING_LSS_PRIMITIVE_END_CAPS_MODE_NONE_NV:
            dump_enum<Format>(settings, "VK_RAY_TRACING_LSS_PRIMITIVE_END_CAPS_MODE_NONE_NV", static_cast<uint32_t>(object));
            break;
        case VK_RAY_TRACING_LSS_PRIMITIVE_END_CAPS_MODE_CHAINED_NV:
            dump_enum<Format>(settings, "VK_RAY_TRACING_LSS_PRIMITIVE_END_CAPS_MODE_CHAINED_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkSubpassMergeStatusEXT(const VkSubpassMergeStatusEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SUBPASS_MERGE_STATUS_MERGED_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_MERGED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_DISALLOWED_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_DISALLOWED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SIDE_EFFECTS_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SIDE_EFFECTS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SAMPLES_MISMATCH_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SAMPLES_MISMATCH_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_VIEWS_MISMATCH_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_VIEWS_MISMATCH_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_ALIASING_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_ALIASING_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPENDENCIES_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPENDENCIES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INCOMPATIBLE_INPUT_ATTACHMENT_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INCOMPATIBLE_INPUT_ATTACHMENT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_TOO_MANY_ATTACHMENTS_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_TOO_MANY_ATTACHMENTS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INSUFFICIENT_STORAGE_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_INSUFFICIENT_STORAGE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPTH_STENCIL_COUNT_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_DEPTH_STENCIL_COUNT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_RESOLVE_ATTACHMENT_REUSE_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_RESOLVE_ATTACHMENT_REUSE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SINGLE_SUBPASS_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_SINGLE_SUBPASS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SUBPASS_MERGE_STATUS_NOT_MERGED_UNSPECIFIED_EXT:
            dump_enum<Format>(settings, "VK_SUBPASS_MERGE_STATUS_NOT_MERGED_UNSPECIFIED_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDirectDriverLoadingModeLUNARG(const VkDirectDriverLoadingModeLUNARG object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DIRECT_DRIVER_LOADING_MODE_EXCLUSIVE_LUNARG:
            dump_enum<Format>(settings, "VK_DIRECT_DRIVER_LOADING_MODE_EXCLUSIVE_LUNARG", static_cast<uint32_t>(object));
            break;
        case VK_DIRECT_DRIVER_LOADING_MODE_INCLUSIVE_LUNARG:
            dump_enum<Format>(settings, "VK_DIRECT_DRIVER_LOADING_MODE_INCLUSIVE_LUNARG", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkTensorTilingARM(const VkTensorTilingARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_TENSOR_TILING_OPTIMAL_ARM:
            dump_enum<Format>(settings, "VK_TENSOR_TILING_OPTIMAL_ARM", static_cast<uint32_t>(object));
            break;
        case VK_TENSOR_TILING_LINEAR_ARM:
            dump_enum<Format>(settings, "VK_TENSOR_TILING_LINEAR_ARM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkOpticalFlowPerformanceLevelNV(const VkOpticalFlowPerformanceLevelNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_UNKNOWN_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_UNKNOWN_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_SLOW_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_SLOW_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_MEDIUM_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_MEDIUM_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_FAST_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_PERFORMANCE_LEVEL_FAST_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkOpticalFlowSessionBindingPointNV(const VkOpticalFlowSessionBindingPointNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_UNKNOWN_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_UNKNOWN_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_INPUT_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_INPUT_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_REFERENCE_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_REFERENCE_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_HINT_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_HINT_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_FLOW_VECTOR_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_FLOW_VECTOR_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_FLOW_VECTOR_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_FLOW_VECTOR_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_COST_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_COST_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_COST_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_BACKWARD_COST_NV", static_cast<uint32_t>(object));
            break;
        case VK_OPTICAL_FLOW_SESSION_BINDING_POINT_GLOBAL_FLOW_NV:
            dump_enum<Format>(settings, "VK_OPTICAL_FLOW_SESSION_BINDING_POINT_GLOBAL_FLOW_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAntiLagModeAMD(const VkAntiLagModeAMD object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ANTI_LAG_MODE_DRIVER_CONTROL_AMD:
            dump_enum<Format>(settings, "VK_ANTI_LAG_MODE_DRIVER_CONTROL_AMD", static_cast<uint32_t>(object));
            break;
        case VK_ANTI_LAG_MODE_ON_AMD:
            dump_enum<Format>(settings, "VK_ANTI_LAG_MODE_ON_AMD", static_cast<uint32_t>(object));
            break;
        case VK_ANTI_LAG_MODE_OFF_AMD:
            dump_enum<Format>(settings, "VK_ANTI_LAG_MODE_OFF_AMD", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkAntiLagStageAMD(const VkAntiLagStageAMD object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_ANTI_LAG_STAGE_INPUT_AMD:
            dump_enum<Format>(settings, "VK_ANTI_LAG_STAGE_INPUT_AMD", static_cast<uint32_t>(object));
            break;
        case VK_ANTI_LAG_STAGE_PRESENT_AMD:
            dump_enum<Format>(settings, "VK_ANTI_LAG_STAGE_PRESENT_AMD", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
template <ApiDumpFormat Format>
void dump_VkCompressedTriangleFormatAMDX(const VkCompressedTriangleFormatAMDX object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COMPRESSED_TRIANGLE_FORMAT_DGF1_AMDX:
            dump_enum<Format>(settings, "VK_COMPRESSED_TRIANGLE_FORMAT_DGF1_AMDX", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#endif  // VK_ENABLE_BETA_EXTENSIONS
template <ApiDumpFormat Format>
void dump_VkShaderCodeTypeEXT(const VkShaderCodeTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SHADER_CODE_TYPE_BINARY_EXT:
            dump_enum<Format>(settings, "VK_SHADER_CODE_TYPE_BINARY_EXT", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_CODE_TYPE_SPIRV_EXT:
            dump_enum<Format>(settings, "VK_SHADER_CODE_TYPE_SPIRV_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDepthClampModeEXT(const VkDepthClampModeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DEPTH_CLAMP_MODE_VIEWPORT_RANGE_EXT:
            dump_enum<Format>(settings, "VK_DEPTH_CLAMP_MODE_VIEWPORT_RANGE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_DEPTH_CLAMP_MODE_USER_DEFINED_RANGE_EXT:
            dump_enum<Format>(settings, "VK_DEPTH_CLAMP_MODE_USER_DEFINED_RANGE_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkRayTracingInvocationReorderModeEXT(const VkRayTracingInvocationReorderModeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_RAY_TRACING_INVOCATION_REORDER_MODE_NONE_EXT:
            dump_enum<Format>(settings, "VK_RAY_TRACING_INVOCATION_REORDER_MODE_NONE_EXT", static_cast<uint32_t>(object));
            break;
        case VK_RAY_TRACING_INVOCATION_REORDER_MODE_REORDER_EXT:
            dump_enum<Format>(settings, "VK_RAY_TRACING_INVOCATION_REORDER_MODE_REORDER_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCooperativeVectorMatrixLayoutNV(const VkCooperativeVectorMatrixLayoutNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_ROW_MAJOR_NV:
            dump_enum<Format>(settings, "VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_ROW_MAJOR_NV", static_cast<uint32_t>(object));
            break;
        case VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_COLUMN_MAJOR_NV:
            dump_enum<Format>(settings, "VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_COLUMN_MAJOR_NV", static_cast<uint32_t>(object));
            break;
        case VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_INFERENCING_OPTIMAL_NV:
            dump_enum<Format>(settings, "VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_INFERENCING_OPTIMAL_NV", static_cast<uint32_t>(object));
            break;
        case VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_TRAINING_OPTIMAL_NV:
            dump_enum<Format>(settings, "VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_TRAINING_OPTIMAL_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkLayerSettingTypeEXT(const VkLayerSettingTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_LAYER_SETTING_TYPE_BOOL32_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_BOOL32_EXT", static_cast<uint32_t>(object));
            break;
        case VK_LAYER_SETTING_TYPE_INT32_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_INT32_EXT", static_cast<uint32_t>(object));
            break;
        case VK_LAYER_SETTING_TYPE_INT64_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_INT64_EXT", static_cast<uint32_t>(object));
            break;
        case VK_LAYER_SETTING_TYPE_UINT32_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_UINT32_EXT", static_cast<uint32_t>(object));
            break;
        case VK_LAYER_SETTING_TYPE_UINT64_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_UINT64_EXT", static_cast<uint32_t>(object));
            break;
        case VK_LAYER_SETTING_TYPE_FLOAT32_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_FLOAT32_EXT", static_cast<uint32_t>(object));
            break;
        case VK_LAYER_SETTING_TYPE_FLOAT64_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_FLOAT64_EXT", static_cast<uint32_t>(object));
            break;
        case VK_LAYER_SETTING_TYPE_STRING_EXT:
            dump_enum<Format>(settings, "VK_LAYER_SETTING_TYPE_STRING_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkLatencyMarkerNV(const VkLatencyMarkerNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_LATENCY_MARKER_SIMULATION_START_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_SIMULATION_START_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_SIMULATION_END_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_SIMULATION_END_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_RENDERSUBMIT_START_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_RENDERSUBMIT_START_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_RENDERSUBMIT_END_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_RENDERSUBMIT_END_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_PRESENT_START_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_PRESENT_START_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_PRESENT_END_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_PRESENT_END_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_INPUT_SAMPLE_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_INPUT_SAMPLE_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_TRIGGER_FLASH_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_TRIGGER_FLASH_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_OUT_OF_BAND_RENDERSUBMIT_START_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_OUT_OF_BAND_RENDERSUBMIT_START_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_OUT_OF_BAND_RENDERSUBMIT_END_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_OUT_OF_BAND_RENDERSUBMIT_END_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_OUT_OF_BAND_PRESENT_START_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_OUT_OF_BAND_PRESENT_START_NV", static_cast<uint32_t>(object));
            break;
        case VK_LATENCY_MARKER_OUT_OF_BAND_PRESENT_END_NV:
            dump_enum<Format>(settings, "VK_LATENCY_MARKER_OUT_OF_BAND_PRESENT_END_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkOutOfBandQueueTypeNV(const VkOutOfBandQueueTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_OUT_OF_BAND_QUEUE_TYPE_RENDER_NV:
            dump_enum<Format>(settings, "VK_OUT_OF_BAND_QUEUE_TYPE_RENDER_NV", static_cast<uint32_t>(object));
            break;
        case VK_OUT_OF_BAND_QUEUE_TYPE_PRESENT_NV:
            dump_enum<Format>(settings, "VK_OUT_OF_BAND_QUEUE_TYPE_PRESENT_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDataGraphPipelineSessionBindPointARM(const VkDataGraphPipelineSessionBindPointARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_TRANSIENT_ARM:
            dump_enum<Format>(settings, "VK_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_TRANSIENT_ARM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDataGraphPipelineSessionBindPointTypeARM(const VkDataGraphPipelineSessionBindPointTypeARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_TYPE_MEMORY_ARM:
            dump_enum<Format>(settings, "VK_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_TYPE_MEMORY_ARM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDataGraphPipelinePropertyARM(const VkDataGraphPipelinePropertyARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DATA_GRAPH_PIPELINE_PROPERTY_CREATION_LOG_ARM:
            dump_enum<Format>(settings, "VK_DATA_GRAPH_PIPELINE_PROPERTY_CREATION_LOG_ARM", static_cast<uint32_t>(object));
            break;
        case VK_DATA_GRAPH_PIPELINE_PROPERTY_IDENTIFIER_ARM:
            dump_enum<Format>(settings, "VK_DATA_GRAPH_PIPELINE_PROPERTY_IDENTIFIER_ARM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPhysicalDeviceDataGraphProcessingEngineTypeARM(const VkPhysicalDeviceDataGraphProcessingEngineTypeARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_DEFAULT_ARM:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_DEFAULT_ARM", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_NEURAL_QCOM:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_NEURAL_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_COMPUTE_QCOM:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_DATA_GRAPH_PROCESSING_ENGINE_TYPE_COMPUTE_QCOM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPhysicalDeviceDataGraphOperationTypeARM(const VkPhysicalDeviceDataGraphOperationTypeARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PHYSICAL_DEVICE_DATA_GRAPH_OPERATION_TYPE_SPIRV_EXTENDED_INSTRUCTION_SET_ARM:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_DATA_GRAPH_OPERATION_TYPE_SPIRV_EXTENDED_INSTRUCTION_SET_ARM", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_DATA_GRAPH_OPERATION_TYPE_NEURAL_MODEL_QCOM:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_DATA_GRAPH_OPERATION_TYPE_NEURAL_MODEL_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_PHYSICAL_DEVICE_DATA_GRAPH_OPERATION_TYPE_BUILTIN_MODEL_QCOM:
            dump_enum<Format>(settings, "VK_PHYSICAL_DEVICE_DATA_GRAPH_OPERATION_TYPE_BUILTIN_MODEL_QCOM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkBlockMatchWindowCompareModeQCOM(const VkBlockMatchWindowCompareModeQCOM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_BLOCK_MATCH_WINDOW_COMPARE_MODE_MIN_QCOM:
            dump_enum<Format>(settings, "VK_BLOCK_MATCH_WINDOW_COMPARE_MODE_MIN_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_BLOCK_MATCH_WINDOW_COMPARE_MODE_MAX_QCOM:
            dump_enum<Format>(settings, "VK_BLOCK_MATCH_WINDOW_COMPARE_MODE_MAX_QCOM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkCubicFilterWeightsQCOM(const VkCubicFilterWeightsQCOM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_CUBIC_FILTER_WEIGHTS_CATMULL_ROM_QCOM:
            dump_enum<Format>(settings, "VK_CUBIC_FILTER_WEIGHTS_CATMULL_ROM_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_CUBIC_FILTER_WEIGHTS_ZERO_TANGENT_CARDINAL_QCOM:
            dump_enum<Format>(settings, "VK_CUBIC_FILTER_WEIGHTS_ZERO_TANGENT_CARDINAL_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_CUBIC_FILTER_WEIGHTS_B_SPLINE_QCOM:
            dump_enum<Format>(settings, "VK_CUBIC_FILTER_WEIGHTS_B_SPLINE_QCOM", static_cast<uint32_t>(object));
            break;
        case VK_CUBIC_FILTER_WEIGHTS_MITCHELL_NETRAVALI_QCOM:
            dump_enum<Format>(settings, "VK_CUBIC_FILTER_WEIGHTS_MITCHELL_NETRAVALI_QCOM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkLayeredDriverUnderlyingApiMSFT(const VkLayeredDriverUnderlyingApiMSFT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_LAYERED_DRIVER_UNDERLYING_API_NONE_MSFT:
            dump_enum<Format>(settings, "VK_LAYERED_DRIVER_UNDERLYING_API_NONE_MSFT", static_cast<uint32_t>(object));
            break;
        case VK_LAYERED_DRIVER_UNDERLYING_API_D3D12_MSFT:
            dump_enum<Format>(settings, "VK_LAYERED_DRIVER_UNDERLYING_API_D3D12_MSFT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDisplaySurfaceStereoTypeNV(const VkDisplaySurfaceStereoTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DISPLAY_SURFACE_STEREO_TYPE_NONE_NV:
            dump_enum<Format>(settings, "VK_DISPLAY_SURFACE_STEREO_TYPE_NONE_NV", static_cast<uint32_t>(object));
            break;
        case VK_DISPLAY_SURFACE_STEREO_TYPE_ONBOARD_DIN_NV:
            dump_enum<Format>(settings, "VK_DISPLAY_SURFACE_STEREO_TYPE_ONBOARD_DIN_NV", static_cast<uint32_t>(object));
            break;
        case VK_DISPLAY_SURFACE_STEREO_TYPE_HDMI_3D_NV:
            dump_enum<Format>(settings, "VK_DISPLAY_SURFACE_STEREO_TYPE_HDMI_3D_NV", static_cast<uint32_t>(object));
            break;
        case VK_DISPLAY_SURFACE_STEREO_TYPE_INBAND_DISPLAYPORT_NV:
            dump_enum<Format>(settings, "VK_DISPLAY_SURFACE_STEREO_TYPE_INBAND_DISPLAYPORT_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkClusterAccelerationStructureTypeNV(const VkClusterAccelerationStructureTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_CLUSTERS_BOTTOM_LEVEL_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_CLUSTERS_BOTTOM_LEVEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_TRIANGLE_CLUSTER_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_TRIANGLE_CLUSTER_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_TRIANGLE_CLUSTER_TEMPLATE_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_TYPE_TRIANGLE_CLUSTER_TEMPLATE_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkClusterAccelerationStructureOpTypeNV(const VkClusterAccelerationStructureOpTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_CLUSTERS_BOTTOM_LEVEL_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_CLUSTERS_BOTTOM_LEVEL_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_TEMPLATE_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_TEMPLATE_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_INSTANTIATE_TRIANGLE_CLUSTER_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_INSTANTIATE_TRIANGLE_CLUSTER_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_GET_CLUSTER_TEMPLATE_INDICES_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_GET_CLUSTER_TEMPLATE_INDICES_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkClusterAccelerationStructureOpModeNV(const VkClusterAccelerationStructureOpModeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV", static_cast<uint32_t>(object));
            break;
        case VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_COMPUTE_SIZES_NV:
            dump_enum<Format>(settings, "VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_COMPUTE_SIZES_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkPartitionedAccelerationStructureOpTypeNV(const VkPartitionedAccelerationStructureOpTypeNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_WRITE_INSTANCE_NV:
            dump_enum<Format>(settings, "VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_WRITE_INSTANCE_NV", static_cast<uint32_t>(object));
            break;
        case VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_UPDATE_INSTANCE_NV:
            dump_enum<Format>(settings, "VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_UPDATE_INSTANCE_NV", static_cast<uint32_t>(object));
            break;
        case VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_WRITE_PARTITION_TRANSLATION_NV:
            dump_enum<Format>(settings, "VK_PARTITIONED_ACCELERATION_STRUCTURE_OP_TYPE_WRITE_PARTITION_TRANSLATION_NV", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkIndirectExecutionSetInfoTypeEXT(const VkIndirectExecutionSetInfoTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_INDIRECT_EXECUTION_SET_INFO_TYPE_PIPELINES_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_EXECUTION_SET_INFO_TYPE_PIPELINES_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_EXECUTION_SET_INFO_TYPE_SHADER_OBJECTS_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_EXECUTION_SET_INFO_TYPE_SHADER_OBJECTS_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkIndirectCommandsTokenTypeEXT(const VkIndirectCommandsTokenTypeEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_SEQUENCE_INDEX_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_SEQUENCE_INDEX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_COUNT_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_COUNT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_COUNT_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_COUNT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DISPATCH_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_DATA_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_DATA_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_DATA_SEQUENCE_INDEX_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_DATA_SEQUENCE_INDEX_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_COUNT_NV_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_COUNT_NV_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_COUNT_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_COUNT_EXT", static_cast<uint32_t>(object));
            break;
        case VK_INDIRECT_COMMANDS_TOKEN_TYPE_TRACE_RAYS2_EXT:
            dump_enum<Format>(settings, "VK_INDIRECT_COMMANDS_TOKEN_TYPE_TRACE_RAYS2_EXT", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDataGraphModelCacheTypeQCOM(const VkDataGraphModelCacheTypeQCOM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_DATA_GRAPH_MODEL_CACHE_TYPE_GENERIC_BINARY_QCOM:
            dump_enum<Format>(settings, "VK_DATA_GRAPH_MODEL_CACHE_TYPE_GENERIC_BINARY_QCOM", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkBuildAccelerationStructureModeKHR(const VkBuildAccelerationStructureModeKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR:
            dump_enum<Format>(settings, "VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR", static_cast<uint32_t>(object));
            break;
        case VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR:
            dump_enum<Format>(settings, "VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkShaderGroupShaderKHR(const VkShaderGroupShaderKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    switch ((int64_t)object) {
        case VK_SHADER_GROUP_SHADER_GENERAL_KHR:
            dump_enum<Format>(settings, "VK_SHADER_GROUP_SHADER_GENERAL_KHR", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR:
            dump_enum<Format>(settings, "VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_GROUP_SHADER_ANY_HIT_KHR:
            dump_enum<Format>(settings, "VK_SHADER_GROUP_SHADER_ANY_HIT_KHR", static_cast<uint32_t>(object));
            break;
        case VK_SHADER_GROUP_SHADER_INTERSECTION_KHR:
            dump_enum<Format>(settings, "VK_SHADER_GROUP_SHADER_INTERSECTION_KHR", static_cast<uint32_t>(object));
            break;
        default:
            dump_enum_with_value<Format>(settings, "UNKNOWN", static_cast<uint32_t>(object));
    }
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

//========================= Bitmask Implementations =========================//

template <ApiDumpFormat Format>
void dump_VkAccessFlagBits(const VkAccessFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_ACCESS_INDIRECT_COMMAND_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INDIRECT_COMMAND_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_INDEX_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INDEX_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_UNIFORM_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_UNIFORM_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_INPUT_ATTACHMENT_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_INPUT_ATTACHMENT_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_SHADER_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_SHADER_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_SHADER_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_SHADER_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_COLOR_ATTACHMENT_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_TRANSFER_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFER_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_TRANSFER_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFER_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_HOST_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_HOST_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_HOST_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_HOST_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_MEMORY_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_MEMORY_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_MEMORY_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_MEMORY_WRITE_BIT";
        is_first = false;
    }
    if (object == VK_ACCESS_NONE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_NONE";
        is_first = false;
    }
    if (object & VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkImageAspectFlagBits(const VkImageAspectFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_IMAGE_ASPECT_COLOR_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_COLOR_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_DEPTH_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_DEPTH_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_STENCIL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_STENCIL_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_METADATA_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_METADATA_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_PLANE_0_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_0_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_PLANE_1_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_1_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_PLANE_2_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_PLANE_2_BIT";
        is_first = false;
    }
    if (object == VK_IMAGE_ASPECT_NONE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_NONE";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkFormatFeatureFlagBits(const VkFormatFeatureFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_BLIT_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_BLIT_SRC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_BLIT_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_BLIT_DST_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_TRANSFER_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_TRANSFER_SRC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_TRANSFER_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_TRANSFER_DST_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_DISJOINT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_DISJOINT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkImageCreateFlagBits(const VkImageCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_IMAGE_CREATE_SPARSE_BINDING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_BINDING_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_SPARSE_ALIASED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPARSE_ALIASED_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_ALIAS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_ALIAS_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_EXTENDED_USAGE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_EXTENDED_USAGE_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_PROTECTED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_PROTECTED_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_DISJOINT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_DISJOINT_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSampleCountFlagBits(const VkSampleCountFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SAMPLE_COUNT_1_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_1_BIT";
        is_first = false;
    }
    if (object & VK_SAMPLE_COUNT_2_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_2_BIT";
        is_first = false;
    }
    if (object & VK_SAMPLE_COUNT_4_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_4_BIT";
        is_first = false;
    }
    if (object & VK_SAMPLE_COUNT_8_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_8_BIT";
        is_first = false;
    }
    if (object & VK_SAMPLE_COUNT_16_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_16_BIT";
        is_first = false;
    }
    if (object & VK_SAMPLE_COUNT_32_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_32_BIT";
        is_first = false;
    }
    if (object & VK_SAMPLE_COUNT_64_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLE_COUNT_64_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkImageUsageFlagBits(const VkImageUsageFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_IMAGE_USAGE_TRANSFER_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSFER_SRC_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_TRANSFER_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSFER_DST_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_SAMPLED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLED_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_STORAGE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_STORAGE_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_HOST_TRANSFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_HOST_TRANSFER_BIT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLE_WEIGHT_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_SAMPLE_BLOCK_MATCH_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_TENSOR_ALIASING_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TENSOR_ALIASING_BIT_ARM";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_TILE_MEMORY_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_TILE_MEMORY_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkInstanceCreateFlagBits(const VkInstanceCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkMemoryHeapFlagBits(const VkMemoryHeapFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_MEMORY_HEAP_DEVICE_LOCAL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_DEVICE_LOCAL_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_HEAP_MULTI_INSTANCE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_MULTI_INSTANCE_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkMemoryPropertyFlagBits(const VkMemoryPropertyFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_HOST_COHERENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_COHERENT_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_HOST_CACHED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_HOST_CACHED_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_PROTECTED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_PROTECTED_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD";
        is_first = false;
    }
    if (object & VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkQueueFlagBits(const VkQueueFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_QUEUE_GRAPHICS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_GRAPHICS_BIT";
        is_first = false;
    }
    if (object & VK_QUEUE_COMPUTE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_COMPUTE_BIT";
        is_first = false;
    }
    if (object & VK_QUEUE_TRANSFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_TRANSFER_BIT";
        is_first = false;
    }
    if (object & VK_QUEUE_SPARSE_BINDING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_SPARSE_BINDING_BIT";
        is_first = false;
    }
    if (object & VK_QUEUE_PROTECTED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_PROTECTED_BIT";
        is_first = false;
    }
    if (object & VK_QUEUE_VIDEO_DECODE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_VIDEO_DECODE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_QUEUE_VIDEO_ENCODE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_VIDEO_ENCODE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_QUEUE_OPTICAL_FLOW_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_OPTICAL_FLOW_BIT_NV";
        is_first = false;
    }
    if (object & VK_QUEUE_DATA_GRAPH_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUEUE_DATA_GRAPH_BIT_ARM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDeviceQueueCreateFlagBits(const VkDeviceQueueCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT";
        is_first = false;
    }
    if (object & VK_DEVICE_QUEUE_CREATE_INTERNALLY_SYNCHRONIZED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_QUEUE_CREATE_INTERNALLY_SYNCHRONIZED_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineStageFlagBits(const VkPipelineStageFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_VERTEX_INPUT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_VERTEX_INPUT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_VERTEX_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_VERTEX_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_TRANSFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TRANSFER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_HOST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_HOST_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_ALL_COMMANDS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ALL_COMMANDS_BIT";
        is_first = false;
    }
    if (object == VK_PIPELINE_STAGE_NONE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_NONE";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_TASK_SHADER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_TASK_SHADER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_MESH_SHADER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_MESH_SHADER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkMemoryMapFlagBits(const VkMemoryMapFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_MEMORY_MAP_PLACED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_MAP_PLACED_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSparseMemoryBindFlagBits(const VkSparseMemoryBindFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SPARSE_MEMORY_BIND_METADATA_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_MEMORY_BIND_METADATA_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSparseImageFormatFlagBits(const VkSparseImageFormatFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT";
        is_first = false;
    }
    if (object & VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT";
        is_first = false;
    }
    if (object & VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkFenceCreateFlagBits(const VkFenceCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_FENCE_CREATE_SIGNALED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FENCE_CREATE_SIGNALED_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkQueryPoolCreateFlagBits(const VkQueryPoolCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_QUERY_POOL_CREATE_RESET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_POOL_CREATE_RESET_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkQueryPipelineStatisticFlagBits(const VkQueryPipelineStatisticFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_TASK_SHADER_INVOCATIONS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_MESH_SHADER_INVOCATIONS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_QUERY_PIPELINE_STATISTIC_CLUSTER_CULLING_SHADER_INVOCATIONS_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_PIPELINE_STATISTIC_CLUSTER_CULLING_SHADER_INVOCATIONS_BIT_HUAWEI";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkQueryResultFlagBits(const VkQueryResultFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_QUERY_RESULT_64_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_64_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_RESULT_WAIT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WAIT_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_RESULT_WITH_AVAILABILITY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WITH_AVAILABILITY_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_RESULT_PARTIAL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_PARTIAL_BIT";
        is_first = false;
    }
    if (object & VK_QUERY_RESULT_WITH_STATUS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_RESULT_WITH_STATUS_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkBufferCreateFlagBits(const VkBufferCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_BUFFER_CREATE_SPARSE_BINDING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_BINDING_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_CREATE_SPARSE_ALIASED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_SPARSE_ALIASED_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_CREATE_PROTECTED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_PROTECTED_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkBufferUsageFlagBits(const VkBufferUsageFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_BUFFER_USAGE_TRANSFER_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFER_SRC_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_TRANSFER_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFER_DST_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_STORAGE_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_STORAGE_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_INDEX_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_INDEX_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_VERTEX_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VERTEX_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_EXECUTION_GRAPH_SCRATCH_BIT_AMDX) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_EXECUTION_GRAPH_SCRATCH_BIT_AMDX";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_DESCRIPTOR_HEAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_DESCRIPTOR_HEAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkImageViewCreateFlagBits(const VkImageViewCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDependencyFlagBits(const VkDependencyFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEPENDENCY_BY_REGION_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_BY_REGION_BIT";
        is_first = false;
    }
    if (object & VK_DEPENDENCY_DEVICE_GROUP_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_DEVICE_GROUP_BIT";
        is_first = false;
    }
    if (object & VK_DEPENDENCY_VIEW_LOCAL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_VIEW_LOCAL_BIT";
        is_first = false;
    }
    if (object & VK_DEPENDENCY_FEEDBACK_LOOP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_FEEDBACK_LOOP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEPENDENCY_QUEUE_FAMILY_OWNERSHIP_TRANSFER_USE_ALL_STAGES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_QUEUE_FAMILY_OWNERSHIP_TRANSFER_USE_ALL_STAGES_BIT_KHR";
        is_first = false;
    }
    if (object & VK_DEPENDENCY_ASYMMETRIC_EVENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEPENDENCY_ASYMMETRIC_EVENT_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkCommandPoolCreateFlagBits(const VkCommandPoolCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_COMMAND_POOL_CREATE_TRANSIENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_TRANSIENT_BIT";
        is_first = false;
    }
    if (object & VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_COMMAND_POOL_CREATE_PROTECTED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_CREATE_PROTECTED_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkCommandPoolResetFlagBits(const VkCommandPoolResetFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkCommandBufferUsageFlagBits(const VkCommandBufferUsageFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT";
        is_first = false;
    }
    if (object & VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT";
        is_first = false;
    }
    if (object & VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkQueryControlFlagBits(const VkQueryControlFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_QUERY_CONTROL_PRECISE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_QUERY_CONTROL_PRECISE_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkCommandBufferResetFlagBits(const VkCommandBufferResetFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkEventCreateFlagBits(const VkEventCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EVENT_CREATE_DEVICE_ONLY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EVENT_CREATE_DEVICE_ONLY_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineCacheCreateFlagBits(const VkPipelineCacheCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CACHE_CREATE_INTERNALLY_SYNCHRONIZED_MERGE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CACHE_CREATE_INTERNALLY_SYNCHRONIZED_MERGE_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineCreateFlagBits(const VkPipelineCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_DERIVATIVE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DERIVATIVE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_DISPATCH_BASE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DISPATCH_BASE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_LIBRARY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_LIBRARY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineShaderStageCreateFlagBits(const VkPipelineShaderStageCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkShaderStageFlagBits(const VkShaderStageFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SHADER_STAGE_VERTEX_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_VERTEX_BIT";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_GEOMETRY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_GEOMETRY_BIT";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_FRAGMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_FRAGMENT_BIT";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_COMPUTE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_COMPUTE_BIT";
        is_first = false;
    }
    if (object == VK_SHADER_STAGE_ALL_GRAPHICS) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ALL_GRAPHICS";
        is_first = false;
    }
    if (object == VK_SHADER_STAGE_ALL) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ALL";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_RAYGEN_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_RAYGEN_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_ANY_HIT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_ANY_HIT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_MISS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_MISS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_INTERSECTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_INTERSECTION_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_CALLABLE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CALLABLE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_TASK_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_TASK_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_MESH_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_MESH_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI";
        is_first = false;
    }
    if (object & VK_SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_STAGE_CLUSTER_CULLING_BIT_HUAWEI";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineLayoutCreateFlagBits(const VkPipelineLayoutCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSamplerCreateFlagBits(const VkSamplerCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SAMPLER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SAMPLER_CREATE_NON_SEAMLESS_CUBE_MAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_NON_SEAMLESS_CUBE_MAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SAMPLER_CREATE_IMAGE_PROCESSING_BIT_QCOM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDescriptorPoolCreateFlagBits(const VkDescriptorPoolCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDescriptorSetLayoutCreateFlagBits(const VkDescriptorSetLayoutCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_SET_LAYOUT_CREATE_INDIRECT_BINDABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_INDIRECT_BINDABLE_BIT_NV";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkColorComponentFlagBits(const VkColorComponentFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_COLOR_COMPONENT_R_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_R_BIT";
        is_first = false;
    }
    if (object & VK_COLOR_COMPONENT_G_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_G_BIT";
        is_first = false;
    }
    if (object & VK_COLOR_COMPONENT_B_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_B_BIT";
        is_first = false;
    }
    if (object & VK_COLOR_COMPONENT_A_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COLOR_COMPONENT_A_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkCullModeFlagBits(const VkCullModeFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_CULL_MODE_NONE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_NONE";
        is_first = false;
    }
    if (object & VK_CULL_MODE_FRONT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_FRONT_BIT";
        is_first = false;
    }
    if (object & VK_CULL_MODE_BACK_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_BACK_BIT";
        is_first = false;
    }
    if (object == VK_CULL_MODE_FRONT_AND_BACK) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CULL_MODE_FRONT_AND_BACK";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineDepthStencilStateCreateFlagBits(const VkPipelineDepthStencilStateCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineColorBlendStateCreateFlagBits(const VkPipelineColorBlendStateCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkAttachmentDescriptionFlagBits(const VkAttachmentDescriptionFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT";
        is_first = false;
    }
    if (object & VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ATTACHMENT_DESCRIPTION_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ATTACHMENT_DESCRIPTION_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkFramebufferCreateFlagBits(const VkFramebufferCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkRenderPassCreateFlagBits(const VkRenderPassCreateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_RENDER_PASS_CREATE_PER_LAYER_FRAGMENT_DENSITY_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDER_PASS_CREATE_PER_LAYER_FRAGMENT_DENSITY_BIT_VALVE";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSubpassDescriptionFlagBits(const VkSubpassDescriptionFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_TILE_SHADING_APRON_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_TILE_SHADING_APRON_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_ENABLE_LEGACY_DITHERING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_ENABLE_LEGACY_DITHERING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SUBPASS_DESCRIPTION_CUSTOM_RESOLVE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBPASS_DESCRIPTION_CUSTOM_RESOLVE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkStencilFaceFlagBits(const VkStencilFaceFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_STENCIL_FACE_FRONT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_FRONT_BIT";
        is_first = false;
    }
    if (object & VK_STENCIL_FACE_BACK_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_BACK_BIT";
        is_first = false;
    }
    if (object == VK_STENCIL_FACE_FRONT_AND_BACK) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_STENCIL_FACE_FRONT_AND_BACK";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPeerMemoryFeatureFlagBits(const VkPeerMemoryFeatureFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT";
        is_first = false;
    }
    if (object & VK_PEER_MEMORY_FEATURE_COPY_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_COPY_DST_BIT";
        is_first = false;
    }
    if (object & VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT";
        is_first = false;
    }
    if (object & VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkMemoryAllocateFlagBits(const VkMemoryAllocateFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT";
        is_first = false;
    }
    if (object & VK_MEMORY_ALLOCATE_ZERO_INITIALIZE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_ALLOCATE_ZERO_INITIALIZE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalMemoryHandleTypeFlagBits(const VkExternalMemoryHandleTypeFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_OH_NATIVE_BUFFER_BIT_OHOS) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OH_NATIVE_BUFFER_BIT_OHOS";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_SCREEN_BUFFER_BIT_QNX";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLBUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLBUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLTEXTURE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLTEXTURE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLHEAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_MTLHEAP_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalMemoryFeatureFlagBits(const VkExternalMemoryFeatureFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalFenceHandleTypeFlagBits(const VkExternalFenceHandleTypeFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalFenceFeatureFlagBits(const VkExternalFenceFeatureFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkFenceImportFlagBits(const VkFenceImportFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_FENCE_IMPORT_TEMPORARY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FENCE_IMPORT_TEMPORARY_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSemaphoreImportFlagBits(const VkSemaphoreImportFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SEMAPHORE_IMPORT_TEMPORARY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SEMAPHORE_IMPORT_TEMPORARY_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalSemaphoreHandleTypeFlagBits(const VkExternalSemaphoreHandleTypeFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalSemaphoreFeatureFlagBits(const VkExternalSemaphoreFeatureFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT";
        is_first = false;
    }
    if (object & VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSubgroupFeatureFlagBits(const VkSubgroupFeatureFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SUBGROUP_FEATURE_BASIC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_BASIC_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_VOTE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_VOTE_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_ARITHMETIC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_ARITHMETIC_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_BALLOT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_BALLOT_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_SHUFFLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_SHUFFLE_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_CLUSTERED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_CLUSTERED_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_QUAD_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_QUAD_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_ROTATE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_ROTATE_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_ROTATE_CLUSTERED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_ROTATE_CLUSTERED_BIT";
        is_first = false;
    }
    if (object & VK_SUBGROUP_FEATURE_PARTITIONED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBGROUP_FEATURE_PARTITIONED_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkResolveModeFlagBits(const VkResolveModeFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_RESOLVE_MODE_NONE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_NONE";
        is_first = false;
    }
    if (object & VK_RESOLVE_MODE_SAMPLE_ZERO_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_SAMPLE_ZERO_BIT";
        is_first = false;
    }
    if (object & VK_RESOLVE_MODE_AVERAGE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_AVERAGE_BIT";
        is_first = false;
    }
    if (object & VK_RESOLVE_MODE_MIN_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_MIN_BIT";
        is_first = false;
    }
    if (object & VK_RESOLVE_MODE_MAX_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_MAX_BIT";
        is_first = false;
    }
    if (object & VK_RESOLVE_MODE_EXTERNAL_FORMAT_DOWNSAMPLE_BIT_ANDROID) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_EXTERNAL_FORMAT_DOWNSAMPLE_BIT_ANDROID";
        is_first = false;
    }
    if (object & VK_RESOLVE_MODE_CUSTOM_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_MODE_CUSTOM_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSemaphoreWaitFlagBits(const VkSemaphoreWaitFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SEMAPHORE_WAIT_ANY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SEMAPHORE_WAIT_ANY_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDescriptorBindingFlagBits(const VkDescriptorBindingFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT";
        is_first = false;
    }
    if (object & VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkToolPurposeFlagBits(const VkToolPurposeFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_TOOL_PURPOSE_VALIDATION_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_VALIDATION_BIT";
        is_first = false;
    }
    if (object & VK_TOOL_PURPOSE_PROFILING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_PROFILING_BIT";
        is_first = false;
    }
    if (object & VK_TOOL_PURPOSE_TRACING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_TRACING_BIT";
        is_first = false;
    }
    if (object & VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT";
        is_first = false;
    }
    if (object & VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT";
        is_first = false;
    }
    if (object & VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineStageFlagBits2(const VkPipelineStageFlagBits2 object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_PIPELINE_STAGE_2_NONE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_NONE";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_HOST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_HOST_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_COPY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COPY_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_RESOLVE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RESOLVE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_BLIT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_BLIT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_CLEAR_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CLEAR_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CLUSTER_CULLING_SHADER_BIT_HUAWEI";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_DATA_GRAPH_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_DATA_GRAPH_BIT_ARM";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_COPY_INDIRECT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_COPY_INDIRECT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_STAGE_2_MEMORY_DECOMPRESSION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_STAGE_2_MEMORY_DECOMPRESSION_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkAccessFlagBits2(const VkAccessFlagBits2 object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_ACCESS_2_NONE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_NONE";
        is_first = false;
    }
    if (object & VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_INDEX_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INDEX_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_UNIFORM_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_UNIFORM_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_TRANSFER_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFER_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_TRANSFER_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFER_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_HOST_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_HOST_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_HOST_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_HOST_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_MEMORY_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_MEMORY_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_SAMPLED_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_SAMPLED_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_STORAGE_READ_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_STORAGE_READ_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SAMPLER_HEAP_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SAMPLER_HEAP_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_RESOURCE_HEAP_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_RESOURCE_HEAP_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI";
        is_first = false;
    }
    if (object & VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCESS_2_MICROMAP_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MICROMAP_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV";
        is_first = false;
    }
    if (object & VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV";
        is_first = false;
    }
    if (object & VK_ACCESS_2_DATA_GRAPH_READ_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DATA_GRAPH_READ_BIT_ARM";
        is_first = false;
    }
    if (object & VK_ACCESS_2_DATA_GRAPH_WRITE_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_DATA_GRAPH_WRITE_BIT_ARM";
        is_first = false;
    }
    if (object & VK_ACCESS_2_MEMORY_DECOMPRESSION_READ_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_DECOMPRESSION_READ_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCESS_2_MEMORY_DECOMPRESSION_WRITE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_2_MEMORY_DECOMPRESSION_WRITE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSubmitFlagBits(const VkSubmitFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SUBMIT_PROTECTED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SUBMIT_PROTECTED_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkFormatFeatureFlagBits2(const VkFormatFeatureFlagBits2 object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STORAGE_IMAGE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_IMAGE_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STORAGE_IMAGE_ATOMIC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_IMAGE_ATOMIC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_UNIFORM_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_UNIFORM_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_ATOMIC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_ATOMIC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_VERTEX_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VERTEX_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BLEND_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BLEND_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_DEPTH_STENCIL_ATTACHMENT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DEPTH_STENCIL_ATTACHMENT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_BLIT_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLIT_SRC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_BLIT_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLIT_DST_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_LINEAR_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_LINEAR_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_MINMAX_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_MINMAX_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_MIDPOINT_CHROMA_SAMPLES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_MIDPOINT_CHROMA_SAMPLES_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_DISJOINT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DISJOINT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_COSITED_CHROMA_SAMPLES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COSITED_CHROMA_SAMPLES_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STORAGE_READ_WITHOUT_FORMAT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_READ_WITHOUT_FORMAT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STORAGE_WRITE_WITHOUT_FORMAT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STORAGE_WRITE_WITHOUT_FORMAT_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_DEPTH_COMPARISON_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_DEPTH_COMPARISON_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_CUBIC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_CUBIC_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_VIDEO_DECODE_OUTPUT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_DECODE_OUTPUT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_VIDEO_DECODE_DPB_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_DECODE_DPB_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_FRAGMENT_DENSITY_MAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_FRAGMENT_DENSITY_MAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_VIDEO_ENCODE_INPUT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_INPUT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_VIDEO_ENCODE_DPB_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_DPB_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_RADIUS_BUFFER_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_RADIUS_BUFFER_BIT_NV";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_WEIGHT_IMAGE_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_WEIGHT_IMAGE_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_WEIGHT_SAMPLED_IMAGE_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_WEIGHT_SAMPLED_IMAGE_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_BLOCK_MATCHING_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BLOCK_MATCHING_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_BOX_FILTER_SAMPLED_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_BOX_FILTER_SAMPLED_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_TENSOR_SHADER_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TENSOR_SHADER_BIT_ARM";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_TENSOR_IMAGE_ALIASING_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TENSOR_IMAGE_ALIASING_BIT_ARM";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_OPTICAL_FLOW_IMAGE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_IMAGE_BIT_NV";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_OPTICAL_FLOW_VECTOR_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_VECTOR_BIT_NV";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_OPTICAL_FLOW_COST_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_OPTICAL_FLOW_COST_BIT_NV";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_TENSOR_DATA_GRAPH_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_TENSOR_DATA_GRAPH_BIT_ARM";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_COPY_IMAGE_INDIRECT_DST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_COPY_IMAGE_INDIRECT_DST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_DEPTH_COPY_ON_COMPUTE_QUEUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DEPTH_COPY_ON_COMPUTE_QUEUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_DEPTH_COPY_ON_TRANSFER_QUEUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_DEPTH_COPY_ON_TRANSFER_QUEUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STENCIL_COPY_ON_COMPUTE_QUEUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STENCIL_COPY_ON_COMPUTE_QUEUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_FORMAT_FEATURE_2_STENCIL_COPY_ON_TRANSFER_QUEUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FORMAT_FEATURE_2_STENCIL_COPY_ON_TRANSFER_QUEUE_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineCreationFeedbackFlagBits(const VkPipelineCreationFeedbackFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkRenderingFlagBits(const VkRenderingFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT";
        is_first = false;
    }
    if (object & VK_RENDERING_SUSPENDING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_SUSPENDING_BIT";
        is_first = false;
    }
    if (object & VK_RENDERING_RESUMING_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_RESUMING_BIT";
        is_first = false;
    }
    if (object & VK_RENDERING_ENABLE_LEGACY_DITHERING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_ENABLE_LEGACY_DITHERING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_RENDERING_CONTENTS_INLINE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_CONTENTS_INLINE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_RENDERING_PER_LAYER_FRAGMENT_DENSITY_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_PER_LAYER_FRAGMENT_DENSITY_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_RENDERING_FRAGMENT_REGION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_FRAGMENT_REGION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_RENDERING_CUSTOM_RESOLVE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_CUSTOM_RESOLVE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_RENDERING_LOCAL_READ_CONCURRENT_ACCESS_CONTROL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_LOCAL_READ_CONCURRENT_ACCESS_CONTROL_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkMemoryUnmapFlagBits(const VkMemoryUnmapFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_MEMORY_UNMAP_RESERVE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_UNMAP_RESERVE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkBufferUsageFlagBits2(const VkBufferUsageFlagBits2 object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_BUFFER_USAGE_2_TRANSFER_SRC_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFER_SRC_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_TRANSFER_DST_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFER_DST_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_UNIFORM_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_UNIFORM_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_STORAGE_TEXEL_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_STORAGE_TEXEL_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_UNIFORM_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_UNIFORM_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_STORAGE_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_STORAGE_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_INDEX_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_INDEX_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_VERTEX_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VERTEX_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_INDIRECT_BUFFER_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_INDIRECT_BUFFER_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_SHADER_DEVICE_ADDRESS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_SHADER_DEVICE_ADDRESS_BIT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_EXECUTION_GRAPH_SCRATCH_BIT_AMDX) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_EXECUTION_GRAPH_SCRATCH_BIT_AMDX";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_DESCRIPTOR_HEAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_DESCRIPTOR_HEAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_CONDITIONAL_RENDERING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_CONDITIONAL_RENDERING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_SHADER_BINDING_TABLE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_SHADER_BINDING_TABLE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_VIDEO_DECODE_SRC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_DECODE_SRC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_VIDEO_DECODE_DST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_DECODE_DST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_VIDEO_ENCODE_DST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_ENCODE_DST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_VIDEO_ENCODE_SRC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_VIDEO_ENCODE_SRC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_MICROMAP_STORAGE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_MICROMAP_STORAGE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_COMPRESSED_DATA_DGF1_BIT_AMDX) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_COMPRESSED_DATA_DGF1_BIT_AMDX";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_DATA_GRAPH_FOREIGN_DESCRIPTOR_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_DATA_GRAPH_FOREIGN_DESCRIPTOR_BIT_ARM";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_TILE_MEMORY_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_TILE_MEMORY_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_MEMORY_DECOMPRESSION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_MEMORY_DECOMPRESSION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUFFER_USAGE_2_PREPROCESS_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUFFER_USAGE_2_PREPROCESS_BUFFER_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkHostImageCopyFlagBits(const VkHostImageCopyFlagBits object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_HOST_IMAGE_COPY_MEMCPY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_HOST_IMAGE_COPY_MEMCPY_BIT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineCreateFlagBits2(const VkPipelineCreateFlagBits2 object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PIPELINE_CREATE_2_DISABLE_OPTIMIZATION_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DISABLE_OPTIMIZATION_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_ALLOW_DERIVATIVES_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_ALLOW_DERIVATIVES_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_DERIVATIVE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DERIVATIVE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_VIEW_INDEX_FROM_DEVICE_INDEX_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_VIEW_INDEX_FROM_DEVICE_INDEX_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_DISPATCH_BASE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DISPATCH_BASE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_EARLY_RETURN_ON_FAILURE_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_EARLY_RETURN_ON_FAILURE_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DESCRIPTOR_HEAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_ALLOW_SPHERES_AND_LINEAR_SWEPT_SPHERES_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_ALLOW_SPHERES_AND_LINEAR_SWEPT_SPHERES_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_ENABLE_LEGACY_DITHERING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_ENABLE_LEGACY_DITHERING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_DEFER_COMPILE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DEFER_COMPILE_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_CAPTURE_STATISTICS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_CAPTURE_STATISTICS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_LINK_TIME_OPTIMIZATION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_LINK_TIME_OPTIMIZATION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_LIBRARY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_LIBRARY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_SKIP_AABBS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_SKIP_AABBS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_ALLOW_MOTION_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_ALLOW_MOTION_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_COLOR_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DEPTH_STENCIL_ATTACHMENT_FEEDBACK_LOOP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_DESCRIPTOR_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DESCRIPTOR_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_DISALLOW_OPACITY_MICROMAP_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_DISALLOW_OPACITY_MICROMAP_BIT_ARM";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_CAPTURE_DATA_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_CAPTURE_DATA_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_PER_LAYER_FRAGMENT_DENSITY_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_PER_LAYER_FRAGMENT_DENSITY_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PIPELINE_CREATE_2_64_BIT_INDEXING_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSurfaceTransformFlagBitsKHR(const VkSurfaceTransformFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkCompositeAlphaFlagBitsKHR(const VkCompositeAlphaFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSwapchainCreateFlagBitsKHR(const VkSwapchainCreateFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SWAPCHAIN_CREATE_PRESENT_TIMING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_PRESENT_TIMING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SWAPCHAIN_CREATE_PRESENT_ID_2_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_PRESENT_ID_2_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SWAPCHAIN_CREATE_PRESENT_WAIT_2_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_PRESENT_WAIT_2_BIT_KHR";
        is_first = false;
    }
    if (object & VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDeviceGroupPresentModeFlagBitsKHR(const VkDeviceGroupPresentModeFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR";
        is_first = false;
    }
    if (object & VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR";
        is_first = false;
    }
    if (object & VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDisplayPlaneAlphaFlagBitsKHR(const VkDisplayPlaneAlphaFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR";
        is_first = false;
    }
    if (object & VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR";
        is_first = false;
    }
    if (object & VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoCodecOperationFlagBitsKHR(const VkVideoCodecOperationFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_CODEC_OPERATION_NONE_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_NONE_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_H264_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_H265_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODEC_OPERATION_DECODE_AV1_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_AV1_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODEC_OPERATION_DECODE_VP9_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODEC_OPERATION_DECODE_VP9_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoChromaSubsamplingFlagBitsKHR(const VkVideoChromaSubsamplingFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_CHROMA_SUBSAMPLING_INVALID_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_INVALID_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CHROMA_SUBSAMPLING_MONOCHROME_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_MONOCHROME_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CHROMA_SUBSAMPLING_420_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_420_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CHROMA_SUBSAMPLING_422_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_422_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CHROMA_SUBSAMPLING_444_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CHROMA_SUBSAMPLING_444_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoComponentBitDepthFlagBitsKHR(const VkVideoComponentBitDepthFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_COMPONENT_BIT_DEPTH_INVALID_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_INVALID_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_COMPONENT_BIT_DEPTH_8_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_8_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_COMPONENT_BIT_DEPTH_10_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_10_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_COMPONENT_BIT_DEPTH_12_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_COMPONENT_BIT_DEPTH_12_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoCapabilityFlagBitsKHR(const VkVideoCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_CAPABILITY_PROTECTED_CONTENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CAPABILITY_PROTECTED_CONTENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CAPABILITY_SEPARATE_REFERENCE_IMAGES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CAPABILITY_SEPARATE_REFERENCE_IMAGES_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoSessionCreateFlagBitsKHR(const VkVideoSessionCreateFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_SESSION_CREATE_PROTECTED_CONTENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_PROTECTED_CONTENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_PARAMETER_OPTIMIZATIONS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_PARAMETER_OPTIMIZATIONS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_SESSION_CREATE_INLINE_QUERIES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_INLINE_QUERIES_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_ALLOW_ENCODE_EMPHASIS_MAP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_SESSION_CREATE_INLINE_SESSION_PARAMETERS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_CREATE_INLINE_SESSION_PARAMETERS_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoSessionParametersCreateFlagBitsKHR(const VkVideoSessionParametersCreateFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_SESSION_PARAMETERS_CREATE_QUANTIZATION_MAP_COMPATIBLE_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoCodingControlFlagBitsKHR(const VkVideoCodingControlFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_CODING_CONTROL_RESET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_RESET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_ENCODE_RATE_CONTROL_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_CODING_CONTROL_ENCODE_QUALITY_LEVEL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_CODING_CONTROL_ENCODE_QUALITY_LEVEL_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoDecodeCapabilityFlagBitsKHR(const VkVideoDecodeCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_DISTINCT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_DISTINCT_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoDecodeUsageFlagBitsKHR(const VkVideoDecodeUsageFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_DECODE_USAGE_DEFAULT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_DEFAULT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_DECODE_USAGE_TRANSCODING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_TRANSCODING_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_DECODE_USAGE_OFFLINE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_OFFLINE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_DECODE_USAGE_STREAMING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_USAGE_STREAMING_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH264CapabilityFlagBitsKHR(const VkVideoEncodeH264CapabilityFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_HRD_COMPLIANCE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_HRD_COMPLIANCE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_ROW_UNALIGNED_SLICE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_ROW_UNALIGNED_SLICE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L0_LIST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L0_LIST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_PER_SLICE_CONSTANT_QP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_PER_SLICE_CONSTANT_QP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_GENERATE_PREFIX_NALU_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_GENERATE_PREFIX_NALU_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_B_PICTURE_INTRA_REFRESH_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_B_PICTURE_INTRA_REFRESH_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_CAPABILITY_MB_QP_DIFF_WRAPAROUND_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_CAPABILITY_MB_QP_DIFF_WRAPAROUND_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH264StdFlagBitsKHR(const VkVideoEncodeH264StdFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H264_STD_SEPARATE_COLOR_PLANE_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SEPARATE_COLOR_PLANE_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_QPPRIME_Y_ZERO_TRANSFORM_BYPASS_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_QPPRIME_Y_ZERO_TRANSFORM_BYPASS_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_SCALING_MATRIX_PRESENT_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SCALING_MATRIX_PRESENT_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_CHROMA_QP_INDEX_OFFSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_CHROMA_QP_INDEX_OFFSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_SECOND_CHROMA_QP_INDEX_OFFSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SECOND_CHROMA_QP_INDEX_OFFSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_PIC_INIT_QP_MINUS26_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_PIC_INIT_QP_MINUS26_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_WEIGHTED_PRED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_WEIGHTED_PRED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_WEIGHTED_BIPRED_IDC_EXPLICIT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_WEIGHTED_BIPRED_IDC_EXPLICIT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_WEIGHTED_BIPRED_IDC_IMPLICIT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_WEIGHTED_BIPRED_IDC_IMPLICIT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_TRANSFORM_8X8_MODE_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_TRANSFORM_8X8_MODE_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_DIRECT_SPATIAL_MV_PRED_FLAG_UNSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DIRECT_SPATIAL_MV_PRED_FLAG_UNSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_ENTROPY_CODING_MODE_FLAG_UNSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_ENTROPY_CODING_MODE_FLAG_UNSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_ENTROPY_CODING_MODE_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_ENTROPY_CODING_MODE_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_DIRECT_8X8_INFERENCE_FLAG_UNSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DIRECT_8X8_INFERENCE_FLAG_UNSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_CONSTRAINED_INTRA_PRED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_CONSTRAINED_INTRA_PRED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_DISABLED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_DISABLED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_ENABLED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_ENABLED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_PARTIAL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DEBLOCKING_FILTER_PARTIAL_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_SLICE_QP_DELTA_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_SLICE_QP_DELTA_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_STD_DIFFERENT_SLICE_QP_DELTA_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_STD_DIFFERENT_SLICE_QP_DELTA_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH264RateControlFlagBitsKHR(const VkVideoEncodeH264RateControlFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H264_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_RATE_CONTROL_REGULAR_GOP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_REGULAR_GOP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H264_RATE_CONTROL_TEMPORAL_LAYER_PATTERN_DYADIC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H264_RATE_CONTROL_TEMPORAL_LAYER_PATTERN_DYADIC_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH265CapabilityFlagBitsKHR(const VkVideoEncodeH265CapabilityFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_HRD_COMPLIANCE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_HRD_COMPLIANCE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PREDICTION_WEIGHT_TABLE_GENERATED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_ROW_UNALIGNED_SLICE_SEGMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_ROW_UNALIGNED_SLICE_SEGMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_SLICE_SEGMENT_TYPE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_SLICE_SEGMENT_TYPE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L0_LIST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L0_LIST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PER_PICTURE_TYPE_MIN_MAX_QP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_PER_SLICE_SEGMENT_CONSTANT_QP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_PER_SLICE_SEGMENT_CONSTANT_QP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILES_PER_SLICE_SEGMENT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILES_PER_SLICE_SEGMENT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_SLICE_SEGMENTS_PER_TILE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_SLICE_SEGMENTS_PER_TILE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_B_PICTURE_INTRA_REFRESH_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_B_PICTURE_INTRA_REFRESH_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CAPABILITY_CU_QP_DIFF_WRAPAROUND_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CAPABILITY_CU_QP_DIFF_WRAPAROUND_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH265StdFlagBitsKHR(const VkVideoEncodeH265StdFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H265_STD_SEPARATE_COLOR_PLANE_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SEPARATE_COLOR_PLANE_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_SAMPLE_ADAPTIVE_OFFSET_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SAMPLE_ADAPTIVE_OFFSET_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_SCALING_LIST_DATA_PRESENT_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SCALING_LIST_DATA_PRESENT_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_PCM_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_PCM_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_SPS_TEMPORAL_MVP_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SPS_TEMPORAL_MVP_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_INIT_QP_MINUS26_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_INIT_QP_MINUS26_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_WEIGHTED_PRED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_WEIGHTED_PRED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_WEIGHTED_BIPRED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_WEIGHTED_BIPRED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_LOG2_PARALLEL_MERGE_LEVEL_MINUS2_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_LOG2_PARALLEL_MERGE_LEVEL_MINUS2_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_SIGN_DATA_HIDING_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SIGN_DATA_HIDING_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_TRANSFORM_SKIP_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_TRANSFORM_SKIP_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_TRANSFORM_SKIP_ENABLED_FLAG_UNSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_TRANSFORM_SKIP_ENABLED_FLAG_UNSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_PPS_SLICE_CHROMA_QP_OFFSETS_PRESENT_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_PPS_SLICE_CHROMA_QP_OFFSETS_PRESENT_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_TRANSQUANT_BYPASS_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_TRANSQUANT_BYPASS_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_CONSTRAINED_INTRA_PRED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_CONSTRAINED_INTRA_PRED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_ENTROPY_CODING_SYNC_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_ENTROPY_CODING_SYNC_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_DEBLOCKING_FILTER_OVERRIDE_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DEBLOCKING_FILTER_OVERRIDE_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_DEPENDENT_SLICE_SEGMENTS_ENABLED_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DEPENDENT_SLICE_SEGMENTS_ENABLED_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_DEPENDENT_SLICE_SEGMENT_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DEPENDENT_SLICE_SEGMENT_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_SLICE_QP_DELTA_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_SLICE_QP_DELTA_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_STD_DIFFERENT_SLICE_QP_DELTA_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_STD_DIFFERENT_SLICE_QP_DELTA_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH265CtbSizeFlagBitsKHR(const VkVideoEncodeH265CtbSizeFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H265_CTB_SIZE_16_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_16_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CTB_SIZE_32_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_32_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_CTB_SIZE_64_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_CTB_SIZE_64_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH265TransformBlockSizeFlagBitsKHR(const VkVideoEncodeH265TransformBlockSizeFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_4_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_4_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_8_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_8_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_16_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_16_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_32_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_32_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeH265RateControlFlagBitsKHR(const VkVideoEncodeH265RateControlFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_H265_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_ATTEMPT_HRD_COMPLIANCE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_RATE_CONTROL_REGULAR_GOP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_REGULAR_GOP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_H265_RATE_CONTROL_TEMPORAL_SUB_LAYER_PATTERN_DYADIC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_H265_RATE_CONTROL_TEMPORAL_SUB_LAYER_PATTERN_DYADIC_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoDecodeH264PictureLayoutFlagBitsKHR(const VkVideoDecodeH264PictureLayoutFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_PROGRESSIVE_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_PROGRESSIVE_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_INTERLEAVED_LINES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_INTERLEAVED_LINES_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPerformanceCounterDescriptionFlagBitsKHR(const VkPerformanceCounterDescriptionFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkAcquireProfilingLockFlagBitsKHR(const VkAcquireProfilingLockFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeFlagBitsKHR(const VkVideoEncodeFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_INTRA_REFRESH_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_INTRA_REFRESH_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_WITH_QUANTIZATION_DELTA_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_WITH_QUANTIZATION_DELTA_MAP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_WITH_EMPHASIS_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_WITH_EMPHASIS_MAP_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeCapabilityFlagBitsKHR(const VkVideoEncodeCapabilityFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_CAPABILITY_PRECEDING_EXTERNALLY_ENCODED_BYTES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_PRECEDING_EXTERNALLY_ENCODED_BYTES_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_CAPABILITY_INSUFFICIENT_BITSTREAM_BUFFER_RANGE_DETECTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_INSUFFICIENT_BITSTREAM_BUFFER_RANGE_DETECTION_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_CAPABILITY_QUANTIZATION_DELTA_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_QUANTIZATION_DELTA_MAP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_CAPABILITY_EMPHASIS_MAP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CAPABILITY_EMPHASIS_MAP_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeRateControlModeFlagBitsKHR(const VkVideoEncodeRateControlModeFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DEFAULT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DEFAULT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_DISABLED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RATE_CONTROL_MODE_CBR_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_CBR_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RATE_CONTROL_MODE_VBR_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RATE_CONTROL_MODE_VBR_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeFeedbackFlagBitsKHR(const VkVideoEncodeFeedbackFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BUFFER_OFFSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BUFFER_OFFSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BYTES_WRITTEN_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_BYTES_WRITTEN_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_HAS_OVERRIDES_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_FEEDBACK_BITSTREAM_HAS_OVERRIDES_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeUsageFlagBitsKHR(const VkVideoEncodeUsageFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_ENCODE_USAGE_DEFAULT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_DEFAULT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_USAGE_TRANSCODING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_TRANSCODING_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_USAGE_STREAMING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_STREAMING_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_USAGE_RECORDING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_RECORDING_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_USAGE_CONFERENCING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_USAGE_CONFERENCING_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeContentFlagBitsKHR(const VkVideoEncodeContentFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_ENCODE_CONTENT_DEFAULT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_DEFAULT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_CONTENT_CAMERA_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_CAMERA_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_CONTENT_DESKTOP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_DESKTOP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_CONTENT_RENDERED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_CONTENT_RENDERED_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPresentScalingFlagBitsKHR(const VkPresentScalingFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PRESENT_SCALING_ONE_TO_ONE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_ONE_TO_ONE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PRESENT_SCALING_ASPECT_RATIO_STRETCH_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_ASPECT_RATIO_STRETCH_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PRESENT_SCALING_STRETCH_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_SCALING_STRETCH_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPresentGravityFlagBitsKHR(const VkPresentGravityFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PRESENT_GRAVITY_MIN_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_MIN_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PRESENT_GRAVITY_MAX_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_MAX_BIT_KHR";
        is_first = false;
    }
    if (object & VK_PRESENT_GRAVITY_CENTERED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_GRAVITY_CENTERED_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeAV1CapabilityFlagBitsKHR(const VkVideoEncodeAV1CapabilityFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_AV1_CAPABILITY_PER_RATE_CONTROL_GROUP_MIN_MAX_Q_INDEX_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_PER_RATE_CONTROL_GROUP_MIN_MAX_Q_INDEX_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_CAPABILITY_GENERATE_OBU_EXTENSION_HEADER_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_GENERATE_OBU_EXTENSION_HEADER_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_CAPABILITY_PRIMARY_REFERENCE_CDF_ONLY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_PRIMARY_REFERENCE_CDF_ONLY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_CAPABILITY_FRAME_SIZE_OVERRIDE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_FRAME_SIZE_OVERRIDE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_CAPABILITY_MOTION_VECTOR_SCALING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_MOTION_VECTOR_SCALING_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_CAPABILITY_COMPOUND_PREDICTION_INTRA_REFRESH_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_CAPABILITY_COMPOUND_PREDICTION_INTRA_REFRESH_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeAV1StdFlagBitsKHR(const VkVideoEncodeAV1StdFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_AV1_STD_UNIFORM_TILE_SPACING_FLAG_SET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_UNIFORM_TILE_SPACING_FLAG_SET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_STD_SKIP_MODE_PRESENT_UNSET_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_SKIP_MODE_PRESENT_UNSET_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_STD_PRIMARY_REF_FRAME_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_PRIMARY_REF_FRAME_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_STD_DELTA_Q_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_STD_DELTA_Q_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeAV1SuperblockSizeFlagBitsKHR(const VkVideoEncodeAV1SuperblockSizeFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_AV1_SUPERBLOCK_SIZE_64_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_SUPERBLOCK_SIZE_64_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_SUPERBLOCK_SIZE_128_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_SUPERBLOCK_SIZE_128_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeAV1RateControlFlagBitsKHR(const VkVideoEncodeAV1RateControlFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REGULAR_GOP_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REGULAR_GOP_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_RATE_CONTROL_TEMPORAL_LAYER_PATTERN_DYADIC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_TEMPORAL_LAYER_PATTERN_DYADIC_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REFERENCE_PATTERN_FLAT_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_AV1_RATE_CONTROL_REFERENCE_PATTERN_DYADIC_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkAddressCopyFlagBitsKHR(const VkAddressCopyFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_ADDRESS_COPY_DEVICE_LOCAL_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ADDRESS_COPY_DEVICE_LOCAL_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ADDRESS_COPY_SPARSE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ADDRESS_COPY_SPARSE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ADDRESS_COPY_PROTECTED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ADDRESS_COPY_PROTECTED_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeIntraRefreshModeFlagBitsKHR(const VkVideoEncodeIntraRefreshModeFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_NONE_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_NONE_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_PER_PICTURE_PARTITION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_PER_PICTURE_PARTITION_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_BLOCK_BASED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_BLOCK_BASED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_BLOCK_ROW_BASED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_BLOCK_ROW_BASED_BIT_KHR";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_BLOCK_COLUMN_BASED_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_INTRA_REFRESH_MODE_BLOCK_COLUMN_BASED_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkAccessFlagBits3KHR(const VkAccessFlagBits3KHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_ACCESS_3_NONE_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCESS_3_NONE_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkRenderingAttachmentFlagBitsKHR(const VkRenderingAttachmentFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_RENDERING_ATTACHMENT_INPUT_ATTACHMENT_FEEDBACK_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_ATTACHMENT_INPUT_ATTACHMENT_FEEDBACK_BIT_KHR";
        is_first = false;
    }
    if (object & VK_RENDERING_ATTACHMENT_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_ATTACHMENT_RESOLVE_SKIP_TRANSFER_FUNCTION_BIT_KHR";
        is_first = false;
    }
    if (object & VK_RENDERING_ATTACHMENT_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RENDERING_ATTACHMENT_RESOLVE_ENABLE_TRANSFER_FUNCTION_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkResolveImageFlagBitsKHR(const VkResolveImageFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_RESOLVE_IMAGE_SKIP_TRANSFER_FUNCTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_IMAGE_SKIP_TRANSFER_FUNCTION_BIT_KHR";
        is_first = false;
    }
    if (object & VK_RESOLVE_IMAGE_ENABLE_TRANSFER_FUNCTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_RESOLVE_IMAGE_ENABLE_TRANSFER_FUNCTION_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDebugReportFlagBitsEXT(const VkDebugReportFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEBUG_REPORT_INFORMATION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_INFORMATION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_REPORT_WARNING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_WARNING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_REPORT_ERROR_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_ERROR_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_REPORT_DEBUG_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_REPORT_DEBUG_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalMemoryHandleTypeFlagBitsNV(const VkExternalMemoryHandleTypeFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkExternalMemoryFeatureFlagBitsNV(const VkExternalMemoryFeatureFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV";
        is_first = false;
    }
    if (object & VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkConditionalRenderingFlagBitsEXT(const VkConditionalRenderingFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSurfaceCounterFlagBitsEXT(const VkSurfaceCounterFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SURFACE_COUNTER_VBLANK_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SURFACE_COUNTER_VBLANK_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDebugUtilsMessageSeverityFlagBitsEXT(const VkDebugUtilsMessageSeverityFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDebugUtilsMessageTypeFlagBitsEXT(const VkDebugUtilsMessageTypeFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_DEBUG_UTILS_MESSAGE_TYPE_DEVICE_ADDRESS_BINDING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEBUG_UTILS_MESSAGE_TYPE_DEVICE_ADDRESS_BINDING_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkTensorViewCreateFlagBitsARM(const VkTensorViewCreateFlagBitsARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_TENSOR_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_VIEW_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_ARM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkSpirvResourceTypeFlagBitsEXT(const VkSpirvResourceTypeFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_SPIRV_RESOURCE_TYPE_ALL_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_ALL_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_SAMPLER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_SAMPLER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_SAMPLED_IMAGE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_SAMPLED_IMAGE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_READ_ONLY_IMAGE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_READ_ONLY_IMAGE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_READ_WRITE_IMAGE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_READ_WRITE_IMAGE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_COMBINED_SAMPLED_IMAGE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_COMBINED_SAMPLED_IMAGE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_UNIFORM_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_UNIFORM_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_READ_ONLY_STORAGE_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_READ_ONLY_STORAGE_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_READ_WRITE_STORAGE_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_READ_WRITE_STORAGE_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_ACCELERATION_STRUCTURE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_ACCELERATION_STRUCTURE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SPIRV_RESOURCE_TYPE_TENSOR_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SPIRV_RESOURCE_TYPE_TENSOR_BIT_ARM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkGeometryFlagBitsKHR(const VkGeometryFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_GEOMETRY_OPAQUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_OPAQUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkGeometryInstanceFlagBitsKHR(const VkGeometryInstanceFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR";
        is_first = false;
    }
    if (object & VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_GEOMETRY_INSTANCE_FORCE_OPACITY_MICROMAP_2_STATE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_FORCE_OPACITY_MICROMAP_2_STATE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_GEOMETRY_INSTANCE_DISABLE_OPACITY_MICROMAPS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GEOMETRY_INSTANCE_DISABLE_OPACITY_MICROMAPS_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkBuildAccelerationStructureFlagBitsKHR(const VkBuildAccelerationStructureFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISABLE_OPACITY_MICROMAPS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISABLE_OPACITY_MICROMAPS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISPLACEMENT_MICROMAP_UPDATE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DISPLACEMENT_MICROMAP_UPDATE_BIT_NV";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_BIT_KHR";
        is_first = false;
    }
    if (object & VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_CLUSTER_OPACITY_MICROMAPS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_CLUSTER_OPACITY_MICROMAPS_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPipelineCompilerControlFlagBitsAMD(const VkPipelineCompilerControlFlagBitsAMD object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPresentStageFlagBitsEXT(const VkPresentStageFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PRESENT_STAGE_QUEUE_OPERATIONS_END_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_STAGE_QUEUE_OPERATIONS_END_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PRESENT_STAGE_REQUEST_DEQUEUED_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_STAGE_REQUEST_DEQUEUED_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PRESENT_STAGE_IMAGE_FIRST_PIXEL_OUT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_STAGE_IMAGE_FIRST_PIXEL_OUT_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PRESENT_STAGE_IMAGE_FIRST_PIXEL_VISIBLE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_STAGE_IMAGE_FIRST_PIXEL_VISIBLE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPastPresentationTimingFlagBitsEXT(const VkPastPresentationTimingFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PAST_PRESENTATION_TIMING_ALLOW_PARTIAL_RESULTS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PAST_PRESENTATION_TIMING_ALLOW_PARTIAL_RESULTS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PAST_PRESENTATION_TIMING_ALLOW_OUT_OF_ORDER_RESULTS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PAST_PRESENTATION_TIMING_ALLOW_OUT_OF_ORDER_RESULTS_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPresentTimingInfoFlagBitsEXT(const VkPresentTimingInfoFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PRESENT_TIMING_INFO_PRESENT_AT_RELATIVE_TIME_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_TIMING_INFO_PRESENT_AT_RELATIVE_TIME_BIT_EXT";
        is_first = false;
    }
    if (object & VK_PRESENT_TIMING_INFO_PRESENT_AT_NEAREST_REFRESH_CYCLE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PRESENT_TIMING_INFO_PRESENT_AT_NEAREST_REFRESH_CYCLE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkShaderCorePropertiesFlagBitsAMD(const VkShaderCorePropertiesFlagBitsAMD object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkIndirectStateFlagBitsNV(const VkIndirectStateFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkIndirectCommandsLayoutUsageFlagBitsNV(const VkIndirectCommandsLayoutUsageFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV";
        is_first = false;
    }
    if (object & VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV";
        is_first = false;
    }
    if (object & VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDeviceDiagnosticsConfigFlagBitsNV(const VkDeviceDiagnosticsConfigFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV";
        is_first = false;
    }
    if (object & VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV";
        is_first = false;
    }
    if (object & VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV";
        is_first = false;
    }
    if (object & VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_ERROR_REPORTING_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_ERROR_REPORTING_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkTileShadingRenderPassFlagBitsQCOM(const VkTileShadingRenderPassFlagBitsQCOM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM";
        is_first = false;
    }
    if (object & VK_TILE_SHADING_RENDER_PASS_PER_TILE_EXECUTION_BIT_QCOM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TILE_SHADING_RENDER_PASS_PER_TILE_EXECUTION_BIT_QCOM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#if defined(VK_USE_PLATFORM_METAL_EXT)

template <ApiDumpFormat Format>
void dump_VkExportMetalObjectTypeFlagBitsEXT(const VkExportMetalObjectTypeFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#endif  // VK_USE_PLATFORM_METAL_EXT

template <ApiDumpFormat Format>
void dump_VkGraphicsPipelineLibraryFlagBitsEXT(const VkGraphicsPipelineLibraryFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkImageCompressionFlagBitsEXT(const VkImageCompressionFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_IMAGE_COMPRESSION_DEFAULT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_DEFAULT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_DEFAULT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_DEFAULT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_DISABLED_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_DISABLED_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkImageCompressionFixedRateFlagBitsEXT(const VkImageCompressionFixedRateFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_IMAGE_COMPRESSION_FIXED_RATE_NONE_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_NONE_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_1BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_1BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_2BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_2BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_3BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_3BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_4BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_4BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_5BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_5BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_6BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_6BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_7BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_7BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_8BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_8BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_9BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_9BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_10BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_10BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_11BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_11BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_12BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_12BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_13BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_13BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_14BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_14BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_15BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_15BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_16BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_16BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_17BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_17BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_18BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_18BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_19BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_19BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_20BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_20BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_21BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_21BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_22BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_22BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_23BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_23BPC_BIT_EXT";
        is_first = false;
    }
    if (object & VK_IMAGE_COMPRESSION_FIXED_RATE_24BPC_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_COMPRESSION_FIXED_RATE_24BPC_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDeviceAddressBindingFlagBitsEXT(const VkDeviceAddressBindingFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DEVICE_ADDRESS_BINDING_INTERNAL_OBJECT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DEVICE_ADDRESS_BINDING_INTERNAL_OBJECT_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#if defined(VK_USE_PLATFORM_FUCHSIA)

template <ApiDumpFormat Format>
void dump_VkImageConstraintsInfoFlagBitsFUCHSIA(const VkImageConstraintsInfoFlagBitsFUCHSIA object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_RARELY_FUCHSIA) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_RARELY_FUCHSIA";
        is_first = false;
    }
    if (object & VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_OFTEN_FUCHSIA) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_OFTEN_FUCHSIA";
        is_first = false;
    }
    if (object & VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_RARELY_FUCHSIA) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_RARELY_FUCHSIA";
        is_first = false;
    }
    if (object & VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_OFTEN_FUCHSIA) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_OFTEN_FUCHSIA";
        is_first = false;
    }
    if (object & VK_IMAGE_CONSTRAINTS_INFO_PROTECTED_OPTIONAL_FUCHSIA) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_IMAGE_CONSTRAINTS_INFO_PROTECTED_OPTIONAL_FUCHSIA";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
#endif  // VK_USE_PLATFORM_FUCHSIA

template <ApiDumpFormat Format>
void dump_VkFrameBoundaryFlagBitsEXT(const VkFrameBoundaryFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_FRAME_BOUNDARY_FRAME_END_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_FRAME_BOUNDARY_FRAME_END_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeRgbModelConversionFlagBitsVALVE(const VkVideoEncodeRgbModelConversionFlagBitsVALVE object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_RGB_IDENTITY_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_RGB_IDENTITY_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_IDENTITY_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_IDENTITY_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_709_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_709_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_601_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_601_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_2020_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_MODEL_CONVERSION_YCBCR_2020_BIT_VALVE";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeRgbRangeCompressionFlagBitsVALVE(const VkVideoEncodeRgbRangeCompressionFlagBitsVALVE object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_RGB_RANGE_COMPRESSION_FULL_RANGE_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_RANGE_COMPRESSION_FULL_RANGE_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RGB_RANGE_COMPRESSION_NARROW_RANGE_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_RANGE_COMPRESSION_NARROW_RANGE_BIT_VALVE";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkVideoEncodeRgbChromaOffsetFlagBitsVALVE(const VkVideoEncodeRgbChromaOffsetFlagBitsVALVE object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_VIDEO_ENCODE_RGB_CHROMA_OFFSET_COSITED_EVEN_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_CHROMA_OFFSET_COSITED_EVEN_BIT_VALVE";
        is_first = false;
    }
    if (object & VK_VIDEO_ENCODE_RGB_CHROMA_OFFSET_MIDPOINT_BIT_VALVE) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_VIDEO_ENCODE_RGB_CHROMA_OFFSET_MIDPOINT_BIT_VALVE";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkBuildMicromapFlagBitsEXT(const VkBuildMicromapFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_BUILD_MICROMAP_PREFER_FAST_TRACE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_PREFER_FAST_TRACE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUILD_MICROMAP_PREFER_FAST_BUILD_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_PREFER_FAST_BUILD_BIT_EXT";
        is_first = false;
    }
    if (object & VK_BUILD_MICROMAP_ALLOW_COMPACTION_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_BUILD_MICROMAP_ALLOW_COMPACTION_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkMicromapCreateFlagBitsEXT(const VkMicromapCreateFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_MICROMAP_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MICROMAP_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPhysicalDeviceSchedulingControlsFlagBitsARM(const VkPhysicalDeviceSchedulingControlsFlagBitsARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkMemoryDecompressionMethodFlagBitsEXT(const VkMemoryDecompressionMethodFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkTensorCreateFlagBitsARM(const VkTensorCreateFlagBitsARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_TENSOR_CREATE_MUTABLE_FORMAT_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_CREATE_MUTABLE_FORMAT_BIT_ARM";
        is_first = false;
    }
    if (object & VK_TENSOR_CREATE_PROTECTED_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_CREATE_PROTECTED_BIT_ARM";
        is_first = false;
    }
    if (object & VK_TENSOR_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_CREATE_DESCRIPTOR_HEAP_CAPTURE_REPLAY_BIT_ARM";
        is_first = false;
    }
    if (object & VK_TENSOR_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_ARM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkTensorUsageFlagBitsARM(const VkTensorUsageFlagBitsARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_TENSOR_USAGE_SHADER_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_USAGE_SHADER_BIT_ARM";
        is_first = false;
    }
    if (object & VK_TENSOR_USAGE_TRANSFER_SRC_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_USAGE_TRANSFER_SRC_BIT_ARM";
        is_first = false;
    }
    if (object & VK_TENSOR_USAGE_TRANSFER_DST_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_USAGE_TRANSFER_DST_BIT_ARM";
        is_first = false;
    }
    if (object & VK_TENSOR_USAGE_IMAGE_ALIASING_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_USAGE_IMAGE_ALIASING_BIT_ARM";
        is_first = false;
    }
    if (object & VK_TENSOR_USAGE_DATA_GRAPH_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_TENSOR_USAGE_DATA_GRAPH_BIT_ARM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkOpticalFlowGridSizeFlagBitsNV(const VkOpticalFlowGridSizeFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_OPTICAL_FLOW_GRID_SIZE_UNKNOWN_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_UNKNOWN_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_GRID_SIZE_1X1_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_1X1_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_GRID_SIZE_2X2_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_2X2_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_GRID_SIZE_4X4_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_4X4_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_GRID_SIZE_8X8_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_GRID_SIZE_8X8_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkOpticalFlowUsageFlagBitsNV(const VkOpticalFlowUsageFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_OPTICAL_FLOW_USAGE_UNKNOWN_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_UNKNOWN_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_USAGE_INPUT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_INPUT_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_USAGE_OUTPUT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_OUTPUT_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_USAGE_HINT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_HINT_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_USAGE_COST_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_COST_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_USAGE_GLOBAL_FLOW_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_USAGE_GLOBAL_FLOW_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkOpticalFlowSessionCreateFlagBitsNV(const VkOpticalFlowSessionCreateFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_HINT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_HINT_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_COST_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_COST_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_GLOBAL_FLOW_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ENABLE_GLOBAL_FLOW_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_SESSION_CREATE_ALLOW_REGIONS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_ALLOW_REGIONS_BIT_NV";
        is_first = false;
    }
    if (object & VK_OPTICAL_FLOW_SESSION_CREATE_BOTH_DIRECTIONS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_SESSION_CREATE_BOTH_DIRECTIONS_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkOpticalFlowExecuteFlagBitsNV(const VkOpticalFlowExecuteFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_OPTICAL_FLOW_EXECUTE_DISABLE_TEMPORAL_HINTS_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_OPTICAL_FLOW_EXECUTE_DISABLE_TEMPORAL_HINTS_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkShaderCreateFlagBitsEXT(const VkShaderCreateFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_SHADER_CREATE_LINK_STAGE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_LINK_STAGE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_DESCRIPTOR_HEAP_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_DESCRIPTOR_HEAP_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_NO_TASK_SHADER_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_NO_TASK_SHADER_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_DISPATCH_BASE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_DISPATCH_BASE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_INDIRECT_BINDABLE_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_INDIRECT_BINDABLE_BIT_EXT";
        is_first = false;
    }
    if (object & VK_SHADER_CREATE_64_BIT_INDEXING_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_SHADER_CREATE_64_BIT_INDEXING_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDataGraphPipelineSessionCreateFlagBitsARM(const VkDataGraphPipelineSessionCreateFlagBitsARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkDataGraphPipelineDispatchFlagBitsARM(const VkDataGraphPipelineDispatchFlagBitsARM object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkClusterAccelerationStructureAddressResolutionFlagBitsNV(const VkClusterAccelerationStructureAddressResolutionFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object == VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_NONE_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_NONE_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_IMPLICIT_DATA_BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SCRATCH_DATA_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SCRATCH_DATA_BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_ADDRESS_ARRAY_BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_SIZES_ARRAY_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_DST_SIZES_ARRAY_BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_ARRAY_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_ARRAY_BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_COUNT_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_ADDRESS_RESOLUTION_INDIRECTED_SRC_INFOS_COUNT_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkClusterAccelerationStructureClusterFlagBitsNV(const VkClusterAccelerationStructureClusterFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_CLUSTER_ALLOW_DISABLE_OPACITY_MICROMAPS_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_CLUSTER_ALLOW_DISABLE_OPACITY_MICROMAPS_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkClusterAccelerationStructureGeometryFlagBitsNV(const VkClusterAccelerationStructureGeometryFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_CULL_DISABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_CULL_DISABLE_BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_NO_DUPLICATE_ANYHIT_INVOCATION_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_NO_DUPLICATE_ANYHIT_INVOCATION_BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_OPAQUE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_GEOMETRY_OPAQUE_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkClusterAccelerationStructureIndexFormatFlagBitsNV(const VkClusterAccelerationStructureIndexFormatFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_8BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_8BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_16BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_16BIT_NV";
        is_first = false;
    }
    if (object & VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_32BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_CLUSTER_ACCELERATION_STRUCTURE_INDEX_FORMAT_32BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkPartitionedAccelerationStructureInstanceFlagBitsNV(const VkPartitionedAccelerationStructureInstanceFlagBitsNV object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_TRIANGLE_FACING_CULL_DISABLE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_TRIANGLE_FACING_CULL_DISABLE_BIT_NV";
        is_first = false;
    }
    if (object & VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_TRIANGLE_FLIP_FACING_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_TRIANGLE_FLIP_FACING_BIT_NV";
        is_first = false;
    }
    if (object & VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_FORCE_OPAQUE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_FORCE_OPAQUE_BIT_NV";
        is_first = false;
    }
    if (object & VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_FORCE_NO_OPAQUE_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_FORCE_NO_OPAQUE_BIT_NV";
        is_first = false;
    }
    if (object & VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_ENABLE_EXPLICIT_BOUNDING_BOX_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCE_FLAG_ENABLE_EXPLICIT_BOUNDING_BOX_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkIndirectCommandsInputModeFlagBitsEXT(const VkIndirectCommandsInputModeFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_INDIRECT_COMMANDS_INPUT_MODE_VULKAN_INDEX_BUFFER_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_INPUT_MODE_VULKAN_INDEX_BUFFER_EXT";
        is_first = false;
    }
    if (object & VK_INDIRECT_COMMANDS_INPUT_MODE_DXGI_INDEX_BUFFER_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_INPUT_MODE_DXGI_INDEX_BUFFER_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkIndirectCommandsLayoutUsageFlagBitsEXT(const VkIndirectCommandsLayoutUsageFlagBitsEXT object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_EXT";
        is_first = false;
    }
    if (object & VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_EXT";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

template <ApiDumpFormat Format>
void dump_VkAccelerationStructureCreateFlagBitsKHR(const VkAccelerationStructureCreateFlagBitsKHR object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value_start<Format>(settings);
    settings.stream() << object;
    bool is_first = true;
    if (object & VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR";
        is_first = false;
    }
    if (object & VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT";
        is_first = false;
    }
    if (object & VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV) {
        settings.stream() << (is_first ? " (" : " | ") << "VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV";
        is_first = false;
    }

    if (!is_first)
        settings.stream() << ")";
    dump_value_end<Format>(settings);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}

//=========================== Flag Implementations ==========================//

template <ApiDumpFormat Format>
void dump_VkAccessFlags(const VkAccessFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkAccessFlagBits<Format>(static_cast<VkAccessFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkImageAspectFlags(const VkImageAspectFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkImageAspectFlagBits<Format>(static_cast<VkImageAspectFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkFormatFeatureFlags(const VkFormatFeatureFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkFormatFeatureFlagBits<Format>(static_cast<VkFormatFeatureFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkImageCreateFlags(const VkImageCreateFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkImageCreateFlagBits<Format>(static_cast<VkImageCreateFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkSampleCountFlags(const VkSampleCountFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkSampleCountFlagBits<Format>(static_cast<VkSampleCountFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkImageUsageFlags(const VkImageUsageFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkImageUsageFlagBits<Format>(static_cast<VkImageUsageFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkInstanceCreateFlags(const VkInstanceCreateFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkInstanceCreateFlagBits<Format>(static_cast<VkInstanceCreateFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkMemoryHeapFlags(const VkMemoryHeapFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkMemoryHeapFlagBits<Format>(static_cast<VkMemoryHeapFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkMemoryPropertyFlags(const VkMemoryPropertyFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkMemoryPropertyFlagBits<Format>(static_cast<VkMemoryPropertyFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkQueueFlags(const VkQueueFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkQueueFlagBits<Format>(static_cast<VkQueueFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkDeviceCreateFlags(const VkDeviceCreateFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_start<Format>(settings, OutputConstruct::value, type_name, var_name, indents, address);
    dump_value<Format>(settings, object);
    dump_end<Format>(settings, OutputConstruct::value, indents);
}
template <ApiDumpFormat Format>
void dump_VkDeviceQueueCreateFlags(const VkDeviceQueueCreateFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkDeviceQueueCreateFlagBits<Format>(static_cast<VkDeviceQueueCreateFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkPipelineStageFlags(const VkPipelineStageFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkPipelineStageFlagBits<Format>(static_cast<VkPipelineStageFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkMemoryMapFlags(const VkMemoryMapFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {
    dump_VkMemoryMapFlagBits<Format>(static_cast<VkMemoryMapFlagBits>(object), settings, type_name, var_name, indents, address);
}
template <ApiDumpFormat Format>
void dump_VkSparseMemoryBindFlags(const VkSparseMemoryBindFlags object, const ApiDumpSettings& settings, const char* type_name, const char* var_name, int indents, const void* address = nullptr) {