#include	"defs.h"
#include	"global.h"
#include	"rastfont.h"

struct rastaccessinfo raccinfo;

rast_mag(struct font_entry *fe, struct accarg *acca, int t)
{
    fe->finfo = (struct finfo *)&raccinfo;
    switch (acca->acc_mode) {
    case ACC_EXACT:
    case ACC_GEN:
	acca->pv_mag = ROUND(acca->actmagfact*resolution*t);
	raccinfo.corrfact = 1;
	break;
    case ACC_SUBST:
	if (ROUND(acca->actmagfact*resolution*t) != acca->reqmag)
	    return FALSE;
	acca->pv_mag = acca->submag;
	raccinfo.corrfact = (float)acca->reqmag/(float)acca->submag;
	break;
    case ACC_MAGSTEP:
	acca->pv_mag = ROUND(acca->stepmagfact*resolution*t);
	raccinfo.corrfact = acca->rawmagfact/acca->stepmagfact;
	break;
    }
    return 0;
}

#ifdef DEBUG
rast_debug_report(fe, acca, ok, type)
struct font_entry *fe;
struct accarg *acca;
__BOOLEAN__ ok;
char *type;
{
    if (Debuguser) {
	if (acca->acc_mode == ACC_EXACT || acca->acc_mode == ACC_GEN)
	    (void)fprintf(stderr, "trying to access(%s) %s\n", type, fe->name);
	else if (ok)
	    (void)fprintf(stderr, "trying to access[%d](%s) %s\n",
			  acca->acc_mode, type, fe->name);
    }
}
#endif

check_id(name, id)
char	*name;
int	id;
{
    FILE *tfp;

    if ((tfp = BINARYOPEN(name)) == NULL)
	Fatal("FNT file %s could not be opened", name);
    if (getuint(tfp, 4) != id) {
	(void)fclose(tfp);
	return FALSE;
    }
    (void)fseek(tfp, -4L, SEEK_END);
    if (getuint(tfp, 4) != id) {
	(void)fclose(tfp);
	return FALSE;
    }
    (void)fclose(tfp);
    return TRUE;
}

init_rast_fontinfo(struct font_entry *fe)
{
    int i;
    struct rastinitfontinfo *k;
    int rast_markchar();

    fe->fnt_markchar = rast_markchar;
    k = (struct rastinitfontinfo *)
	alloc_check(malloc((unsigned)sizeof(struct rastinitfontinfo)+
			   MAXMARKCHAR*sizeof(Boolean)),
		    "rastinitfontinfo");
    for (i = 0; i <= MAXMARKCHAR; i++)
	k->mark[i] = FALSE;
    k->maxc = 0;
    k->corrfact = rastaccinfo(fe)->corrfact;
    rastinifinfo(fe) = k;
}

int rast_markchar(int c)
{
    if (c > MAXMARKCHAR) {
	Warning("char %d in %s ignored", c, curfontent->name);
	return 0;
    }
    rastinifinfo(curfontent)->mark[c] = TRUE;
    if (c > rastinifinfo(curfontent)->maxc)
	rastinifinfo(curfontent)->maxc = c;
    return 1;
}

struct rastfntinfo *
alloc_rastfinfo(nchars, init, rii)
int nchars, init;
struct rastinitfontinfo *rii;
{
    struct rastfntinfo *rfi;
    struct rastchar_entry *ce;	/* temporary char_entry pointer  */
    int i;

    rfi = (struct rastfntinfo *)
	  alloc_check(malloc((unsigned)sizeof(struct rastfntinfo)+
			     (nchars-1)*sizeof(struct rastchar_entry)),
		      "rastfont info");
    if (init)
	for (i = 0; i < nchars; i++) {
	    ce = &(rfi->ch[i]);
	    ce->width = 0;
	    ce->height = 0;
	    ce->xoffset= 0;
	    ce->yoffset = 0;
	    ce->dev_font = DEV_NULLFONT;
	    /*ce->dev_char = NONCHAR;*/
	    ce->where.fileoffset = NONEXISTANT;
	    ce->tfmw = 0;
	}
    rfi->corrfact = rii->corrfact;
    return rfi;
}

/* returs the current fontdict of raster font */
DEV_FONT
rast_fontdict(fe, c)
struct font_entry *fe;
int c;
{
    /* char range check omitted */
    return rastfinfo(fe)->ch[c].dev_font;
}
