#include <string.h>
#include <stdio.h>
#include "mem.h"
#include "error.h"
#include "pdfobj.h"
#include "pdfparse.h"
#include "type0.h"
#include "cid.h"
#include "cid_basefont.h"
#include "cidbase.h"

static unsigned char verbose = 0;

void cidbase_set_verbose(void)
{
  if(verbose<255) verbose += 1;
}

static void cidbase_start_font_descriptor (struct a_cid_font *cid)
{
  pdf_obj *tmp1;
  char *start, *end;
  int base_id;

#ifdef MEM_DEBUG
MEM_START
#endif
  cid->descriptor = pdf_new_dict();
  base_id = cid->base_id;

  pdf_add_dict (cid->descriptor,
		pdf_new_name ("Type"),
		pdf_new_name ("FontDescriptor"));
  pdf_add_dict (cid->descriptor,
		pdf_new_name ("CapHeight"),
		pdf_new_number (cid_basefont[base_id].capheight));
  pdf_add_dict (cid->descriptor,
		pdf_new_name ("Ascent"),
		pdf_new_number (cid_basefont[base_id].ascent));
  pdf_add_dict (cid->descriptor,
		pdf_new_name ("Descent"),
		pdf_new_number (cid_basefont[base_id].descent));

  start = (char *) cid_basefont[base_id].bbox;
  end = start+strlen(cid_basefont[base_id].bbox);
  tmp1 = parse_pdf_array (&start, end);
  pdf_add_dict (cid->descriptor, pdf_new_name ("FontBBox"), tmp1);

  pdf_add_dict (cid->descriptor,
		pdf_new_name ("FontName"),
		pdf_new_name (cid_basefont[base_id].fontname));

  pdf_add_dict (cid->descriptor,
		pdf_new_name ("ItalicAngle"),
		pdf_new_number(cid_basefont[base_id].italic));
  pdf_add_dict (cid->descriptor,
		pdf_new_name ("StemV"),
		pdf_new_number(cid_basefont[base_id].stemv));
  pdf_add_dict (cid->descriptor,
		pdf_new_name ("Flags"),
		pdf_new_number(cid_basefont[base_id].flags));

  /* optional entries */
  if( cid_basefont[base_id].xheight ) {
    pdf_add_dict (cid->descriptor,
		  pdf_new_name ("XHeight"),
		  pdf_new_number(cid_basefont[base_id].xheight));
  }
  if( cid_basefont[base_id].avgw ) {
    pdf_add_dict (cid->descriptor,
		  pdf_new_name ("AvgWidth"),
		  pdf_new_number(cid_basefont[base_id].avgw));
  }
  if( cid_basefont[base_id].leading ) {
    pdf_add_dict (cid->descriptor,
		  pdf_new_name ("Leading"),
		  pdf_new_number(cid_basefont[base_id].leading));
  }
  if( cid_basefont[base_id].maxw ) {
    pdf_add_dict (cid->descriptor,
		  pdf_new_name ("MaxWidth"),
		  pdf_new_number(cid_basefont[base_id].maxw));
  }
  if( cid_basefont[base_id].missw ) {
    pdf_add_dict (cid->descriptor,
		  pdf_new_name ("MissingWidth"),
		  pdf_new_number(cid_basefont[base_id].missw));
  }
  if( cid_basefont[base_id].stemh ) {
    pdf_add_dict (cid->descriptor,
		  pdf_new_name ("StemH"),
		  pdf_new_number(cid_basefont[base_id].stemh));
  }
  if( cid_basefont[base_id].charset ) {
    pdf_add_dict (cid->descriptor,
		  pdf_new_name ("CharSet"),
		  pdf_new_string (cid_basefont[base_id].charset,
				  strlen(cid_basefont[base_id].charset)));
  }
  if (cid_basefont[base_id].style) {
    start = (char *) cid_basefont[base_id].style;
    end = start+strlen(cid_basefont[base_id].style);
    tmp1 = parse_pdf_object (&start, end);
    pdf_add_dict (cid->descriptor, pdf_new_name ("Style"), tmp1);
  }

#ifdef MEM_DEBUG
MEM_END
#endif /* MEM_DEBUG */
  return;
}

int cidbase_get_id (const char *map_name)
{
  struct a_cid_font *cid;
  int i, base_id;
  pdf_obj *font_resource, *tmp1;
  char *start, *end;

#ifdef MEM_DEBUG
MEM_START
#endif
  for (i=0; i<CID_LAST_BASEFONT; i++) {
    if (!strcmp (map_name, cid_basefont[i].fontname)) {
      break;
    }
  }
  if (i == CID_LAST_BASEFONT) return 0; /* not a basefont */

  base_id = i;
  cid = new_cid_font();

  cid->cid_name = NEW (strlen(map_name)+1, char);
  cid->fontname = NEW (strlen(map_name)+1, char);
  strcpy (cid->cid_name, map_name);
  strcpy (cid->fontname, map_name);
  cid->base_id = base_id;

  cidbase_start_font_descriptor(cid);
  font_resource = pdf_new_dict ();
  pdf_add_dict (font_resource,
		pdf_new_name ("Type"),
		pdf_new_name ("Font"));
  pdf_add_dict (font_resource,
		pdf_new_name ("Subtype"),
		pdf_new_name (cid_basefont[base_id].subtype));
  pdf_add_dict (font_resource, 
		pdf_new_name ("BaseFont"),
		pdf_new_name (cid->fontname));
  pdf_add_dict (font_resource, 
		pdf_new_name ("FontDescriptor"),
		pdf_ref_obj(cid->descriptor));

  cid_add_system_info(font_resource, cid_basefont[base_id].cc_name);

  /* optional entries */
  if (cid_basefont[base_id].dw) {
    pdf_add_dict (font_resource, 
		  pdf_new_name ("DW"),
		  pdf_new_number (cid_basefont[base_id].dw));
  }
  if (cid_basefont[base_id].w) {
    start = (char *) cid_basefont[base_id].w;
    end = start+strlen(cid_basefont[base_id].w);
    tmp1 = parse_pdf_array (&start, end);
    pdf_add_dict (font_resource, pdf_new_name ("W"), tmp1);
  }
  if (cid_basefont[base_id].dw2) {
    start = (char *) cid_basefont[base_id].dw2;
    end = start+strlen(cid_basefont[base_id].dw2);
    tmp1 = parse_pdf_array (&start, end);
    pdf_add_dict (font_resource, pdf_new_name ("DW2"), tmp1);
  }
  if (cid_basefont[base_id].w2) {
    start = (char *) cid_basefont[base_id].w2;
    end = start+strlen(cid_basefont[base_id].w2);
    tmp1 = parse_pdf_array (&start, end);
    pdf_add_dict (font_resource, pdf_new_name ("W2"), tmp1);
  }

  cid->indirect = pdf_ref_obj(font_resource);
  /*
    We are not embedding (subsetted) font,
    all information are already given.
    Everything has been done. Flush & release the content !
  */
  pdf_release_obj(cid->descriptor);
  pdf_release_obj (font_resource);
  cid->descriptor = NULL;

#ifdef MEM_DEBUG
MEM_END
#endif /* MEM_DEBUG */
  return 1;
}

void do_cidbase (int id)
{
  /* nothing to be done */
}

void cidbase_release (int id)
{
  /* nothing to be done */
}
