#!/bin/sh
SRCDIR=../src
HEAD=fcftalias.h
TAIL=fcftaliastail.h
rm -f $HEAD $TAIL
echo "#if HAVE_GNUC_ATTRIBUTE" >> $TAIL
for name in \
FcFreeTypeCharIndex \
FcFreeTypeCharSetAndSpacing \
FcFreeTypeCharSet \
FcPatternGetFTFace \
FcPatternAddFTFace \
FcFreeTypeQueryFace
do
	case $name in
	FcCacheDir|FcCacheSubdir)
		;;
	*)
		alias="IA__$name"
		hattr='__attribute((visibility("hidden")))'
		echo "extern __typeof ($name) $alias $hattr;" >> $HEAD
		echo "#define $name $alias" >> $HEAD
		grep -l '^'$name'[ (]' "$SRCDIR"/*.c | head -1 | sed -e 's/^.*\/\([^.]*\)\.c/#ifdef __\1__/' >> $TAIL
		echo "#undef $name" >> $TAIL
		cattr='__attribute((alias("'$alias'"), visibility("default")))'
		echo "extern __typeof ($name) $name $cattr;" >> $TAIL
		echo "#endif" >> $TAIL
		;;
	esac
done
echo "#endif" >> $TAIL
