/*1:*/
#line 66 "cwebdir/common.w"

/*3:*/
#line 53 "cwebdir/comm-w2c.h"

#ifndef HAVE_GETTEXT
#define HAVE_GETTEXT 0
#endif

#if HAVE_GETTEXT
#include <libintl.h> 
#else
#define gettext(A) A
#endif

#include <ctype.h>  
#include <stdbool.h>  
#include <stddef.h>  
#include <stdint.h>  
#include <stdlib.h>  
#include <stdio.h>  
#include <string.h>  

/*:3*//*89:*/
#line 709 "cwebdir/comm-w2c.ch"

#if HAVE_GETTEXT
#include <locale.h>  
#else
#define setlocale(A,B) ""
#define bindtextdomain(A,B) ""
#define textdomain(A) ""
#endif

/*:89*//*91:*/
#line 756 "cwebdir/comm-w2c.ch"

typedef bool boolean;
#define HAVE_BOOLEAN
#include <kpathsea/kpathsea.h>  

#include <w2c/config.h>  
#include <lib/lib.h>  

/*:91*//*94:*/
#line 795 "cwebdir/comm-w2c.ch"

#define CWEB
#include "help.h" 

/*:94*/
#line 67 "cwebdir/common.w"

#define _(S) gettext(S)  \

#define and_and 04
#define lt_lt 020
#define gt_gt 021
#define plus_plus 013
#define minus_minus 01
#define minus_gt 031
#define non_eq 032
#define lt_eq 034
#define gt_eq 035
#define eq_eq 036
#define or_or 037
#define dot_dot_dot 016
#define colon_colon 06
#define period_ast 026
#define minus_gt_ast 027 \

#define xisalpha(c) (isalpha((eight_bits) c) &&((eight_bits) c<0200) ) 
#define xisdigit(c) (isdigit((eight_bits) c) &&((eight_bits) c<0200) ) 
#define xisspace(c) (isspace((eight_bits) c) &&((eight_bits) c<0200) ) 
#define xislower(c) (islower((eight_bits) c) &&((eight_bits) c<0200) ) 
#define xisupper(c) (isupper((eight_bits) c) &&((eight_bits) c<0200) ) 
#define xisxdigit(c) (isxdigit((eight_bits) c) &&((eight_bits) c<0200) )  \

#define max_include_depth 10 \

#define max_file_name_length 1024
#define cur_file file[include_depth]
#define cur_file_name file_name[include_depth]
#define cur_line line[include_depth]
#define web_file file[0]
#define web_file_name file_name[0] \

#define length(c) (size_t) ((c+1) ->byte_start-(c) ->byte_start) 
#define print_id(c) term_write((c) ->byte_start,length((c) ) ) 
#define llink link
#define rlink dummy.Rlink
#define root name_dir->rlink \
 \

#define spotless 0
#define harmless_message 1
#define error_message 2
#define fatal_message 3
#define mark_harmless {if(history==spotless) history= harmless_message;}
#define mark_error history= error_message
#define confusion(s) fatal(_("! This can't happen: ") ,s)  \
 \

#define show_banner flags['b']
#define show_progress flags['p']
#define show_stats flags['s']
#define show_happiness flags['h']
#define temporary_output flags['t']
#define make_xrefs flags['x'] \

#define update_terminal fflush(stdout) 
#define new_line putchar('\n') 
#define putxchar putchar
#define term_write(a,b) fflush(stdout) ,fwrite(a,sizeof(char) ,b,stdout) 
#define C_printf(c,a) fprintf(C_file,c,a) 
#define C_putc(c) putc(c,C_file)  \

#define max_bytes 1000000 \

#define max_toks 1000000
#define max_names 10239 \

#define max_sections 4000
#define max_texts 10239
#define longest_name 10000
#define stack_size 500
#define buf_size 1000
#define long_buf_size (buf_size+longest_name)  \

#define lines_dont_match (change_limit-change_buffer!=limit-buffer|| \
strncmp(buffer,change_buffer,(size_t) (limit-buffer) ) )  \

#define if_section_start_make_pending(b) {*limit= '!'; \
for(loc= buffer;xisspace(*loc) ;loc++) ; \
*limit= ' '; \
if(*loc=='@'&&(xisspace(*(loc+1) ) ||*(loc+1) =='*') ) change_pending= b; \
} \

#define too_long() {include_depth--; \
err_print(_("! Include file name too long") ) ;goto restart;} \

#define hash_size 8501 \

#define first_chunk(p) ((p) ->byte_start+2) 
#define prefix_length(p) (int) ((eight_bits) *((p) ->byte_start) *256+ \
(eight_bits) *((p) ->byte_start+1) ) 
#define set_prefix_length(p,m) (*((p) ->byte_start) = (m) /256, \
*((p) ->byte_start+1) = (m) %256)  \

#define less 0
#define equal 1
#define greater 2
#define prefix 3
#define extension 4 \

#define bad_extension 5 \

#define RETURN_OK 0
#define RETURN_WARN 5
#define RETURN_ERROR 10
#define RETURN_FAIL 20 \

#define flag_change (**argv!='-') 
#define max_banner 50 \

#define PATH_SEPARATOR separators[0]
#define DIR_SEPARATOR separators[1]
#define DEVICE_SEPARATOR separators[2] \

#define kpse_find_cweb(name) kpse_find_file(name,kpse_cweb_format,true)  \


#line 68 "cwebdir/common.w"

/*2:*/
#line 35 "cwebdir/comm-w2c.h"

typedef bool boolean;
typedef uint8_t eight_bits;
typedef uint16_t sixteen_bits;
typedef enum{
ctangle,cweave,ctwill
}cweb;
extern cweb program;
extern int phase;

/*:2*//*4:*/
#line 91 "cwebdir/comm-w2c.h"

extern char section_text[];
extern char*section_text_end;
extern char*id_first;
extern char*id_loc;

/*:4*//*5:*/
#line 105 "cwebdir/comm-w2c.h"

extern char buffer[];
extern char*buffer_end;
extern char*loc;
extern char*limit;

/*:5*//*6:*/
#line 122 "cwebdir/comm-w2c.h"

extern int include_depth;
extern FILE*file[];
extern FILE*change_file;
extern char file_name[][max_file_name_length];

extern char change_file_name[];
extern char check_file_name[];
extern int line[];
extern int change_line;
extern int change_depth;
extern boolean input_has_ended;
extern boolean changing;
extern boolean web_file_open;

/*:6*//*8:*/
#line 143 "cwebdir/comm-w2c.h"

extern sixteen_bits section_count;
extern boolean changed_section[];
extern boolean change_pending;
extern boolean print_where;

/*:8*//*9:*/
#line 157 "cwebdir/comm-w2c.h"

typedef struct name_info{
char*byte_start;
struct name_info*link;
union{
struct name_info*Rlink;

char Ilk;
}dummy;
void*equiv_or_xref;
}name_info;
typedef name_info*name_pointer;
typedef name_pointer*hash_pointer;
extern char byte_mem[];
extern char*byte_mem_end;
extern char*byte_ptr;
extern name_info name_dir[];
extern name_pointer name_dir_end;
extern name_pointer name_ptr;
extern name_pointer hash[];
extern hash_pointer hash_end;
extern hash_pointer h;

/*:9*//*11:*/
#line 201 "cwebdir/comm-w2c.h"

extern int history;

/*:11*//*13:*/
#line 218 "cwebdir/comm-w2c.h"

extern int argc;
extern char**argv;
extern char C_file_name[];
extern char tex_file_name[];
extern char idx_file_name[];
extern char scn_file_name[];
extern boolean flags[];
extern const char*use_language;

/*:13*//*14:*/
#line 235 "cwebdir/comm-w2c.h"

extern FILE*C_file;
extern FILE*tex_file;
extern FILE*idx_file;
extern FILE*scn_file;
extern FILE*active_file;
extern FILE*check_file;

/*:14*/
#line 69 "cwebdir/common.w"

/*18:*/
#line 83 "cwebdir/common.w"

#line 72 "cwebdir/comm-w2c.ch"
cweb program;
#line 85 "cwebdir/common.w"

/*:18*//*19:*/
#line 92 "cwebdir/common.w"

int phase;

/*:19*//*21:*/
#line 130 "cwebdir/common.w"

char section_text[longest_name+1];
char*section_text_end= section_text+longest_name;
char*id_first;
char*id_loc;

/*:21*//*22:*/
#line 150 "cwebdir/common.w"

char buffer[long_buf_size];
char*buffer_end= buffer+buf_size-2;
char*loc= buffer;
char*limit= buffer;

/*:22*//*25:*/
#line 194 "cwebdir/common.w"

int include_depth;
FILE*file[max_include_depth];
FILE*change_file;
char file_name[max_include_depth][max_file_name_length];

char change_file_name[max_file_name_length];
#line 202 "cwebdir/common.w"
int line[max_include_depth];
int change_line;
int change_depth;
boolean input_has_ended;
boolean changing;
boolean web_file_open= false;

/*:25*//*26:*/
#line 220 "cwebdir/common.w"

static char change_buffer[buf_size];
static char*change_limit;

/*:26*//*37:*/
#line 399 "cwebdir/common.w"

sixteen_bits section_count;
boolean changed_section[max_sections];
boolean change_pending;

boolean print_where= false;

/*:37*//*43:*/
#line 596 "cwebdir/common.w"

char byte_mem[max_bytes];
char*byte_mem_end= byte_mem+max_bytes-1;
name_info name_dir[max_names];
name_pointer name_dir_end= name_dir+max_names-1;

/*:43*//*44:*/
#line 607 "cwebdir/common.w"

char*byte_ptr;
name_pointer name_ptr;

/*:44*//*46:*/
#line 627 "cwebdir/common.w"

name_pointer hash[hash_size];
hash_pointer hash_end= hash+hash_size-1;
hash_pointer h;

/*:46*//*65:*/
#line 1014 "cwebdir/common.w"

int history= spotless;

/*:65*//*73:*/
#line 1135 "cwebdir/common.w"

int argc;
char**argv;
char C_file_name[max_file_name_length];
char tex_file_name[max_file_name_length];
char idx_file_name[max_file_name_length];
#line 431 "cwebdir/comm-w2c.ch"
char scn_file_name[max_file_name_length];
char check_file_name[max_file_name_length];
#line 1142 "cwebdir/common.w"
boolean flags[128];

/*:73*//*83:*/
#line 1282 "cwebdir/common.w"

FILE*C_file;
FILE*tex_file;
FILE*idx_file;
#line 569 "cwebdir/comm-w2c.ch"
FILE*scn_file;
FILE*check_file;
#line 576 "cwebdir/comm-w2c.ch"
FILE*active_file;
char*found_filename;
#line 1288 "cwebdir/common.w"

#line 593 "cwebdir/comm-w2c.ch"
/*:83*//*86:*/
#line 638 "cwebdir/comm-w2c.ch"

const char*use_language= "";


/*:86*//*87:*/
#line 651 "cwebdir/comm-w2c.ch"

char cb_banner[max_banner];
string texmf_locale;
#ifndef SEPARATORS
#define SEPARATORS "://"
#endif
char separators[]= SEPARATORS;

/*:87*/
#line 70 "cwebdir/common.w"

/*7:*/
#line 137 "cwebdir/comm-w2c.h"

extern boolean get_line(void);
extern void check_complete(void);
extern void reset_input(void);

/*:7*//*10:*/
#line 180 "cwebdir/comm-w2c.h"

extern boolean names_match(name_pointer,const char*,size_t,eight_bits);
extern name_pointer id_lookup(const char*,const char*,char);

extern name_pointer section_lookup(char*,char*,int);
extern void init_node(name_pointer);
extern void init_p(name_pointer,eight_bits);
extern void print_prefix_name(name_pointer);
extern void print_section_name(name_pointer);
extern void sprint_section_name(char*,name_pointer);

/*:10*//*12:*/
#line 204 "cwebdir/comm-w2c.h"

extern int wrap_up(void);
extern void err_print(const char*);
extern void fatal(const char*,const char*);
extern void overflow(const char*);

/*:12*//*15:*/
#line 244 "cwebdir/comm-w2c.h"

extern void common_init(void);
extern void print_stats(void);
extern void cb_show_banner(void);

/*:15*//*24:*/
#line 180 "cwebdir/common.w"
static boolean input_ln(FILE*);

/*:24*//*28:*/
#line 241 "cwebdir/common.w"
static void prime_the_change_buffer(void);

/*:28*//*33:*/
#line 340 "cwebdir/common.w"
static void check_change(void);

/*:33*//*55:*/
#line 774 "cwebdir/common.w"

static int web_strcmp(char*,int,char*,int);
static name_pointer add_section_name(name_pointer,int,char*,char*,int);
static void extend_section_name(name_pointer,char*,char*,int);

/*:55*//*64:*/
#line 1002 "cwebdir/common.w"
static int section_name_cmp(char**,int,name_pointer);

/*:64*//*76:*/
#line 1197 "cwebdir/common.w"
static void scan_args(void);

#line 496 "cwebdir/comm-w2c.ch"
/*:76*//*96:*/
#line 808 "cwebdir/comm-w2c.ch"

static void cb_usage(const_string str);
static void cb_usagehelp(const_string*message,const_string bug_email);

/*:96*/
#line 71 "cwebdir/common.w"


/*:1*//*20:*/
#line 99 "cwebdir/common.w"

void
common_init(void)
{
#line 78 "cwebdir/comm-w2c.ch"
/*45:*/
#line 611 "cwebdir/common.w"

name_dir->byte_start= byte_ptr= byte_mem;
name_ptr= name_dir+1;
name_ptr->byte_start= byte_mem;
root= NULL;

/*:45*//*47:*/
#line 634 "cwebdir/common.w"

for(h= hash;h<=hash_end;*h++= NULL);

/*:47*/
#line 78 "cwebdir/comm-w2c.ch"

/*92:*/
#line 770 "cwebdir/comm-w2c.ch"

kpse_set_program_name(argv[0],"cweb");

/*:92*/
#line 79 "cwebdir/comm-w2c.ch"

#line 85 "cwebdir/comm-w2c.ch"
/*90:*/
#line 718 "cwebdir/comm-w2c.ch"

setlocale(LC_MESSAGES,setlocale(LC_CTYPE,""));
texmf_locale= kpse_var_expand("${TEXMFLOCALEDIR}");

bindtextdomain("cweb",
bindtextdomain("cweb-tl",
bindtextdomain("web2c-help",
strcmp(texmf_locale,"")?
texmf_locale:"/usr/share/locale")));

free(texmf_locale);
textdomain("cweb");


/*:90*/
#line 85 "cwebdir/comm-w2c.ch"

/*74:*/
#line 1148 "cwebdir/common.w"

#line 438 "cwebdir/comm-w2c.ch"
make_xrefs= true;
temporary_output= true;
#line 1150 "cwebdir/common.w"
show_stats= false;

/*:74*/
#line 86 "cwebdir/comm-w2c.ch"

#line 105 "cwebdir/common.w"
/*84:*/
#line 593 "cwebdir/comm-w2c.ch"

scan_args();
if(program==ctangle){
if((C_file= fopen(C_file_name,"a"))==NULL)
fatal(_("! Cannot open output file "),C_file_name);

else fclose(C_file);
strcpy(check_file_name,C_file_name);
if(check_file_name[0]!='\0'){
char*dot_pos= strrchr(check_file_name,'.');
if(dot_pos==NULL)strcat(check_file_name,".ttp");
else strcpy(dot_pos,".ttp");
}
if((C_file= fopen(check_file_name,"wb"))==NULL)
fatal(_("! Cannot open output file "),check_file_name);

}
else{
if((tex_file= fopen(tex_file_name,"a"))==NULL)
fatal(_("! Cannot open output file "),tex_file_name);
else fclose(tex_file);
strcpy(check_file_name,tex_file_name);
if(check_file_name[0]!='\0'){
char*dot_pos= strrchr(check_file_name,'.');
if(dot_pos==NULL)strcat(check_file_name,".wtp");
else strcpy(dot_pos,".wtp");
}
if((tex_file= fopen(check_file_name,"wb"))==NULL)
fatal(_("! Cannot open output file "),check_file_name);
}
#line 1300 "cwebdir/common.w"

#line 628 "cwebdir/comm-w2c.ch"
/*:84*/
#line 105 "cwebdir/common.w"

}

/*:20*//*23:*/
#line 160 "cwebdir/common.w"

static boolean input_ln(
FILE*fp)
{
register int c= EOF;
register char*k;
if(feof(fp))return false;
limit= k= buffer;
while(k<=buffer_end&&(c= getc(fp))!=EOF&&c!='\n')
#line 92 "cwebdir/comm-w2c.ch"
if((*(k++)= c)!=' '&&c!='\r')limit= k;
#line 170 "cwebdir/common.w"
if(k> buffer_end)
if((c= getc(fp))!=EOF&&c!='\n'){
#line 98 "cwebdir/comm-w2c.ch"
ungetc(c,fp);loc= buffer;err_print(_("! Input line too long"));
#line 173 "cwebdir/common.w"

}
if(c==EOF&&limit==buffer)return false;

return true;
}

/*:23*//*27:*/
#line 231 "cwebdir/common.w"

static void
prime_the_change_buffer(void)
{
change_limit= change_buffer;
/*29:*/
#line 247 "cwebdir/common.w"

while(true){
change_line++;
if(!input_ln(change_file))return;
if(limit<buffer+2)continue;
if(buffer[0]!='@')continue;
if(xisupper(buffer[1]))buffer[1]= tolower((eight_bits)buffer[1]);
if(buffer[1]=='x')break;
if(buffer[1]=='y'||buffer[1]=='z'||buffer[1]=='i'){
loc= buffer+2;
#line 109 "cwebdir/comm-w2c.ch"
err_print(_("! Missing @x in change file"));
#line 258 "cwebdir/common.w"

}
}

/*:29*/
#line 236 "cwebdir/common.w"

/*30:*/
#line 264 "cwebdir/common.w"

do{
change_line++;
if(!input_ln(change_file)){
#line 115 "cwebdir/comm-w2c.ch"
err_print(_("! Change file ended after @x"));
#line 269 "cwebdir/common.w"

return;
}
}while(limit==buffer);

/*:30*/
#line 237 "cwebdir/common.w"

/*31:*/
#line 274 "cwebdir/common.w"

{
change_limit= change_buffer+(ptrdiff_t)(limit-buffer);
strncpy(change_buffer,buffer,(size_t)(limit-buffer+1));
}

/*:31*/
#line 238 "cwebdir/common.w"

}

/*:27*//*32:*/
#line 302 "cwebdir/common.w"

static void
check_change(void)
{
int n= 0;
if(lines_dont_match)return;
change_pending= false;
if(!changed_section[section_count]){
if_section_start_make_pending(true);
if(!change_pending)changed_section[section_count]= true;
}
while(true){
changing= true;print_where= true;change_line++;
if(!input_ln(change_file)){
#line 121 "cwebdir/comm-w2c.ch"
err_print(_("! Change file ended before @y"));
#line 317 "cwebdir/common.w"

change_limit= change_buffer;changing= false;
return;
}
if(limit> buffer+1&&buffer[0]=='@'){
char xyz_code= xisupper(buffer[1])?tolower((eight_bits)buffer[1]):buffer[1];
/*34:*/
#line 342 "cwebdir/common.w"

if(xyz_code=='x'||xyz_code=='z'){
#line 133 "cwebdir/comm-w2c.ch"
loc= buffer+2;err_print(_("! Where is the matching @y?"));
#line 345 "cwebdir/common.w"

}
else if(xyz_code=='y'){
if(n> 0){
loc= buffer+2;
printf("\n! Hmm... %d ",n);
#line 139 "cwebdir/comm-w2c.ch"
err_print(_("of the preceding lines failed to match"));
#line 352 "cwebdir/common.w"

}
change_depth= include_depth;
return;
}

/*:34*/
#line 324 "cwebdir/common.w"

}
/*31:*/
#line 274 "cwebdir/common.w"

{
change_limit= change_buffer+(ptrdiff_t)(limit-buffer);
strncpy(change_buffer,buffer,(size_t)(limit-buffer+1));
}

/*:31*/
#line 326 "cwebdir/common.w"

changing= false;cur_line++;
while(!input_ln(cur_file)){
if(include_depth==0){
#line 127 "cwebdir/comm-w2c.ch"
err_print(_("! CWEB file ended during a change"));
#line 331 "cwebdir/common.w"

input_has_ended= true;return;
}
include_depth--;cur_line++;
}
if(lines_dont_match)n++;
}
}

/*:32*//*35:*/
#line 362 "cwebdir/common.w"

void
reset_input(void)
{
limit= buffer;loc= buffer+1;buffer[0]= ' ';
/*36:*/
#line 377 "cwebdir/common.w"

#line 149 "cwebdir/comm-w2c.ch"
if((found_filename= kpse_find_cweb(web_file_name))==NULL||
(web_file= fopen(found_filename,"r"))==NULL){
fatal(_("! Cannot open input file "),web_file_name);
}else if(strlen(found_filename)<max_file_name_length){

if(strcmp(web_file_name,found_filename))
strcpy(web_file_name,found_filename+
((strncmp(found_filename,"./",2)==0)?2:0));
free(found_filename);
}else fatal(_("! Filename too long\n"),found_filename);
#line 383 "cwebdir/common.w"


web_file_open= true;
#line 165 "cwebdir/comm-w2c.ch"
if((found_filename= kpse_find_cweb(change_file_name))==NULL||
(change_file= fopen(found_filename,"r"))==NULL){
fatal(_("! Cannot open change file "),change_file_name);
}else if(strlen(found_filename)<max_file_name_length){

if(strcmp(change_file_name,found_filename))
strcpy(change_file_name,found_filename+
((strncmp(found_filename,"./",2)==0)?2:0));
free(found_filename);
}else fatal(_("! Filename too long\n"),found_filename);
#line 388 "cwebdir/common.w"

/*:36*/
#line 367 "cwebdir/common.w"

include_depth= 0;cur_line= 0;change_line= 0;
change_depth= include_depth;
changing= 1;prime_the_change_buffer();changing= !changing;
limit= buffer;loc= buffer+1;buffer[0]= ' ';input_has_ended= false;
}

/*:35*//*38:*/
#line 406 "cwebdir/common.w"

boolean get_line(void)
{
restart:
if(changing&&include_depth==change_depth)
/*41:*/
#line 514 "cwebdir/common.w"
{
change_line++;
if(!input_ln(change_file)){
#line 274 "cwebdir/comm-w2c.ch"
err_print(_("! Change file ended without @z"));
#line 518 "cwebdir/common.w"

buffer[0]= '@';buffer[1]= 'z';limit= buffer+2;
}
if(limit> buffer){
if(change_pending){
if_section_start_make_pending(false);
if(change_pending){
changed_section[section_count]= true;change_pending= false;
}
}
*limit= ' ';
if(buffer[0]=='@'){
if(xisupper(buffer[1]))buffer[1]= tolower((eight_bits)buffer[1]);
if(buffer[1]=='x'||buffer[1]=='y'){
loc= buffer+2;
#line 280 "cwebdir/comm-w2c.ch"
err_print(_("! Where is the matching @z?"));
#line 534 "cwebdir/common.w"

}
else if(buffer[1]=='z'){
prime_the_change_buffer();changing= !changing;print_where= true;
}
}
}
}

/*:41*/
#line 411 "cwebdir/common.w"

if(!changing||include_depth> change_depth){
/*40:*/
#line 497 "cwebdir/common.w"
{
cur_line++;
while(!input_ln(cur_file)){
print_where= true;
if(include_depth==0){input_has_ended= true;break;}
else{
fclose(cur_file);include_depth--;
if(changing&&include_depth==change_depth)break;
cur_line++;
}
}
if(!changing&&!input_has_ended)
if(limit-buffer==change_limit-change_buffer)
if(buffer[0]==change_buffer[0])
if(change_limit> change_buffer)check_change();
}

/*:40*/
#line 413 "cwebdir/common.w"

if(changing&&include_depth==change_depth)goto restart;
}
if(input_has_ended)return false;
loc= buffer;*limit= ' ';
if(buffer[0]=='@'&&(buffer[1]=='i'||buffer[1]=='I')){
loc= buffer+2;*limit= '"';
while(*loc==' '||*loc=='\t')loc++;
if(loc>=limit){
#line 180 "cwebdir/comm-w2c.ch"
err_print(_("! Include file name not given"));
#line 423 "cwebdir/common.w"

goto restart;
}
if(include_depth>=max_include_depth-1){
#line 186 "cwebdir/comm-w2c.ch"
err_print(_("! Too many nested includes"));
#line 428 "cwebdir/common.w"

goto restart;
}
include_depth++;
/*39:*/
#line 451 "cwebdir/common.w"
{
#line 223 "cwebdir/comm-w2c.ch"
char*cur_file_name_end= cur_file_name+max_file_name_length-1;
char*k= cur_file_name;
#line 456 "cwebdir/common.w"

if(*loc=='"'){
loc++;
while(*loc!='"'&&k<=cur_file_name_end)*k++= *loc++;
if(loc==limit)k= cur_file_name_end+1;
}else
while(*loc!=' '&&*loc!='\t'&&*loc!='"'&&k<=cur_file_name_end)*k++= *loc++;
if(k> cur_file_name_end)too_long();

*k= '\0';
#line 230 "cwebdir/comm-w2c.ch"
if((found_filename= kpse_find_cweb(cur_file_name))!=NULL&&
(cur_file= fopen(found_filename,"r"))!=NULL){

if(strlen(found_filename)<max_file_name_length){
if(strcmp(cur_file_name,found_filename))
strcpy(cur_file_name,found_filename+
((strncmp(found_filename,"./",2)==0)?2:0));
free(found_filename);
}else fatal(_("! Filename too long\n"),found_filename);
#line 467 "cwebdir/common.w"
cur_line= 0;print_where= true;
goto restart;
}
#line 268 "cwebdir/comm-w2c.ch"
include_depth--;err_print(_("! Cannot open include file"));goto restart;
#line 495 "cwebdir/common.w"
}

/*:39*/
#line 432 "cwebdir/common.w"

}
return true;
}

#line 201 "cwebdir/comm-w2c.ch"
/*:38*//*42:*/
#line 546 "cwebdir/common.w"

void
check_complete(void){
if(change_limit!=change_buffer){
strncpy(buffer,change_buffer,(size_t)(change_limit-change_buffer+1));
limit= buffer+(ptrdiff_t)(change_limit-change_buffer);
changing= true;change_depth= include_depth;loc= buffer;
#line 286 "cwebdir/comm-w2c.ch"
err_print(_("! Change file entry did not match"));
#line 554 "cwebdir/common.w"

}
}

/*:42*//*48:*/
#line 639 "cwebdir/common.w"

name_pointer
id_lookup(
const char*first,
const char*last,
char t)
{
const char*i= first;
int h;
int l;
name_pointer p;
if(last==NULL)for(last= first;*last!='\0';last++);
l= (int)(last-first);
/*49:*/
#line 662 "cwebdir/common.w"

h= (eight_bits)*i;
while(++i<last)h= (h+h+(int)((eight_bits)*i))%hash_size;


/*:49*/
#line 652 "cwebdir/common.w"

/*50:*/
#line 670 "cwebdir/common.w"

p= hash[h];
while(p&&!names_match(p,first,l,t))p= p->link;
if(p==NULL){
p= name_ptr;
p->link= hash[h];hash[h]= p;
}

/*:50*/
#line 653 "cwebdir/common.w"

if(p==name_ptr)/*51:*/
#line 681 "cwebdir/common.w"
{
#line 293 "cwebdir/comm-w2c.ch"
if(byte_ptr+l> byte_mem_end)overflow(_("byte memory"));
if(name_ptr>=name_dir_end)overflow(_("name"));
#line 684 "cwebdir/common.w"
strncpy(byte_ptr,first,l);
(++name_ptr)->byte_start= byte_ptr+= l;
init_p(p,t);
}

/*:51*/
#line 654 "cwebdir/common.w"

return p;
}

/*:48*//*52:*/
#line 713 "cwebdir/common.w"

void
print_section_name(
name_pointer p)
{
char*ss,*s= first_chunk(p);
name_pointer q= p+1;
while(p!=name_dir){
ss= (p+1)->byte_start-1;
if(*ss==' '&&ss>=s){
term_write(s,(size_t)(ss-s));p= q->link;q= p;
}else{
term_write(s,(size_t)(ss+1-s));p= name_dir;q= NULL;
}
s= p->byte_start;
}
if(q)term_write("...",3);
}

/*:52*//*53:*/
#line 732 "cwebdir/common.w"

void
sprint_section_name(
char*dest,
name_pointer p)
{
char*ss,*s= first_chunk(p);
name_pointer q= p+1;
while(p!=name_dir){
ss= (p+1)->byte_start-1;
if(*ss==' '&&ss>=s){
p= q->link;q= p;
}else{
ss++;p= name_dir;
}
strncpy(dest,s,(size_t)(ss-s)),dest+= ss-s;
s= p->byte_start;
}
*dest= '\0';
}

/*:53*//*54:*/
#line 753 "cwebdir/common.w"

void
print_prefix_name(
name_pointer p)
{
char*s= first_chunk(p);
int l= prefix_length(p);
term_write(s,l);
if(s+l<(p+1)->byte_start)term_write("...",3);
}

/*:54*//*56:*/
#line 779 "cwebdir/common.w"

static int web_strcmp(
char*j,
int j_len,
char*k,
int k_len)
{
char*j1= j+j_len,*k1= k+k_len;
while(k<k1&&j<j1&&*j==*k)k++,j++;
if(k==k1)if(j==j1)return equal;
else return extension;
else if(j==j1)return prefix;
else if(*j<*k)return less;
else return greater;
}

/*:56*//*57:*/
#line 808 "cwebdir/common.w"

static name_pointer
add_section_name(
name_pointer par,
int c,
char*first,
char*last,
int ispref)
{
name_pointer p= name_ptr;
char*s= first_chunk(p);
int name_len= (int)(last-first)+ispref;
#line 301 "cwebdir/comm-w2c.ch"
if(s+name_len> byte_mem_end)overflow(_("byte memory"));
if(name_ptr+1>=name_dir_end)overflow(_("name"));
#line 822 "cwebdir/common.w"
(++name_ptr)->byte_start= byte_ptr= s+name_len;
if(ispref){
*(byte_ptr-1)= ' ';
name_len--;
name_ptr->link= name_dir;
(++name_ptr)->byte_start= byte_ptr;
}
set_prefix_length(p,name_len);
strncpy(s,first,name_len);
p->llink= NULL;
p->rlink= NULL;
init_node(p);
return par==NULL?(root= p):c==less?(par->llink= p):(par->rlink= p);
}

/*:57*//*58:*/
#line 837 "cwebdir/common.w"

static void
extend_section_name(
name_pointer p,
char*first,
char*last,
int ispref)
{
char*s;
name_pointer q= p+1;
int name_len= (int)(last-first)+ispref;
#line 308 "cwebdir/comm-w2c.ch"
if(name_ptr>=name_dir_end)overflow(_("name"));
#line 849 "cwebdir/common.w"
while(q->link!=name_dir)q= q->link;
q->link= name_ptr;
s= name_ptr->byte_start;
name_ptr->link= name_dir;
#line 314 "cwebdir/comm-w2c.ch"
if(s+name_len> byte_mem_end)overflow(_("byte memory"));
#line 854 "cwebdir/common.w"
(++name_ptr)->byte_start= byte_ptr= s+name_len;
strncpy(s,first,name_len);
if(ispref)*(byte_ptr-1)= ' ';
}

/*:58*//*59:*/
#line 865 "cwebdir/common.w"

name_pointer
section_lookup(
char*first,char*last,
int ispref)
{
int c= 0;
name_pointer p= root;
name_pointer q= NULL;
name_pointer r= NULL;
name_pointer par= NULL;

int name_len= (int)(last-first)+1;
/*60:*/
#line 889 "cwebdir/common.w"

while(p){
c= web_strcmp(first,name_len,first_chunk(p),prefix_length(p));
if(c==less||c==greater){
if(r==NULL)
par= p;
p= (c==less?p->llink:p->rlink);
}else{
if(r!=NULL){
#line 320 "cwebdir/comm-w2c.ch"
fputs(_("\n! Ambiguous prefix: matches <"),stdout);
#line 899 "cwebdir/common.w"

print_prefix_name(p);
#line 326 "cwebdir/comm-w2c.ch"
fputs(_(">\n and <"),stdout);
#line 902 "cwebdir/common.w"
print_prefix_name(r);
err_print(">");
return name_dir;
}
r= p;
p= p->llink;
q= r->rlink;
}
if(p==NULL)
p= q,q= NULL;
}

/*:60*/
#line 879 "cwebdir/common.w"

/*61:*/
#line 914 "cwebdir/common.w"

if(r==NULL)
return add_section_name(par,c,first,last+1,ispref);

/*:61*/
#line 880 "cwebdir/common.w"

/*62:*/
#line 922 "cwebdir/common.w"

switch(section_name_cmp(&first,name_len,r)){

case prefix:
if(!ispref){
#line 332 "cwebdir/comm-w2c.ch"
fputs(_("\n! New name is a prefix of <"),stdout);
#line 928 "cwebdir/common.w"

print_section_name(r);
err_print(">");
}
else if(name_len<prefix_length(r))set_prefix_length(r,name_len);

case equal:return r;
case extension:if(!ispref||first<=last)
extend_section_name(r,first,last+1,ispref);
return r;
case bad_extension:
#line 338 "cwebdir/comm-w2c.ch"
fputs(_("\n! New name extends <"),stdout);
#line 940 "cwebdir/common.w"

print_section_name(r);
err_print(">");
return r;
default:
#line 344 "cwebdir/comm-w2c.ch"
fputs(_("\n! Section name incompatible with <"),stdout);
#line 946 "cwebdir/common.w"

print_prefix_name(r);
#line 350 "cwebdir/comm-w2c.ch"
fputs(_(">,\n which abbreviates <"),stdout);
#line 949 "cwebdir/common.w"
print_section_name(r);
err_print(">");
return r;
}

/*:62*/
#line 881 "cwebdir/common.w"

}

/*:59*//*63:*/
#line 970 "cwebdir/common.w"

static int section_name_cmp(
char**pfirst,
int len,
name_pointer r)
{
char*first= *pfirst;
name_pointer q= r+1;
char*ss,*s= first_chunk(r);
int c;
int ispref;
while(true){
ss= (r+1)->byte_start-1;
if(*ss==' '&&ss>=r->byte_start)ispref= 1,q= q->link;
else ispref= 0,ss++,q= name_dir;
switch(c= web_strcmp(first,len,s,ss-s)){
case equal:if(q==name_dir)
if(ispref){
*pfirst= first+(ptrdiff_t)(ss-s);
return extension;
}else return equal;
else return(q->byte_start==(q+1)->byte_start)?equal:prefix;
case extension:
if(!ispref)return bad_extension;
first+= ss-s;
if(q!=name_dir){len-= (int)(ss-s);s= q->byte_start;r= q;continue;}
*pfirst= first;return extension;
default:return c;
}
}
}

/*:63*//*66:*/
#line 1024 "cwebdir/common.w"

void
err_print(
const char*s)
{
char*k,*l;
printf(*s=='!'?"\n%s":"%s",s);
if(web_file_open)/*67:*/
#line 1044 "cwebdir/common.w"

{if(changing&&include_depth==change_depth)
#line 358 "cwebdir/comm-w2c.ch"
printf(_(". (l. %d of change file)\n"),change_line);
else if(include_depth==0)printf(_(". (l. %d)\n"),cur_line);
else printf(_(". (l. %d of include file %s)\n"),cur_line,cur_file_name);
#line 1049 "cwebdir/common.w"
l= (loc>=limit?limit:loc);
if(l> buffer){
for(k= buffer;k<l;k++)
if(*k=='\t')putchar(' ');
else putchar(*k);
putchar('\n');
for(k= buffer;k<l;k++)putchar(' ');
}
for(k= l;k<limit;k++)putchar(*k);
if(*limit=='|')putchar('|');
putchar(' ');
}

/*:67*/
#line 1031 "cwebdir/common.w"

update_terminal;mark_error;
}

/*:66*//*68:*/
#line 1076 "cwebdir/common.w"

int wrap_up(void){
if(show_progress)new_line;
if(show_stats)
print_stats();
#line 388 "cwebdir/comm-w2c.ch"
/*69:*/
#line 1086 "cwebdir/common.w"

switch(history){
#line 412 "cwebdir/comm-w2c.ch"
case spotless:
if(show_happiness)puts(_("(No errors were found.)"));break;
case harmless_message:
puts(_("(Did you see the warning message above?)"));break;
case error_message:
puts(_("(Pardon me, but I think I spotted something wrong.)"));break;
case fatal_message:
puts(_("(That was a fatal error, my friend.)"));
#line 1094 "cwebdir/common.w"
}

/*:69*/
#line 388 "cwebdir/comm-w2c.ch"

/*88:*/
#line 662 "cwebdir/comm-w2c.ch"

if(C_file)fclose(C_file);
if(tex_file)fclose(tex_file);
if(check_file)fclose(check_file);
if(strlen(check_file_name))
remove(check_file_name);

/*:88*/
#line 389 "cwebdir/comm-w2c.ch"

#line 396 "cwebdir/comm-w2c.ch"
switch(history){
case harmless_message:return RETURN_WARN;
case error_message:return RETURN_ERROR;
case fatal_message:return RETURN_FAIL;
default:return RETURN_OK;
}
#line 1084 "cwebdir/common.w"
}

/*:68*//*70:*/
#line 1102 "cwebdir/common.w"
void
fatal(
const char*s,const char*t)
{
if(*s)err_print(s);
err_print(t);
history= fatal_message;exit(wrap_up());
}

/*:70*//*71:*/
#line 1113 "cwebdir/common.w"
void
overflow(
const char*t)
{
#line 425 "cwebdir/comm-w2c.ch"
printf(_("\n! Sorry, %s capacity exceeded"),t);fatal("","");
#line 1118 "cwebdir/common.w"
}


/*:71*//*75:*/
#line 1167 "cwebdir/common.w"

static void
scan_args(void)
{
char*dot_pos;
char*name_pos;
register char*s;
boolean found_web= false,found_change= false,found_out= false;


#line 462 "cwebdir/comm-w2c.ch"

#if defined DEV_NULL
strncpy(change_file_name,DEV_NULL,max_file_name_length-2);
change_file_name[max_file_name_length-2]= '\0';
#elif defined _DEV_NULL
strncpy(change_file_name,_DEV_NULL,max_file_name_length-2);
change_file_name[max_file_name_length-2]= '\0';
#else
strcpy(change_file_name,"/dev/null");
#endif

#line 1178 "cwebdir/common.w"
while(--argc> 0){
if((**(++argv)=='-'||**argv=='+')&&*(*argv+1))/*80:*/
#line 510 "cwebdir/comm-w2c.ch"

{
if(strcmp("-help",*argv)==0||strcmp("--help",*argv)==0)

/*95:*/
#line 799 "cwebdir/comm-w2c.ch"

cb_usagehelp(program==ctangle?CTANGLEHELP:
program==cweave?CWEAVEHELP:CTWILLHELP,NULL);


/*:95*/
#line 514 "cwebdir/comm-w2c.ch"

if(strcmp("-version",*argv)==0||strcmp("--version",*argv)==0)

/*98:*/
#line 846 "cwebdir/comm-w2c.ch"

printversionandexit(cb_banner,
program==ctwill?"Donald E. Knuth":"Silvio Levy and Donald E. Knuth",
NULL,"Contemporary development on https://github.com/ascherer/cweb.\n");


/*:98*/
#line 517 "cwebdir/comm-w2c.ch"

if(strcmp("-verbose",*argv)==0||strcmp("--verbose",*argv)==0)

{show_banner= show_progress= show_happiness= 1;continue;}
if(strcmp("-quiet",*argv)==0||strcmp("--quiet",*argv)==0)

{show_banner= show_progress= show_happiness= 0;continue;}
for(dot_pos= *argv+1;*dot_pos> '\0';dot_pos++)
if(*dot_pos=='v'){
show_banner= show_progress= show_happiness= true;
}else
if(*dot_pos=='q'){
show_banner= show_progress= show_happiness= false;
}else
if(*dot_pos=='d'){
if(sscanf(++dot_pos,"%u",&kpathsea_debug)!=1)/*81:*/
#line 555 "cwebdir/comm-w2c.ch"

cb_usage(program==ctangle?"ctangle":program==cweave?"cweave":"ctwill");

#line 1275 "cwebdir/common.w"

#line 563 "cwebdir/comm-w2c.ch"
/*:81*/
#line 532 "cwebdir/comm-w2c.ch"

while(isdigit(*dot_pos))dot_pos++;
dot_pos--;
}else
if(*dot_pos=='l'){
use_language= ++dot_pos;
break;
}else
#line 1261 "cwebdir/common.w"
 flags[(eight_bits)*dot_pos]= flag_change;
}

#line 555 "cwebdir/comm-w2c.ch"
/*:80*/
#line 1179 "cwebdir/common.w"

else{
s= name_pos= *argv;dot_pos= NULL;
#line 482 "cwebdir/comm-w2c.ch"
while(*s){
if(*s=='.')dot_pos= s++;
else if(*s==DIR_SEPARATOR||*s==DEVICE_SEPARATOR||*s=='/')
dot_pos= NULL,name_pos= ++s;
else s++;
}

#line 1187 "cwebdir/common.w"
if(!found_web)/*77:*/
#line 1206 "cwebdir/common.w"

{
if(s-*argv> max_file_name_length-5)
/*82:*/
#line 563 "cwebdir/comm-w2c.ch"
fatal(_("! Filename too long\n"),*argv);
#line 1277 "cwebdir/common.w"


/*:82*/
#line 1209 "cwebdir/common.w"

if(dot_pos==NULL)
sprintf(web_file_name,"%s.w",*argv);
else{
strcpy(web_file_name,*argv);
*dot_pos= 0;
}
#line 1217 "cwebdir/common.w"
sprintf(tex_file_name,"%s.tex",name_pos);
sprintf(idx_file_name,"%s.idx",name_pos);
sprintf(scn_file_name,"%s.scn",name_pos);
sprintf(C_file_name,"%s.c",name_pos);
found_web= true;
}

/*:77*/
#line 1188 "cwebdir/common.w"

else if(!found_change)/*78:*/
#line 1224 "cwebdir/common.w"

{
if(strcmp(*argv,"-")!=0){
if(s-*argv> max_file_name_length-4)
/*82:*/
#line 563 "cwebdir/comm-w2c.ch"
fatal(_("! Filename too long\n"),*argv);
#line 1277 "cwebdir/common.w"


/*:82*/
#line 1228 "cwebdir/common.w"

if(dot_pos==NULL)
sprintf(change_file_name,"%s.ch",*argv);
else strcpy(change_file_name,*argv);
}
found_change= true;
}

/*:78*/
#line 1189 "cwebdir/common.w"

else if(!found_out)/*79:*/
#line 1236 "cwebdir/common.w"

{
if(s-*argv> max_file_name_length-5)
/*82:*/
#line 563 "cwebdir/comm-w2c.ch"
fatal(_("! Filename too long\n"),*argv);
#line 1277 "cwebdir/common.w"


/*:82*/
#line 1239 "cwebdir/common.w"

if(dot_pos==NULL){
sprintf(tex_file_name,"%s.tex",*argv);
sprintf(idx_file_name,"%s.idx",*argv);
sprintf(scn_file_name,"%s.scn",*argv);
sprintf(C_file_name,"%s.c",*argv);
}else{
strcpy(tex_file_name,*argv);
strcpy(C_file_name,*argv);
if(make_xrefs){
*dot_pos= 0;
sprintf(idx_file_name,"%s.idx",*argv);
sprintf(scn_file_name,"%s.scn",*argv);
}
}
found_out= true;
}

/*:79*/
#line 1190 "cwebdir/common.w"

else/*81:*/
#line 555 "cwebdir/comm-w2c.ch"

cb_usage(program==ctangle?"ctangle":program==cweave?"cweave":"ctwill");

#line 1275 "cwebdir/common.w"

#line 563 "cwebdir/comm-w2c.ch"
/*:81*/
#line 1191 "cwebdir/common.w"

}
}
if(!found_web)/*81:*/
#line 555 "cwebdir/comm-w2c.ch"

cb_usage(program==ctangle?"ctangle":program==cweave?"cweave":"ctwill");

#line 1275 "cwebdir/common.w"

#line 563 "cwebdir/comm-w2c.ch"
/*:81*/
#line 1194 "cwebdir/common.w"

}

/*:75*//*97:*/
#line 812 "cwebdir/comm-w2c.ch"

static void cb_usage(const_string str)
{
textdomain("cweb-tl");

fprintf(stderr,_("%s: Need one to three file arguments.\n"),str);
fprintf(stderr,_("Try `%s --help' for more information.\n"),str);

textdomain("cweb");

history= fatal_message;exit(wrap_up());
}

static void cb_usagehelp(const_string*message,const_string bug_email)
{
if(!bug_email)
bug_email= "tex-k@tug.org";
textdomain("web2c-help");

while(*message){
printf("%s\n",strcmp("",*message)?_(*message):*message);
++message;
}
textdomain("cweb-tl");

printf(_("\nEmail bug reports to %s.\n"),bug_email);
textdomain("cweb");

history= spotless;exit(wrap_up());
}

/*:97*//*99:*/
#line 854 "cwebdir/comm-w2c.ch"

void cb_show_banner(void)
{
assert(cb_banner[0]!='\0');
textdomain("cweb-tl");

printf("%s%s\n",_(cb_banner),versionstring);
textdomain("cweb");

}

/*:99*/
